/*
 * Decompiled with CFR 0.152.
 */
package me.devnatan.inventoryframework.component;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import me.devnatan.inventoryframework.component.ComponentComposition;
import me.devnatan.inventoryframework.state.StateValue;
import org.jetbrains.annotations.ApiStatus;

public interface Pagination
extends ComponentComposition,
StateValue {
    public int currentPage();

    public int currentPageIndex();

    public int nextPage();

    public int nextPageIndex();

    public int lastPage();

    public int lastPageIndex();

    public boolean isFirstPage();

    public boolean isLastPage();

    public boolean hasPage(int var1);

    public void switchTo(int var1);

    public void advance();

    public boolean canAdvance();

    public void back();

    public boolean canBack();

    public char getLayoutTarget();

    @ApiStatus.Internal
    public boolean isLazy();

    @ApiStatus.Internal
    public boolean isStatic();

    @ApiStatus.Internal
    public boolean isComputed();

    @ApiStatus.Internal
    public boolean isAsync();

    @ApiStatus.Experimental
    public boolean isLoading();

    @Override
    @ApiStatus.Experimental
    public void forceUpdate();

    public static List<?> splitSourceForPage(int index, int pageSize, int pagesCount, List<?> src) {
        if (src.isEmpty()) {
            return Collections.emptyList();
        }
        if (src.size() <= pageSize) {
            return new ArrayList(src);
        }
        if (index < 0 || pagesCount > 0 && index > pagesCount) {
            throw new IndexOutOfBoundsException(String.format("Page index must be between the range of 0 and %d. Given: %d", pagesCount - 1, index));
        }
        LinkedList contents = new LinkedList();
        int base = index * pageSize;
        int until = base + pageSize;
        if (until > src.size()) {
            until = src.size();
        }
        for (int i = base; i < until; ++i) {
            contents.add(src.get(i));
        }
        return contents;
    }
}

