/*
 * Decompiled with CFR 0.152.
 */
package me.devnatan.inventoryframework.component;

import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Predicate;
import me.devnatan.inventoryframework.InventoryFrameworkException;
import me.devnatan.inventoryframework.Ref;
import me.devnatan.inventoryframework.VirtualView;
import me.devnatan.inventoryframework.component.Component;
import me.devnatan.inventoryframework.component.InteractionHandler;
import me.devnatan.inventoryframework.context.IFContext;
import me.devnatan.inventoryframework.context.IFRenderContext;
import me.devnatan.inventoryframework.context.IFSlotClickContext;
import me.devnatan.inventoryframework.context.IFSlotContext;
import me.devnatan.inventoryframework.context.IFSlotRenderContext;
import me.devnatan.inventoryframework.state.State;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.UnmodifiableView;

public class ItemComponent
implements Component,
InteractionHandler {
    private final String key = UUID.randomUUID().toString();
    private final VirtualView root;
    private int position;
    private final Object stack;
    private final boolean cancelOnClick;
    private final boolean closeOnClick;
    private final Predicate<? extends IFContext> displayCondition;
    private final Consumer<? super IFSlotRenderContext> renderHandler;
    private final Consumer<? super IFSlotContext> updateHandler;
    private final Consumer<? super IFSlotClickContext> clickHandler;
    private final Set<State<?>> watching;
    private final boolean isManagedExternally;
    private final boolean updateOnClick;
    private boolean isVisible;
    private final Ref<Component> reference;

    public ItemComponent(VirtualView root, int position, Object stack, boolean cancelOnClick, boolean closeOnClick, Predicate<? extends IFContext> displayCondition, Consumer<? super IFSlotRenderContext> renderHandler, Consumer<? super IFSlotContext> updateHandler, Consumer<? super IFSlotClickContext> clickHandler, Set<State<?>> watching, boolean isManagedExternally, boolean updateOnClick, boolean isVisible, Ref<Component> reference) {
        this.root = root;
        this.position = position;
        this.stack = stack;
        this.cancelOnClick = cancelOnClick;
        this.closeOnClick = closeOnClick;
        this.displayCondition = displayCondition;
        this.renderHandler = renderHandler;
        this.updateHandler = updateHandler;
        this.clickHandler = clickHandler;
        this.watching = watching;
        this.isManagedExternally = isManagedExternally;
        this.updateOnClick = updateOnClick;
        this.isVisible = isVisible;
        this.reference = reference;
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    @NotNull
    public VirtualView getRoot() {
        return this.root;
    }

    @Override
    public int getPosition() {
        return this.position;
    }

    public Object getStack() {
        return this.stack;
    }

    public boolean isCancelOnClick() {
        return this.cancelOnClick;
    }

    public boolean isCloseOnClick() {
        return this.closeOnClick;
    }

    public boolean isUpdateOnClick() {
        return this.updateOnClick;
    }

    @Override
    public boolean shouldRender(IFContext context) {
        return this.displayCondition == null || this.displayCondition.test(context);
    }

    public Consumer<? super IFSlotRenderContext> getRenderHandler() {
        return this.renderHandler;
    }

    public Consumer<? super IFSlotContext> getUpdateHandler() {
        return this.updateHandler;
    }

    public Consumer<? super IFSlotClickContext> getClickHandler() {
        return this.clickHandler;
    }

    public Set<State<?>> getWatching() {
        return this.watching;
    }

    @Override
    public boolean isContainedWithin(int position) {
        return this.getPosition() == position;
    }

    @Override
    public boolean intersects(@NotNull Component other) {
        return Component.intersects(this, other);
    }

    @Override
    @NotNull
    public InteractionHandler getInteractionHandler() {
        return this;
    }

    @Override
    public void render(@NotNull IFSlotRenderContext context) {
        if (this.getRenderHandler() != null) {
            int initialSlot = this.getPosition();
            this.getRenderHandler().accept(context);
            if (!this.isManagedExternally()) {
                int updatedSlot;
                this.position = updatedSlot = context.getSlot();
                if (updatedSlot == -1 && initialSlot == -1) {
                    throw new InventoryFrameworkException("Missing position (unset slot) for item component");
                }
                if (initialSlot != -1 && initialSlot != updatedSlot) {
                    context.getContainer().removeItem(initialSlot);
                    this.setVisible(false);
                }
            }
            context.getContainer().renderItem(this.getPosition(), context.getResult());
            this.setVisible(true);
            return;
        }
        if (this.getStack() == null) {
            if (context.getContainer().getType().isResultSlot(this.getPosition())) {
                this.setVisible(true);
                return;
            }
            throw new IllegalStateException("At least one fallback item or render handler must be provided");
        }
        context.getContainer().renderItem(this.getPosition(), this.getStack());
        this.setVisible(true);
    }

    @Override
    public void updated(@NotNull IFSlotRenderContext context) {
        if (context.isCancelled()) {
            return;
        }
        if (!context.isForceUpdate() && this.displayCondition == null && this.getRenderHandler() == null) {
            return;
        }
        if (this.getUpdateHandler() != null) {
            this.getUpdateHandler().accept(context);
            if (context.isCancelled()) {
                return;
            }
        }
        context.getParent().renderComponent(this);
    }

    @Override
    public void clear(@NotNull IFContext context) {
        ((IFRenderContext)context).getContainer().removeItem(this.getPosition());
    }

    @Override
    public void update() {
        if (this.isManagedExternally()) {
            throw new IllegalStateException("This component is externally managed by another component and cannot be updated directly");
        }
        if (this.root instanceof IFContext) {
            ((IFContext)this.root).updateComponent(this, false);
        }
    }

    @Override
    public @UnmodifiableView Set<State<?>> getWatchingStates() {
        return Collections.unmodifiableSet(this.getWatching());
    }

    @Override
    public void clicked(@NotNull Component component, @NotNull IFSlotClickContext context) {
        if (this.getClickHandler() != null) {
            this.getClickHandler().accept(context);
        }
        if (this.isUpdateOnClick()) {
            context.update();
        }
    }

    @Override
    public boolean isVisible() {
        if (this.root instanceof Component) {
            return ((Component)this.root).isVisible() && this.isVisible;
        }
        return this.isVisible;
    }

    @Override
    public void setVisible(boolean visible) {
        this.isVisible = visible;
    }

    @Override
    public boolean isManagedExternally() {
        return this.isManagedExternally;
    }

    @Override
    public Ref<Component> getReference() {
        return this.reference;
    }

    @Override
    public void forceUpdate() {
        if (this.root instanceof IFContext) {
            ((IFContext)this.root).updateComponent(this, true);
        }
    }

    @Override
    public void hide() {
        this.setVisible(false);
        this.clear((IFContext)this.getRoot());
    }

    @Override
    public void show() {
        this.setVisible(true);
        this.forceUpdate();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ItemComponent that = (ItemComponent)o;
        return this.getPosition() == that.getPosition() && Objects.equals(this.getStack(), that.getStack());
    }

    public int hashCode() {
        return Objects.hash(this.getPosition(), this.getStack());
    }

    public String toString() {
        return "ItemComponent{, position=" + this.position + ", stack=" + this.stack + ", cancelOnClick=" + this.cancelOnClick + ", closeOnClick=" + this.closeOnClick + ", displayCondition=" + this.displayCondition + ", renderHandler=" + this.renderHandler + ", updateHandler=" + this.updateHandler + ", clickHandler=" + this.clickHandler + ", watching=" + this.watching + ", isVisible=" + this.isVisible + ", isManagedExternally=" + this.isManagedExternally + '}';
    }
}

