/*
 * Decompiled with CFR 0.152.
 */
package me.devnatan.inventoryframework;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.UnaryOperator;
import me.devnatan.inventoryframework.AnvilInput;
import me.devnatan.inventoryframework.AnvilInputConfig;
import me.devnatan.inventoryframework.AnvilInputNMS;
import me.devnatan.inventoryframework.BukkitViewContainer;
import me.devnatan.inventoryframework.PlatformView;
import me.devnatan.inventoryframework.ViewConfig;
import me.devnatan.inventoryframework.ViewContainer;
import me.devnatan.inventoryframework.ViewFrame;
import me.devnatan.inventoryframework.ViewType;
import me.devnatan.inventoryframework.context.IFCloseContext;
import me.devnatan.inventoryframework.context.IFContext;
import me.devnatan.inventoryframework.context.IFRenderContext;
import me.devnatan.inventoryframework.context.OpenContext;
import me.devnatan.inventoryframework.context.SlotClickContext;
import me.devnatan.inventoryframework.feature.Feature;
import me.devnatan.inventoryframework.pipeline.PipelineInterceptor;
import me.devnatan.inventoryframework.pipeline.PipelinePhase;
import me.devnatan.inventoryframework.state.State;
import me.devnatan.inventoryframework.state.StateValueHost;
import org.bukkit.Material;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;

public final class AnvilInputFeature
implements Feature<AnvilInputConfig, Void, ViewFrame> {
    private static final int INGREDIENT_SLOT = 0;
    public static final Feature<AnvilInputConfig, Void, ViewFrame> AnvilInput = new AnvilInputFeature();
    private AnvilInputConfig config;
    private PipelineInterceptor frameInterceptor;

    private AnvilInputFeature() {
    }

    @NotNull
    public String name() {
        return "Anvil Input";
    }

    @NotNull
    public Void install(ViewFrame framework, UnaryOperator<AnvilInputConfig> configure) {
        this.config = (AnvilInputConfig)configure.apply(me.devnatan.inventoryframework.AnvilInput.defaultConfig());
        this.frameInterceptor = this.createFrameworkInterceptor();
        framework.getPipeline().intercept((PipelinePhase)PipelinePhase.Frame.FRAME_REGISTERED, this.frameInterceptor);
        return null;
    }

    public void uninstall(ViewFrame framework) {
        framework.getPipeline().removeInterceptor((PipelinePhase)PipelinePhase.Frame.FRAME_REGISTERED, this.frameInterceptor);
    }

    private PipelineInterceptor createFrameworkInterceptor() {
        return (pipeline, subject) -> {
            Map views = subject.getRegisteredViews();
            for (PlatformView view : views.values()) {
                this.handleOpen(view);
                this.handleClose(view);
                this.handleClick(view);
            }
        };
    }

    private AnvilInput getAnvilInput(IFContext context) {
        if (context.getConfig().getType() != ViewType.ANVIL) {
            return null;
        }
        Optional<ViewConfig.Modifier> optional = context.getConfig().getModifiers().stream().filter(modifier -> modifier instanceof AnvilInput).findFirst();
        if (!optional.isPresent()) {
            return null;
        }
        return (AnvilInput)optional.get();
    }

    private void updatePhysicalResult(String newText, ViewContainer container) {
        Inventory inventory = ((BukkitViewContainer)container).getInventory();
        ItemStack ingredientItem = Objects.requireNonNull(inventory.getItem(0));
        ItemMeta ingredientMeta = Objects.requireNonNull(ingredientItem.getItemMeta());
        ingredientMeta.setDisplayName(newText);
        ingredientItem.setItemMeta(ingredientMeta);
    }

    private void handleClick(PlatformView view) {
        view.getPipeline().intercept((PipelinePhase)PipelinePhase.Context.CONTEXT_SLOT_CLICK, (pipeline, subject) -> {
            SlotClickContext context = (SlotClickContext)subject;
            AnvilInput anvilInput = this.getAnvilInput((IFContext)context);
            if (anvilInput == null) {
                return;
            }
            int resultSlot = context.getContainer().getType().getResultSlots()[0];
            if (context.getClickedSlot() != resultSlot) {
                return;
            }
            ItemStack resultItem = context.getItem();
            if (resultItem == null || resultItem.getType() == Material.AIR) {
                return;
            }
            ItemMeta resultMeta = Objects.requireNonNull(resultItem.getItemMeta());
            String text = resultMeta.getDisplayName();
            Inventory clickedInventory = Objects.requireNonNull(context.getClickOrigin().getClickedInventory(), "Clicked inventory cannot be null");
            ItemStack ingredientItem = Objects.requireNonNull(clickedInventory.getItem(0));
            ItemMeta ingredientMeta = Objects.requireNonNull(ingredientItem.getItemMeta());
            ingredientMeta.setDisplayName(text);
            context.updateState(anvilInput.internalId(), (Object)text);
            ingredientItem.setItemMeta(ingredientMeta);
            if (this.config.closeOnSelect) {
                context.closeForPlayer();
            }
        });
    }

    private void handleOpen(PlatformView view) {
        view.getPipeline().intercept((PipelinePhase)PipelinePhase.Context.CONTEXT_OPEN, (pipeline, subject) -> {
            OpenContext context = (OpenContext)subject;
            AnvilInput anvilInput = this.getAnvilInput((IFContext)context);
            if (anvilInput == null) {
                return;
            }
            context.getInternalStateValue((State)anvilInput);
            context.watchState(anvilInput.internalId(), (pipelineContext, diff) -> this.updatePhysicalResult((String)diff.getNewValue(), ((IFRenderContext)diff.getHost()).getContainer()));
            String globalInitialInput = this.config.initialInput;
            String scopedInitialInput = (String)anvilInput.get((StateValueHost)context);
            Inventory inventory = AnvilInputNMS.open(context.getPlayer(), context.getConfig().getTitle(), scopedInitialInput.isEmpty() ? globalInitialInput : scopedInitialInput);
            BukkitViewContainer container = new BukkitViewContainer(inventory, ViewType.ANVIL, false, true);
            context.setContainer((ViewContainer)container);
        });
    }

    private void handleClose(PlatformView view) {
        view.getPipeline().intercept((PipelinePhase)PipelinePhase.Context.CONTEXT_CLOSE, (pipeline, subject) -> {
            IFCloseContext context = (IFCloseContext)subject;
            AnvilInput anvilInput = this.getAnvilInput((IFContext)context);
            if (anvilInput == null) {
                return;
            }
            BukkitViewContainer container = (BukkitViewContainer)context.getContainer();
            int slot = container.getType().getResultSlots()[0];
            ItemStack item = container.getInventory().getItem(slot);
            if (item == null || item.getType() == Material.AIR) {
                return;
            }
            String input = Objects.requireNonNull(item.getItemMeta()).getDisplayName();
            context.updateState(anvilInput.internalId(), (Object)input);
        });
    }
}

