/*
 * Decompiled with CFR 0.152.
 */
package me.devnatan.inventoryframework;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodType;
import me.devnatan.inventoryframework.runtime.thirdparty.InventoryUpdate;
import me.devnatan.inventoryframework.runtime.thirdparty.ReflectionUtils;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.AnvilInventory;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

class AnvilInputNMS {
    private static final MethodHandle ANVIL_CONSTRUCTOR;
    private static final Class<?> ANVIL;
    private static final MethodHandle GET_PLAYER_NEXT_CONTAINER_COUNTER;
    private static final MethodHandle GET_PLAYER_INVENTORY;
    private static final MethodHandle SET_PLAYER_ACTIVE_CONTAINER;
    private static final MethodHandle ADD_CONTAINER_SLOT_LISTENER;
    private static final MethodHandle INIT_MENU;
    private static final MethodHandle CONTAINER_CHECK_REACHABLE;
    private static final MethodHandle PLAYER_DEFAULT_CONTAINER;
    private static final MethodHandle CONTAINER_WINDOW_ID;

    private AnvilInputNMS() {
    }

    public static Inventory open(Player player, Object title, String initialInput) {
        try {
            Object entityPlayer = ReflectionUtils.getEntityPlayer((Object)player);
            Object defaultContainer = PLAYER_DEFAULT_CONTAINER.invoke(entityPlayer);
            SET_PLAYER_ACTIVE_CONTAINER.invoke(entityPlayer, defaultContainer);
            int windowId = GET_PLAYER_NEXT_CONTAINER_COUNTER.invoke(entityPlayer);
            Object anvilContainer = ANVIL_CONSTRUCTOR.invoke(windowId, GET_PLAYER_INVENTORY.invoke(entityPlayer));
            CONTAINER_CHECK_REACHABLE.invoke(anvilContainer, false);
            AnvilInventory inventory = (AnvilInventory)InventoryUpdate.getBukkitView.invoke(anvilContainer).getTopInventory();
            inventory.setMaximumRepairCost(0);
            ItemStack item = new ItemStack(Material.PAPER, 1, 0);
            ItemMeta meta = item.getItemMeta();
            meta.setDisplayName(initialInput);
            item.setItemMeta(meta);
            inventory.setItem(0, item);
            Object nmsContainers = InventoryUpdate.getContainerOrName((InventoryUpdate.Containers)InventoryUpdate.Containers.ANVIL, (InventoryType)InventoryType.ANVIL);
            Object updatedTitle = InventoryUpdate.createTitleComponent((Object)title);
            Object openWindowPacket = InventoryUpdate.useContainers() ? InventoryUpdate.packetPlayOutOpenWindow.invoke(windowId, nmsContainers, updatedTitle) : InventoryUpdate.packetPlayOutOpenWindow.invoke(windowId, nmsContainers, updatedTitle, InventoryType.ANVIL.getDefaultSize());
            ReflectionUtils.sendPacketSync((Player)player, (Object[])new Object[]{openWindowPacket});
            SET_PLAYER_ACTIVE_CONTAINER.invoke(entityPlayer, anvilContainer);
            CONTAINER_WINDOW_ID.invoke(anvilContainer, windowId);
            if (ReflectionUtils.supports((int)19)) {
                INIT_MENU.invoke(entityPlayer, anvilContainer);
            } else {
                ADD_CONTAINER_SLOT_LISTENER.invoke(anvilContainer, player);
            }
            return inventory;
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    static {
        try {
            ANVIL = ReflectionUtils.getNMSClass((String)"world.inventory", (String)"ContainerAnvil");
            Class playerInventoryClass = ReflectionUtils.getNMSClass((String)"world.entity.player", (String)"PlayerInventory");
            ANVIL_CONSTRUCTOR = InventoryUpdate.getConstructor(ANVIL, (Class[])new Class[]{Integer.TYPE, playerInventoryClass});
            CONTAINER_CHECK_REACHABLE = InventoryUpdate.setFieldHandle((Class)InventoryUpdate.CONTAINER, Boolean.TYPE, (String)"checkReachable");
            Class containerPlayer = ReflectionUtils.getNMSClass((String)"world.inventory", (String)"ContainerPlayer");
            PLAYER_DEFAULT_CONTAINER = InventoryUpdate.getField((Class)InventoryUpdate.ENTITY_PLAYER, (Class)containerPlayer, (String)"inventoryMenu", (String[])new String[]{"bQ"});
            SET_PLAYER_ACTIVE_CONTAINER = InventoryUpdate.setField((Class)InventoryUpdate.ENTITY_PLAYER, (Class)containerPlayer, (String)"activeContainer", (String[])new String[]{"bR", "containerMenu"});
            GET_PLAYER_NEXT_CONTAINER_COUNTER = InventoryUpdate.getMethod((Class)InventoryUpdate.ENTITY_PLAYER, (String)"nextContainerCounter", (MethodType)MethodType.methodType(Integer.TYPE));
            GET_PLAYER_INVENTORY = InventoryUpdate.getMethod((Class)InventoryUpdate.ENTITY_PLAYER, (String)"fN", (MethodType)MethodType.methodType(playerInventoryClass));
            CONTAINER_WINDOW_ID = InventoryUpdate.setField((Class)InventoryUpdate.CONTAINER, Integer.TYPE, (String)"windowId", (String[])new String[]{"containerId", "j"});
            ADD_CONTAINER_SLOT_LISTENER = InventoryUpdate.getMethod((Class)InventoryUpdate.CONTAINER, (String)"a", (MethodType)MethodType.methodType(Void.TYPE, ReflectionUtils.getNMSClass((String)"world.inventory.ICrafting")));
            INIT_MENU = InventoryUpdate.getMethod((Class)InventoryUpdate.ENTITY_PLAYER, (String)"a", (MethodType)MethodType.methodType(Void.TYPE, InventoryUpdate.CONTAINER));
        }
        catch (Exception exception) {
            throw new RuntimeException("Unsupported version for Anvil Input feature: " + ReflectionUtils.getVersionInformation(), exception);
        }
    }
}

