/*
 * Decompiled with CFR 0.152.
 */
package me.confuser.banmanager.bukkit.listeners;

import github.scarsz.discordsrv.DiscordSRV;
import github.scarsz.discordsrv.dependencies.jda.api.entities.TextChannel;
import github.scarsz.discordsrv.util.DiscordUtil;
import github.scarsz.discordsrv.util.WebhookUtil;
import java.util.UUID;
import me.confuser.banmanager.bukkit.api.events.IpBannedEvent;
import me.confuser.banmanager.bukkit.api.events.IpUnbanEvent;
import me.confuser.banmanager.bukkit.api.events.PlayerBannedEvent;
import me.confuser.banmanager.bukkit.api.events.PlayerKickedEvent;
import me.confuser.banmanager.bukkit.api.events.PlayerMutedEvent;
import me.confuser.banmanager.bukkit.api.events.PlayerReportedEvent;
import me.confuser.banmanager.bukkit.api.events.PlayerUnbanEvent;
import me.confuser.banmanager.bukkit.api.events.PlayerUnmuteEvent;
import me.confuser.banmanager.bukkit.api.events.PlayerWarnedEvent;
import me.confuser.banmanager.common.BanManagerPlugin;
import me.confuser.banmanager.common.listeners.CommonDiscordListener;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;

public class DiscordListener
implements Listener {
    private BanManagerPlugin plugin;
    private CommonDiscordListener listener;

    public DiscordListener(BanManagerPlugin plugin) {
        this.plugin = plugin;
        this.listener = new CommonDiscordListener(plugin);
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void notifyOnBan(PlayerBannedEvent event) {
        Object[] data = this.listener.notifyOnBan(event.getBan());
        if (event.isSilent() && ((Boolean)data[2]).booleanValue()) {
            return;
        }
        this.send(data, Bukkit.getPlayer((UUID)event.getBan().getActor().getUUID()));
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void notifyOnMute(PlayerMutedEvent event) {
        Object[] data = this.listener.notifyOnMute(event.getMute());
        if (event.isSilent() && ((Boolean)data[2]).booleanValue()) {
            return;
        }
        this.send(data, Bukkit.getPlayer((UUID)event.getMute().getActor().getUUID()));
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void notifyOnBan(IpBannedEvent event) {
        Object[] data = this.listener.notifyOnBan(event.getBan());
        if (event.isSilent() && ((Boolean)data[2]).booleanValue()) {
            return;
        }
        this.send(data, Bukkit.getPlayer((UUID)event.getBan().getActor().getUUID()));
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void notifyOnKick(PlayerKickedEvent event) {
        Object[] data = this.listener.notifyOnKick(event.getKick());
        if (event.isSilent() && ((Boolean)data[2]).booleanValue()) {
            return;
        }
        this.send(data, Bukkit.getPlayer((UUID)event.getKick().getActor().getUUID()));
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void notifyOnWarn(PlayerWarnedEvent event) {
        Object[] data = this.listener.notifyOnWarn(event.getWarning());
        if (event.isSilent() && ((Boolean)data[2]).booleanValue()) {
            return;
        }
        this.send(data, Bukkit.getPlayer((UUID)event.getWarning().getActor().getUUID()));
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void notifyOnUnban(PlayerUnbanEvent event) {
        Object[] data = this.listener.notifyOnUnban(event.getBan(), event.getActor(), event.getReason());
        this.send(data, Bukkit.getPlayer((UUID)event.getActor().getUUID()));
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void notifyOnUnban(IpUnbanEvent event) {
        Object[] data = this.listener.notifyOnUnban(event.getBan(), event.getActor(), event.getReason());
        this.send(data, Bukkit.getPlayer((UUID)event.getBan().getActor().getUUID()));
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void notifyOnUnmute(PlayerUnmuteEvent event) {
        Object[] data = this.listener.notifyOnUnmute(event.getMute(), event.getActor(), event.getReason());
        this.send(data, Bukkit.getPlayer((UUID)event.getActor().getUUID()));
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void notifyOnReport(PlayerReportedEvent event) {
        Object[] data = this.listener.notifyOnReport(event.getReport(), event.getReport().getActor(), event.getReport().getReason());
        if (event.isSilent() && ((Boolean)data[2]).booleanValue()) {
            return;
        }
        this.send(data, Bukkit.getPlayer((UUID)event.getReport().getActor().getUUID()));
    }

    private void send(Object[] data, Player actor) {
        if (actor == null || !this.plugin.getDiscordConfig().isMessagesFromActor()) {
            DiscordUtil.sendMessage((TextChannel)DiscordSRV.getPlugin().getDestinationTextChannelForGameChannelName((String)data[0]), (String)data[1].toString());
        } else {
            WebhookUtil.deliverMessage((TextChannel)DiscordSRV.getPlugin().getDestinationTextChannelForGameChannelName((String)data[0]), (Player)actor, (String)data[1].toString());
        }
    }
}

