/*
 * Decompiled with CFR 0.152.
 */
package me.confuser.banmanager.bukkit;

import java.sql.SQLException;
import java.util.UUID;
import me.confuser.banmanager.bukkit.BukkitServer;
import me.confuser.banmanager.common.BanManagerPlugin;
import me.confuser.banmanager.common.commands.CommonSender;
import me.confuser.banmanager.common.data.PlayerData;
import me.confuser.banmanager.common.util.Message;
import me.confuser.banmanager.common.util.UUIDUtils;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class BukkitSender
implements CommonSender {
    private BanManagerPlugin plugin;
    private CommandSender sender;

    public BukkitSender(BanManagerPlugin plugin, CommandSender sender) {
        this.plugin = plugin;
        this.sender = sender;
    }

    public String getName() {
        return this.sender.getName();
    }

    public boolean hasPermission(String permission) {
        return this.sender.hasPermission(permission);
    }

    public void sendMessage(String message) {
        this.sender.sendMessage(BukkitServer.formatMessage(message));
    }

    public void sendMessage(Message message) {
        this.sendMessage(message.toString());
    }

    public boolean isConsole() {
        return !(this.sender instanceof Player);
    }

    public PlayerData getData() {
        if (this.isConsole()) {
            return this.plugin.getPlayerStorage().getConsole();
        }
        try {
            return (PlayerData)this.plugin.getPlayerStorage().queryForId((Object)UUIDUtils.toBytes((UUID)((Player)this.sender).getUniqueId()));
        }
        catch (SQLException e) {
            e.printStackTrace();
            this.sender.sendMessage(Message.get((String)"sender.error.exception").toString());
            return null;
        }
    }
}

