/*
 * Decompiled with CFR 0.152.
 */
package me.confuser.banmanager.bukkit;

import java.util.HashMap;
import me.confuser.banmanager.common.CommonMetrics;
import org.bstats.bukkit.Metrics;
import org.bstats.charts.CustomChart;
import org.bstats.charts.DrilldownPie;
import org.bstats.charts.SimplePie;

public class BukkitMetrics
implements CommonMetrics {
    private final Metrics metrics;

    public BukkitMetrics(Metrics metrics) {
        this.metrics = metrics;
    }

    public void submitOnlineMode(boolean online) {
        this.metrics.addCustomChart((CustomChart)new SimplePie("banmanagerMode", () -> online ? "online" : "offline"));
    }

    public void submitStorageType(String storageType) {
        this.metrics.addCustomChart((CustomChart)new SimplePie("storageType", () -> storageType));
    }

    public void submitStorageVersion(String version) {
        this.metrics.addCustomChart((CustomChart)new DrilldownPie("storageVersion", () -> {
            HashMap map = new HashMap();
            HashMap<String, Integer> entry = new HashMap<String, Integer>();
            entry.put(version, 1);
            if (version.contains("Maria")) {
                map.put("MariaDB", entry);
            } else {
                map.put("MySQL", entry);
            }
            return map;
        }));
    }

    public void submitGlobalMode(boolean enabled) {
        this.metrics.addCustomChart((CustomChart)new SimplePie("globalMode", () -> enabled ? "enabled" : "disabled"));
    }

    public void submitGeoMode(boolean enabled) {
        this.metrics.addCustomChart((CustomChart)new SimplePie("geoMode", () -> enabled ? "enabled" : "disabled"));
    }

    public void submitDiscordMode(boolean enabled) {
        this.metrics.addCustomChart((CustomChart)new SimplePie("discordMode", () -> enabled ? "enabled" : "disabled"));
    }
}

