/*
 * Decompiled with CFR 0.152.
 */
package me.confuser.banmanager.bukkit;

import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.List;
import me.confuser.banmanager.bukkit.BukkitPlayer;
import me.confuser.banmanager.bukkit.BukkitSender;
import me.confuser.banmanager.common.BanManagerPlugin;
import me.confuser.banmanager.common.commands.CommonCommand;
import me.confuser.banmanager.common.commands.CommonSender;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;

public class BukkitCommand
implements CommandExecutor,
TabCompleter {
    private CommonCommand command;

    public BukkitCommand(CommonCommand command) {
        this.command = command;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        CommonSender commonSender = this.getSender(sender);
        try {
            if (sender.hasPermission(this.command.getPermission())) {
                return this.command.onCommand(commonSender, this.command.getParser(args));
            }
            commonSender.sendMessage("&cYou do not have permission to use this command");
            return true;
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            e.printStackTrace();
            return false;
        }
    }

    private CommonSender getSender(CommandSender source) {
        if (source instanceof Player) {
            return new BukkitPlayer((Player)source, BanManagerPlugin.getInstance().getConfig().isOnlineMode());
        }
        return new BukkitSender(BanManagerPlugin.getInstance(), source);
    }

    public List<String> onTabComplete(CommandSender commandSender, Command command, String label, String[] args) {
        if (!this.command.isEnableTabCompletion()) {
            return Collections.emptyList();
        }
        return this.command.handlePlayerNameTabComplete(this.getSender(commandSender), args);
    }
}

