/*
 * Decompiled with CFR 0.152.
 */
package me.confuser.banmanager.bukkit;

import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import me.confuser.banmanager.bukkit.BukkitCommand;
import me.confuser.banmanager.bukkit.BukkitMetrics;
import me.confuser.banmanager.bukkit.BukkitScheduler;
import me.confuser.banmanager.bukkit.BukkitServer;
import me.confuser.banmanager.bukkit.PluginLogger;
import me.confuser.banmanager.bukkit.listeners.BanListener;
import me.confuser.banmanager.bukkit.listeners.ChatListener;
import me.confuser.banmanager.bukkit.listeners.CommandListener;
import me.confuser.banmanager.bukkit.listeners.DiscordListener;
import me.confuser.banmanager.bukkit.listeners.HookListener;
import me.confuser.banmanager.bukkit.listeners.JoinListener;
import me.confuser.banmanager.bukkit.listeners.LeaveListener;
import me.confuser.banmanager.bukkit.listeners.MuteListener;
import me.confuser.banmanager.bukkit.listeners.NoteListener;
import me.confuser.banmanager.bukkit.listeners.ReportListener;
import me.confuser.banmanager.bukkit.placeholders.PAPIPlaceholders;
import me.confuser.banmanager.common.BanManagerPlugin;
import me.confuser.banmanager.common.CommonLogger;
import me.confuser.banmanager.common.CommonMetrics;
import me.confuser.banmanager.common.CommonScheduler;
import me.confuser.banmanager.common.CommonServer;
import me.confuser.banmanager.common.commands.CommonCommand;
import me.confuser.banmanager.common.configs.PluginInfo;
import me.confuser.banmanager.common.configuration.Configuration;
import me.confuser.banmanager.common.configuration.ConfigurationSection;
import me.confuser.banmanager.common.configuration.file.YamlConfiguration;
import me.confuser.banmanager.common.runnables.BanSync;
import me.confuser.banmanager.common.runnables.BmRunnable;
import me.confuser.banmanager.common.runnables.ExpiresSync;
import me.confuser.banmanager.common.runnables.GlobalBanSync;
import me.confuser.banmanager.common.runnables.GlobalIpSync;
import me.confuser.banmanager.common.runnables.GlobalMuteSync;
import me.confuser.banmanager.common.runnables.GlobalNoteSync;
import me.confuser.banmanager.common.runnables.IpRangeSync;
import me.confuser.banmanager.common.runnables.IpSync;
import me.confuser.banmanager.common.runnables.MuteSync;
import me.confuser.banmanager.common.runnables.NameSync;
import me.confuser.banmanager.common.runnables.Purge;
import me.confuser.banmanager.common.runnables.RollbackSync;
import me.confuser.banmanager.common.runnables.Runner;
import me.confuser.banmanager.common.runnables.SaveLastChecked;
import me.confuser.banmanager.common.runnables.WarningSync;
import org.bstats.bukkit.Metrics;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class BMBukkitPlugin
extends JavaPlugin {
    private BanManagerPlugin plugin;
    private String[] configs = new String[]{"config.yml", "console.yml", "discord.yml", "exemptions.yml", "geoip.yml", "messages.yml", "reasons.yml", "schedules.yml"};
    private Metrics metrics;

    public void onEnable() {
        PluginInfo pluginInfo;
        BukkitServer server = new BukkitServer();
        try {
            pluginInfo = this.setupConfigs();
        }
        catch (IOException e) {
            this.getPluginLoader().disablePlugin((Plugin)this);
            e.printStackTrace();
            return;
        }
        this.metrics = new Metrics((JavaPlugin)this, 6455);
        this.plugin = new BanManagerPlugin(pluginInfo, (CommonLogger)new PluginLogger(this.getLogger()), this.getDataFolder(), (CommonScheduler)new BukkitScheduler(this), (CommonServer)server, (CommonMetrics)new BukkitMetrics(this.metrics));
        server.enable(this.plugin);
        try {
            this.plugin.enable();
        }
        catch (Exception e) {
            this.getPluginLoader().disablePlugin((Plugin)this);
            e.printStackTrace();
            return;
        }
        this.setupListeners();
        this.setupCommands();
        this.setupRunnables();
    }

    public void onDisable() {
        this.getServer().getScheduler().cancelTasks((Plugin)this);
        if (this.plugin != null) {
            this.plugin.disable();
        }
    }

    private PluginInfo setupConfigs() throws IOException {
        for (String name : this.configs) {
            if (!new File(this.getDataFolder(), name).exists()) {
                this.saveResource(name, false);
                continue;
            }
            File file = new File(this.getDataFolder(), name);
            InputStreamReader defConfigStream = new InputStreamReader(this.getResource(file.getName()), "UTF8");
            YamlConfiguration conf = YamlConfiguration.loadConfiguration((File)file);
            YamlConfiguration defConfig = YamlConfiguration.loadConfiguration((Reader)defConfigStream);
            conf.setDefaults((Configuration)defConfig);
            conf.options().copyDefaults(true);
            conf.save(file);
        }
        PluginInfo pluginInfo = new PluginInfo();
        InputStreamReader defConfigStream = new InputStreamReader(this.getResource("plugin.yml"), "UTF8");
        YamlConfiguration conf = YamlConfiguration.loadConfiguration((Reader)defConfigStream);
        ConfigurationSection commands = conf.getConfigurationSection("commands");
        for (String command : commands.getKeys(false)) {
            ConfigurationSection cmd = commands.getConfigurationSection(command);
            pluginInfo.setCommand(new PluginInfo.CommandInfo(command, cmd.getString("permission"), cmd.getString("usage"), cmd.getStringList("aliases")));
        }
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this, () -> {
            this.plugin.getLogger().info("The following commands are blocked whilst muted:");
            this.plugin.getConfig().handleBlockedCommands(this.plugin, this.plugin.getConfig().getMutedBlacklistCommands());
            this.plugin.getLogger().info("The following commands are blocked whilst soft muted:");
            this.plugin.getConfig().handleBlockedCommands(this.plugin, this.plugin.getConfig().getSoftMutedBlacklistCommands());
        });
        return pluginInfo;
    }

    public void setupListeners() {
        this.registerEvent(new JoinListener(this.plugin));
        this.registerEvent(new LeaveListener(this.plugin));
        this.registerEvent(new CommandListener(this.plugin));
        this.registerEvent(new HookListener(this.plugin));
        String chatPriority = this.plugin.getConfig().getChatPriority();
        if (!chatPriority.equals("NONE")) {
            ChatListener chatListener = new ChatListener(this.plugin);
            this.getServer().getPluginManager().registerEvent(AsyncPlayerChatEvent.class, (Listener)chatListener, EventPriority.valueOf((String)chatPriority), (listener, event) -> {
                ((ChatListener)listener).onPlayerChat((AsyncPlayerChatEvent)event);
                ((ChatListener)listener).onIpChat((AsyncPlayerChatEvent)event);
            }, (Plugin)this);
        }
        if (this.plugin.getConfig().isDisplayNotificationsEnabled()) {
            this.registerEvent(new BanListener(this.plugin));
            this.registerEvent(new MuteListener(this.plugin));
            this.registerEvent(new NoteListener(this.plugin));
            this.registerEvent(new ReportListener(this.plugin));
        }
        if (this.plugin.getDiscordConfig().isEnabled() && Bukkit.getPluginManager().getPlugin("DiscordSRV") != null) {
            this.registerEvent(new DiscordListener(this.plugin));
        }
        if (Bukkit.getPluginManager().getPlugin("PlaceholderAPI") != null) {
            new PAPIPlaceholders(this.plugin).register();
        }
    }

    private void registerEvent(Listener listener) {
        this.getServer().getPluginManager().registerEvents(listener, (Plugin)this);
    }

    public void setupCommands() {
        for (CommonCommand cmd : this.plugin.getCommands()) {
            try {
                this.getCommand(cmd.getCommandName()).setExecutor((CommandExecutor)new BukkitCommand(cmd));
            }
            catch (NullPointerException e) {
                this.plugin.getLogger().severe("Failed to register /" + cmd.getCommandName() + " command");
            }
        }
        if (this.plugin.getGlobalConn() != null) {
            for (CommonCommand cmd : this.plugin.getGlobalCommands()) {
                try {
                    this.getCommand(cmd.getCommandName()).setExecutor((CommandExecutor)new BukkitCommand(cmd));
                }
                catch (NullPointerException e) {
                    this.plugin.getLogger().severe("Failed to register /" + cmd.getCommandName() + " command");
                }
            }
        }
    }

    public void setupRunnables() {
        Runner syncRunner = this.plugin.getGlobalConn() == null ? new Runner(new BmRunnable[]{new BanSync(this.plugin), new MuteSync(this.plugin), new IpSync(this.plugin), new IpRangeSync(this.plugin), new ExpiresSync(this.plugin), new WarningSync(this.plugin), new RollbackSync(this.plugin), new NameSync(this.plugin)}) : new Runner(new BmRunnable[]{new BanSync(this.plugin), new MuteSync(this.plugin), new IpSync(this.plugin), new IpRangeSync(this.plugin), new ExpiresSync(this.plugin), new WarningSync(this.plugin), new RollbackSync(this.plugin), new NameSync(this.plugin), new GlobalBanSync(this.plugin), new GlobalMuteSync(this.plugin), new GlobalIpSync(this.plugin), new GlobalNoteSync(this.plugin)});
        this.plugin.setSyncRunner(syncRunner);
        this.setupAsyncRunnable(10L, (Runnable)syncRunner);
        this.setupAsyncRunnable((long)this.plugin.getSchedulesConfig().getSchedule("saveLastChecked") * 20L + 1L, (Runnable)new SaveLastChecked(this.plugin));
        this.plugin.getScheduler().runAsync((Runnable)new Purge(this.plugin));
    }

    private void setupAsyncRunnable(long length, Runnable runnable) {
        if (length <= 0L) {
            return;
        }
        this.getServer().getScheduler().runTaskTimerAsynchronously((Plugin)this, runnable, length, length);
    }

    public BanManagerPlugin getPlugin() {
        return this.plugin;
    }
}

