/*
 * Decompiled with CFR 0.152.
 */
package me.confuser.banmanager.bukkit.placeholders;

import java.util.HashMap;
import java.util.function.BiFunction;
import java.util.function.Function;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import me.confuser.banmanager.bukkit.placeholders.IpBanPlaceholder;
import me.confuser.banmanager.bukkit.placeholders.IpMutePlaceholder;
import me.confuser.banmanager.bukkit.placeholders.Placeholder;
import me.confuser.banmanager.bukkit.placeholders.PlayerBanPlaceholder;
import me.confuser.banmanager.bukkit.placeholders.PlayerMutePlaceholder;
import me.confuser.banmanager.common.BanManagerPlugin;
import me.confuser.banmanager.common.data.IpBanData;
import me.confuser.banmanager.common.data.IpMuteData;
import me.confuser.banmanager.common.data.PlayerBanData;
import me.confuser.banmanager.common.data.PlayerMuteData;
import org.bukkit.entity.Player;

public class PAPIPlaceholders
extends PlaceholderExpansion {
    private BanManagerPlugin plugin;
    private HashMap<String, Placeholder> placeholders = new HashMap();

    public PAPIPlaceholders(BanManagerPlugin plugin) {
        this.plugin = plugin;
        this.registerPlaceholder("player_bans", player -> String.valueOf(plugin.getPlayerBanStorage().getBans().size()));
        this.registerPlaceholder("player_mutes", player -> String.valueOf(plugin.getPlayerMuteStorage().getMutes().size()));
        this.registerPlaceholder("ip_bans", player -> String.valueOf(plugin.getIpBanStorage().getBans().size()));
        this.registerPlaceholder("ip_mutes", player -> String.valueOf(plugin.getIpMuteStorage().getMutes().size()));
        this.registerPlaceholder("iprange_bans", player -> String.valueOf(plugin.getIpRangeBanStorage().getBans().size()));
        this.registerBanPlaceholder("currentban_id", (player, data) -> String.valueOf(data.getId()));
        this.registerBanPlaceholder("currentban_created", (player, data) -> String.valueOf(data.getCreated()));
        this.registerBanPlaceholder("currentban_expires", (player, data) -> String.valueOf(data.getExpires()));
        this.registerBanPlaceholder("currentban_reason", (player, data) -> data.getReason());
        this.registerBanPlaceholder("currentban_actor_id", (player, data) -> data.getActor().getUUID().toString());
        this.registerBanPlaceholder("currentban_actor_name", (player, data) -> data.getActor().getName());
        this.registerMutePlaceholder("currentmute_id", (player, data) -> String.valueOf(data.getId()));
        this.registerMutePlaceholder("currentmute_created", (player, data) -> String.valueOf(data.getCreated()));
        this.registerMutePlaceholder("currentmute_expires", (player, data) -> String.valueOf(data.getExpires()));
        this.registerMutePlaceholder("currentmute_reason", (player, data) -> data.getReason());
        this.registerMutePlaceholder("currentmute_actor_id", (player, data) -> data.getActor().getUUID().toString());
        this.registerMutePlaceholder("currentmute_actor_name", (player, data) -> data.getActor().getName());
        this.registerIpBanPlaceholder("currentipban_id", (player, data) -> String.valueOf(data.getId()));
        this.registerIpBanPlaceholder("currentipban_created", (player, data) -> String.valueOf(data.getCreated()));
        this.registerIpBanPlaceholder("currentipban_expires", (player, data) -> String.valueOf(data.getExpires()));
        this.registerIpBanPlaceholder("currentipban_reason", (player, data) -> data.getReason());
        this.registerIpBanPlaceholder("currentipban_actor_id", (player, data) -> data.getActor().getUUID().toString());
        this.registerIpBanPlaceholder("currentipban_actor_name", (player, data) -> data.getActor().getName());
        this.registerIpBanPlaceholder("currentipban_ip", (player, data) -> data.getIp().toString());
        this.registerIpMutePlaceholder("currentipmute_id", (player, data) -> String.valueOf(data.getId()));
        this.registerIpMutePlaceholder("currentipmute_created", (player, data) -> String.valueOf(data.getCreated()));
        this.registerIpMutePlaceholder("currentipmute_expires", (player, data) -> String.valueOf(data.getExpires()));
        this.registerIpMutePlaceholder("currentipmute_reason", (player, data) -> data.getReason());
        this.registerIpMutePlaceholder("currentipmute_actor_id", (player, data) -> data.getActor().getUUID().toString());
        this.registerIpMutePlaceholder("currentipmute_actor_name", (player, data) -> data.getActor().getName());
        this.registerIpMutePlaceholder("currentipmute_ip", (player, data) -> data.getIp().toString());
    }

    public void registerPlaceholder(String identifier, final Function<Player, String> fn) {
        this.placeholders.put(identifier, new Placeholder(this.plugin, identifier){

            @Override
            public String getValue(Player player) {
                return (String)fn.apply(player);
            }
        });
    }

    public void registerBanPlaceholder(String identifier, final BiFunction<Player, PlayerBanData, String> fn) {
        this.placeholders.put(identifier, new PlayerBanPlaceholder(this.plugin, identifier){

            @Override
            public String getValue(Player player, PlayerBanData data) {
                return (String)fn.apply(player, data);
            }
        });
    }

    public void registerMutePlaceholder(String identifier, final BiFunction<Player, PlayerMuteData, String> fn) {
        this.placeholders.put(identifier, new PlayerMutePlaceholder(this.plugin, identifier){

            @Override
            public String getValue(Player player, PlayerMuteData data) {
                return (String)fn.apply(player, data);
            }
        });
    }

    public void registerIpBanPlaceholder(String identifier, final BiFunction<Player, IpBanData, String> fn) {
        this.placeholders.put(identifier, new IpBanPlaceholder(this.plugin, identifier){

            @Override
            public String getValue(Player player, IpBanData data) {
                return (String)fn.apply(player, data);
            }
        });
    }

    public void registerIpMutePlaceholder(String identifier, final BiFunction<Player, IpMuteData, String> fn) {
        this.placeholders.put(identifier, new IpMutePlaceholder(this.plugin, identifier){

            @Override
            public String getValue(Player player, IpMuteData data) {
                return (String)fn.apply(player, data);
            }
        });
    }

    public boolean persist() {
        return true;
    }

    public boolean canRegister() {
        return true;
    }

    public String getAuthor() {
        return "confuser";
    }

    public String getIdentifier() {
        return "bm";
    }

    public String getVersion() {
        return "7";
    }

    public String onPlaceholderRequest(Player player, String identifier) {
        Placeholder placeholder = this.placeholders.get(identifier);
        if (placeholder == null) {
            this.plugin.getLogger().warning("Unknown placeholder " + identifier + " detected");
            return null;
        }
        return placeholder.getValue(player);
    }
}

