/*
 * Decompiled with CFR 0.152.
 */
package me.confuser.banmanager.bukkit.listeners;

import java.net.InetAddress;
import me.confuser.banmanager.bukkit.BukkitPlayer;
import me.confuser.banmanager.bukkit.BukkitServer;
import me.confuser.banmanager.common.BanManagerPlugin;
import me.confuser.banmanager.common.CommonPlayer;
import me.confuser.banmanager.common.listeners.CommonJoinHandler;
import me.confuser.banmanager.common.listeners.CommonJoinListener;
import me.confuser.banmanager.common.util.IPUtils;
import me.confuser.banmanager.common.util.Message;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerPreLoginEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerLoginEvent;

public class JoinListener
implements Listener {
    private final CommonJoinListener listener;
    private BanManagerPlugin plugin;

    public JoinListener(BanManagerPlugin plugin) {
        this.plugin = plugin;
        this.listener = new CommonJoinListener(plugin);
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void banCheck(AsyncPlayerPreLoginEvent event) {
        this.listener.banCheck(event.getUniqueId(), event.getName(), IPUtils.toIPAddress((InetAddress)event.getAddress()), (CommonJoinHandler)new BanJoinHandler(event));
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onJoin(AsyncPlayerPreLoginEvent event) {
        if (event.getLoginResult() != AsyncPlayerPreLoginEvent.Result.ALLOWED) {
            return;
        }
        this.listener.onPreJoin(event.getUniqueId(), event.getName(), IPUtils.toIPAddress((InetAddress)event.getAddress()));
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onJoin(PlayerJoinEvent event) {
        this.listener.onJoin((CommonPlayer)new BukkitPlayer(event.getPlayer(), this.plugin.getConfig().isOnlineMode()));
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerLogin(PlayerLoginEvent event) {
        if (event.getResult() != PlayerLoginEvent.Result.ALLOWED) {
            return;
        }
        this.listener.onPlayerLogin((CommonPlayer)new BukkitPlayer(event.getPlayer(), this.plugin.getConfig().isOnlineMode(), event.getAddress()), (CommonJoinHandler)new LoginHandler(event));
    }

    private class LoginHandler
    implements CommonJoinHandler {
        private final PlayerLoginEvent event;

        public void handleDeny(Message message) {
            this.event.disallow(PlayerLoginEvent.Result.KICK_BANNED, message.toString());
        }

        public LoginHandler(PlayerLoginEvent event) {
            this.event = event;
        }
    }

    private class BanJoinHandler
    implements CommonJoinHandler {
        private final AsyncPlayerPreLoginEvent event;

        public void handleDeny(Message message) {
            this.event.setLoginResult(AsyncPlayerPreLoginEvent.Result.KICK_BANNED);
            this.event.setKickMessage(BukkitServer.formatMessage(message.toString()));
        }

        public BanJoinHandler(AsyncPlayerPreLoginEvent event) {
            this.event = event;
        }
    }
}

