/*
 * Decompiled with CFR 0.152.
 */
package me.confuser.banmanager.bukkit.listeners;

import me.confuser.banmanager.common.BanManagerPlugin;
import me.confuser.banmanager.common.CommonPlayer;
import me.confuser.banmanager.common.listeners.CommonChatHandler;
import me.confuser.banmanager.common.listeners.CommonChatListener;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;

public class ChatListener
implements Listener {
    private final CommonChatListener listener;
    private BanManagerPlugin plugin;

    public ChatListener(BanManagerPlugin plugin) {
        this.plugin = plugin;
        this.listener = new CommonChatListener(plugin);
    }

    public void onPlayerChat(AsyncPlayerChatEvent event) {
        CommonPlayer player = this.plugin.getServer().getPlayer(event.getPlayer().getUniqueId());
        if (this.listener.onPlayerChat(player, (CommonChatHandler)new ChatHandler(event), event.getMessage())) {
            event.setCancelled(true);
        }
    }

    public void onIpChat(AsyncPlayerChatEvent event) {
        CommonPlayer player = this.plugin.getServer().getPlayer(event.getPlayer().getUniqueId());
        if (this.listener.onIpChat(player, event.getPlayer().getAddress().getAddress(), (CommonChatHandler)new ChatHandler(event), event.getMessage())) {
            event.setCancelled(true);
        }
    }

    private class ChatHandler
    implements CommonChatHandler {
        private final AsyncPlayerChatEvent event;

        public void handleSoftMute() {
            this.event.getRecipients().clear();
            this.event.getRecipients().add(this.event.getPlayer());
        }

        public ChatHandler(AsyncPlayerChatEvent event) {
            this.event = event;
        }
    }
}

