/*
 * Decompiled with CFR 0.152.
 */
package me.confuser.banmanager.bukkit;

import java.util.Arrays;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import me.confuser.banmanager.bukkit.BukkitPlayer;
import me.confuser.banmanager.bukkit.BukkitSender;
import me.confuser.banmanager.bukkit.api.events.CustomCancellableEvent;
import me.confuser.banmanager.bukkit.api.events.CustomEvent;
import me.confuser.banmanager.bukkit.api.events.IpBanEvent;
import me.confuser.banmanager.bukkit.api.events.IpBannedEvent;
import me.confuser.banmanager.bukkit.api.events.IpMuteEvent;
import me.confuser.banmanager.bukkit.api.events.IpMutedEvent;
import me.confuser.banmanager.bukkit.api.events.IpRangeBanEvent;
import me.confuser.banmanager.bukkit.api.events.IpRangeBannedEvent;
import me.confuser.banmanager.bukkit.api.events.IpRangeUnbanEvent;
import me.confuser.banmanager.bukkit.api.events.IpUnbanEvent;
import me.confuser.banmanager.bukkit.api.events.IpUnmutedEvent;
import me.confuser.banmanager.bukkit.api.events.NameBanEvent;
import me.confuser.banmanager.bukkit.api.events.NameBannedEvent;
import me.confuser.banmanager.bukkit.api.events.NameUnbanEvent;
import me.confuser.banmanager.bukkit.api.events.PlayerBanEvent;
import me.confuser.banmanager.bukkit.api.events.PlayerBannedEvent;
import me.confuser.banmanager.bukkit.api.events.PlayerKickedEvent;
import me.confuser.banmanager.bukkit.api.events.PlayerMuteEvent;
import me.confuser.banmanager.bukkit.api.events.PlayerMutedEvent;
import me.confuser.banmanager.bukkit.api.events.PlayerNoteCreatedEvent;
import me.confuser.banmanager.bukkit.api.events.PlayerReportDeletedEvent;
import me.confuser.banmanager.bukkit.api.events.PlayerReportEvent;
import me.confuser.banmanager.bukkit.api.events.PlayerReportedEvent;
import me.confuser.banmanager.bukkit.api.events.PlayerUnbanEvent;
import me.confuser.banmanager.bukkit.api.events.PlayerUnmuteEvent;
import me.confuser.banmanager.bukkit.api.events.PlayerWarnEvent;
import me.confuser.banmanager.bukkit.api.events.PlayerWarnedEvent;
import me.confuser.banmanager.bukkit.api.events.SilentCancellableEvent;
import me.confuser.banmanager.bukkit.api.events.SilentEvent;
import me.confuser.banmanager.common.BanManagerPlugin;
import me.confuser.banmanager.common.CommonExternalCommand;
import me.confuser.banmanager.common.CommonPlayer;
import me.confuser.banmanager.common.CommonServer;
import me.confuser.banmanager.common.CommonWorld;
import me.confuser.banmanager.common.api.events.CommonEvent;
import me.confuser.banmanager.common.commands.CommonSender;
import me.confuser.banmanager.common.data.IpBanData;
import me.confuser.banmanager.common.data.IpMuteData;
import me.confuser.banmanager.common.data.IpRangeBanData;
import me.confuser.banmanager.common.data.NameBanData;
import me.confuser.banmanager.common.data.PlayerBanData;
import me.confuser.banmanager.common.data.PlayerData;
import me.confuser.banmanager.common.data.PlayerKickData;
import me.confuser.banmanager.common.data.PlayerMuteData;
import me.confuser.banmanager.common.data.PlayerNoteData;
import me.confuser.banmanager.common.data.PlayerReportData;
import me.confuser.banmanager.common.data.PlayerWarnData;
import me.confuser.banmanager.common.kyori.text.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.World;
import org.bukkit.command.BlockCommandSender;
import org.bukkit.command.CommandSender;
import org.bukkit.command.PluginCommand;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permissible;

public class BukkitServer
implements CommonServer {
    private BanManagerPlugin plugin;

    public void enable(BanManagerPlugin plugin) {
        this.plugin = plugin;
    }

    public CommonPlayer getPlayer(UUID uniqueId) {
        Player player = Bukkit.getPlayer((UUID)uniqueId);
        if (player == null) {
            return null;
        }
        return new BukkitPlayer(player, this.plugin.getConfig().isOnlineMode());
    }

    public CommonPlayer getPlayer(String name) {
        Player player = Bukkit.getPlayer((String)name);
        if (player == null) {
            return null;
        }
        return new BukkitPlayer(player, this.plugin.getConfig().isOnlineMode());
    }

    public CommonPlayer[] getOnlinePlayers() {
        return Bukkit.getOnlinePlayers().stream().map(player -> new BukkitPlayer((Player)player, this.plugin.getConfig().isOnlineMode())).collect(Collectors.toList()).toArray(new CommonPlayer[0]);
    }

    public void broadcast(String message, String permission) {
        if (message.isEmpty()) {
            return;
        }
        Set permissibles = Bukkit.getPluginManager().getPermissionSubscriptions("bukkit.broadcast.user");
        for (Permissible permissible : permissibles) {
            if (permissible instanceof BlockCommandSender || !(permissible instanceof CommandSender) || !permissible.hasPermission(permission)) continue;
            CommandSender user = (CommandSender)permissible;
            user.sendMessage(BukkitServer.formatMessage(message));
        }
    }

    public void broadcastJSON(TextComponent message, String permission) {
        Arrays.stream(this.getOnlinePlayers()).forEach(player -> {
            if (player.hasPermission(permission)) {
                player.sendJSONMessage(message);
            }
        });
    }

    public void broadcast(String message, String permission, CommonSender sender) {
        this.broadcast(message, permission);
        if (!sender.hasPermission(permission)) {
            sender.sendMessage(message);
        }
    }

    public static String formatMessage(String message) {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)message.replace("\\n", "\n"));
    }

    public CommonSender getConsoleSender() {
        return new BukkitSender(this.plugin, (CommandSender)Bukkit.getServer().getConsoleSender());
    }

    public boolean dispatchCommand(CommonSender sender, String command) {
        Object bukkitSender = sender.isConsole() ? Bukkit.getServer().getConsoleSender() : Bukkit.getPlayer((String)sender.getName());
        return Bukkit.dispatchCommand((CommandSender)bukkitSender, (String)command);
    }

    public CommonWorld getWorld(String name) {
        World world = Bukkit.getWorld((String)name);
        if (world == null) {
            return null;
        }
        return new CommonWorld(name);
    }

    public CommonEvent callEvent(String name, Object ... args) {
        CustomEvent event = null;
        CommonEvent commonEvent = new CommonEvent(false, true);
        switch (name) {
            case "PlayerBanEvent": {
                event = new PlayerBanEvent((PlayerBanData)args[0], (boolean)((Boolean)args[1]));
                break;
            }
            case "PlayerBannedEvent": {
                event = new PlayerBannedEvent((PlayerBanData)args[0], (boolean)((Boolean)args[1]));
                break;
            }
            case "PlayerUnbanEvent": {
                event = new PlayerUnbanEvent((PlayerBanData)args[0], (PlayerData)args[1], (String)args[2]);
                break;
            }
            case "IpBanEvent": {
                event = new IpBanEvent((IpBanData)args[0], (boolean)((Boolean)args[1]));
                break;
            }
            case "IpBannedEvent": {
                event = new IpBannedEvent((IpBanData)args[0], (boolean)((Boolean)args[1]));
                break;
            }
            case "IpUnbanEvent": {
                event = new IpUnbanEvent((IpBanData)args[0], (PlayerData)args[1], (String)args[2]);
                break;
            }
            case "IpMuteEvent": {
                event = new IpMuteEvent((IpMuteData)args[0], (boolean)((Boolean)args[1]));
                break;
            }
            case "IpMutedEvent": {
                event = new IpMutedEvent((IpMuteData)args[0], (boolean)((Boolean)args[1]));
                break;
            }
            case "IpUnmutedEvent": {
                event = new IpUnmutedEvent((IpMuteData)args[0], (PlayerData)args[1], (String)args[2]);
                break;
            }
            case "PlayerKickedEvent": {
                event = new PlayerKickedEvent((PlayerKickData)args[0], (boolean)((Boolean)args[1]));
                break;
            }
            case "PlayerNoteCreatedEvent": {
                event = new PlayerNoteCreatedEvent((PlayerNoteData)args[0]);
                break;
            }
            case "PlayerReportEvent": {
                event = new PlayerReportEvent((PlayerReportData)args[0], (boolean)((Boolean)args[1]));
                break;
            }
            case "PlayerReportedEvent": {
                event = new PlayerReportedEvent((PlayerReportData)args[0], (boolean)((Boolean)args[1]));
                break;
            }
            case "PlayerReportDeletedEvent": {
                event = new PlayerReportDeletedEvent((PlayerReportData)args[0]);
                break;
            }
            case "NameBanEvent": {
                event = new NameBanEvent((NameBanData)args[0], (boolean)((Boolean)args[1]));
                break;
            }
            case "NameBannedEvent": {
                event = new NameBannedEvent((NameBanData)args[0], (boolean)((Boolean)args[1]));
                break;
            }
            case "NameUnbanEvent": {
                event = new NameUnbanEvent((NameBanData)args[0], (PlayerData)args[1], (String)args[2]);
                break;
            }
            case "PlayerWarnEvent": {
                event = new PlayerWarnEvent((PlayerWarnData)args[0], (boolean)((Boolean)args[1]));
                break;
            }
            case "PlayerWarnedEvent": {
                event = new PlayerWarnedEvent((PlayerWarnData)args[0], (boolean)((Boolean)args[1]));
                break;
            }
            case "IpRangeBanEvent": {
                event = new IpRangeBanEvent((IpRangeBanData)args[0], (boolean)((Boolean)args[1]));
                break;
            }
            case "IpRangeBannedEvent": {
                event = new IpRangeBannedEvent((IpRangeBanData)args[0], (boolean)((Boolean)args[1]));
                break;
            }
            case "IpRangeUnbanEvent": {
                event = new IpRangeUnbanEvent((IpRangeBanData)args[0], (PlayerData)args[1], (String)args[2]);
                break;
            }
            case "PlayerMuteEvent": {
                event = new PlayerMuteEvent((PlayerMuteData)args[0], (boolean)((Boolean)args[1]));
                break;
            }
            case "PlayerMutedEvent": {
                event = new PlayerMutedEvent((PlayerMuteData)args[0], (boolean)((Boolean)args[1]));
                break;
            }
            case "PlayerUnmuteEvent": {
                event = new PlayerUnmuteEvent((PlayerMuteData)args[0], (PlayerData)args[1], (String)args[2]);
            }
        }
        if (event == null) {
            this.plugin.getLogger().warning("Unable to call missing event " + name);
            return commonEvent;
        }
        Bukkit.getServer().getPluginManager().callEvent(event);
        if (event instanceof SilentCancellableEvent) {
            commonEvent = new CommonEvent(((SilentCancellableEvent)event).isCancelled(), ((SilentCancellableEvent)event).isSilent());
        } else if (event instanceof SilentEvent) {
            commonEvent = new CommonEvent(false, ((SilentEvent)event).isSilent());
        } else if (event instanceof CustomCancellableEvent) {
            commonEvent = new CommonEvent(((CustomCancellableEvent)event).isCancelled(), true);
        }
        return commonEvent;
    }

    public CommonExternalCommand getPluginCommand(String commandName) {
        PluginCommand pluginCommand = Bukkit.getServer().getPluginCommand(commandName);
        if (pluginCommand == null) {
            return null;
        }
        return new CommonExternalCommand(pluginCommand.getPlugin().getDescription().getName().toLowerCase(), pluginCommand.getName(), pluginCommand.getAliases());
    }
}

