/*
 * Decompiled with CFR 0.152.
 */
package me.confuser.banmanager.bukkit;

import java.net.InetAddress;
import java.sql.SQLException;
import java.util.UUID;
import me.confuser.banmanager.bukkit.BukkitServer;
import me.confuser.banmanager.common.BanManagerPlugin;
import me.confuser.banmanager.common.CommonPlayer;
import me.confuser.banmanager.common.CommonWorld;
import me.confuser.banmanager.common.data.PlayerData;
import me.confuser.banmanager.common.kyori.text.Component;
import me.confuser.banmanager.common.kyori.text.TextComponent;
import me.confuser.banmanager.common.kyori.text.serializer.gson.GsonComponentSerializer;
import me.confuser.banmanager.common.util.Message;
import me.confuser.banmanager.common.util.UUIDUtils;
import net.md_5.bungee.chat.ComponentSerializer;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Player;

public class BukkitPlayer
implements CommonPlayer {
    private Player player;
    private final UUID uuid;
    private InetAddress address;
    private final boolean onlineMode;

    public BukkitPlayer(UUID uuid, String name, boolean onlineMode) {
        this.uuid = uuid;
        this.onlineMode = onlineMode;
    }

    public BukkitPlayer(Player player, boolean onlineMode) {
        this(player.getUniqueId(), player.getName(), onlineMode);
        this.player = player;
    }

    public BukkitPlayer(Player player, boolean onlineMode, InetAddress address) {
        this(player, onlineMode);
        this.address = address;
    }

    public void kick(String message) {
        this.getPlayer().kickPlayer(BukkitServer.formatMessage(message));
    }

    public void sendMessage(String message) {
        if (message.isEmpty()) {
            return;
        }
        if (Message.isJSONMessage((String)message)) {
            this.sendJSONMessage(message);
        } else {
            this.getPlayer().sendMessage(BukkitServer.formatMessage(message));
        }
    }

    public void sendMessage(Message message) {
        this.sendMessage(message.toString());
    }

    public void sendJSONMessage(TextComponent jsonString) {
        this.getPlayer().spigot().sendMessage(ComponentSerializer.parse((String)GsonComponentSerializer.INSTANCE.serialize((Component)jsonString)));
    }

    public void sendJSONMessage(String message) {
        this.getPlayer().spigot().sendMessage(ComponentSerializer.parse((String)message));
    }

    public boolean isConsole() {
        return false;
    }

    public PlayerData getData() {
        try {
            return (PlayerData)BanManagerPlugin.getInstance().getPlayerStorage().queryForId((Object)UUIDUtils.toBytes((UUID)this.getUniqueId()));
        }
        catch (SQLException e) {
            e.printStackTrace();
            this.sendMessage(Message.get((String)"sender.error.exception").toString());
            return null;
        }
    }

    public boolean isOnlineMode() {
        return this.onlineMode;
    }

    public boolean hasPermission(String permission) {
        return this.getPlayer().hasPermission(permission);
    }

    public String getDisplayName() {
        return this.getPlayer().getDisplayName();
    }

    public String getName() {
        return this.getPlayer().getName();
    }

    public InetAddress getAddress() {
        if (this.address != null) {
            return this.address;
        }
        return this.getPlayer().getAddress().getAddress();
    }

    public UUID getUniqueId() {
        return this.getPlayer().getUniqueId();
    }

    public boolean teleport(CommonWorld world, double x, double y, double z, float pitch, float yaw) {
        Player player = this.getPlayer();
        Location location = new Location(Bukkit.getWorld((String)world.getName()), x, y, z, yaw, pitch);
        if (player.isInsideVehicle()) {
            player.leaveVehicle();
        }
        return player.teleport(location);
    }

    public boolean canSee(CommonPlayer player) {
        return this.getPlayer().canSee(Bukkit.getPlayer((UUID)player.getUniqueId()));
    }

    public boolean isOnline() {
        return this.getPlayer() != null;
    }

    private Player getPlayer() {
        if (this.player != null) {
            return this.player;
        }
        if (this.isOnlineMode()) {
            return Bukkit.getServer().getPlayer(this.uuid);
        }
        for (Player onlinePlayer : Bukkit.getServer().getOnlinePlayers()) {
            if (!UUIDUtils.createOfflineUUID((String)onlinePlayer.getName()).equals(this.uuid)) continue;
            return onlinePlayer;
        }
        return null;
    }
}

