/*
 * Decompiled with CFR 0.152.
 */
package me.catcoder.sidebar;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.ProtocolManager;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.wrappers.EnumWrappers;
import com.comphenix.protocol.wrappers.WrappedChatComponent;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import lombok.NonNull;
import me.catcoder.sidebar.util.VersionUtil;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;

public class SidebarLine {
    private static final ChatColor[] COLORS = ChatColor.values();
    private static final Splitter SPLITTER = Splitter.fixedLength((int)16);
    private static final int TEAM_CREATED = 0;
    private static final int TEAM_REMOVED = 1;
    private static final int TEAM_UPDATED = 2;
    private static final int PLAYERS_ADDED = 3;
    private static final int PLAYERS_REMOVED = 4;
    private final String teamName;
    private int score = -1;
    private final int index;
    private final boolean staticText;
    private Function<Player, String> updater;

    SidebarLine(@NonNull Function<Player, String> updater, @NonNull String teamName, boolean staticText, int index) {
        if (updater == null) {
            throw new NullPointerException("updater is marked non-null but is null");
        }
        if (teamName == null) {
            throw new NullPointerException("teamName is marked non-null but is null");
        }
        this.updater = updater;
        this.teamName = teamName;
        this.staticText = staticText;
        this.index = index;
    }

    public void setUpdater(@NonNull Function<Player, String> updater) {
        if (updater == null) {
            throw new NullPointerException("updater is marked non-null but is null");
        }
        Preconditions.checkState((!this.isStaticText() ? 1 : 0) != 0, (Object)"Cannot set updater for static text line");
        this.updater = updater;
    }

    void updateTeam(@NonNull Player player, int previousScore, @NonNull String objective) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        if (objective == null) {
            throw new NullPointerException("objective is marked non-null but is null");
        }
        if (!this.isStaticText()) {
            String text = this.updater.apply(player);
            SidebarLine.sendPacket(player, this.createTeamPacket(2, player, text));
        }
        if (previousScore != this.score) {
            SidebarLine.sendPacket(player, this.createScorePacket(EnumWrappers.ScoreboardAction.CHANGE, objective));
        }
    }

    void removeTeam(@NonNull Player player, @NonNull String objective) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        if (objective == null) {
            throw new NullPointerException("objective is marked non-null but is null");
        }
        SidebarLine.sendPacket(player, this.createScorePacket(EnumWrappers.ScoreboardAction.REMOVE, objective));
        SidebarLine.sendPacket(player, this.createTeamPacket(1, null, null));
    }

    void createTeam(@NonNull Player player, @NonNull String objective) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        if (objective == null) {
            throw new NullPointerException("objective is marked non-null but is null");
        }
        String text = this.updater.apply(player);
        SidebarLine.sendPacket(player, this.createTeamPacket(0, player, text));
        SidebarLine.sendPacket(player, this.createScorePacket(EnumWrappers.ScoreboardAction.CHANGE, objective));
    }

    void setScore(int score) {
        this.score = score;
    }

    private PacketContainer createTeamPacket(int mode, Player player, String text) {
        String teamEntry = COLORS[this.index].toString();
        PacketContainer packet = SidebarLine.getProtocolManager().createPacket(PacketType.Play.Server.SCOREBOARD_TEAM);
        packet.getModifier().writeDefaults();
        packet.getStrings().write(0, (Object)this.teamName);
        packet.getIntegers().write(1, (Object)mode);
        if (mode == 1) {
            return packet;
        }
        int version = VersionUtil.getPlayerVersion(player.getUniqueId());
        packet.getSpecificModifier(Collection.class).write(0, Collections.singletonList(teamEntry));
        if (version >= 393) {
            if (!text.isEmpty() && text.charAt(0) != '\u00a7') {
                text = ChatColor.RESET + text;
            }
            if (VersionUtil.SERVER_VERSION >= 393) {
                packet.getChatComponents().write(1, (Object)WrappedChatComponent.fromText((String)text));
                packet.getChatComponents().write(2, (Object)WrappedChatComponent.fromText((String)ChatColor.RESET.toString()));
            } else {
                packet.getStrings().write(2, (Object)text);
                packet.getStrings().write(3, (Object)ChatColor.RESET.toString());
            }
            return packet;
        }
        Iterator iterator = SPLITTER.split((CharSequence)text).iterator();
        String prefix = (String)iterator.next();
        packet.getStrings().write(2, (Object)prefix);
        if (text.length() > 16) {
            String prefixColor = ChatColor.getLastColors((String)prefix);
            String suffix = (String)iterator.next();
            if (prefix.endsWith(String.valueOf('\u00a7'))) {
                prefix = prefix.substring(0, prefix.length() - 1);
                packet.getStrings().write(2, (Object)prefix);
                prefixColor = ChatColor.getByChar((char)suffix.charAt(0)).toString();
                suffix = suffix.substring(1);
            }
            if (prefixColor == null) {
                prefixColor = "";
            }
            if ((suffix = (prefixColor.equals("") ? ChatColor.RESET : prefixColor) + suffix).length() > 16) {
                suffix = suffix.substring(0, 13) + "...";
            }
            packet.getStrings().write(3, (Object)suffix);
        }
        return packet;
    }

    private PacketContainer createScorePacket(EnumWrappers.ScoreboardAction action, String objectiveName) {
        PacketContainer packet = SidebarLine.getProtocolManager().createPacket(PacketType.Play.Server.SCOREBOARD_SCORE);
        packet.getStrings().write(0, (Object)COLORS[this.index].toString());
        packet.getStrings().write(1, (Object)objectiveName);
        packet.getScoreboardActions().write(0, (Object)action);
        packet.getIntegers().write(0, (Object)this.score);
        return packet;
    }

    private static ProtocolManager getProtocolManager() {
        return ProtocolLibrary.getProtocolManager();
    }

    static void sendPacket(Player player, PacketContainer packet) {
        SidebarLine.getProtocolManager().sendServerPacket(player, packet);
    }

    public String getTeamName() {
        return this.teamName;
    }

    public int getScore() {
        return this.score;
    }

    public int getIndex() {
        return this.index;
    }

    public boolean isStaticText() {
        return this.staticText;
    }

    public Function<Player, String> getUpdater() {
        return this.updater;
    }

    public String toString() {
        return "SidebarLine(teamName=" + this.getTeamName() + ", score=" + this.getScore() + ", index=" + this.getIndex() + ", staticText=" + this.isStaticText() + ", updater=" + this.getUpdater() + ")";
    }
}

