/*
 * Decompiled with CFR 0.152.
 */
package me.catcoder.sidebar;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;
import lombok.NonNull;
import me.catcoder.sidebar.ScoreboardObjective;
import me.catcoder.sidebar.SidebarLine;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public class Sidebar
implements Listener {
    private final Set<UUID> viewers = new HashSet<UUID>();
    private final List<SidebarLine> lines = new ArrayList<SidebarLine>();
    private final ScoreboardObjective objective;

    @Deprecated
    public Sidebar(@NonNull Plugin owner, @NonNull String objective, @NonNull String title) {
        if (owner == null) {
            throw new NullPointerException("owner is marked non-null but is null");
        }
        if (objective == null) {
            throw new NullPointerException("objective is marked non-null but is null");
        }
        if (title == null) {
            throw new NullPointerException("title is marked non-null but is null");
        }
        this.objective = new ScoreboardObjective(objective, title);
        this.addListener(owner);
    }

    public Sidebar(@NonNull String objective, @NonNull String title) {
        if (objective == null) {
            throw new NullPointerException("objective is marked non-null but is null");
        }
        if (title == null) {
            throw new NullPointerException("title is marked non-null but is null");
        }
        this.objective = new ScoreboardObjective(objective, title);
    }

    public void addListener(@NonNull Plugin plugin) {
        if (plugin == null) {
            throw new NullPointerException("plugin is marked non-null but is null");
        }
        plugin.getServer().getPluginManager().registerEvents((Listener)this, plugin);
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        this.viewers.remove(event.getPlayer().getUniqueId());
    }

    public void setTitle(@NonNull String title) {
        if (title == null) {
            throw new NullPointerException("title is marked non-null but is null");
        }
        this.objective.setDisplayName(title);
        this.broadcast(this.objective::updateValue);
    }

    public void shiftLine(SidebarLine line, int offset) {
        this.lines.remove(line);
        this.lines.add(offset, line);
        this.update();
    }

    public BukkitTask updatePeriodically(long delay, long period, @NonNull Plugin plugin) {
        if (plugin == null) {
            throw new NullPointerException("plugin is marked non-null but is null");
        }
        return Bukkit.getScheduler().runTaskTimerAsynchronously(plugin, this::update, delay, period);
    }

    public SidebarLine addLine(@NonNull String text) {
        if (text == null) {
            throw new NullPointerException("text is marked non-null but is null");
        }
        return this.addLine(x -> text, true);
    }

    public SidebarLine addBlankLine() {
        return this.addLine("");
    }

    public SidebarLine addLine(@NonNull Function<Player, String> updater) {
        if (updater == null) {
            throw new NullPointerException("updater is marked non-null but is null");
        }
        return this.addLine(updater, false);
    }

    public SidebarLine addLine(@NonNull Function<Player, String> updater, boolean staticText) {
        if (updater == null) {
            throw new NullPointerException("updater is marked non-null but is null");
        }
        SidebarLine line = new SidebarLine(updater, this.objective.getName() + this.lines.size(), staticText, this.lines.size());
        this.lines.add(line);
        return line;
    }

    public void removeLine(@NonNull SidebarLine line) {
        if (line == null) {
            throw new NullPointerException("line is marked non-null but is null");
        }
        if (this.lines.remove(line) && line.getScore() != -1) {
            this.broadcast(p -> line.removeTeam((Player)p, this.objective.getName()));
            this.update();
        }
    }

    public Optional<SidebarLine> maxLine() {
        return this.lines.stream().filter(line -> line.getScore() != -1).max(Comparator.comparingInt(SidebarLine::getScore));
    }

    public Optional<SidebarLine> minLine() {
        return this.lines.stream().filter(line -> line.getScore() != -1).min(Comparator.comparingInt(SidebarLine::getScore));
    }

    public void update() {
        int index = this.lines.size();
        for (SidebarLine line : this.lines) {
            if (line.getScore() == -1) {
                line.setScore(index--);
                this.broadcast(p -> line.createTeam((Player)p, this.objective.getName()));
                continue;
            }
            int prevIndex = line.getScore();
            line.setScore(index--);
            this.broadcast(p -> line.updateTeam((Player)p, prevIndex, this.objective.getName()));
        }
    }

    public void removeViewers() {
        for (UUID id : new ArrayList<UUID>(this.viewers)) {
            Player player = Bukkit.getPlayer((UUID)id);
            if (player == null) continue;
            this.removeViewer(player);
        }
    }

    public void addViewer(@NonNull Player player) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        if (this.viewers.add(player.getUniqueId())) {
            this.update();
            this.objective.create(player);
            this.lines.forEach(line -> line.createTeam(player, this.objective.getName()));
            this.objective.display(player);
        }
    }

    public void removeViewer(@NonNull Player player) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        if (this.viewers.remove(player.getUniqueId())) {
            this.update();
            this.lines.forEach(line -> line.removeTeam(player, this.objective.getName()));
            this.objective.remove(player);
        }
    }

    public Set<UUID> getViewers() {
        return Collections.unmodifiableSet(this.viewers);
    }

    public List<SidebarLine> getLines() {
        return Collections.unmodifiableList(this.lines);
    }

    public ScoreboardObjective getObjective() {
        return this.objective;
    }

    private void broadcast(@NonNull Consumer<Player> consumer) {
        if (consumer == null) {
            throw new NullPointerException("consumer is marked non-null but is null");
        }
        this.viewers.stream().map(Bukkit::getPlayer).filter(Objects::nonNull).forEach(consumer);
    }
}

