/*
 * Decompiled with CFR 0.152.
 */
package me.catcoder.sidebar;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.ProtocolManager;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.wrappers.WrappedChatComponent;
import com.google.common.base.Preconditions;
import lombok.NonNull;
import me.catcoder.sidebar.util.VersionUtil;
import org.bukkit.entity.Player;

public class ScoreboardObjective {
    public static final int DISPLAY_SIDEBAR = 1;
    public static final int ADD_OBJECTIVE = 0;
    public static final int REMOVE_OBJECTIVE = 1;
    public static final int UPDATE_VALUE = 2;
    private final String name;
    private String displayName;

    public ScoreboardObjective(@NonNull String name, @NonNull String displayName) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (displayName == null) {
            throw new NullPointerException("displayName is marked non-null but is null");
        }
        Preconditions.checkArgument((name.length() <= 16 ? 1 : 0) != 0, (Object)"Objective name exceeds 16 symbols limit");
        this.name = name;
        this.displayName = displayName;
    }

    void setDisplayName(@NonNull String displayName) {
        if (displayName == null) {
            throw new NullPointerException("displayName is marked non-null but is null");
        }
        this.displayName = displayName;
    }

    void updateValue(@NonNull Player player) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        PacketContainer packet = this.getPacket(player);
        packet.getIntegers().write(0, (Object)2);
        ScoreboardObjective.sendPacket(player, packet);
    }

    void create(@NonNull Player player) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        PacketContainer packet = this.getPacket(player);
        packet.getIntegers().write(0, (Object)0);
        ScoreboardObjective.sendPacket(player, packet);
    }

    void remove(@NonNull Player player) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        PacketContainer packet = this.getPacket(player);
        packet.getIntegers().write(0, (Object)1);
        ScoreboardObjective.sendPacket(player, packet);
    }

    void display(@NonNull Player player) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        PacketContainer packet = ScoreboardObjective.getProtocolManager().createPacket(PacketType.Play.Server.SCOREBOARD_DISPLAY_OBJECTIVE);
        packet.getIntegers().write(0, (Object)1);
        packet.getStrings().write(0, (Object)this.name);
        ScoreboardObjective.sendPacket(player, packet);
    }

    private PacketContainer getPacket(@NonNull Player player) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        int version = VersionUtil.getPlayerVersion(player.getUniqueId());
        PacketContainer packet = ScoreboardObjective.getProtocolManager().createPacket(PacketType.Play.Server.SCOREBOARD_OBJECTIVE);
        if (version < 393 && this.displayName.length() > 32) {
            this.displayName = this.displayName.substring(0, 32);
        }
        if (VersionUtil.SERVER_VERSION >= 393) {
            packet.getChatComponents().write(0, (Object)WrappedChatComponent.fromText((String)this.displayName));
        } else {
            packet.getStrings().write(1, (Object)this.displayName);
        }
        packet.getStrings().write(0, (Object)this.name);
        packet.getEnumModifier(HealthDisplay.class, 2).write(0, (Object)HealthDisplay.INTEGER);
        return packet;
    }

    private static ProtocolManager getProtocolManager() {
        return ProtocolLibrary.getProtocolManager();
    }

    static void sendPacket(Player player, PacketContainer packet) {
        ScoreboardObjective.getProtocolManager().sendServerPacket(player, packet);
    }

    public String getName() {
        return this.name;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public static enum HealthDisplay {
        INTEGER,
        HEARTS;

    }
}

