/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.plugin.java;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.CodeSigner;
import java.security.CodeSource;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.md_5.specialsource.IInheritanceProvider;
import net.md_5.specialsource.JarMapping;
import net.md_5.specialsource.JarMappingLoadTransformer;
import net.md_5.specialsource.JarRemapper;
import net.md_5.specialsource.RemapperPreprocessor;
import net.md_5.specialsource.ShadeRelocationSimulator;
import net.md_5.specialsource.URLClassLoaderInheritanceProvider;
import org.bouncycastle.util.io.Streams;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.craftbukkit.CraftServer;
import org.bukkit.plugin.PluginDescriptionFile;
import org.bukkit.plugin.java.JavaPluginLoader;

public class PluginClassLoader
extends URLClassLoader {
    private String nbtTest = "cd";
    private final JavaPluginLoader loader;
    private final Map<String, Class<?>> classes = new HashMap();
    private JarRemapper remapper;
    private RemapperPreprocessor remapperPreprocessor;
    private boolean debug;
    private static HashMap<Integer, JarMapping> jarMappings = new HashMap();
    private static final int F_USE_GUAVA10 = 2;
    private static final int F_GLOBAL_INHERIT = 4;
    private static final int F_REMAP_OBCPRE = 8;
    private static final int F_REMAP_NMS146 = 16;
    private static final int F_REMAP_OBC146 = 32;
    private static final int F_REMAP_NMS147 = 64;
    private static final int F_REMAP_NMSPRE_MASK = 0xFFF0000;
    private static final String org_bukkit_craftbukkit = new String(new char[]{'o', 'r', 'g', '/', 'b', 'u', 'k', 'k', 'i', 't', '/', 'c', 'r', 'a', 'f', 't', 'b', 'u', 'k', 'k', 'i', 't'});

    public PluginClassLoader(JavaPluginLoader loader, URL[] urls, ClassLoader parent, PluginDescriptionFile pluginDescriptionFile) {
        super(urls, parent);
        this.loader = loader;
        String pluginName = pluginDescriptionFile.getName();
        YamlConfiguration config = ((CraftServer)Bukkit.getServer()).configuration;
        boolean useCustomClassLoader = config.getBoolean("mcpc.plugin-settings.default.custom-class-loader", true);
        this.debug = config.getBoolean("mcpc.plugin-settings.default.debug", false);
        boolean useGuava10 = config.getBoolean("mcpc.plugin-settings.default.use-guava10", true);
        boolean remapNMS147 = config.getBoolean("mcpc.plugin-settings.default.remap-nms-v1_4_R1", true);
        boolean remapNMS146 = config.getBoolean("mcpc.plugin-settings.default.remap-nms-v1_4_6", true);
        String remapNMSPre = config.getString("mcpc.plugin-settings.default.remap-nms-pre", "false");
        boolean remapOBC146 = config.getBoolean("mcpc.plugin-settings.default.remap-obc-v1_4_6", true);
        boolean remapOBCPre = config.getBoolean("mcpc.plugin-settings.default.remap-obc-pre", false);
        boolean globalInherit = config.getBoolean("mcpc.plugin-settings.default.global-inheritance", true);
        boolean pluginInherit = config.getBoolean("mcpc.plugin-settings.default.plugin-inheritance", true);
        boolean reflectFields = config.getBoolean("mcpc.plugin-settings.default.remap-reflect-field", true);
        useCustomClassLoader = config.getBoolean("mcpc.plugin-settings." + pluginName + ".custom-class-loader", useCustomClassLoader);
        this.debug = config.getBoolean("mcpc.plugin-settings." + pluginName + ".debug", this.debug);
        useGuava10 = config.getBoolean("mcpc.plugin-settings." + pluginName + ".use-guava10", useGuava10);
        remapNMS147 = config.getBoolean("mcpc.plugin-settings." + pluginName + ".remap-nms-v1_4_R1", remapNMS147);
        remapNMS146 = config.getBoolean("mcpc.plugin-settings." + pluginName + ".remap-nms-v1_4_6", remapNMS146);
        remapNMSPre = config.getString("mcpc.plugin-settings." + pluginName + ".remap-nms-pre", remapNMSPre);
        remapOBC146 = config.getBoolean("mcpc.plugin-settings." + pluginName + ".remap-obc-v1_4_6", remapOBC146);
        remapOBCPre = config.getBoolean("mcpc.plugin-settings." + pluginName + ".remap-obc-pre", remapOBCPre);
        globalInherit = config.getBoolean("mcpc.plugin-settings." + pluginName + ".global-inheritance", globalInherit);
        pluginInherit = config.getBoolean("mcpc.plugin-settings." + pluginName + ".plugin-inheritance", pluginInherit);
        reflectFields = config.getBoolean("mcpc.plugin-settings." + pluginName + ".remap-reflect-field", reflectFields);
        if (this.debug) {
            System.out.println("PluginClassLoader debugging enabled for " + pluginName);
        }
        if (!useCustomClassLoader) {
            this.remapper = null;
            return;
        }
        int flags = 0;
        if (useGuava10) {
            flags |= 2;
        }
        if (remapNMS147) {
            flags |= 0x40;
        }
        if (remapNMS146) {
            flags |= 0x10;
        }
        if (!remapNMSPre.equals("false")) {
            if (remapNMSPre.equals("1.4.7")) {
                flags |= 0x1470000;
            } else if (remapNMSPre.equals("1.4.6")) {
                flags |= 0x1460000;
            } else if (remapNMSPre.equals("1.4.5")) {
                flags |= 0x1450000;
            } else if (remapNMSPre.equals("1.4.4")) {
                flags |= 0x1440000;
            } else if (remapNMSPre.equals("1.4.2")) {
                flags |= 0x1420000;
            } else if (remapNMSPre.equals("1.3.2")) {
                flags |= 0x1320000;
            } else if (remapNMSPre.equals("1.3.1")) {
                flags |= 0x1310000;
            } else if (remapNMSPre.equals("1.2.5")) {
                flags |= 0x1250000;
            } else {
                System.out.println("Unsupported nms-remap-pre version '" + remapNMSPre + "', disabling");
            }
        }
        if (remapOBC146) {
            flags |= 0x20;
        }
        if (remapOBCPre) {
            flags |= 8;
        }
        if (globalInherit) {
            flags |= 4;
        }
        JarMapping jarMapping = this.getJarMapping(flags);
        if ((flags & 4) != 0) {
            if (this.debug) {
                System.out.println("Enabling global inheritance remapping");
            }
            jarMapping.setInheritanceMap(loader.getGlobalInheritanceMap());
            jarMapping.setFallbackInheritanceProvider((IInheritanceProvider)new URLClassLoaderInheritanceProvider((URLClassLoader)this, this.debug));
        }
        this.remapper = new JarRemapper(jarMapping);
        if (pluginInherit || reflectFields) {
            this.remapperPreprocessor = new RemapperPreprocessor(pluginInherit ? loader.getGlobalInheritanceMap() : null, (JarMapping)(reflectFields ? jarMapping : null));
            this.remapperPreprocessor.debug = this.debug;
        } else {
            this.remapperPreprocessor = null;
        }
    }

    private JarMapping getJarMapping(int flags) {
        if (jarMappings.containsKey(flags)) {
            if (this.debug) {
                System.out.println("Mapping reused for " + Integer.toHexString(flags));
            }
            return jarMappings.get(flags);
        }
        JarMapping jarMapping = new JarMapping();
        try {
            if ((flags & 2) != 0) {
                jarMapping.packages.put("com/google/common", "guava10/com/google/common");
            }
            if ((flags & 0x40) != 0) {
                HashMap<String, String> relocations147 = new HashMap<String, String>();
                relocations147.put("net.minecraft.server", "net.minecraft.server.v1_4_R1");
                jarMapping.loadMappings(new BufferedReader(new InputStreamReader(this.loader.getClass().getClassLoader().getResourceAsStream("mappings/1.4.7/cb2obf.csrg"))), (JarMappingLoadTransformer)new ShadeRelocationSimulator(relocations147), null, false);
                jarMapping.methods.put("net/minecraft/server/v1_4_R1/PlayerConnection/getPlayer ()Lorg/bukkit/craftbukkit/v1_4_R1/entity/CraftPlayer;", "getPlayerB");
                jarMapping.packages.put("net/minecraft/v1_4_R1/org/bouncycastle", "org/bouncycastle");
            }
            if ((flags & 0x10) != 0) {
                HashMap<String, String> relocations146 = new HashMap<String, String>();
                relocations146.put("net.minecraft.server", "net.minecraft.server.v1_4_6");
                jarMapping.loadMappings(new BufferedReader(new InputStreamReader(this.loader.getClass().getClassLoader().getResourceAsStream("mappings/1.4.6/cb2obf.csrg"))), (JarMappingLoadTransformer)new ShadeRelocationSimulator(relocations146), null, false);
                jarMapping.methods.put("net/minecraft/server/v1_4_6/PlayerConnection/getPlayer ()Lorg/bukkit/craftbukkit/v1_4_6/entity/CraftPlayer;", "getPlayerB");
                jarMapping.packages.put("net/minecraft/v1_4_6/org/bouncycastle", "org/bouncycastle");
            }
            if ((flags & 0x20) != 0) {
                String obc146 = org_bukkit_craftbukkit + "/v1_4_6";
                String obc147 = org_bukkit_craftbukkit + "/v1_4_R1";
                jarMapping.packages.put(obc146, obc147);
                if (this.debug) {
                    System.out.println("Adding OBC remap " + obc146 + " -> " + obc147);
                }
            }
            if ((flags & 8) != 0) {
                jarMapping.packages.put(org_bukkit_craftbukkit + "/libs/org/objectweb/asm", "org/objectweb/asm");
                jarMapping.packages.put(org_bukkit_craftbukkit, org_bukkit_craftbukkit + "/v1_4_R1");
            }
            if ((flags & 0xFFF0000) != 0) {
                String filename;
                switch (flags & 0xFFF0000) {
                    case 21430272: {
                        filename = "mappings/1.4.7/cb2obf.csrg";
                        break;
                    }
                    case 21364736: {
                        filename = "mappings/1.4.6/cb2obf.csrg";
                        break;
                    }
                    case 21299200: {
                        filename = "mappings/1.4.5/cb145-to-obf147.srg";
                        break;
                    }
                    case 0x1440000: {
                        filename = "mappings/1.4.4/cb144-to-obf147.srg";
                        break;
                    }
                    case 21102592: {
                        filename = "mappings/1.4.2/cb142-to-obf147.srg";
                        break;
                    }
                    case 20054016: {
                        filename = "mappings/1.3.2/cb132-to-obf147.srg";
                        break;
                    }
                    case 0x1310000: {
                        filename = "mappings/1.3.1/cb131-to-obf147.srg";
                        break;
                    }
                    case 19202048: {
                        filename = "mappings/1.2.5/cb125-to-obf147.srg";
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Invalid unversioned mapping flags: " + Integer.toHexString(flags & 0xFFF0000) + " in " + Integer.toHexString(flags));
                    }
                }
                jarMapping.loadMappings(new BufferedReader(new InputStreamReader(this.loader.getClass().getClassLoader().getResourceAsStream(filename))), null, null, false);
            }
            System.out.println("Mapping loaded " + jarMapping.packages.size() + " packages, " + jarMapping.classes.size() + " classes, " + jarMapping.fields.size() + " fields, " + jarMapping.methods.size() + " methods, flags " + Integer.toHexString(flags));
            jarMappings.put(flags, jarMapping);
            return jarMapping;
        }
        catch (IOException ex2) {
            ex2.printStackTrace();
            throw new RuntimeException(ex2);
        }
    }

    @Override
    public void addURL(URL url) {
        super.addURL(url);
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        return this.findClass(name, true);
    }

    protected Class<?> findClass(String name, boolean checkGlobal) throws ClassNotFoundException {
        if (name.startsWith("org.bukkit.") || name.startsWith("net.minecraft.")) {
            if (this.debug) {
                System.out.println("Unexpected plugin findClass on OBC/NMS: name=" + name + ", checkGlobal=" + checkGlobal + "; returning not found");
            }
            throw new ClassNotFoundException(name);
        }
        Class<?> result = this.classes.get(name);
        if (result == null) {
            if (checkGlobal) {
                result = this.loader.getClassByName(name);
            }
            if (result == null && (result = this.remapper == null ? super.findClass(name) : this.remappedFindClass(name)) != null) {
                this.loader.setClass(name, result);
            }
            this.classes.put(name, result);
        }
        return result;
    }

    public Set<String> getClasses() {
        return this.classes.keySet();
    }

    private Class<?> remappedFindClass(String name) throws ClassNotFoundException {
        Class<?> result;
        block9: {
            result = null;
            try {
                JarURLConnection jarURLConnection;
                URL jarURL;
                CodeSource codeSource;
                InputStream stream;
                String path = name.replace('.', '/').concat(".class");
                URL url = this.findResource(path);
                if (url == null || (stream = url.openStream()) == null) break block9;
                byte[] bytecode = null;
                if (this.remapperPreprocessor != null && (bytecode = this.remapperPreprocessor.preprocess(stream)) == null) {
                    stream = url.openStream();
                }
                if (bytecode == null) {
                    bytecode = Streams.readAll((InputStream)stream);
                }
                byte[] remappedBytecode = this.remapper.remapClassFile(bytecode);
                if (this.debug) {
                    File file = new File("remapped-plugin-classes/" + name + ".class");
                    file.getParentFile().mkdirs();
                    try {
                        FileOutputStream fileOutputStream = new FileOutputStream(file);
                        fileOutputStream.write(remappedBytecode);
                        fileOutputStream.close();
                    }
                    catch (IOException ex2) {
                        ex2.printStackTrace();
                    }
                }
                if ((result = this.defineClass(name, remappedBytecode, 0, remappedBytecode.length, codeSource = new CodeSource(jarURL = (jarURLConnection = (JarURLConnection)url.openConnection()).getJarFileURL(), new CodeSigner[0]))) != null) {
                    this.resolveClass(result);
                }
            }
            catch (Throwable t2) {
                if (this.debug) {
                    System.out.println("remappedFindClass(" + name + ") exception: " + t2);
                    t2.printStackTrace();
                }
                throw new ClassNotFoundException("Failed to remap class " + name, t2);
            }
        }
        return result;
    }
}

