/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.craftbukkit.util.TimedThread;

public class Metrics {
    private static final int REVISION = 5;
    private static final String BASE_URL = "http://mcstats.org";
    private static final String REPORT_URL = "/report/%s";
    private static final String CONFIG_FILE = "plugins/PluginMetrics/config.yml";
    private static final String CUSTOM_DATA_SEPARATOR = "~~";
    private static final int PING_INTERVAL = 5;
    private final Set<Graph> graphs = Collections.synchronizedSet(new HashSet());
    private final Graph defaultGraph = new Graph("Default");
    private final YamlConfiguration configuration;
    private final String guid;

    public Metrics() throws IOException {
        File file = new File(CONFIG_FILE);
        this.configuration = YamlConfiguration.loadConfiguration((File)file);
        this.configuration.addDefault("opt-out", (Object)false);
        this.configuration.addDefault("guid", (Object)UUID.randomUUID().toString());
        if (this.configuration.get("guid", null) == null) {
            this.configuration.options().header("http://metrics.griefcraft.com").copyDefaults(true);
            this.configuration.save(file);
        }
        this.guid = this.configuration.getString("guid");
        Graph graph = this.createGraph("Operating System");
        graph.addPlotter(new Plotter(System.getProperty("os.name")){

            @Override
            public int getValue() {
                return 1;
            }
        });
        graph = this.createGraph("System Cores");
        graph.addPlotter(new Plotter(Integer.toString(Runtime.getRuntime().availableProcessors())){

            @Override
            public int getValue() {
                return 1;
            }
        });
        graph = this.createGraph("System RAM");
        long RAM = Runtime.getRuntime().maxMemory() / 1024L / 1024L;
        String plotName = RAM < 1024L ? "< 1024mb" : (RAM < 2048L ? "1024-2048mb" : (RAM < 4096L ? "2048-4096mb" : (RAM < 8192L ? "4096-8192mb" : (RAM < 16384L ? "8192-16384mb" : "16384+ mb"))));
        graph.addPlotter(new Plotter(plotName){

            @Override
            public int getValue() {
                return 1;
            }
        });
    }

    public Graph createGraph(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Graph name cannot be null");
        }
        Graph graph = new Graph(name);
        this.graphs.add(graph);
        return graph;
    }

    public void addCustomData(Plotter plotter) {
        if (plotter == null) {
            throw new IllegalArgumentException("Plotter cannot be null");
        }
        this.defaultGraph.addPlotter(plotter);
        this.graphs.add(this.defaultGraph);
    }

    public void start() {
        if (this.configuration.getBoolean("opt-out", false)) {
            return;
        }
        new TimedThread(new Runnable(){
            private boolean firstPost = true;

            @Override
            public void run() {
                try {
                    Metrics.this.postPlugin(!this.firstPost);
                    this.firstPost = false;
                }
                catch (IOException e2) {
                    System.err.println("[Metrics] " + e2.getMessage());
                }
            }
        }, 300000L).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void postPlugin(boolean isPing) throws IOException {
        String data = Metrics.encode("guid") + '=' + Metrics.encode(this.guid) + Metrics.encodeDataPair("version", "Spigot 1.4") + Metrics.encodeDataPair("server", Bukkit.getVersion()) + Metrics.encodeDataPair("players", Integer.toString(Bukkit.getServer().getOnlinePlayers().length)) + Metrics.encodeDataPair("revision", String.valueOf(5));
        if (isPing) {
            data = data + Metrics.encodeDataPair("ping", "true");
        }
        Set<Graph> set = this.graphs;
        synchronized (set) {
            for (Graph graph : this.graphs) {
                for (Plotter plotter : graph.getPlotters()) {
                    String key = String.format("C%s%s%s%s", CUSTOM_DATA_SEPARATOR, graph.getName(), CUSTOM_DATA_SEPARATOR, plotter.getColumnName());
                    String value = Integer.toString(plotter.getValue());
                    data = data + Metrics.encodeDataPair(key, value);
                }
            }
        }
        URL url = new URL(BASE_URL + String.format(REPORT_URL, "Spigot"));
        URLConnection connection = this.isMineshafterPresent() ? url.openConnection(Proxy.NO_PROXY) : url.openConnection();
        connection.setDoOutput(true);
        OutputStreamWriter writer = new OutputStreamWriter(connection.getOutputStream());
        writer.write(data);
        writer.flush();
        BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
        String response = reader.readLine();
        writer.close();
        reader.close();
        if (response.startsWith("ERR")) {
            throw new IOException(response);
        }
        if (response.contains("OK This is your first update this hour")) {
            Set<Graph> set2 = this.graphs;
            synchronized (set2) {
                for (Graph graph : this.graphs) {
                    for (Plotter plotter : graph.getPlotters()) {
                        plotter.reset();
                    }
                }
            }
        }
    }

    private boolean isMineshafterPresent() {
        try {
            Class.forName("mineshafter.MineServer");
            return true;
        }
        catch (Exception e2) {
            return false;
        }
    }

    private static String encodeDataPair(String key, String value) throws UnsupportedEncodingException {
        return '&' + Metrics.encode(key) + '=' + Metrics.encode(value);
    }

    private static String encode(String text) throws UnsupportedEncodingException {
        return URLEncoder.encode(text, "UTF-8");
    }

    public static abstract class Plotter {
        private final String name;

        public Plotter() {
            this("Default");
        }

        public Plotter(String name) {
            this.name = name;
        }

        public abstract int getValue();

        public String getColumnName() {
            return this.name;
        }

        public void reset() {
        }

        public int hashCode() {
            return this.getColumnName().hashCode() + this.getValue();
        }

        public boolean equals(Object object) {
            if (!(object instanceof Plotter)) {
                return false;
            }
            Plotter plotter = (Plotter)object;
            return plotter.name.equals(this.name) && plotter.getValue() == this.getValue();
        }
    }

    public static class Graph {
        private final String name;
        private final Set<Plotter> plotters = new LinkedHashSet<Plotter>();

        public Graph(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public void addPlotter(Plotter plotter) {
            this.plotters.add(plotter);
        }

        public void removePlotter(Plotter plotter) {
            this.plotters.remove(plotter);
        }

        public Set<Plotter> getPlotters() {
            return Collections.unmodifiableSet(this.plotters);
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public boolean equals(Object object) {
            if (!(object instanceof Graph)) {
                return false;
            }
            Graph graph = (Graph)object;
            return graph.name.equals(this.name);
        }
    }
}

