/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.util;

import org.bukkit.craftbukkit.util.LongHash;

public class FlatMap<V> {
    private static final int FLAT_LOOKUP_SIZE = 512;
    private final Object[][] flatLookup = new Object[1024][1024];

    public void put(long msw, long lsw, V value) {
        long acx2 = Math.abs(msw);
        long acz2 = Math.abs(lsw);
        if (acx2 < 512L && acz2 < 512L) {
            this.flatLookup[(int)(msw + 512L)][(int)(lsw + 512L)] = value;
        }
    }

    public void put(long key, V value) {
        this.put(LongHash.msw(key), LongHash.lsw(key), value);
    }

    public V get(long msw, long lsw) {
        long acx2 = Math.abs(msw);
        long acz2 = Math.abs(lsw);
        if (acx2 < 512L && acz2 < 512L) {
            return (V)this.flatLookup[(int)(msw + 512L)][(int)(lsw + 512L)];
        }
        return null;
    }

    public V get(long key) {
        return this.get(LongHash.msw(key), LongHash.lsw(key));
    }
}

