/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.metadata;

import java.util.List;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.metadata.MetadataStore;
import org.bukkit.metadata.MetadataStoreBase;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;

public class BlockMetadataStore
extends MetadataStoreBase<Block>
implements MetadataStore<Block> {
    private World owningWorld;

    public BlockMetadataStore(World owningWorld) {
        this.owningWorld = owningWorld;
    }

    protected String disambiguate(Block block, String metadataKey) {
        return Integer.toString(block.getX()) + ":" + Integer.toString(block.getY()) + ":" + Integer.toString(block.getZ()) + ":" + metadataKey;
    }

    public List<MetadataValue> getMetadata(Block block, String metadataKey) {
        if (block.getWorld() == this.owningWorld) {
            return super.getMetadata((Object)block, metadataKey);
        }
        throw new IllegalArgumentException("Block does not belong to world " + this.owningWorld.getName());
    }

    public boolean hasMetadata(Block block, String metadataKey) {
        if (block.getWorld() == this.owningWorld) {
            return super.hasMetadata((Object)block, metadataKey);
        }
        throw new IllegalArgumentException("Block does not belong to world " + this.owningWorld.getName());
    }

    public void removeMetadata(Block block, String metadataKey, Plugin owningPlugin) {
        if (block.getWorld() != this.owningWorld) {
            throw new IllegalArgumentException("Block does not belong to world " + this.owningWorld.getName());
        }
        super.removeMetadata((Object)block, metadataKey, owningPlugin);
    }

    public void setMetadata(Block block, String metadataKey, MetadataValue newMetadataValue) {
        if (block.getWorld() != this.owningWorld) {
            throw new IllegalArgumentException("Block does not belong to world " + this.owningWorld.getName());
        }
        super.setMetadata((Object)block, metadataKey, newMetadataValue);
    }
}

