/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.map;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.craftbukkit.CraftWorld;
import org.bukkit.craftbukkit.entity.CraftPlayer;
import org.bukkit.craftbukkit.map.CraftMapCanvas;
import org.bukkit.craftbukkit.map.CraftMapRenderer;
import org.bukkit.craftbukkit.map.RenderData;
import org.bukkit.entity.Player;
import org.bukkit.map.MapCanvas;
import org.bukkit.map.MapRenderer;
import org.bukkit.map.MapView;

public final class CraftMapView
implements MapView {
    private final Map<CraftPlayer, RenderData> renderCache = new HashMap<CraftPlayer, RenderData>();
    private final List<MapRenderer> renderers = new ArrayList<MapRenderer>();
    private final Map<MapRenderer, Map<CraftPlayer, CraftMapCanvas>> canvases = new HashMap<MapRenderer, Map<CraftPlayer, CraftMapCanvas>>();
    protected final ahn worldMap;

    public CraftMapView(ahn worldMap) {
        this.worldMap = worldMap;
        this.addRenderer(new CraftMapRenderer(this, worldMap));
    }

    public short getId() {
        String text = this.worldMap.h;
        if (text.startsWith("map_")) {
            try {
                return Short.parseShort(text.substring("map_".length()));
            }
            catch (NumberFormatException ex2) {
                throw new IllegalStateException("Map has non-numeric ID");
            }
        }
        throw new IllegalStateException("Map has invalid ID");
    }

    public boolean isVirtual() {
        return this.renderers.size() > 0 && !(this.renderers.get(0) instanceof CraftMapRenderer);
    }

    public MapView.Scale getScale() {
        return MapView.Scale.valueOf((byte)this.worldMap.d);
    }

    public void setScale(MapView.Scale scale) {
        this.worldMap.d = scale.getValue();
    }

    public World getWorld() {
        int dimension = this.worldMap.c;
        for (World world : Bukkit.getServer().getWorlds()) {
            if (((CraftWorld)world).getHandle().dimension != dimension) continue;
            return world;
        }
        return null;
    }

    public void setWorld(World world) {
        this.worldMap.c = (byte)((CraftWorld)world).getHandle().dimension;
    }

    public int getCenterX() {
        return this.worldMap.a;
    }

    public int getCenterZ() {
        return this.worldMap.b;
    }

    public void setCenterX(int x2) {
        this.worldMap.a = x2;
    }

    public void setCenterZ(int z2) {
        this.worldMap.b = z2;
    }

    public List<MapRenderer> getRenderers() {
        return new ArrayList<MapRenderer>(this.renderers);
    }

    public void addRenderer(MapRenderer renderer) {
        if (!this.renderers.contains(renderer)) {
            this.renderers.add(renderer);
            this.canvases.put(renderer, new HashMap());
            renderer.initialize((MapView)this);
        }
    }

    public boolean removeRenderer(MapRenderer renderer) {
        if (this.renderers.contains(renderer)) {
            this.renderers.remove(renderer);
            for (Map.Entry<CraftPlayer, CraftMapCanvas> entry : this.canvases.get(renderer).entrySet()) {
                for (int x2 = 0; x2 < 128; ++x2) {
                    for (int y2 = 0; y2 < 128; ++y2) {
                        entry.getValue().setPixel(x2, y2, (byte)-1);
                    }
                }
            }
            this.canvases.remove(renderer);
            return true;
        }
        return false;
    }

    private boolean isContextual() {
        for (MapRenderer renderer : this.renderers) {
            if (!renderer.isContextual()) continue;
            return true;
        }
        return false;
    }

    public RenderData render(CraftPlayer player) {
        boolean context = this.isContextual();
        RenderData render = this.renderCache.get(context ? player : null);
        if (render == null) {
            render = new RenderData();
            this.renderCache.put(context ? player : null, render);
        }
        if (context && this.renderCache.containsKey(null)) {
            this.renderCache.remove(null);
        }
        Arrays.fill(render.buffer, (byte)0);
        render.cursors.clear();
        Iterator<MapRenderer> i$ = this.renderers.iterator();
        while (i$.hasNext()) {
            int i2;
            MapRenderer renderer;
            CraftMapCanvas canvas = this.canvases.get(renderer).get((renderer = i$.next()).isContextual() ? player : null);
            if (canvas == null) {
                canvas = new CraftMapCanvas(this);
                this.canvases.get(renderer).put(renderer.isContextual() ? player : null, canvas);
            }
            canvas.setBase(render.buffer);
            renderer.render((MapView)this, (MapCanvas)canvas, (Player)player);
            byte[] buf = canvas.getBuffer();
            for (i2 = 0; i2 < buf.length; ++i2) {
                if (buf[i2] < 0) continue;
                render.buffer[i2] = buf[i2];
            }
            for (i2 = 0; i2 < canvas.getCursors().size(); ++i2) {
                render.cursors.add(canvas.getCursors().getCursor(i2));
            }
        }
        return render;
    }
}

