/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.inventory;

import guava10.com.google.common.base.Strings;
import guava10.com.google.common.collect.ImmutableList;
import guava10.com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.Validate;
import org.bukkit.Material;
import org.bukkit.configuration.serialization.DelegateDeserialization;
import org.bukkit.craftbukkit.inventory.CraftMetaItem;
import org.bukkit.inventory.meta.BookMeta;

@DelegateDeserialization(value=CraftMetaItem.SerializableMeta.class)
class CraftMetaBook
extends CraftMetaItem
implements BookMeta {
    static final CraftMetaItem.ItemMetaKey BOOK_TITLE = new CraftMetaItem.ItemMetaKey("title");
    static final CraftMetaItem.ItemMetaKey BOOK_AUTHOR = new CraftMetaItem.ItemMetaKey("author");
    static final CraftMetaItem.ItemMetaKey BOOK_PAGES = new CraftMetaItem.ItemMetaKey("pages");
    static final int MAX_PAGE_LENGTH = 256;
    static final int MAX_TITLE_LENGTH = 65535;
    private String title;
    private String author;
    private List<String> pages = new ArrayList<String>();

    CraftMetaBook(CraftMetaItem meta) {
        super(meta);
        if (!(meta instanceof CraftMetaBook)) {
            return;
        }
        CraftMetaBook bookMeta = (CraftMetaBook)meta;
        this.title = bookMeta.title;
        this.author = bookMeta.author;
        this.pages.addAll(bookMeta.pages);
    }

    CraftMetaBook(bq tag) {
        super(tag);
        if (tag.b(CraftMetaBook.BOOK_TITLE.NBT)) {
            this.title = tag.i(CraftMetaBook.BOOK_TITLE.NBT);
        }
        if (tag.b(CraftMetaBook.BOOK_AUTHOR.NBT)) {
            this.author = tag.i(CraftMetaBook.BOOK_AUTHOR.NBT);
        }
        if (tag.b(CraftMetaBook.BOOK_PAGES.NBT)) {
            by pages = tag.m(CraftMetaBook.BOOK_PAGES.NBT);
            String[] pageArray = new String[pages.c()];
            for (int i2 = 0; i2 < pages.c(); ++i2) {
                String page;
                pageArray[i2] = page = ((cc)pages.b((int)i2)).a;
            }
            this.addPage(pageArray);
        }
    }

    CraftMetaBook(Map<String, Object> map) {
        super(map);
        this.setAuthor(CraftMetaItem.SerializableMeta.getString(map, CraftMetaBook.BOOK_AUTHOR.BUKKIT, true));
        this.setTitle(CraftMetaItem.SerializableMeta.getString(map, CraftMetaBook.BOOK_TITLE.BUKKIT, true));
        Iterable pages = CraftMetaItem.SerializableMeta.getObject(Iterable.class, map, CraftMetaBook.BOOK_PAGES.BUKKIT, true);
        CraftMetaItem.safelyAdd(pages, this.pages, 256);
    }

    @Override
    void applyToItem(bq itemData) {
        super.applyToItem(itemData);
        if (this.hasTitle()) {
            itemData.a(CraftMetaBook.BOOK_TITLE.NBT, this.title);
        }
        if (this.hasAuthor()) {
            itemData.a(CraftMetaBook.BOOK_AUTHOR.NBT, this.author);
        }
        if (this.hasPages()) {
            itemData.a(CraftMetaBook.BOOK_PAGES.NBT, CraftMetaBook.createStringList(this.pages, BOOK_PAGES));
        }
    }

    @Override
    boolean isEmpty() {
        return super.isEmpty() && this.isBookEmpty();
    }

    boolean isBookEmpty() {
        return !this.hasPages() && !this.hasAuthor() && !this.hasTitle();
    }

    @Override
    boolean applicableTo(Material type) {
        switch (type) {
            case WRITTEN_BOOK: 
            case BOOK_AND_QUILL: {
                return true;
            }
        }
        return false;
    }

    public boolean hasAuthor() {
        return !Strings.isNullOrEmpty((String)this.author);
    }

    public boolean hasTitle() {
        return !Strings.isNullOrEmpty((String)this.title);
    }

    public boolean hasPages() {
        return !this.pages.isEmpty();
    }

    public String getTitle() {
        return this.title;
    }

    public boolean setTitle(String title) {
        if (title == null) {
            this.title = null;
            return true;
        }
        if (title.length() > 65535) {
            return false;
        }
        this.title = title;
        return true;
    }

    public String getAuthor() {
        return this.author;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public String getPage(int page) {
        Validate.isTrue((boolean)this.isValidPage(page), (String)"Invalid page number");
        return this.pages.get(page - 1);
    }

    public void setPage(int page, String text) {
        if (!this.isValidPage(page)) {
            throw new IllegalArgumentException("Invalid page number " + page + "/" + this.pages.size());
        }
        this.pages.set(page - 1, text == null ? "" : (text.length() > 256 ? text.substring(0, 256) : text));
    }

    public void setPages(String ... pages) {
        this.pages.clear();
        this.addPage(pages);
    }

    public void addPage(String ... pages) {
        for (String page : pages) {
            if (page == null) {
                page = "";
            } else if (page.length() > 256) {
                page = page.substring(0, 256);
            }
            this.pages.add(page);
        }
    }

    public int getPageCount() {
        return this.pages.size();
    }

    public List<String> getPages() {
        return ImmutableList.copyOf(this.pages);
    }

    public void setPages(List<String> pages) {
        this.pages.clear();
        CraftMetaItem.safelyAdd(pages, this.pages, 256);
    }

    private boolean isValidPage(int page) {
        return page > 0 && page <= this.pages.size();
    }

    @Override
    public CraftMetaBook clone() {
        CraftMetaBook meta = (CraftMetaBook)super.clone();
        meta.pages = new ArrayList<String>(this.pages);
        return meta;
    }

    @Override
    int applyHash() {
        int original;
        int hash = original = super.applyHash();
        if (this.hasTitle()) {
            hash = 61 * hash + this.title.hashCode();
        }
        if (this.hasAuthor()) {
            hash = 61 * hash + 13 * this.author.hashCode();
        }
        if (this.hasPages()) {
            hash = 61 * hash + 17 * this.pages.hashCode();
        }
        return original != hash ? CraftMetaBook.class.hashCode() ^ hash : hash;
    }

    @Override
    boolean equalsCommon(CraftMetaItem meta) {
        if (!super.equalsCommon(meta)) {
            return false;
        }
        if (meta instanceof CraftMetaBook) {
            CraftMetaBook that = (CraftMetaBook)meta;
            return (this.hasTitle() ? that.hasTitle() && this.title.equals(that.title) : !that.hasTitle()) && (this.hasAuthor() ? that.hasAuthor() && this.author.equals(that.author) : !that.hasAuthor()) && (this.hasPages() ? that.hasPages() && this.pages.equals(that.pages) : !that.hasPages());
        }
        return true;
    }

    @Override
    boolean notUncommon(CraftMetaItem meta) {
        return super.notUncommon(meta) && (meta instanceof CraftMetaBook || this.isBookEmpty());
    }

    @Override
    ImmutableMap.Builder<String, Object> serialize(ImmutableMap.Builder<String, Object> builder) {
        super.serialize(builder);
        if (this.hasTitle()) {
            builder.put((Object)CraftMetaBook.BOOK_TITLE.BUKKIT, (Object)this.title);
        }
        if (this.hasAuthor()) {
            builder.put((Object)CraftMetaBook.BOOK_AUTHOR.BUKKIT, (Object)this.author);
        }
        if (this.hasPages()) {
            builder.put((Object)CraftMetaBook.BOOK_PAGES.BUKKIT, this.pages);
        }
        return builder;
    }
}

