/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.inventory;

import org.bukkit.GameMode;
import org.bukkit.craftbukkit.entity.CraftHumanEntity;
import org.bukkit.craftbukkit.inventory.CraftInventory;
import org.bukkit.craftbukkit.inventory.CraftItemStack;
import org.bukkit.entity.HumanEntity;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;

public class CraftInventoryView
extends InventoryView {
    private final rq container;
    private final CraftHumanEntity player;
    private final CraftInventory viewing;

    public CraftInventoryView(HumanEntity player, Inventory viewing, rq container) {
        this.player = (CraftHumanEntity)player;
        this.viewing = (CraftInventory)viewing;
        this.container = container;
    }

    public Inventory getTopInventory() {
        return this.viewing;
    }

    public Inventory getBottomInventory() {
        return this.player.getInventory();
    }

    public HumanEntity getPlayer() {
        return this.player;
    }

    public InventoryType getType() {
        InventoryType type = this.viewing.getType();
        if (type == InventoryType.CRAFTING && this.player.getGameMode() == GameMode.CREATIVE) {
            return InventoryType.CREATIVE;
        }
        return type;
    }

    public void setItem(int slot, ItemStack item) {
        ur stack = CraftItemStack.asNMSCopy(item);
        if (slot != -999) {
            this.container.a(slot).c(stack);
        } else {
            this.player.getHandle().c(stack);
        }
    }

    public ItemStack getItem(int slot) {
        if (slot == -999) {
            return null;
        }
        return CraftItemStack.asCraftMirror(this.container.a(slot).c());
    }

    public boolean isInTop(int rawSlot) {
        return rawSlot < this.viewing.getSize();
    }

    public rq getHandle() {
        return this.container;
    }

    public static InventoryType.SlotType getSlotType(InventoryView inventory, int slot) {
        InventoryType.SlotType type;
        block21: {
            block20: {
                type = InventoryType.SlotType.CONTAINER;
                if (slot >= inventory.getTopInventory().getSize()) break block20;
                switch (inventory.getType()) {
                    case FURNACE: {
                        if (slot == 2) {
                            type = InventoryType.SlotType.RESULT;
                            break;
                        }
                        if (slot == 1) {
                            type = InventoryType.SlotType.FUEL;
                            break;
                        }
                        break block21;
                    }
                    case BREWING: {
                        if (slot == 0) {
                            type = InventoryType.SlotType.FUEL;
                            break;
                        }
                        type = InventoryType.SlotType.CRAFTING;
                        break;
                    }
                    case ENCHANTING: {
                        type = InventoryType.SlotType.CRAFTING;
                        break;
                    }
                    case WORKBENCH: 
                    case CRAFTING: {
                        if (slot == 0) {
                            type = InventoryType.SlotType.RESULT;
                            break;
                        }
                        type = InventoryType.SlotType.CRAFTING;
                        break;
                    }
                    case MERCHANT: {
                        if (slot == 2) {
                            type = InventoryType.SlotType.RESULT;
                            break;
                        }
                        type = InventoryType.SlotType.CRAFTING;
                        break;
                    }
                    case BEACON: {
                        type = InventoryType.SlotType.CRAFTING;
                        break;
                    }
                    case ANVIL: {
                        if (slot == 2) {
                            type = InventoryType.SlotType.RESULT;
                            break;
                        }
                        type = InventoryType.SlotType.CRAFTING;
                        break;
                    }
                }
                break block21;
            }
            if (slot == -999) {
                type = InventoryType.SlotType.OUTSIDE;
            } else if (inventory.getType() == InventoryType.CRAFTING && slot < 9) {
                type = InventoryType.SlotType.ARMOR;
            } else if (slot >= inventory.countSlots() - 9) {
                type = InventoryType.SlotType.QUICKBAR;
            }
        }
        return type;
    }
}

