/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.inventory;

import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import org.apache.commons.lang.Validate;
import org.bukkit.Material;
import org.bukkit.craftbukkit.inventory.CraftInventoryCustom;
import org.bukkit.craftbukkit.inventory.CraftItemStack;
import org.bukkit.craftbukkit.inventory.InventoryIterator;
import org.bukkit.entity.HumanEntity;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;

public class CraftInventory
implements Inventory {
    protected la inventory;

    public CraftInventory(la inventory) {
        this.inventory = inventory;
    }

    public la getInventory() {
        return this.inventory;
    }

    public int getSize() {
        return this.getInventory().k_();
    }

    public String getName() {
        return this.getInventory().b();
    }

    public ItemStack getItem(int index) {
        ur item = this.getInventory().a(index);
        return item == null ? null : CraftItemStack.asCraftMirror(item);
    }

    public ItemStack[] getContents() {
        ItemStack[] items = new ItemStack[this.getSize()];
        ur[] mcItems = this.getInventory().getContents();
        for (int i2 = 0; i2 < mcItems.length; ++i2) {
            items[i2] = mcItems[i2] == null ? null : CraftItemStack.asCraftMirror(mcItems[i2]);
        }
        return items;
    }

    public void setContents(ItemStack[] items) {
        if (this.getInventory().getContents().length < items.length) {
            throw new IllegalArgumentException("Invalid inventory size; expected " + this.getInventory().getContents().length + " or less");
        }
        ur[] mcItems = this.getInventory().getContents();
        for (int i2 = 0; i2 < mcItems.length; ++i2) {
            mcItems[i2] = i2 >= items.length ? null : CraftItemStack.asNMSCopy(items[i2]);
        }
    }

    public void setItem(int index, ItemStack item) {
        this.getInventory().a(index, item == null || item.getTypeId() == 0 ? null : CraftItemStack.asNMSCopy(item));
    }

    public boolean contains(int materialId) {
        for (ItemStack item : this.getContents()) {
            if (item == null || item.getTypeId() != materialId) continue;
            return true;
        }
        return false;
    }

    public boolean contains(Material material) {
        Validate.notNull((Object)((Object)material), (String)"Material cannot be null");
        return this.contains(material.getId());
    }

    public boolean contains(ItemStack item) {
        if (item == null) {
            return false;
        }
        for (ItemStack i2 : this.getContents()) {
            if (!item.equals((Object)i2)) continue;
            return true;
        }
        return false;
    }

    public boolean contains(int materialId, int amount) {
        if (amount <= 0) {
            return true;
        }
        for (ItemStack item : this.getContents()) {
            if (item == null || item.getTypeId() != materialId || (amount -= item.getAmount()) > 0) continue;
            return true;
        }
        return false;
    }

    public boolean contains(Material material, int amount) {
        Validate.notNull((Object)((Object)material), (String)"Material cannot be null");
        return this.contains(material.getId(), amount);
    }

    public boolean contains(ItemStack item, int amount) {
        if (item == null) {
            return false;
        }
        if (amount <= 0) {
            return true;
        }
        for (ItemStack i2 : this.getContents()) {
            if (!item.equals((Object)i2) || --amount > 0) continue;
            return true;
        }
        return false;
    }

    public boolean containsAtLeast(ItemStack item, int amount) {
        if (item == null) {
            return false;
        }
        if (amount <= 0) {
            return true;
        }
        for (ItemStack i2 : this.getContents()) {
            if (!item.isSimilar(i2) || (amount -= i2.getAmount()) > 0) continue;
            return true;
        }
        return false;
    }

    public HashMap<Integer, ItemStack> all(int materialId) {
        HashMap<Integer, ItemStack> slots = new HashMap<Integer, ItemStack>();
        ItemStack[] inventory = this.getContents();
        for (int i2 = 0; i2 < inventory.length; ++i2) {
            ItemStack item = inventory[i2];
            if (item == null || item.getTypeId() != materialId) continue;
            slots.put(i2, item);
        }
        return slots;
    }

    public HashMap<Integer, ItemStack> all(Material material) {
        Validate.notNull((Object)((Object)material), (String)"Material cannot be null");
        return this.all(material.getId());
    }

    public HashMap<Integer, ItemStack> all(ItemStack item) {
        HashMap<Integer, ItemStack> slots = new HashMap<Integer, ItemStack>();
        if (item != null) {
            ItemStack[] inventory = this.getContents();
            for (int i2 = 0; i2 < inventory.length; ++i2) {
                if (!item.equals((Object)inventory[i2])) continue;
                slots.put(i2, inventory[i2]);
            }
        }
        return slots;
    }

    public int first(int materialId) {
        ItemStack[] inventory = this.getContents();
        for (int i2 = 0; i2 < inventory.length; ++i2) {
            ItemStack item = inventory[i2];
            if (item == null || item.getTypeId() != materialId) continue;
            return i2;
        }
        return -1;
    }

    public int first(Material material) {
        Validate.notNull((Object)((Object)material), (String)"Material cannot be null");
        return this.first(material.getId());
    }

    public int first(ItemStack item) {
        return this.first(item, true);
    }

    private int first(ItemStack item, boolean withAmount) {
        if (item == null) {
            return -1;
        }
        ItemStack[] inventory = this.getContents();
        for (int i2 = 0; i2 < inventory.length; ++i2) {
            if (inventory[i2] == null || !(withAmount ? item.equals((Object)inventory[i2]) : item.isSimilar(inventory[i2]))) continue;
            return i2;
        }
        return -1;
    }

    public int firstEmpty() {
        ItemStack[] inventory = this.getContents();
        for (int i2 = 0; i2 < inventory.length; ++i2) {
            if (inventory[i2] != null) continue;
            return i2;
        }
        return -1;
    }

    public int firstPartial(int materialId) {
        ItemStack[] inventory = this.getContents();
        for (int i2 = 0; i2 < inventory.length; ++i2) {
            ItemStack item = inventory[i2];
            if (item == null || item.getTypeId() != materialId || item.getAmount() >= item.getMaxStackSize()) continue;
            return i2;
        }
        return -1;
    }

    public int firstPartial(Material material) {
        Validate.notNull((Object)((Object)material), (String)"Material cannot be null");
        return this.firstPartial(material.getId());
    }

    private int firstPartial(ItemStack item) {
        ItemStack[] inventory = this.getContents();
        CraftItemStack filteredItem = CraftItemStack.asCraftCopy(item);
        if (item == null) {
            return -1;
        }
        for (int i2 = 0; i2 < inventory.length; ++i2) {
            ItemStack cItem = inventory[i2];
            if (cItem == null || cItem.getAmount() >= cItem.getMaxStackSize() || !cItem.isSimilar((ItemStack)filteredItem)) continue;
            return i2;
        }
        return -1;
    }

    public HashMap<Integer, ItemStack> addItem(ItemStack ... items) {
        Validate.noNullElements((Object[])items, (String)"Item cannot be null");
        HashMap<Integer, ItemStack> leftover = new HashMap<Integer, ItemStack>();
        block0: for (int i2 = 0; i2 < items.length; ++i2) {
            ItemStack item = items[i2];
            while (true) {
                int maxAmount;
                int partialAmount;
                int firstPartial;
                if ((firstPartial = this.firstPartial(item)) == -1) {
                    int firstFree = this.firstEmpty();
                    if (firstFree == -1) {
                        leftover.put(i2, item);
                        continue block0;
                    }
                    if (item.getAmount() > this.getMaxItemStack()) {
                        CraftItemStack stack = CraftItemStack.asCraftCopy(item);
                        stack.setAmount(this.getMaxItemStack());
                        this.setItem(firstFree, stack);
                        item.setAmount(item.getAmount() - this.getMaxItemStack());
                        continue;
                    }
                    this.setItem(firstFree, item);
                    continue block0;
                }
                ItemStack partialItem = this.getItem(firstPartial);
                int amount = item.getAmount();
                if (amount + (partialAmount = partialItem.getAmount()) <= (maxAmount = partialItem.getMaxStackSize())) {
                    partialItem.setAmount(amount + partialAmount);
                    continue block0;
                }
                partialItem.setAmount(maxAmount);
                item.setAmount(amount + partialAmount - maxAmount);
            }
        }
        return leftover;
    }

    public HashMap<Integer, ItemStack> removeItem(ItemStack ... items) {
        Validate.notNull((Object)items, (String)"Items cannot be null");
        HashMap<Integer, ItemStack> leftover = new HashMap<Integer, ItemStack>();
        block0: for (int i2 = 0; i2 < items.length; ++i2) {
            ItemStack item = items[i2];
            int toDelete = item.getAmount();
            do {
                int first;
                if ((first = this.first(item, false)) == -1) {
                    item.setAmount(toDelete);
                    leftover.put(i2, item);
                    continue block0;
                }
                ItemStack itemStack = this.getItem(first);
                int amount = itemStack.getAmount();
                if (amount <= toDelete) {
                    toDelete -= amount;
                    this.clear(first);
                    continue;
                }
                itemStack.setAmount(amount - toDelete);
                this.setItem(first, itemStack);
                toDelete = 0;
            } while (toDelete > 0);
        }
        return leftover;
    }

    private int getMaxItemStack() {
        return this.getInventory().c();
    }

    public void remove(int materialId) {
        ItemStack[] items = this.getContents();
        for (int i2 = 0; i2 < items.length; ++i2) {
            if (items[i2] == null || items[i2].getTypeId() != materialId) continue;
            this.clear(i2);
        }
    }

    public void remove(Material material) {
        Validate.notNull((Object)((Object)material), (String)"Material cannot be null");
        this.remove(material.getId());
    }

    public void remove(ItemStack item) {
        ItemStack[] items = this.getContents();
        for (int i2 = 0; i2 < items.length; ++i2) {
            if (items[i2] == null || !items[i2].equals((Object)item)) continue;
            this.clear(i2);
        }
    }

    public void clear(int index) {
        this.setItem(index, null);
    }

    public void clear() {
        for (int i2 = 0; i2 < this.getSize(); ++i2) {
            this.clear(i2);
        }
    }

    public ListIterator<ItemStack> iterator() {
        return new InventoryIterator(this);
    }

    public ListIterator<ItemStack> iterator(int index) {
        if (index < 0) {
            index += this.getSize() + 1;
        }
        return new InventoryIterator(this, index);
    }

    public List<HumanEntity> getViewers() {
        return this.inventory.getViewers();
    }

    public String getTitle() {
        return this.inventory.b();
    }

    public InventoryType getType() {
        if (this.inventory instanceof ry) {
            return this.inventory.k_() >= 9 ? InventoryType.WORKBENCH : InventoryType.CRAFTING;
        }
        if (this.inventory instanceof qw) {
            return InventoryType.PLAYER;
        }
        if (this.inventory instanceof ano) {
            return InventoryType.DISPENSER;
        }
        if (this.inventory instanceof anr) {
            return InventoryType.FURNACE;
        }
        if (this.inventory instanceof sb) {
            return InventoryType.ENCHANTING;
        }
        if (this.inventory instanceof anl) {
            return InventoryType.BREWING;
        }
        if (this.inventory instanceof CraftInventoryCustom.MinecraftInventory) {
            return ((CraftInventoryCustom.MinecraftInventory)this.inventory).getType();
        }
        if (this.inventory instanceof sl) {
            return InventoryType.ENDER_CHEST;
        }
        if (this.inventory instanceof si) {
            return InventoryType.MERCHANT;
        }
        if (this.inventory instanceof ank) {
            return InventoryType.BEACON;
        }
        if (this.inventory instanceof sn) {
            return InventoryType.ANVIL;
        }
        return InventoryType.CHEST;
    }

    public InventoryHolder getHolder() {
        return this.inventory.getOwner();
    }

    public int getMaxStackSize() {
        return this.inventory.c();
    }

    public void setMaxStackSize(int size) {
        this.inventory.setMaxStackSize(size);
    }
}

