/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.event;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.Instrument;
import org.bukkit.Material;
import org.bukkit.Note;
import org.bukkit.Server;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.craftbukkit.CraftServer;
import org.bukkit.craftbukkit.CraftWorld;
import org.bukkit.craftbukkit.block.CraftBlock;
import org.bukkit.craftbukkit.block.CraftBlockState;
import org.bukkit.craftbukkit.entity.CraftEntity;
import org.bukkit.craftbukkit.entity.CraftHumanEntity;
import org.bukkit.craftbukkit.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.entity.CraftPlayer;
import org.bukkit.craftbukkit.inventory.CraftInventoryCrafting;
import org.bukkit.craftbukkit.inventory.CraftItemStack;
import org.bukkit.entity.AnimalTamer;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Creeper;
import org.bukkit.entity.Entity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Item;
import org.bukkit.entity.LightningStrike;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Pig;
import org.bukkit.entity.PigZombie;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.ThrownExpBottle;
import org.bukkit.entity.ThrownPotion;
import org.bukkit.event.Event;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockDamageEvent;
import org.bukkit.event.block.BlockFadeEvent;
import org.bukkit.event.block.BlockGrowEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.block.BlockRedstoneEvent;
import org.bukkit.event.block.BlockSpreadEvent;
import org.bukkit.event.block.NotePlayEvent;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.CreeperPowerEvent;
import org.bukkit.event.entity.EntityBreakDoorEvent;
import org.bukkit.event.entity.EntityChangeBlockEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.EntityShootBowEvent;
import org.bukkit.event.entity.EntityTameEvent;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.event.entity.EntityTargetLivingEntityEvent;
import org.bukkit.event.entity.ExpBottleEvent;
import org.bukkit.event.entity.FoodLevelChangeEvent;
import org.bukkit.event.entity.ItemDespawnEvent;
import org.bukkit.event.entity.ItemSpawnEvent;
import org.bukkit.event.entity.PigZapEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.entity.PotionSplashEvent;
import org.bukkit.event.entity.ProjectileLaunchEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.event.inventory.PrepareItemCraftEvent;
import org.bukkit.event.player.PlayerBucketEmptyEvent;
import org.bukkit.event.player.PlayerBucketFillEvent;
import org.bukkit.event.player.PlayerEvent;
import org.bukkit.event.player.PlayerExpChangeEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerItemBreakEvent;
import org.bukkit.event.player.PlayerLevelChangeEvent;
import org.bukkit.event.server.ServerListPingEvent;
import org.bukkit.inventory.CraftingInventory;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;

public class CraftEventFactory {
    private static boolean canBuild(CraftWorld world, Player player, int x2, int z2) {
        in worldServer = world.getHandle();
        int spawnSize = Bukkit.getServer().getSpawnRadius();
        if (world.getHandle().dimension != 0) {
            return true;
        }
        if (spawnSize <= 0) {
            return true;
        }
        if (((CraftServer)Bukkit.getServer()).getHandle().i().isEmpty()) {
            return true;
        }
        if (player.isOp()) {
            return true;
        }
        s chunkcoordinates = worldServer.H();
        int distanceFromSpawn = Math.max(Math.abs(x2 - chunkcoordinates.a), Math.abs(z2 - chunkcoordinates.c));
        return distanceFromSpawn >= spawnSize;
    }

    public static <T extends Event> T callEvent(T event) {
        Bukkit.getServer().getPluginManager().callEvent(event);
        return event;
    }

    public static BlockPlaceEvent callBlockPlaceEvent(yc world, qx who, BlockState replacedBlockState, int clickedX, int clickedY, int clickedZ) {
        CraftWorld craftWorld = ((in)world).getWorld();
        CraftServer craftServer = ((in)world).getServer();
        Player player = who == null ? null : (Player)who.getBukkitEntity();
        Block blockClicked = craftWorld.getBlockAt(clickedX, clickedY, clickedZ);
        Block placedBlock = replacedBlockState.getBlock();
        boolean canBuild = CraftEventFactory.canBuild(craftWorld, player, placedBlock.getX(), placedBlock.getZ());
        BlockPlaceEvent event = new BlockPlaceEvent(placedBlock, replacedBlockState, blockClicked, player.getItemInHand(), player, canBuild);
        craftServer.getPluginManager().callEvent((Event)event);
        return event;
    }

    public static PlayerBucketEmptyEvent callPlayerBucketEmptyEvent(qx who, int clickedX, int clickedY, int clickedZ, int clickedFace, ur itemInHand) {
        return (PlayerBucketEmptyEvent)CraftEventFactory.getPlayerBucketEvent(false, who, clickedX, clickedY, clickedZ, clickedFace, itemInHand, up.aw);
    }

    public static PlayerBucketFillEvent callPlayerBucketFillEvent(qx who, int clickedX, int clickedY, int clickedZ, int clickedFace, ur itemInHand, up bucket) {
        return (PlayerBucketFillEvent)CraftEventFactory.getPlayerBucketEvent(true, who, clickedX, clickedY, clickedZ, clickedFace, itemInHand, bucket);
    }

    private static PlayerEvent getPlayerBucketEvent(boolean isFilling, qx who, int clickedX, int clickedY, int clickedZ, int clickedFace, ur itemstack, up item) {
        Player player = who == null ? null : (Player)who.getBukkitEntity();
        CraftItemStack itemInHand = CraftItemStack.asNewCraftStack(item);
        Material bucket = Material.getMaterial(itemstack.c);
        CraftWorld craftWorld = (CraftWorld)player.getWorld();
        CraftServer craftServer = (CraftServer)player.getServer();
        Block blockClicked = craftWorld.getBlockAt(clickedX, clickedY, clickedZ);
        BlockFace blockFace = CraftBlock.notchToBlockFace(clickedFace);
        PlayerBucketFillEvent event = null;
        if (isFilling) {
            event = new PlayerBucketFillEvent(player, blockClicked, blockFace, bucket, (ItemStack)itemInHand);
            event.setCancelled(!CraftEventFactory.canBuild(craftWorld, player, clickedX, clickedZ));
        } else {
            event = new PlayerBucketEmptyEvent(player, blockClicked, blockFace, bucket, (ItemStack)itemInHand);
            ((PlayerBucketEmptyEvent)event).setCancelled(!CraftEventFactory.canBuild(craftWorld, player, clickedX, clickedZ));
        }
        craftServer.getPluginManager().callEvent((Event)event);
        return event;
    }

    public static PlayerInteractEvent callPlayerInteractEvent(qx who, Action action, ur itemstack) {
        if (action != Action.LEFT_CLICK_AIR && action != Action.RIGHT_CLICK_AIR) {
            throw new IllegalArgumentException();
        }
        return CraftEventFactory.callPlayerInteractEvent(who, action, 0, 256, 0, 0, itemstack);
    }

    public static PlayerInteractEvent callPlayerInteractEvent(qx who, Action action, int clickedX, int clickedY, int clickedZ, int clickedFace, ur itemstack) {
        Player player = who == null ? null : (Player)who.getBukkitEntity();
        CraftItemStack itemInHand = CraftItemStack.asCraftMirror(itemstack);
        CraftWorld craftWorld = (CraftWorld)player.getWorld();
        CraftServer craftServer = (CraftServer)player.getServer();
        Block blockClicked = craftWorld.getBlockAt(clickedX, clickedY, clickedZ);
        BlockFace blockFace = CraftBlock.notchToBlockFace(clickedFace);
        if (clickedY > 255) {
            blockClicked = null;
            switch (action) {
                case LEFT_CLICK_BLOCK: {
                    action = Action.LEFT_CLICK_AIR;
                    break;
                }
                case RIGHT_CLICK_BLOCK: {
                    action = Action.RIGHT_CLICK_AIR;
                }
            }
        }
        if (itemInHand.getType() == Material.AIR || itemInHand.getAmount() == 0) {
            itemInHand = null;
        }
        PlayerInteractEvent event = new PlayerInteractEvent(player, action, (ItemStack)itemInHand, blockClicked, blockFace);
        craftServer.getPluginManager().callEvent((Event)event);
        return event;
    }

    public static EntityShootBowEvent callEntityShootBowEvent(md who, ur itemstack, qz entityArrow, float force) {
        LivingEntity shooter = (LivingEntity)who.getBukkitEntity();
        CraftItemStack itemInHand = CraftItemStack.asCraftMirror(itemstack);
        Arrow arrow = (Arrow)entityArrow.getBukkitEntity();
        if (itemInHand != null && (itemInHand.getType() == Material.AIR || itemInHand.getAmount() == 0)) {
            itemInHand = null;
        }
        EntityShootBowEvent event = new EntityShootBowEvent(shooter, (ItemStack)itemInHand, (Projectile)arrow, force);
        Bukkit.getPluginManager().callEvent((Event)event);
        return event;
    }

    public static BlockDamageEvent callBlockDamageEvent(qx who, int x2, int y2, int z2, ur itemstack, boolean instaBreak) {
        Player player = who == null ? null : (Player)who.getBukkitEntity();
        CraftItemStack itemInHand = CraftItemStack.asCraftMirror(itemstack);
        CraftWorld craftWorld = (CraftWorld)player.getWorld();
        CraftServer craftServer = (CraftServer)player.getServer();
        Block blockClicked = craftWorld.getBlockAt(x2, y2, z2);
        BlockDamageEvent event = new BlockDamageEvent(player, blockClicked, (ItemStack)itemInHand, instaBreak);
        craftServer.getPluginManager().callEvent((Event)event);
        return event;
    }

    public static CreatureSpawnEvent callCreatureSpawnEvent(md entityliving, CreatureSpawnEvent.SpawnReason spawnReason) {
        LivingEntity entity = (LivingEntity)entityliving.getBukkitEntity();
        CraftServer craftServer = (CraftServer)entity.getServer();
        CreatureSpawnEvent event = new CreatureSpawnEvent(entity, spawnReason);
        craftServer.getPluginManager().callEvent((Event)event);
        return event;
    }

    public static EntityTameEvent callEntityTameEvent(md entity, qx tamer) {
        CraftEntity bukkitEntity = entity.getBukkitEntity();
        CraftHumanEntity bukkitTamer = tamer != null ? tamer.getBukkitEntity() : null;
        CraftServer craftServer = (CraftServer)bukkitEntity.getServer();
        entity.bU = true;
        EntityTameEvent event = new EntityTameEvent((LivingEntity)bukkitEntity, (AnimalTamer)bukkitTamer);
        craftServer.getPluginManager().callEvent((Event)event);
        return event;
    }

    public static ItemSpawnEvent callItemSpawnEvent(px entityitem) {
        Item entity = (Item)entityitem.getBukkitEntity();
        CraftServer craftServer = (CraftServer)entity.getServer();
        ItemSpawnEvent event = new ItemSpawnEvent(entity, entity.getLocation());
        craftServer.getPluginManager().callEvent((Event)event);
        return event;
    }

    public static ItemDespawnEvent callItemDespawnEvent(px entityitem) {
        Item entity = (Item)entityitem.getBukkitEntity();
        ItemDespawnEvent event = new ItemDespawnEvent(entity, entity.getLocation());
        ((CraftServer)entity.getServer()).getPluginManager().callEvent((Event)event);
        return event;
    }

    public static PotionSplashEvent callPotionSplashEvent(rm potion, Map<LivingEntity, Double> affectedEntities) {
        ThrownPotion thrownPotion = (ThrownPotion)potion.getBukkitEntity();
        PotionSplashEvent event = new PotionSplashEvent(thrownPotion, affectedEntities);
        Bukkit.getPluginManager().callEvent((Event)event);
        return event;
    }

    public static BlockFadeEvent callBlockFadeEvent(Block block, int type) {
        BlockState state = block.getState();
        state.setTypeId(type);
        BlockFadeEvent event = new BlockFadeEvent(block, state);
        Bukkit.getPluginManager().callEvent((Event)event);
        return event;
    }

    public static void handleBlockSpreadEvent(Block block, Block source, int type, int data) {
        BlockState state = block.getState();
        state.setTypeId(type);
        state.setRawData((byte)data);
        BlockSpreadEvent event = new BlockSpreadEvent(block, source, state);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (!event.isCancelled()) {
            state.update(true);
        }
    }

    public static EntityDeathEvent callEntityDeathEvent(md victim) {
        return CraftEventFactory.callEntityDeathEvent(victim, new ArrayList<ItemStack>(0));
    }

    public static EntityDeathEvent callEntityDeathEvent(md victim, List<ItemStack> drops) {
        CraftLivingEntity entity = (CraftLivingEntity)victim.getBukkitEntity();
        EntityDeathEvent event = new EntityDeathEvent((LivingEntity)entity, drops, victim.getExpReward());
        World world = entity.getWorld();
        Bukkit.getServer().getPluginManager().callEvent((Event)event);
        victim.expToDrop = event.getDroppedExp();
        for (ItemStack stack : event.getDrops()) {
            if (stack == null || stack.getType() == Material.AIR) continue;
            world.dropItemNaturally(entity.getLocation(), stack);
        }
        return event;
    }

    public static PlayerDeathEvent callPlayerDeathEvent(iq victim, List<ItemStack> drops, String deathMessage) {
        CraftPlayer entity = victim.getBukkitEntity();
        PlayerDeathEvent event = new PlayerDeathEvent((Player)entity, drops, victim.getExpReward(), 0, deathMessage);
        World world = entity.getWorld();
        Bukkit.getServer().getPluginManager().callEvent((Event)event);
        victim.keepLevel = event.getKeepLevel();
        victim.newLevel = event.getNewLevel();
        victim.newTotalExp = event.getNewTotalExp();
        victim.expToDrop = event.getDroppedExp();
        victim.newExp = event.getNewExp();
        for (ItemStack stack : event.getDrops()) {
            if (stack == null || stack.getType() == Material.AIR) continue;
            world.dropItemNaturally(entity.getLocation(), stack);
        }
        return event;
    }

    public static ServerListPingEvent callServerListPingEvent(Server craftServer, InetAddress address, String motd, int numPlayers, int maxPlayers) {
        ServerListPingEvent event = new ServerListPingEvent(address, motd, numPlayers, maxPlayers);
        craftServer.getPluginManager().callEvent((Event)event);
        return event;
    }

    public static EntityDamageEvent callEntityDamageEvent(lq damager, lq damagee, EntityDamageEvent.DamageCause cause, int damage) {
        Object event = damager != null ? new EntityDamageByEntityEvent((Entity)damager.getBukkitEntity(), (Entity)damagee.getBukkitEntity(), cause, damage) : new EntityDamageEvent((Entity)damagee.getBukkitEntity(), cause, damage);
        CraftEventFactory.callEvent(event);
        if (!event.isCancelled()) {
            event.getEntity().setLastDamageCause(event);
        }
        return event;
    }

    public static EntityDamageEvent handleEntityDamageEvent(lq entity, lh source, int damage) {
        lq damager = source.g();
        EntityDamageEvent.DamageCause cause = EntityDamageEvent.DamageCause.ENTITY_ATTACK;
        if (source instanceof lj && (damager = ((lj)source).getProximateDamageSource()) != null) {
            if (damager.getBukkitEntity() instanceof ThrownPotion) {
                cause = EntityDamageEvent.DamageCause.MAGIC;
            } else if (damager.getBukkitEntity() instanceof Projectile) {
                cause = EntityDamageEvent.DamageCause.PROJECTILE;
            }
        }
        return CraftEventFactory.callEntityDamageEvent(damager, entity, cause, damage);
    }

    public static boolean handleNonLivingEntityDamageEvent(lq entity, lh source, int damage) {
        if (!(source instanceof li)) {
            return false;
        }
        EntityDamageEvent event = CraftEventFactory.handleEntityDamageEvent(entity, source, damage);
        return event.isCancelled() || event.getDamage() == 0;
    }

    public static PlayerLevelChangeEvent callPlayerLevelChangeEvent(Player player, int oldLevel, int newLevel) {
        PlayerLevelChangeEvent event = new PlayerLevelChangeEvent(player, oldLevel, newLevel);
        Bukkit.getPluginManager().callEvent((Event)event);
        return event;
    }

    public static PlayerExpChangeEvent callPlayerExpChangeEvent(qx entity, int expAmount) {
        Player player = (Player)entity.getBukkitEntity();
        PlayerExpChangeEvent event = new PlayerExpChangeEvent(player, expAmount);
        Bukkit.getPluginManager().callEvent((Event)event);
        return event;
    }

    public static void handleBlockGrowEvent(yc world, int x2, int y2, int z2, int type, int data) {
        Block block = world.getWorld().getBlockAt(x2, y2, z2);
        CraftBlockState state = (CraftBlockState)block.getState();
        state.setTypeId(type);
        state.setRawData((byte)data);
        BlockGrowEvent event = new BlockGrowEvent(block, (BlockState)state);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (!event.isCancelled()) {
            state.update(true);
        }
    }

    public static FoodLevelChangeEvent callFoodLevelChangeEvent(qx entity, int level) {
        FoodLevelChangeEvent event = new FoodLevelChangeEvent((HumanEntity)((Player)entity.getBukkitEntity()), level);
        entity.getBukkitEntity().getServer().getPluginManager().callEvent((Event)event);
        return event;
    }

    public static PigZapEvent callPigZapEvent(lq pig, lq lightning, lq pigzombie) {
        PigZapEvent event = new PigZapEvent((Pig)pig.getBukkitEntity(), (LightningStrike)lightning.getBukkitEntity(), (PigZombie)pigzombie.getBukkitEntity());
        pig.getBukkitEntity().getServer().getPluginManager().callEvent((Event)event);
        return event;
    }

    public static EntityChangeBlockEvent callEntityChangeBlockEvent(Entity entity, Block block, Material material) {
        return CraftEventFactory.callEntityChangeBlockEvent(entity, block, material, 0);
    }

    public static EntityChangeBlockEvent callEntityChangeBlockEvent(lq entity, Block block, Material material) {
        return CraftEventFactory.callEntityChangeBlockEvent(entity.getBukkitEntity(), block, material, 0);
    }

    public static EntityChangeBlockEvent callEntityChangeBlockEvent(lq entity, int x2, int y2, int z2, int type, int data) {
        Block block = entity.p.getWorld().getBlockAt(x2, y2, z2);
        Material material = Material.getMaterial(type);
        return CraftEventFactory.callEntityChangeBlockEvent(entity.getBukkitEntity(), block, material, data);
    }

    public static EntityChangeBlockEvent callEntityChangeBlockEvent(Entity entity, Block block, Material material, int data) {
        EntityChangeBlockEvent event = new EntityChangeBlockEvent(entity, block, material, (byte)data);
        entity.getServer().getPluginManager().callEvent((Event)event);
        return event;
    }

    public static CreeperPowerEvent callCreeperPowerEvent(lq creeper, lq lightning, CreeperPowerEvent.PowerCause cause) {
        CreeperPowerEvent event = new CreeperPowerEvent((Creeper)creeper.getBukkitEntity(), (LightningStrike)lightning.getBukkitEntity(), cause);
        creeper.getBukkitEntity().getServer().getPluginManager().callEvent((Event)event);
        return event;
    }

    public static EntityTargetEvent callEntityTargetEvent(lq entity, lq target, EntityTargetEvent.TargetReason reason) {
        EntityTargetEvent event = new EntityTargetEvent((Entity)entity.getBukkitEntity(), (Entity)(target == null ? null : target.getBukkitEntity()), reason);
        entity.getBukkitEntity().getServer().getPluginManager().callEvent((Event)event);
        return event;
    }

    public static EntityTargetLivingEntityEvent callEntityTargetLivingEvent(lq entity, md target, EntityTargetEvent.TargetReason reason) {
        EntityTargetLivingEntityEvent event = new EntityTargetLivingEntityEvent((Entity)entity.getBukkitEntity(), (LivingEntity)target.getBukkitEntity(), reason);
        entity.getBukkitEntity().getServer().getPluginManager().callEvent((Event)event);
        return event;
    }

    public static EntityBreakDoorEvent callEntityBreakDoorEvent(lq entity, int x2, int y2, int z2) {
        CraftEntity entity1 = entity.getBukkitEntity();
        Block block = entity1.getWorld().getBlockAt(x2, y2, z2);
        EntityBreakDoorEvent event = new EntityBreakDoorEvent((LivingEntity)entity1, block);
        entity1.getServer().getPluginManager().callEvent((Event)event);
        return event;
    }

    public static rq callInventoryOpenEvent(iq player, rq container) {
        if (player.bL != player.bK) {
            player.a.a(new dd(player.bL.d));
        }
        CraftServer server = ((in)player.p).getServer();
        CraftPlayer craftPlayer = player.getBukkitEntity();
        try {
            player.bL.transferTo(container, craftPlayer);
        }
        catch (AbstractMethodError e2) {
            // empty catch block
        }
        InventoryOpenEvent event = new InventoryOpenEvent(container.getBukkitView());
        server.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            container.transferTo(player.bL, craftPlayer);
            return null;
        }
        return container;
    }

    public static ur callPreCraftEvent(ry matrix, ur result, InventoryView lastCraftView, boolean isRepair) {
        CraftInventoryCrafting inventory = new CraftInventoryCrafting(matrix, matrix.resultInventory);
        inventory.setResult(CraftItemStack.asCraftMirror(result));
        PrepareItemCraftEvent event = new PrepareItemCraftEvent((CraftingInventory)inventory, lastCraftView, isRepair);
        Bukkit.getPluginManager().callEvent((Event)event);
        ItemStack bitem = event.getInventory().getResult();
        return CraftItemStack.asNMSCopy(bitem);
    }

    public static ProjectileLaunchEvent callProjectileLaunchEvent(lq entity) {
        Projectile bukkitEntity = (Projectile)entity.getBukkitEntity();
        ProjectileLaunchEvent event = new ProjectileLaunchEvent((Entity)bukkitEntity);
        Bukkit.getPluginManager().callEvent((Event)event);
        return event;
    }

    public static ExpBottleEvent callExpBottleEvent(lq entity, int exp) {
        ThrownExpBottle bottle = (ThrownExpBottle)entity.getBukkitEntity();
        ExpBottleEvent event = new ExpBottleEvent(bottle, exp);
        Bukkit.getPluginManager().callEvent((Event)event);
        return event;
    }

    public static BlockRedstoneEvent callRedstoneChange(yc world, int x2, int y2, int z2, int oldCurrent, int newCurrent) {
        BlockRedstoneEvent event = new BlockRedstoneEvent(world.getWorld().getBlockAt(x2, y2, z2), oldCurrent, newCurrent);
        world.getServer().getPluginManager().callEvent((Event)event);
        return event;
    }

    public static NotePlayEvent callNotePlayEvent(yc world, int x2, int y2, int z2, byte instrument, byte note) {
        NotePlayEvent event = new NotePlayEvent(world.getWorld().getBlockAt(x2, y2, z2), Instrument.getByType((byte)instrument), new Note((int)note));
        world.getServer().getPluginManager().callEvent((Event)event);
        return event;
    }

    public static void callPlayerItemBreakEvent(qx human, ur brokenItem) {
        CraftItemStack item = CraftItemStack.asCraftMirror(brokenItem);
        PlayerItemBreakEvent event = new PlayerItemBreakEvent((Player)human.getBukkitEntity(), (ItemStack)item);
        Bukkit.getPluginManager().callEvent((Event)event);
    }
}

