/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.entity;

import org.apache.commons.lang.Validate;
import org.bukkit.Rotation;
import org.bukkit.craftbukkit.CraftServer;
import org.bukkit.craftbukkit.entity.CraftHanging;
import org.bukkit.craftbukkit.inventory.CraftItemStack;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.ItemFrame;
import org.bukkit.inventory.ItemStack;

public class CraftItemFrame
extends CraftHanging
implements ItemFrame {
    public CraftItemFrame(CraftServer server, mc entity) {
        super(server, entity);
    }

    public void setItem(ItemStack item) {
        if (item == null || item.getTypeId() == 0) {
            this.getHandle().v().a(2, 5);
            this.getHandle().v().h(2);
        } else {
            this.getHandle().a(CraftItemStack.asNMSCopy(item));
        }
    }

    public ItemStack getItem() {
        return CraftItemStack.asBukkitCopy(this.getHandle().i());
    }

    public Rotation getRotation() {
        return this.toBukkitRotation(this.getHandle().j());
    }

    Rotation toBukkitRotation(int value) {
        switch (value) {
            case 0: {
                return Rotation.NONE;
            }
            case 1: {
                return Rotation.CLOCKWISE;
            }
            case 2: {
                return Rotation.FLIPPED;
            }
            case 3: {
                return Rotation.COUNTER_CLOCKWISE;
            }
        }
        throw new AssertionError((Object)("Unknown rotation " + this.getHandle().j() + " for " + this.getHandle()));
    }

    public void setRotation(Rotation rotation) {
        Validate.notNull((Object)rotation, (String)"Rotation cannot be null");
        this.getHandle().g(CraftItemFrame.toInteger(rotation));
    }

    static int toInteger(Rotation rotation) {
        switch (rotation) {
            case NONE: {
                return 0;
            }
            case CLOCKWISE: {
                return 1;
            }
            case FLIPPED: {
                return 2;
            }
            case COUNTER_CLOCKWISE: {
                return 3;
            }
        }
        throw new IllegalArgumentException(rotation + " is not applicable to an ItemFrame");
    }

    @Override
    public mc getHandle() {
        return (mc)this.entity;
    }

    @Override
    public String toString() {
        return "CraftItemFrame{item=" + this.getItem() + ", rotation=" + this.getRotation() + "}";
    }

    @Override
    public EntityType getType() {
        return EntityType.ITEM_FRAME;
    }
}

