/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.command;

import net.minecraft.server.MinecraftServer;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;

public class TicksPerSecondCommand
extends Command {
    public TicksPerSecondCommand(String name) {
        super(name);
        this.description = "Gets the current ticks per second for the server";
        this.usageMessage = "/tps";
        this.setPermission("bukkit.command.tps");
    }

    public boolean execute(CommandSender sender, String currentAlias, String[] args) {
        if (!this.testPermission(sender)) {
            return true;
        }
        double tps = (double)Math.round(MinecraftServer.currentTPS * 10.0) / 10.0;
        ChatColor color = tps > 19.2 ? ChatColor.GREEN : (tps > 17.4 ? ChatColor.YELLOW : ChatColor.RED);
        sender.sendMessage(ChatColor.GOLD + "[TPS] " + color + tps);
        return true;
    }
}

