/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.block;

import java.util.List;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.craftbukkit.CraftChunk;
import org.bukkit.craftbukkit.CraftWorld;
import org.bukkit.material.MaterialData;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;

public class CraftBlockState
implements BlockState {
    private final CraftWorld world;
    private final CraftChunk chunk;
    private final int x;
    private final int y;
    private final int z;
    protected int type;
    protected MaterialData data;
    protected final byte light;

    public CraftBlockState(Block block) {
        this.world = (CraftWorld)block.getWorld();
        this.x = block.getX();
        this.y = block.getY();
        this.z = block.getZ();
        this.type = block.getTypeId();
        this.light = block.getLightLevel();
        this.chunk = (CraftChunk)block.getChunk();
        this.createData(block.getData());
    }

    public static CraftBlockState getBlockState(yc world, int x2, int y2, int z2) {
        return new CraftBlockState(world.getWorld().getBlockAt(x2, y2, z2));
    }

    public World getWorld() {
        return this.world;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getZ() {
        return this.z;
    }

    public Chunk getChunk() {
        return this.chunk;
    }

    public void setData(MaterialData data) {
        Material mat = this.getType();
        if (mat == null || mat.getData() == null) {
            this.data = data;
        } else if (data.getClass() == mat.getData() || data.getClass() == MaterialData.class) {
            this.data = data;
        } else {
            throw new IllegalArgumentException("Provided data is not of type " + mat.getData().getName() + ", found " + data.getClass().getName());
        }
    }

    public MaterialData getData() {
        return this.data;
    }

    public void setType(Material type) {
        this.setTypeId(type.getId());
    }

    public boolean setTypeId(int type) {
        if (this.type != type) {
            this.type = type;
            this.createData((byte)0);
        }
        return true;
    }

    public Material getType() {
        return Material.getMaterial(this.getTypeId());
    }

    public int getTypeId() {
        return this.type;
    }

    public byte getLightLevel() {
        return this.light;
    }

    public Block getBlock() {
        return this.world.getBlockAt(this.x, this.y, this.z);
    }

    public boolean update() {
        return this.update(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean update(boolean force) {
        Block block;
        Block block2 = block = this.getBlock();
        synchronized (block2) {
            if (block.getType() != this.getType()) {
                if (force) {
                    block.setTypeId(this.getTypeId());
                } else {
                    return false;
                }
            }
            block.setData(this.getRawData());
            this.world.getHandle().i(this.x, this.y, this.z);
        }
        return true;
    }

    private void createData(byte data) {
        Material mat = this.getType();
        this.data = mat == null || mat.getData() == null ? new MaterialData(this.type, data) : mat.getNewData(data);
    }

    public byte getRawData() {
        return this.data.getData();
    }

    public Location getLocation() {
        return new Location((World)this.world, (double)this.x, (double)this.y, (double)this.z);
    }

    public Location getLocation(Location loc) {
        if (loc != null) {
            loc.setWorld((World)this.world);
            loc.setX((double)this.x);
            loc.setY((double)this.y);
            loc.setZ((double)this.z);
            loc.setYaw(0.0f);
            loc.setPitch(0.0f);
        }
        return loc;
    }

    public void setRawData(byte data) {
        this.data.setData(data);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CraftBlockState other = (CraftBlockState)obj;
        if (!(this.world == other.world || this.world != null && this.world.equals(other.world))) {
            return false;
        }
        if (this.x != other.x) {
            return false;
        }
        if (this.y != other.y) {
            return false;
        }
        if (this.z != other.z) {
            return false;
        }
        if (this.type != other.type) {
            return false;
        }
        return this.data == other.data || this.data != null && this.data.equals((Object)other.data);
    }

    public int hashCode() {
        int hash = 7;
        hash = 73 * hash + (this.world != null ? this.world.hashCode() : 0);
        hash = 73 * hash + this.x;
        hash = 73 * hash + this.y;
        hash = 73 * hash + this.z;
        hash = 73 * hash + this.type;
        hash = 73 * hash + (this.data != null ? this.data.hashCode() : 0);
        return hash;
    }

    public void setMetadata(String metadataKey, MetadataValue newMetadataValue) {
        this.chunk.getCraftWorld().getBlockMetadata().setMetadata(this.getBlock(), metadataKey, newMetadataValue);
    }

    public List<MetadataValue> getMetadata(String metadataKey) {
        return this.chunk.getCraftWorld().getBlockMetadata().getMetadata(this.getBlock(), metadataKey);
    }

    public boolean hasMetadata(String metadataKey) {
        return this.chunk.getCraftWorld().getBlockMetadata().hasMetadata(this.getBlock(), metadataKey);
    }

    public void removeMetadata(String metadataKey, Plugin owningPlugin) {
        this.chunk.getCraftWorld().getBlockMetadata().removeMetadata(this.getBlock(), metadataKey, owningPlugin);
    }
}

