/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit;

public class OrebfuscatorManager {
    public static boolean[] obfuscateBlocks = new boolean[Short.MAX_VALUE];

    public static void updateNearbyBlocks(yc world, int x2, int y2, int z2) {
        OrebfuscatorManager.updateNearbyBlocks(world, x2, y2, z2, world.getServer().orebfuscatorUpdateRadius);
    }

    public static void obfuscate(int chunkX, int chunkY, int bitmask, byte[] buffer, yc world) {
        if (world.getServer().orebfuscatorEnabled && world.getWorld().obfuscated) {
            int initialRadius = 1;
            int index = 0;
            int startX = chunkX << 4;
            int startZ = chunkY << 4;
            for (int i2 = 0; i2 < 16; ++i2) {
                if ((bitmask & 1 << i2) == 0) continue;
                for (int y2 = 0; y2 < 16; ++y2) {
                    for (int z2 = 0; z2 < 16; ++z2) {
                        for (int x2 = 0; x2 < 16; ++x2) {
                            byte data = buffer[index];
                            if (obfuscateBlocks[data & 0xFF] && (initialRadius == 0 || !OrebfuscatorManager.areAjacentBlocksTransparent(world, startX + x2, (i2 << 4) + y2, startZ + z2, initialRadius))) {
                                buffer[index] = (byte)amq.w.cm;
                            }
                            if (++index < buffer.length) continue;
                            return;
                        }
                    }
                }
            }
        }
    }

    private static void updateNearbyBlocks(yc world, int x2, int y2, int z2, int radius) {
        if (world.getServer().orebfuscatorEnabled && world.getWorld().obfuscated && world.f(x2, y2, z2)) {
            int id2 = world.a(x2, y2, z2);
            if (obfuscateBlocks[id2]) {
                world.i(x2, y2, z2);
            }
            if (radius != 0) {
                OrebfuscatorManager.updateNearbyBlocks(world, x2 + 1, y2, z2, radius - 1);
                OrebfuscatorManager.updateNearbyBlocks(world, x2 - 1, y2, z2, radius - 1);
                OrebfuscatorManager.updateNearbyBlocks(world, x2, y2 + 1, z2, radius - 1);
                OrebfuscatorManager.updateNearbyBlocks(world, x2, y2 - 1, z2, radius - 1);
                OrebfuscatorManager.updateNearbyBlocks(world, x2, y2, z2 + 1, radius - 1);
                OrebfuscatorManager.updateNearbyBlocks(world, x2, y2, z2 - 1, radius - 1);
            }
        }
    }

    private static boolean areAjacentBlocksTransparent(yc world, int x2, int y2, int z2, int radius) {
        return y2 > 0 && y2 <= world.O() && world.f(x2, y2, z2) && !amq.i(world.a(x2, y2, z2)) || radius > 0 && (OrebfuscatorManager.areAjacentBlocksTransparent(world, x2, y2 + 1, z2, radius - 1) || OrebfuscatorManager.areAjacentBlocksTransparent(world, x2, y2 - 1, z2, radius - 1) || OrebfuscatorManager.areAjacentBlocksTransparent(world, x2 + 1, y2, z2, radius - 1) || OrebfuscatorManager.areAjacentBlocksTransparent(world, x2 - 1, y2, z2, radius - 1) || OrebfuscatorManager.areAjacentBlocksTransparent(world, x2, y2, z2 + 1, radius - 1) || OrebfuscatorManager.areAjacentBlocksTransparent(world, x2, y2, z2 - 1, radius - 1));
    }

    static {
        OrebfuscatorManager.obfuscateBlocks[amq.w.cm] = true;
        OrebfuscatorManager.obfuscateBlocks[amq.J.cm] = true;
        OrebfuscatorManager.obfuscateBlocks[amq.K.cm] = true;
        OrebfuscatorManager.obfuscateBlocks[amq.L.cm] = true;
        OrebfuscatorManager.obfuscateBlocks[amq.Q.cm] = true;
        OrebfuscatorManager.obfuscateBlocks[amq.ax.cm] = true;
        OrebfuscatorManager.obfuscateBlocks[amq.az.cm] = true;
        OrebfuscatorManager.obfuscateBlocks[amq.aQ.cm] = true;
        OrebfuscatorManager.obfuscateBlocks[amq.aR.cm] = true;
        OrebfuscatorManager.obfuscateBlocks[amq.bU.cm] = true;
        OrebfuscatorManager.obfuscateBlocks[amq.bV.cm] = true;
    }
}

