/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.lang.Validate;
import org.bukkit.BlockChangeDelegate;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.ChunkSnapshot;
import org.bukkit.Difficulty;
import org.bukkit.Effect;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.TreeType;
import org.bukkit.World;
import org.bukkit.WorldType;
import org.bukkit.block.Biome;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.craftbukkit.CraftChunk;
import org.bukkit.craftbukkit.CraftEffect;
import org.bukkit.craftbukkit.CraftServer;
import org.bukkit.craftbukkit.CraftSound;
import org.bukkit.craftbukkit.block.CraftBlock;
import org.bukkit.craftbukkit.entity.CraftEntity;
import org.bukkit.craftbukkit.entity.CraftItem;
import org.bukkit.craftbukkit.entity.CraftLightningStrike;
import org.bukkit.craftbukkit.entity.CraftMinecart;
import org.bukkit.craftbukkit.entity.CraftPlayer;
import org.bukkit.craftbukkit.inventory.CraftItemStack;
import org.bukkit.craftbukkit.metadata.BlockMetadataStore;
import org.bukkit.craftbukkit.util.LongHash;
import org.bukkit.entity.Ambient;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Bat;
import org.bukkit.entity.Blaze;
import org.bukkit.entity.Boat;
import org.bukkit.entity.CaveSpider;
import org.bukkit.entity.Chicken;
import org.bukkit.entity.ComplexLivingEntity;
import org.bukkit.entity.Cow;
import org.bukkit.entity.CreatureType;
import org.bukkit.entity.Creeper;
import org.bukkit.entity.Egg;
import org.bukkit.entity.EnderCrystal;
import org.bukkit.entity.EnderDragon;
import org.bukkit.entity.EnderSignal;
import org.bukkit.entity.Enderman;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.ExperienceOrb;
import org.bukkit.entity.FallingBlock;
import org.bukkit.entity.Fireball;
import org.bukkit.entity.Firework;
import org.bukkit.entity.Fish;
import org.bukkit.entity.Ghast;
import org.bukkit.entity.Giant;
import org.bukkit.entity.Golem;
import org.bukkit.entity.Hanging;
import org.bukkit.entity.IronGolem;
import org.bukkit.entity.Item;
import org.bukkit.entity.ItemFrame;
import org.bukkit.entity.LightningStrike;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.MagmaCube;
import org.bukkit.entity.Minecart;
import org.bukkit.entity.MushroomCow;
import org.bukkit.entity.Ocelot;
import org.bukkit.entity.Painting;
import org.bukkit.entity.Pig;
import org.bukkit.entity.PigZombie;
import org.bukkit.entity.Player;
import org.bukkit.entity.PoweredMinecart;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.Sheep;
import org.bukkit.entity.Silverfish;
import org.bukkit.entity.Skeleton;
import org.bukkit.entity.Slime;
import org.bukkit.entity.SmallFireball;
import org.bukkit.entity.Snowball;
import org.bukkit.entity.Snowman;
import org.bukkit.entity.Spider;
import org.bukkit.entity.Squid;
import org.bukkit.entity.StorageMinecart;
import org.bukkit.entity.TNTPrimed;
import org.bukkit.entity.Tameable;
import org.bukkit.entity.ThrownExpBottle;
import org.bukkit.entity.Villager;
import org.bukkit.entity.Weather;
import org.bukkit.entity.Witch;
import org.bukkit.entity.Wither;
import org.bukkit.entity.WitherSkull;
import org.bukkit.entity.Wolf;
import org.bukkit.entity.Zombie;
import org.bukkit.event.Event;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.weather.ThunderChangeEvent;
import org.bukkit.event.weather.WeatherChangeEvent;
import org.bukkit.event.world.SpawnChangeEvent;
import org.bukkit.generator.BlockPopulator;
import org.bukkit.generator.ChunkGenerator;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.messaging.Messenger;
import org.bukkit.plugin.messaging.StandardMessenger;
import org.bukkit.util.Vector;

public class CraftWorld
implements World {
    public static final int CUSTOM_DIMENSION_OFFSET = 10;
    private final in world;
    private World.Environment environment;
    private final CraftServer server = (CraftServer)Bukkit.getServer();
    private final ChunkGenerator generator;
    private final List<BlockPopulator> populators = new ArrayList<BlockPopulator>();
    private final BlockMetadataStore blockMetadata = new BlockMetadataStore(this);
    private int monsterSpawn = -1;
    private int animalSpawn = -1;
    private int waterAnimalSpawn = -1;
    private int ambientSpawn = -1;
    private int chunkLoadCount = 0;
    private int chunkGCTickCount;
    private static final Random rand = new Random();
    public int growthPerTick = 650;
    public double itemMergeRadius = 3.0;
    public double expMergeRadius = 3.0;
    public boolean randomLightingUpdates = false;
    public int mobSpawnRange = 4;
    public int aggregateTicks = 4;
    public int viewDistance;
    public boolean obfuscated = false;
    public int wheatGrowthModifier = 100;
    public int cactusGrowthModifier = 100;
    public int melonGrowthModifier = 100;
    public int pumpkinGrowthModifier = 100;
    public int sugarGrowthModifier = 100;
    public int treeGrowthModifier = 100;
    public int mushroomGrowthModifier = 100;

    public CraftWorld(in world, ChunkGenerator gen, World.Environment env) {
        this.world = world;
        this.generator = gen;
        this.environment = env;
        if (this.server.chunkGCPeriod > 0) {
            this.chunkGCTickCount = rand.nextInt(this.server.chunkGCPeriod);
        }
        YamlConfiguration configuration = this.server.configuration;
        String name = world.y == null || world.y.k() == null ? "default" : world.y.k().replaceAll(" ", "_");
        this.growthPerTick = configuration.getInt("world-settings.default.growth-chunks-per-tick", this.growthPerTick);
        this.itemMergeRadius = configuration.getDouble("world-settings.default.item-merge-radius", this.itemMergeRadius);
        this.expMergeRadius = configuration.getDouble("world-settings.default.exp-merge-radius", this.expMergeRadius);
        this.randomLightingUpdates = configuration.getBoolean("world-settings.default.random-light-updates", this.randomLightingUpdates);
        this.mobSpawnRange = configuration.getInt("world-settings.default.mob-spawn-range", this.mobSpawnRange);
        this.aggregateTicks = Math.max(1, configuration.getInt("world-settings.default.aggregate-chunkticks", this.aggregateTicks));
        this.wheatGrowthModifier = configuration.getInt("world-settings.default.wheat-growth-modifier", this.wheatGrowthModifier);
        this.cactusGrowthModifier = configuration.getInt("world-settings.default.cactus-growth-modifier", this.cactusGrowthModifier);
        this.melonGrowthModifier = configuration.getInt("world-settings.default.melon-growth-modifier", this.melonGrowthModifier);
        this.pumpkinGrowthModifier = configuration.getInt("world-settings.default.pumpkin-growth-modifier", this.pumpkinGrowthModifier);
        this.sugarGrowthModifier = configuration.getInt("world-settings.default.sugar-growth-modifier", this.sugarGrowthModifier);
        this.treeGrowthModifier = configuration.getInt("world-settings.default.tree-growth-modifier", this.treeGrowthModifier);
        this.mushroomGrowthModifier = configuration.getInt("world-settings.default.mushroom-growth-modifier", this.mushroomGrowthModifier);
        this.growthPerTick = configuration.getInt("world-settings." + name + ".growth-chunks-per-tick", this.growthPerTick);
        this.itemMergeRadius = configuration.getDouble("world-settings." + name + ".item-merge-radius", this.itemMergeRadius);
        this.expMergeRadius = configuration.getDouble("world-settings." + name + ".exp-merge-radius", this.expMergeRadius);
        this.randomLightingUpdates = configuration.getBoolean("world-settings." + name + ".random-light-updates", this.randomLightingUpdates);
        this.mobSpawnRange = configuration.getInt("world-settings." + name + ".mob-spawn-range", this.mobSpawnRange);
        this.aggregateTicks = Math.max(1, configuration.getInt("world-settings." + name + ".aggregate-chunkticks", this.aggregateTicks));
        this.wheatGrowthModifier = configuration.getInt("world-settings." + name + ".wheat-growth-modifier", this.wheatGrowthModifier);
        this.cactusGrowthModifier = configuration.getInt("world-settings." + name + ".cactus-growth-modifier", this.cactusGrowthModifier);
        this.melonGrowthModifier = configuration.getInt("world-settings." + name + ".melon-growth-modifier", this.melonGrowthModifier);
        this.pumpkinGrowthModifier = configuration.getInt("world-settings." + name + ".pumpkin-growth-modifier", this.pumpkinGrowthModifier);
        this.sugarGrowthModifier = configuration.getInt("world-settings." + name + ".sugar-growth-modifier", this.sugarGrowthModifier);
        this.treeGrowthModifier = configuration.getInt("world-settings." + name + ".tree-growth-modifier", this.treeGrowthModifier);
        this.mushroomGrowthModifier = configuration.getInt("world-settings." + name + ".mushroom-growth-modifier", this.mushroomGrowthModifier);
        this.viewDistance = Bukkit.getServer().getViewDistance();
        this.viewDistance = configuration.getInt("world-settings." + name + ".view-distance", this.viewDistance);
        boolean bl = this.obfuscated = !world.getServer().orebfuscatorDisabledWorlds.contains(name);
        if (!configuration.getBoolean("world-settings.default.verbose", false)) {
            return;
        }
        this.server.getLogger().info("-------------- Spigot ----------------");
        this.server.getLogger().info("-------- World Settings For [" + name + "] --------");
        this.server.getLogger().info("Growth Per Chunk: " + this.growthPerTick);
        this.server.getLogger().info("Item Merge Radius: " + this.itemMergeRadius);
        this.server.getLogger().info("Experience Merge Radius: " + this.expMergeRadius);
        this.server.getLogger().info("Random Lighting Updates: " + this.randomLightingUpdates);
        this.server.getLogger().info("Mob Spawn Range: " + this.mobSpawnRange);
        this.server.getLogger().info("Aggregate Ticks: " + this.aggregateTicks);
        this.server.getLogger().info("Wheat Growth Modifier: " + this.wheatGrowthModifier);
        this.server.getLogger().info("Cactus Growth Modifier: " + this.cactusGrowthModifier);
        this.server.getLogger().info("Melon Growth Modifier: " + this.melonGrowthModifier);
        this.server.getLogger().info("Pumpkin Growth Modifier: " + this.pumpkinGrowthModifier);
        this.server.getLogger().info("Sugar Growth Modifier: " + this.sugarGrowthModifier);
        this.server.getLogger().info("Tree Growth Modifier: " + this.treeGrowthModifier);
        this.server.getLogger().info("Mushroom Growth Modifier: " + this.mushroomGrowthModifier);
        this.server.getLogger().info("View distance: " + this.viewDistance);
        this.server.getLogger().info("Oreobfuscator: " + this.obfuscated);
        this.server.getLogger().info("-------------------------------------------------");
    }

    public Block getBlockAt(int x2, int y2, int z2) {
        return this.getChunkAt(x2 >> 4, z2 >> 4).getBlock(x2 & 0xF, y2 & 0xFF, z2 & 0xF);
    }

    public int getBlockTypeIdAt(int x2, int y2, int z2) {
        return this.world.a(x2, y2, z2);
    }

    public int getHighestBlockYAt(int x2, int z2) {
        if (!this.isChunkLoaded(x2 >> 4, z2 >> 4)) {
            this.loadChunk(x2 >> 4, z2 >> 4);
        }
        return this.world.f(x2, z2);
    }

    public Location getSpawnLocation() {
        s spawn = this.world.H();
        return new Location((World)this, (double)spawn.a, (double)spawn.b, (double)spawn.c);
    }

    public boolean setSpawnLocation(int x2, int y2, int z2) {
        try {
            Location previousLocation = this.getSpawnLocation();
            this.world.y.a(x2, y2, z2);
            SpawnChangeEvent event = new SpawnChangeEvent((World)this, previousLocation);
            this.server.getPluginManager().callEvent((Event)event);
            return true;
        }
        catch (Exception e2) {
            return false;
        }
    }

    public Chunk getChunkAt(int x2, int z2) {
        return this.world.b.c((int)x2, (int)z2).bukkitChunk;
    }

    public Chunk getChunkAt(Block block) {
        return this.getChunkAt(block.getX() >> 4, block.getZ() >> 4);
    }

    public boolean isChunkLoaded(int x2, int z2) {
        return this.world.b.a(x2, z2);
    }

    public Chunk[] getLoadedChunks() {
        Object[] chunks = this.world.b.f.values().toArray();
        Chunk[] craftChunks = new CraftChunk[chunks.length];
        for (int i2 = 0; i2 < chunks.length; ++i2) {
            zz chunk = (zz)chunks[i2];
            craftChunks[i2] = chunk.bukkitChunk;
        }
        return craftChunks;
    }

    public void loadChunk(int x2, int z2) {
        this.loadChunk(x2, z2, true);
    }

    public boolean unloadChunk(Chunk chunk) {
        return this.unloadChunk(chunk.getX(), chunk.getZ());
    }

    public boolean unloadChunk(int x2, int z2) {
        return this.unloadChunk(x2, z2, true);
    }

    public boolean unloadChunk(int x2, int z2, boolean save) {
        return this.unloadChunk(x2, z2, save, false);
    }

    public boolean unloadChunkRequest(int x2, int z2) {
        return this.unloadChunkRequest(x2, z2, true);
    }

    public boolean unloadChunkRequest(int x2, int z2, boolean safe) {
        if (safe && this.isChunkInUse(x2, z2)) {
            return false;
        }
        this.world.b.b(x2, z2);
        return true;
    }

    public boolean unloadChunk(int x2, int z2, boolean save, boolean safe) {
        if (safe && this.isChunkInUse(x2, z2)) {
            return false;
        }
        zz chunk = this.world.b.d(x2, z2);
        if (chunk.mustSave) {
            save = true;
        }
        chunk.d();
        if (save && !(chunk instanceof zy)) {
            this.world.b.b(chunk);
            this.world.b.a(chunk);
        }
        this.world.b.b.remove(x2, z2);
        this.world.b.f.remove(LongHash.toLong(x2, z2));
        this.world.b.g.remove(chunk);
        return true;
    }

    public boolean regenerateChunk(int x2, int z2) {
        this.unloadChunk(x2, z2, false, false);
        this.world.b.b.remove(x2, z2);
        zz chunk = null;
        chunk = this.world.b.d == null ? this.world.b.c : this.world.b.d.d(x2, z2);
        this.chunkLoadPostProcess(chunk, x2, z2);
        this.refreshChunk(x2, z2);
        return chunk != null;
    }

    public boolean refreshChunk(int x2, int z2) {
        if (!this.isChunkLoaded(x2, z2)) {
            return false;
        }
        int px2 = x2 << 4;
        int pz2 = z2 << 4;
        int height = this.getMaxHeight() / 16;
        for (int idx = 0; idx < 64; ++idx) {
            this.world.i(px2 + idx / height, idx % height * 16, pz2);
        }
        this.world.i(px2 + 15, height * 16 - 1, pz2 + 15);
        return true;
    }

    public boolean isChunkInUse(int x2, int z2) {
        return this.world.r().isChunkInUse(x2, z2);
    }

    public boolean loadChunk(int x2, int z2, boolean generate) {
        ++this.chunkLoadCount;
        if (generate) {
            return this.world.b.c(x2, z2) != null;
        }
        this.world.b.b.remove(x2, z2);
        zz chunk = this.world.b.f.get(LongHash.toLong(x2, z2));
        if (chunk == null) {
            chunk = this.world.b.f(x2, z2);
            this.chunkLoadPostProcess(chunk, x2, z2);
        }
        return chunk != null;
    }

    private void chunkLoadPostProcess(zz chunk, int x2, int z2) {
        if (chunk != null) {
            this.world.b.f.put(LongHash.toLong(x2, z2), chunk);
            this.world.b.g.add(chunk);
            chunk.c();
            if (!chunk.k && this.world.b.a(x2 + 1, z2 + 1) && this.world.b.a(x2, z2 + 1) && this.world.b.a(x2 + 1, z2)) {
                this.world.b.a(this.world.b, x2, z2);
            }
            if (this.world.b.a(x2 - 1, z2) && !this.world.b.d((int)(x2 - 1), (int)z2).k && this.world.b.a(x2 - 1, z2 + 1) && this.world.b.a(x2, z2 + 1) && this.world.b.a(x2 - 1, z2)) {
                this.world.b.a(this.world.b, x2 - 1, z2);
            }
            if (this.world.b.a(x2, z2 - 1) && !this.world.b.d((int)x2, (int)(z2 - 1)).k && this.world.b.a(x2 + 1, z2 - 1) && this.world.b.a(x2, z2 - 1) && this.world.b.a(x2 + 1, z2)) {
                this.world.b.a(this.world.b, x2, z2 - 1);
            }
            if (this.world.b.a(x2 - 1, z2 - 1) && !this.world.b.d((int)(x2 - 1), (int)(z2 - 1)).k && this.world.b.a(x2 - 1, z2 - 1) && this.world.b.a(x2, z2 - 1) && this.world.b.a(x2 - 1, z2)) {
                this.world.b.a(this.world.b, x2 - 1, z2 - 1);
            }
        }
    }

    public boolean isChunkLoaded(Chunk chunk) {
        return this.isChunkLoaded(chunk.getX(), chunk.getZ());
    }

    public void loadChunk(Chunk chunk) {
        this.loadChunk(chunk.getX(), chunk.getZ());
        ((CraftChunk)this.getChunkAt((int)chunk.getX(), (int)chunk.getZ())).getHandle().bukkitChunk = chunk;
    }

    public in getHandle() {
        return this.world;
    }

    public Item dropItem(Location loc, ItemStack item) {
        Validate.notNull((Object)item, (String)"Cannot drop a Null item.");
        Validate.isTrue((item.getTypeId() != 0 ? 1 : 0) != 0, (String)"Cannot drop AIR.");
        px entity = new px(this.world, loc.getX(), loc.getY(), loc.getZ(), CraftItemStack.asNMSCopy(item));
        entity.b = 10;
        this.world.d(entity);
        return new CraftItem(this.world.getServer(), entity);
    }

    public Item dropItemNaturally(Location loc, ItemStack item) {
        double xs2 = (double)(this.world.t.nextFloat() * 0.7f) + (double)0.15f;
        double ys2 = (double)(this.world.t.nextFloat() * 0.7f) + (double)0.15f;
        double zs2 = (double)(this.world.t.nextFloat() * 0.7f) + (double)0.15f;
        loc = loc.clone();
        loc.setX(loc.getX() + xs2);
        loc.setY(loc.getY() + ys2);
        loc.setZ(loc.getZ() + zs2);
        return this.dropItem(loc, item);
    }

    public Arrow spawnArrow(Location loc, Vector velocity, float speed, float spread) {
        Validate.notNull((Object)loc, (String)"Can not spawn arrow with a null location");
        Validate.notNull((Object)velocity, (String)"Can not spawn arrow with a null velocity");
        qz arrow = new qz(this.world);
        arrow.b(loc.getX(), loc.getY(), loc.getZ(), loc.getPitch(), loc.getYaw());
        arrow.c(velocity.getX(), velocity.getY(), velocity.getZ(), speed, spread);
        this.world.d(arrow);
        return (Arrow)arrow.getBukkitEntity();
    }

    @Deprecated
    public LivingEntity spawnCreature(Location loc, CreatureType creatureType) {
        return this.spawnCreature(loc, creatureType.toEntityType());
    }

    @Deprecated
    public LivingEntity spawnCreature(Location loc, EntityType creatureType) {
        Validate.isTrue((boolean)creatureType.isAlive(), (String)"EntityType not instance of LivingEntity");
        return (LivingEntity)this.spawnEntity(loc, creatureType);
    }

    public Entity spawnEntity(Location loc, EntityType entityType) {
        return this.spawn(loc, entityType.getEntityClass());
    }

    public LightningStrike strikeLightning(Location loc) {
        pu lightning = new pu(this.world, loc.getX(), loc.getY(), loc.getZ());
        this.world.c(lightning);
        return new CraftLightningStrike(this.server, lightning);
    }

    public LightningStrike strikeLightningEffect(Location loc) {
        pu lightning = new pu(this.world, loc.getX(), loc.getY(), loc.getZ(), true);
        this.world.c(lightning);
        return new CraftLightningStrike(this.server, lightning);
    }

    public boolean generateTree(Location loc, TreeType type) {
        return this.generateTree(loc, type, this.world);
    }

    public boolean generateTree(Location loc, TreeType type, BlockChangeDelegate delegate) {
        abm gen;
        switch (type) {
            case BIG_TREE: {
                gen = new abe(true);
                break;
            }
            case BIRCH: {
                gen = new abf(true);
                break;
            }
            case REDWOOD: {
                gen = new acf(true);
                break;
            }
            case TALL_REDWOOD: {
                gen = new abz();
                break;
            }
            case JUNGLE: {
                gen = new abw(true, 10 + rand.nextInt(20), 3, 3);
                break;
            }
            case SMALL_JUNGLE: {
                gen = new aci(true, 4 + rand.nextInt(7), 3, 3, false);
                break;
            }
            case JUNGLE_BUSH: {
                gen = new abo(3, 0);
                break;
            }
            case RED_MUSHROOM: {
                gen = new abt(1);
                break;
            }
            case BROWN_MUSHROOM: {
                gen = new abt(0);
                break;
            }
            case SWAMP: {
                gen = new acg();
                break;
            }
            default: {
                gen = new aci(true);
            }
        }
        return gen.generate(delegate, rand, loc.getBlockX(), loc.getBlockY(), loc.getBlockZ());
    }

    public any getTileEntityAt(int x2, int y2, int z2) {
        return this.world.q(x2, y2, z2);
    }

    public String getName() {
        return this.world.y.k();
    }

    @Deprecated
    public long getId() {
        return this.world.y.b();
    }

    public UUID getUID() {
        return this.world.J().getUUID();
    }

    public String toString() {
        return "CraftWorld{name=" + this.getName() + '}';
    }

    public long getTime() {
        long time = this.getFullTime() % 24000L;
        if (time < 0L) {
            time += 24000L;
        }
        return time;
    }

    public void setTime(long time) {
        long margin = (time - this.getFullTime()) % 24000L;
        if (margin < 0L) {
            margin += 24000L;
        }
        this.setFullTime(this.getFullTime() + margin);
    }

    public long getFullTime() {
        return this.world.G();
    }

    public void setFullTime(long time) {
        this.world.b(time);
        for (Player p2 : this.getPlayers()) {
            CraftPlayer cp2 = (CraftPlayer)p2;
            if (cp2.getHandle().a == null) continue;
            cp2.getHandle().a.b(new fa(cp2.getHandle().p.F(), cp2.getHandle().getPlayerTime()));
        }
    }

    public boolean createExplosion(double x2, double y2, double z2, float power) {
        return this.createExplosion(x2, y2, z2, power, false, true);
    }

    public boolean createExplosion(double x2, double y2, double z2, float power, boolean setFire) {
        return this.createExplosion(x2, y2, z2, power, setFire, true);
    }

    public boolean createExplosion(double x2, double y2, double z2, float power, boolean setFire, boolean breakBlocks) {
        return !this.world.a(null, (double)x2, (double)y2, (double)z2, (float)power, (boolean)setFire, (boolean)breakBlocks).wasCanceled;
    }

    public boolean createExplosion(Location loc, float power) {
        return this.createExplosion(loc, power, false);
    }

    public boolean createExplosion(Location loc, float power, boolean setFire) {
        return this.createExplosion(loc.getX(), loc.getY(), loc.getZ(), power, setFire);
    }

    public World.Environment getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(World.Environment env) {
        if (this.environment != env) {
            this.environment = env;
            this.world.u = aaq.a(this.environment.getId());
        }
    }

    public Block getBlockAt(Location location) {
        return this.getBlockAt(location.getBlockX(), location.getBlockY(), location.getBlockZ());
    }

    public int getBlockTypeIdAt(Location location) {
        return this.getBlockTypeIdAt(location.getBlockX(), location.getBlockY(), location.getBlockZ());
    }

    public int getHighestBlockYAt(Location location) {
        return this.getHighestBlockYAt(location.getBlockX(), location.getBlockZ());
    }

    public Chunk getChunkAt(Location location) {
        return this.getChunkAt(location.getBlockX() >> 4, location.getBlockZ() >> 4);
    }

    public ChunkGenerator getGenerator() {
        return this.generator;
    }

    public List<BlockPopulator> getPopulators() {
        return this.populators;
    }

    public Block getHighestBlockAt(int x2, int z2) {
        return this.getBlockAt(x2, this.getHighestBlockYAt(x2, z2), z2);
    }

    public Block getHighestBlockAt(Location location) {
        return this.getHighestBlockAt(location.getBlockX(), location.getBlockZ());
    }

    public Biome getBiome(int x2, int z2) {
        return CraftBlock.biomeBaseToBiome(this.world.a(x2, z2));
    }

    public void setBiome(int x2, int z2, Biome bio) {
        zz chunk;
        yy bb2 = CraftBlock.biomeToBiomeBase(bio);
        if (this.world.f(x2, 0, z2) && (chunk = this.world.d(x2, z2)) != null) {
            byte[] biomevals = chunk.m();
            biomevals[(z2 & 0xF) << 4 | x2 & 0xF] = (byte)bb2.N;
        }
    }

    public double getTemperature(int x2, int z2) {
        return this.world.a((int)x2, (int)z2).F;
    }

    public double getHumidity(int x2, int z2) {
        return this.world.a((int)x2, (int)z2).G;
    }

    public List<Entity> getEntities() {
        ArrayList<Entity> list = new ArrayList<Entity>();
        for (Object o2 : this.world.e) {
            lq mcEnt;
            CraftEntity bukkitEntity;
            if (!(o2 instanceof lq) || (bukkitEntity = (mcEnt = (lq)o2).getBukkitEntity()) == null) continue;
            list.add(bukkitEntity);
        }
        return list;
    }

    public List<LivingEntity> getLivingEntities() {
        ArrayList<LivingEntity> list = new ArrayList<LivingEntity>();
        for (Object o2 : this.world.e) {
            lq mcEnt;
            CraftEntity bukkitEntity;
            if (!(o2 instanceof lq) || (bukkitEntity = (mcEnt = (lq)o2).getBukkitEntity()) == null || !(bukkitEntity instanceof LivingEntity)) continue;
            list.add((LivingEntity)bukkitEntity);
        }
        return list;
    }

    @Deprecated
    public <T extends Entity> Collection<T> getEntitiesByClass(Class<T> ... classes) {
        return this.getEntitiesByClasses(classes);
    }

    public <T extends Entity> Collection<T> getEntitiesByClass(Class<T> clazz) {
        ArrayList<CraftEntity> list = new ArrayList<CraftEntity>();
        for (Object entity : this.world.e) {
            Class<?> bukkitClass;
            CraftEntity bukkitEntity;
            if (!(entity instanceof lq) || (bukkitEntity = ((lq)entity).getBukkitEntity()) == null || !clazz.isAssignableFrom(bukkitClass = bukkitEntity.getClass())) continue;
            list.add(bukkitEntity);
        }
        return list;
    }

    public Collection<Entity> getEntitiesByClasses(Class<?> ... classes) {
        ArrayList<Entity> list = new ArrayList<Entity>();
        block0: for (Object entity : this.world.e) {
            CraftEntity bukkitEntity;
            if (!(entity instanceof lq) || (bukkitEntity = ((lq)entity).getBukkitEntity()) == null) continue;
            Class<?> bukkitClass = bukkitEntity.getClass();
            for (Class<?> clazz : classes) {
                if (!clazz.isAssignableFrom(bukkitClass)) continue;
                list.add(bukkitEntity);
                continue block0;
            }
        }
        return list;
    }

    public List<Player> getPlayers() {
        ArrayList<Player> list = new ArrayList<Player>();
        for (Object o2 : this.world.e) {
            lq mcEnt;
            CraftEntity bukkitEntity;
            if (!(o2 instanceof lq) || (bukkitEntity = (mcEnt = (lq)o2).getBukkitEntity()) == null || !(bukkitEntity instanceof Player)) continue;
            list.add((Player)bukkitEntity);
        }
        return list;
    }

    public void save() {
        try {
            boolean oldSave = this.world.c;
            this.world.c = false;
            this.world.a(true, null);
            this.world.c = oldSave;
        }
        catch (yh ex2) {
            ex2.printStackTrace();
        }
    }

    public boolean isAutoSave() {
        return !this.world.c;
    }

    public void setAutoSave(boolean value) {
        this.world.c = !value;
    }

    public void setDifficulty(Difficulty difficulty) {
        this.getHandle().s = difficulty.getValue();
    }

    public Difficulty getDifficulty() {
        return Difficulty.getByValue((int)this.getHandle().s);
    }

    public BlockMetadataStore getBlockMetadata() {
        return this.blockMetadata;
    }

    public boolean hasStorm() {
        return this.world.y.p();
    }

    public void setStorm(boolean hasStorm) {
        CraftServer server = this.world.getServer();
        WeatherChangeEvent weather = new WeatherChangeEvent((World)this, hasStorm);
        server.getPluginManager().callEvent((Event)weather);
        if (!weather.isCancelled()) {
            this.world.y.b(hasStorm);
            if (hasStorm) {
                this.setWeatherDuration(rand.nextInt(12000) + 12000);
            } else {
                this.setWeatherDuration(rand.nextInt(168000) + 12000);
            }
        }
    }

    public int getWeatherDuration() {
        return this.world.y.q();
    }

    public void setWeatherDuration(int duration) {
        this.world.y.g(duration);
    }

    public boolean isThundering() {
        return this.hasStorm() && this.world.y.n();
    }

    public void setThundering(boolean thundering) {
        if (thundering && !this.hasStorm()) {
            this.setStorm(true);
        }
        CraftServer server = this.world.getServer();
        ThunderChangeEvent thunder = new ThunderChangeEvent((World)this, thundering);
        server.getPluginManager().callEvent((Event)thunder);
        if (!thunder.isCancelled()) {
            this.world.y.a(thundering);
            if (thundering) {
                this.setThunderDuration(rand.nextInt(12000) + 3600);
            } else {
                this.setThunderDuration(rand.nextInt(168000) + 12000);
            }
        }
    }

    public int getThunderDuration() {
        return this.world.y.o();
    }

    public void setThunderDuration(int duration) {
        this.world.y.f(duration);
    }

    public long getSeed() {
        return this.world.y.b();
    }

    public boolean getPVP() {
        return this.world.pvpMode;
    }

    public void setPVP(boolean pvp) {
        this.world.pvpMode = pvp;
    }

    public void playEffect(Player player, Effect effect, int data) {
        this.playEffect(player.getLocation(), effect, data, 0);
    }

    public void playEffect(Location location, Effect effect, int data) {
        this.playEffect(location, effect, data, 64);
    }

    public <T> void playEffect(Location loc, Effect effect, T data) {
        this.playEffect(loc, effect, data, 64);
    }

    public <T> void playEffect(Location loc, Effect effect, T data, int radius) {
        if (data != null) {
            Validate.isTrue((boolean)data.getClass().equals(effect.getData()), (String)"Wrong kind of data for this effect!");
        } else {
            Validate.isTrue((effect.getData() == null ? 1 : 0) != 0, (String)"Wrong kind of data for this effect!");
        }
        int datavalue = data == null ? 0 : CraftEffect.getDataValue(effect, data);
        this.playEffect(loc, effect, datavalue, radius);
    }

    public void playEffect(Location location, Effect effect, int data, int radius) {
        Validate.notNull((Object)location, (String)"Location cannot be null");
        Validate.notNull((Object)effect, (String)"Effect cannot be null");
        Validate.notNull((Object)location.getWorld(), (String)"World cannot be null");
        int packetData = effect.getId();
        du packet = new du(packetData, location.getBlockX(), location.getBlockY(), location.getBlockZ(), data, false);
        radius *= radius;
        for (Player player : this.getPlayers()) {
            int distance;
            if (((CraftPlayer)player).getHandle().a == null || !location.getWorld().equals(player.getWorld()) || (distance = (int)player.getLocation().distanceSquared(location)) > radius) continue;
            ((CraftPlayer)player).getHandle().a.b(packet);
        }
    }

    public <T extends Entity> T spawn(Location location, Class<T> clazz) throws IllegalArgumentException {
        return this.spawn(location, clazz, CreatureSpawnEvent.SpawnReason.CUSTOM);
    }

    public FallingBlock spawnFallingBlock(Location location, Material material, byte data) throws IllegalArgumentException {
        Validate.notNull((Object)location, (String)"Location cannot be null");
        Validate.notNull((Object)((Object)material), (String)"Material cannot be null");
        Validate.isTrue((boolean)material.isBlock(), (String)"Material must be a block");
        double x2 = (double)location.getBlockX() + 0.5;
        double y2 = (double)location.getBlockY() + 0.5;
        double z2 = (double)location.getBlockZ() + 0.5;
        pw entity = new pw(this.world, x2, y2, z2, material.getId(), data);
        entity.c = 1;
        this.world.addEntity(entity, CreatureSpawnEvent.SpawnReason.CUSTOM);
        return (FallingBlock)entity.getBukkitEntity();
    }

    public FallingBlock spawnFallingBlock(Location location, int blockId, byte blockData) throws IllegalArgumentException {
        return this.spawnFallingBlock(location, Material.getMaterial(blockId), blockData);
    }

    public <T extends Entity> T spawn(Location location, Class<T> clazz, CreatureSpawnEvent.SpawnReason reason) throws IllegalArgumentException {
        if (location == null || clazz == null) {
            throw new IllegalArgumentException("Location or entity class cannot be null");
        }
        lq entity = null;
        double x2 = location.getX();
        double y2 = location.getY();
        double z2 = location.getZ();
        float pitch = location.getPitch();
        float yaw = location.getYaw();
        if (Boat.class.isAssignableFrom(clazz)) {
            entity = new pv(this.world, x2, y2, z2);
        } else if (FallingBlock.class.isAssignableFrom(clazz)) {
            x2 = location.getBlockX();
            y2 = location.getBlockY();
            z2 = location.getBlockZ();
            int type = this.world.a((int)x2, (int)y2, (int)z2);
            int data = this.world.h((int)x2, (int)y2, (int)z2);
            entity = new pw(this.world, x2 + 0.5, y2 + 0.5, z2 + 0.5, type, data);
        } else if (Projectile.class.isAssignableFrom(clazz)) {
            if (Snowball.class.isAssignableFrom(clazz)) {
                entity = new rh(this.world, x2, y2, z2);
            } else if (Egg.class.isAssignableFrom(clazz)) {
                entity = new rj(this.world, x2, y2, z2);
            } else if (Arrow.class.isAssignableFrom(clazz)) {
                entity = new qz(this.world);
                entity.b(x2, y2, z2, 0.0f, 0.0f);
            } else if (ThrownExpBottle.class.isAssignableFrom(clazz)) {
                entity = new rl(this.world);
                entity.b(x2, y2, z2, 0.0f, 0.0f);
            } else if (Fireball.class.isAssignableFrom(clazz)) {
                entity = SmallFireball.class.isAssignableFrom(clazz) ? new rg(this.world) : (WitherSkull.class.isAssignableFrom(clazz) ? new rn(this.world) : new re(this.world));
                ((rb)entity).b(x2, y2, z2, yaw, pitch);
                Vector direction = location.getDirection().multiply(10);
                ((rb)entity).setDirection(direction.getX(), direction.getY(), direction.getZ());
            }
        } else if (Minecart.class.isAssignableFrom(clazz)) {
            entity = PoweredMinecart.class.isAssignableFrom(clazz) ? new py(this.world, x2, y2, z2, CraftMinecart.Type.PoweredMinecart.getId()) : (StorageMinecart.class.isAssignableFrom(clazz) ? new py(this.world, x2, y2, z2, CraftMinecart.Type.StorageMinecart.getId()) : new py(this.world, x2, y2, z2, CraftMinecart.Type.Minecart.getId()));
        } else if (EnderSignal.class.isAssignableFrom(clazz)) {
            entity = new ra(this.world, x2, y2, z2);
        } else if (EnderCrystal.class.isAssignableFrom(clazz)) {
            entity = new po(this.world);
            entity.b(x2, y2, z2, 0.0f, 0.0f);
        } else if (LivingEntity.class.isAssignableFrom(clazz)) {
            if (Chicken.class.isAssignableFrom(clazz)) {
                entity = new oy(this.world);
            } else if (Cow.class.isAssignableFrom(clazz)) {
                entity = MushroomCow.class.isAssignableFrom(clazz) ? new pb(this.world) : new oz(this.world);
            } else if (Golem.class.isAssignableFrom(clazz)) {
                if (Snowman.class.isAssignableFrom(clazz)) {
                    entity = new pg(this.world);
                } else if (IronGolem.class.isAssignableFrom(clazz)) {
                    entity = new pi(this.world);
                }
            } else if (Creeper.class.isAssignableFrom(clazz)) {
                entity = new qc(this.world);
            } else if (Ghast.class.isAssignableFrom(clazz)) {
                entity = new qg(this.world);
            } else if (Pig.class.isAssignableFrom(clazz)) {
                entity = new pd(this.world);
            } else if (!Player.class.isAssignableFrom(clazz)) {
                if (Sheep.class.isAssignableFrom(clazz)) {
                    entity = new pe(this.world);
                } else if (Skeleton.class.isAssignableFrom(clazz)) {
                    entity = new qn(this.world);
                } else if (Slime.class.isAssignableFrom(clazz)) {
                    entity = MagmaCube.class.isAssignableFrom(clazz) ? new qi(this.world) : new qo(this.world);
                } else if (Spider.class.isAssignableFrom(clazz)) {
                    entity = CaveSpider.class.isAssignableFrom(clazz) ? new qb(this.world) : new qp(this.world);
                } else if (Squid.class.isAssignableFrom(clazz)) {
                    entity = new ph(this.world);
                } else if (Tameable.class.isAssignableFrom(clazz)) {
                    if (Wolf.class.isAssignableFrom(clazz)) {
                        entity = new pk(this.world);
                    } else if (Ocelot.class.isAssignableFrom(clazz)) {
                        entity = new pc(this.world);
                    }
                } else if (PigZombie.class.isAssignableFrom(clazz)) {
                    entity = new qk(this.world);
                } else if (Zombie.class.isAssignableFrom(clazz)) {
                    entity = new qr(this.world);
                } else if (Giant.class.isAssignableFrom(clazz)) {
                    entity = new qh(this.world);
                } else if (Silverfish.class.isAssignableFrom(clazz)) {
                    entity = new qm(this.world);
                } else if (Enderman.class.isAssignableFrom(clazz)) {
                    entity = new qd(this.world);
                } else if (Blaze.class.isAssignableFrom(clazz)) {
                    entity = new qa(this.world);
                } else if (Villager.class.isAssignableFrom(clazz)) {
                    entity = new qu(this.world);
                } else if (Witch.class.isAssignableFrom(clazz)) {
                    entity = new qq(this.world);
                } else if (Wither.class.isAssignableFrom(clazz)) {
                    entity = new pr(this.world);
                } else if (ComplexLivingEntity.class.isAssignableFrom(clazz)) {
                    if (EnderDragon.class.isAssignableFrom(clazz)) {
                        entity = new pp(this.world);
                    }
                } else if (Ambient.class.isAssignableFrom(clazz) && Bat.class.isAssignableFrom(clazz)) {
                    entity = new ow(this.world);
                }
            }
            if (entity != null) {
                entity.a(x2, y2, z2, pitch, yaw);
            }
        } else if (Hanging.class.isAssignableFrom(clazz)) {
            int dir;
            Block block = this.getBlockAt(location);
            BlockFace face = BlockFace.SELF;
            if (block.getRelative(BlockFace.EAST).getTypeId() == 0) {
                face = BlockFace.EAST;
            } else if (block.getRelative(BlockFace.NORTH).getTypeId() == 0) {
                face = BlockFace.NORTH;
            } else if (block.getRelative(BlockFace.WEST).getTypeId() == 0) {
                face = BlockFace.WEST;
            } else if (block.getRelative(BlockFace.SOUTH).getTypeId() == 0) {
                face = BlockFace.SOUTH;
            }
            switch (face) {
                default: {
                    dir = 0;
                    break;
                }
                case WEST: {
                    dir = 1;
                    break;
                }
                case NORTH: {
                    dir = 2;
                    break;
                }
                case EAST: {
                    dir = 3;
                }
            }
            if (Painting.class.isAssignableFrom(clazz)) {
                entity = new mg(this.world, (int)x2, (int)y2, (int)z2, dir);
            } else if (ItemFrame.class.isAssignableFrom(clazz)) {
                entity = new mc(this.world, (int)x2, (int)y2, (int)z2, dir);
            }
            if (entity != null && !((mb)entity).c()) {
                entity = null;
            }
        } else if (TNTPrimed.class.isAssignableFrom(clazz)) {
            entity = new pz(this.world, x2, y2, z2);
        } else if (ExperienceOrb.class.isAssignableFrom(clazz)) {
            entity = new lz(this.world, x2, y2, z2, 0);
        } else if (Weather.class.isAssignableFrom(clazz)) {
            entity = new pu(this.world, x2, y2, z2);
        } else if (!LightningStrike.class.isAssignableFrom(clazz)) {
            if (Fish.class.isAssignableFrom(clazz)) {
                entity = new rd(this.world);
                entity.a(x2, y2, z2, pitch, yaw);
            } else if (Firework.class.isAssignableFrom(clazz)) {
                entity = new rc(this.world, x2, y2, z2, null);
            }
        }
        if (entity != null) {
            this.world.addEntity(entity, reason);
            return (T)entity.getBukkitEntity();
        }
        throw new IllegalArgumentException("Cannot spawn an entity for " + clazz.getName());
    }

    public ChunkSnapshot getEmptyChunkSnapshot(int x2, int z2, boolean includeBiome, boolean includeBiomeTempRain) {
        return CraftChunk.getEmptyChunkSnapshot(x2, z2, this, includeBiome, includeBiomeTempRain);
    }

    public void setSpawnFlags(boolean allowMonsters, boolean allowAnimals) {
        this.world.a(allowMonsters, allowAnimals);
    }

    public boolean getAllowAnimals() {
        return this.world.F;
    }

    public boolean getAllowMonsters() {
        return this.world.E;
    }

    public int getMaxHeight() {
        return this.world.O();
    }

    public int getSeaLevel() {
        return 64;
    }

    public boolean getKeepSpawnInMemory() {
        return this.world.keepSpawnInMemory;
    }

    public void setKeepSpawnInMemory(boolean keepLoaded) {
        this.world.keepSpawnInMemory = keepLoaded;
        s chunkcoordinates = this.world.H();
        int chunkCoordX = chunkcoordinates.a >> 4;
        int chunkCoordZ = chunkcoordinates.c >> 4;
        for (int x2 = -12; x2 <= 12; ++x2) {
            for (int z2 = -12; z2 <= 12; ++z2) {
                if (keepLoaded) {
                    this.loadChunk(chunkCoordX + x2, chunkCoordZ + z2);
                    continue;
                }
                if (!this.isChunkLoaded(chunkCoordX + x2, chunkCoordZ + z2)) continue;
                if (this.getHandle().e(chunkCoordX + x2, chunkCoordZ + z2) instanceof zy) {
                    this.unloadChunk(chunkCoordX + x2, chunkCoordZ + z2, false);
                    continue;
                }
                this.unloadChunk(chunkCoordX + x2, chunkCoordZ + z2);
            }
        }
    }

    public int hashCode() {
        return this.getUID().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CraftWorld other = (CraftWorld)obj;
        return this.getUID() == other.getUID();
    }

    public File getWorldFolder() {
        return ((ahv)this.world.J()).b();
    }

    public void explodeBlock(Block block, float yield) {
        if (block.getType().equals((Object)Material.AIR) || block.getType().equals((Object)Material.FIRE)) {
            return;
        }
        int blockId = block.getTypeId();
        int blockX = block.getX();
        int blockY = block.getY();
        int blockZ = block.getZ();
        amq.p[blockId].a((yc)this.world, blockX, blockY, blockZ, block.getData(), yield, 0);
        block.setType(Material.AIR);
        amq.p[blockId].k(this.world, blockX, blockY, blockZ);
    }

    public void sendPluginMessage(Plugin source, String channel, byte[] message) {
        StandardMessenger.validatePluginMessage((Messenger)this.server.getMessenger(), (Plugin)source, (String)channel, (byte[])message);
        for (Player player : this.getPlayers()) {
            player.sendPluginMessage(source, channel, message);
        }
    }

    public Set<String> getListeningPluginChannels() {
        HashSet<String> result = new HashSet<String>();
        for (Player player : this.getPlayers()) {
            result.addAll(player.getListeningPluginChannels());
        }
        return result;
    }

    public WorldType getWorldType() {
        return WorldType.getByName((String)this.world.K().u().a());
    }

    public boolean canGenerateStructures() {
        return this.world.K().s();
    }

    public long getTicksPerAnimalSpawns() {
        return this.world.ticksPerAnimalSpawns;
    }

    public void setTicksPerAnimalSpawns(int ticksPerAnimalSpawns) {
        this.world.ticksPerAnimalSpawns = ticksPerAnimalSpawns;
    }

    public long getTicksPerMonsterSpawns() {
        return this.world.ticksPerMonsterSpawns;
    }

    public void setTicksPerMonsterSpawns(int ticksPerMonsterSpawns) {
        this.world.ticksPerMonsterSpawns = ticksPerMonsterSpawns;
    }

    public void setMetadata(String metadataKey, MetadataValue newMetadataValue) {
        this.server.getWorldMetadata().setMetadata(this, metadataKey, newMetadataValue);
    }

    public List<MetadataValue> getMetadata(String metadataKey) {
        return this.server.getWorldMetadata().getMetadata(this, metadataKey);
    }

    public boolean hasMetadata(String metadataKey) {
        return this.server.getWorldMetadata().hasMetadata(this, metadataKey);
    }

    public void removeMetadata(String metadataKey, Plugin owningPlugin) {
        this.server.getWorldMetadata().removeMetadata(this, metadataKey, owningPlugin);
    }

    public int getMonsterSpawnLimit() {
        if (this.monsterSpawn < 0) {
            return this.server.getMonsterSpawnLimit();
        }
        return this.monsterSpawn;
    }

    public void setMonsterSpawnLimit(int limit) {
        this.monsterSpawn = limit;
    }

    public int getAnimalSpawnLimit() {
        if (this.animalSpawn < 0) {
            return this.server.getAnimalSpawnLimit();
        }
        return this.animalSpawn;
    }

    public void setAnimalSpawnLimit(int limit) {
        this.animalSpawn = limit;
    }

    public int getWaterAnimalSpawnLimit() {
        if (this.waterAnimalSpawn < 0) {
            return this.server.getWaterAnimalSpawnLimit();
        }
        return this.waterAnimalSpawn;
    }

    public void setWaterAnimalSpawnLimit(int limit) {
        this.waterAnimalSpawn = limit;
    }

    public int getAmbientSpawnLimit() {
        if (this.ambientSpawn < 0) {
            return this.server.getAmbientSpawnLimit();
        }
        return this.ambientSpawn;
    }

    public void setAmbientSpawnLimit(int limit) {
        this.ambientSpawn = limit;
    }

    public void playSound(Location loc, Sound sound, float volume, float pitch) {
        if (loc == null || sound == null) {
            return;
        }
        double x2 = loc.getX();
        double y2 = loc.getY();
        double z2 = loc.getZ();
        this.getHandle().a(x2, y2, z2, CraftSound.getSound(sound), volume, pitch);
    }

    public String getGameRuleValue(String rule) {
        return this.getHandle().L().a(rule);
    }

    public boolean setGameRuleValue(String rule, String value) {
        if (rule == null || value == null) {
            return false;
        }
        if (!this.isGameRule(rule)) {
            return false;
        }
        this.getHandle().L().b(rule, value);
        return true;
    }

    public String[] getGameRules() {
        return this.getHandle().L().b();
    }

    public boolean isGameRule(String rule) {
        return this.getHandle().L().e(rule);
    }

    public void processChunkGC() {
        ++this.chunkGCTickCount;
        if (this.chunkLoadCount >= this.server.chunkGCLoadThresh && this.server.chunkGCLoadThresh > 0) {
            this.chunkLoadCount = 0;
        } else if (this.chunkGCTickCount >= this.server.chunkGCPeriod && this.server.chunkGCPeriod > 0) {
            this.chunkGCTickCount = 0;
        } else {
            return;
        }
        im cps = this.world.b;
        for (zz chunk : cps.f.values()) {
            if (this.isChunkInUse(chunk.g, chunk.h) || cps.b.contains(chunk.g, chunk.h)) continue;
            cps.b(chunk.g, chunk.h);
        }
    }
}

