/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit;

import java.io.File;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.Server;
import org.bukkit.configuration.serialization.ConfigurationSerializable;
import org.bukkit.configuration.serialization.SerializableAs;
import org.bukkit.craftbukkit.CraftServer;
import org.bukkit.entity.Player;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;

@SerializableAs(value="Player")
public class CraftOfflinePlayer
implements OfflinePlayer,
ConfigurationSerializable {
    private final String name;
    private final CraftServer server;
    private final ahv storage;

    protected CraftOfflinePlayer(CraftServer server, String name) {
        this.server = server;
        this.name = name;
        this.storage = (ahv)server.console.worlds.get(0).J();
    }

    public boolean isOnline() {
        return this.getPlayer() != null;
    }

    public String getName() {
        return this.name;
    }

    public Server getServer() {
        return this.server;
    }

    public boolean isOp() {
        return this.server.getHandle().e(this.getName().toLowerCase());
    }

    public void setOp(boolean value) {
        if (value == this.isOp()) {
            return;
        }
        if (value) {
            this.server.getHandle().b(this.getName().toLowerCase());
        } else {
            this.server.getHandle().c(this.getName().toLowerCase());
        }
    }

    public boolean isBanned() {
        return this.server.getHandle().e().a(this.name.toLowerCase());
    }

    public void setBanned(boolean value) {
        if (value) {
            fm entry = new fm(this.name.toLowerCase());
            this.server.getHandle().e().a(entry);
        } else {
            this.server.getHandle().e().b(this.name.toLowerCase());
        }
        this.server.getHandle().e().f();
    }

    public boolean isWhitelisted() {
        return this.server.getHandle().h().contains(this.name.toLowerCase());
    }

    public void setWhitelisted(boolean value) {
        if (value) {
            this.server.getHandle().h(this.name.toLowerCase());
        } else {
            this.server.getHandle().i(this.name.toLowerCase());
        }
    }

    public Map<String, Object> serialize() {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        result.put("name", this.name);
        return result;
    }

    public static OfflinePlayer deserialize(Map<String, Object> args) {
        return Bukkit.getServer().getOfflinePlayer((String)args.get("name"));
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[name=" + this.name + "]";
    }

    public Player getPlayer() {
        for (Object obj : this.server.getHandle().b) {
            iq player = (iq)obj;
            if (!player.bR.equalsIgnoreCase(this.getName())) continue;
            return player.a != null ? player.a.getPlayerB() : null;
        }
        return null;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OfflinePlayer)) {
            return false;
        }
        OfflinePlayer other = (OfflinePlayer)obj;
        if (this.getName() == null || other.getName() == null) {
            return false;
        }
        return this.getName().equalsIgnoreCase(other.getName());
    }

    public int hashCode() {
        int hash = 5;
        hash = 97 * hash + (this.getName() != null ? this.getName().toLowerCase().hashCode() : 0);
        return hash;
    }

    private bq getData() {
        return this.storage.a(this.getName());
    }

    private bq getBukkitData() {
        bq result = this.getData();
        if (result != null) {
            if (!result.b("bukkit")) {
                result.a("bukkit", new bq());
            }
            result = result.l("bukkit");
        }
        return result;
    }

    private File getDataFile() {
        return new File(this.storage.getPlayerDir(), this.name + ".dat");
    }

    public long getFirstPlayed() {
        Player player = this.getPlayer();
        if (player != null) {
            return player.getFirstPlayed();
        }
        bq data = this.getBukkitData();
        if (data != null) {
            if (data.b("firstPlayed")) {
                return data.f("firstPlayed");
            }
            File file = this.getDataFile();
            return file.lastModified();
        }
        return 0L;
    }

    public long getLastPlayed() {
        Player player = this.getPlayer();
        if (player != null) {
            return player.getLastPlayed();
        }
        bq data = this.getBukkitData();
        if (data != null) {
            if (data.b("lastPlayed")) {
                return data.f("lastPlayed");
            }
            File file = this.getDataFile();
            return file.lastModified();
        }
        return 0L;
    }

    public boolean hasPlayedBefore() {
        return this.getData() != null;
    }

    public Location getBedSpawnLocation() {
        bq data = this.getData();
        if (data == null) {
            return null;
        }
        if (data.b("SpawnX") && data.b("SpawnY") && data.b("SpawnZ")) {
            String spawnWorld = data.i("SpawnWorld");
            if (spawnWorld.equals("")) {
                spawnWorld = this.server.getWorlds().get(0).getName();
            }
            return new Location(this.server.getWorld(spawnWorld), (double)data.e("SpawnX"), (double)data.e("SpawnY"), (double)data.e("SpawnZ"));
        }
        return null;
    }

    public void setMetadata(String metadataKey, MetadataValue metadataValue) {
        this.server.getPlayerMetadata().setMetadata(this, metadataKey, metadataValue);
    }

    public List<MetadataValue> getMetadata(String metadataKey) {
        return this.server.getPlayerMetadata().getMetadata(this, metadataKey);
    }

    public boolean hasMetadata(String metadataKey) {
        return this.server.getPlayerMetadata().hasMetadata(this, metadataKey);
    }

    public void removeMetadata(String metadataKey, Plugin plugin) {
        this.server.getPlayerMetadata().removeMetadata(this, metadataKey, plugin);
    }
}

