/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.event;

import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.Event;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.event.entity.living.LivingSpecialSpawnEvent;
import net.minecraftforge.event.entity.player.PlayerDestroyItemEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;

public class ForgeEventFactory {
    public static boolean doPlayerHarvestCheck(qx player, amq block, boolean success) {
        PlayerEvent.HarvestCheck event = new PlayerEvent.HarvestCheck(player, block, success);
        MinecraftForge.EVENT_BUS.post(event);
        return event.success;
    }

    public static float getBreakSpeed(qx player, amq block, int metadata, float original) {
        PlayerEvent.BreakSpeed event = new PlayerEvent.BreakSpeed(player, block, metadata, original);
        return MinecraftForge.EVENT_BUS.post(event) ? -1.0f : event.newSpeed;
    }

    public static PlayerInteractEvent onPlayerInteract(qx player, PlayerInteractEvent.Action action, int x2, int y2, int z2, int face) {
        PlayerInteractEvent event = new PlayerInteractEvent(player, action, x2, y2, z2, face);
        MinecraftForge.EVENT_BUS.post(event);
        return event;
    }

    public static void onPlayerDestroyItem(qx player, ur stack) {
        MinecraftForge.EVENT_BUS.post(new PlayerDestroyItemEvent(player, stack));
    }

    public static Event.Result canEntitySpawn(md entity, yc world, float x2, float y2, float z2) {
        LivingSpawnEvent.CheckSpawn event = new LivingSpawnEvent.CheckSpawn(entity, world, x2, y2, z2);
        MinecraftForge.EVENT_BUS.post(event);
        return event.getResult();
    }

    public static boolean doSpecialSpawn(md entity, yc world, float x2, float y2, float z2) {
        boolean result = MinecraftForge.EVENT_BUS.post(new LivingSpecialSpawnEvent(entity, world, x2, y2, z2));
        LivingSpawnEvent.SpecialSpawn nEvent = new LivingSpawnEvent.SpecialSpawn(entity, world, x2, y2, z2);
        if (result) {
            nEvent.setCanceled(true);
        }
        return MinecraftForge.EVENT_BUS.post(nEvent);
    }
}

