/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common;

import com.google.common.base.CharMatcher;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.relauncher.FMLInjectionData;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PushbackInputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraftforge.common.ConfigCategory;
import net.minecraftforge.common.Property;

public class Configuration {
    private static boolean[] configMarkers = new boolean[up.e.length];
    private static final int ITEM_SHIFT = 256;
    private static final int MAX_BLOCKS = 4096;
    public static final String CATEGORY_GENERAL = "general";
    public static final String CATEGORY_BLOCK = "block";
    public static final String CATEGORY_ITEM = "item";
    public static final String ALLOWED_CHARS = "._-";
    public static final String DEFAULT_ENCODING = "UTF-8";
    public static final String CATEGORY_SPLITTER = ".";
    public static final String NEW_LINE;
    private static final Pattern CONFIG_START;
    private static final Pattern CONFIG_END;
    public static final CharMatcher allowedProperties;
    private static Configuration PARENT;
    File file;
    public Map<String, ConfigCategory> categories = new TreeMap<String, ConfigCategory>();
    private Map<String, Configuration> children = new TreeMap<String, Configuration>();
    private boolean caseSensitiveCustomCategories;
    public String defaultEncoding = "UTF-8";
    private String fileName = null;
    public boolean isChild = false;

    public Configuration() {
    }

    public Configuration(File file) {
        this.file = file;
        String basePath = ((File)FMLInjectionData.data()[6]).getAbsolutePath().replace(File.separatorChar, '/').replace("/.", "");
        String path = file.getAbsolutePath().replace(File.separatorChar, '/').replace("/./", "/").replace(basePath, "");
        if (PARENT != null) {
            PARENT.setChild(path, this);
            this.isChild = true;
        } else {
            this.fileName = path;
            this.load();
        }
    }

    public Configuration(File file, boolean caseSensitiveCustomCategories) {
        this(file);
        this.caseSensitiveCustomCategories = caseSensitiveCustomCategories;
    }

    public Property getBlock(String key, int defaultID) {
        return this.getBlock(CATEGORY_BLOCK, key, defaultID, null);
    }

    public Property getBlock(String key, int defaultID, String comment) {
        return this.getBlock(CATEGORY_BLOCK, key, defaultID, comment);
    }

    public Property getBlock(String category, String key, int defaultID) {
        return this.getBlockInternal(category, key, defaultID, null, 256, amq.p.length);
    }

    public Property getBlock(String category, String key, int defaultID, String comment) {
        return this.getBlockInternal(category, key, defaultID, comment, 256, amq.p.length);
    }

    public Property getTerrainBlock(String category, String key, int defaultID, String comment) {
        return this.getBlockInternal(category, key, defaultID, comment, 0, 256);
    }

    private Property getBlockInternal(String category, String key, int defaultID, String comment, int lower, int upper) {
        Property prop = this.get(category, key, -1, comment);
        if (prop.getInt() != -1) {
            Configuration.configMarkers[prop.getInt()] = true;
            return prop;
        }
        if (defaultID < lower) {
            FMLLog.warning("Mod attempted to get a block ID with a default in the Terrain Generation section, mod authors should make sure there defaults are above 256 unless explicitly needed for terrain generation. Most ores do not need to be below 256.", new Object[0]);
            FMLLog.warning("Config \"%s\" Category: \"%s\" Key: \"%s\" Default: %d", this.fileName, category, key, defaultID);
            defaultID = upper - 1;
        }
        if (amq.p[defaultID] == null && !configMarkers[defaultID]) {
            prop.value = Integer.toString(defaultID);
            Configuration.configMarkers[defaultID] = true;
            return prop;
        }
        for (int j2 = upper - 1; j2 > 0; --j2) {
            if (amq.p[j2] != null || configMarkers[j2]) continue;
            prop.value = Integer.toString(j2);
            Configuration.configMarkers[j2] = true;
            return prop;
        }
        throw new RuntimeException("No more block ids available for " + key);
    }

    public Property getItem(String key, int defaultID) {
        return this.getItem(CATEGORY_ITEM, key, defaultID, null);
    }

    public Property getItem(String key, int defaultID, String comment) {
        return this.getItem(CATEGORY_ITEM, key, defaultID, comment);
    }

    public Property getItem(String category, String key, int defaultID) {
        return this.getItem(category, key, defaultID, null);
    }

    public Property getItem(String category, String key, int defaultID, String comment) {
        Property prop = this.get(category, key, -1, comment);
        int defaultShift = defaultID + 256;
        if (prop.getInt() != -1) {
            Configuration.configMarkers[prop.getInt() + 256] = true;
            return prop;
        }
        if (defaultID < 3840) {
            FMLLog.warning("Mod attempted to get a item ID with a default value in the block ID section, mod authors should make sure there defaults are above %d unless explicitly needed so that all block ids are free to store blocks.", 3840);
            FMLLog.warning("Config \"%s\" Category: \"%s\" Key: \"%s\" Default: %d", this.fileName, category, key, defaultID);
        }
        if (up.e[defaultShift] == null && !configMarkers[defaultShift] && defaultShift >= amq.p.length) {
            prop.value = Integer.toString(defaultID);
            Configuration.configMarkers[defaultShift] = true;
            return prop;
        }
        for (int x2 = up.e.length - 1; x2 >= 256; --x2) {
            if (up.e[x2] != null || configMarkers[x2]) continue;
            prop.value = Integer.toString(x2 - 256);
            Configuration.configMarkers[x2] = true;
            return prop;
        }
        throw new RuntimeException("No more item ids available for " + key);
    }

    public Property get(String category, String key, int defaultValue) {
        return this.get(category, key, defaultValue, (String)null);
    }

    public Property get(String category, String key, int defaultValue, String comment) {
        Property prop = this.get(category, key, Integer.toString(defaultValue), comment, Property.Type.INTEGER);
        if (!prop.isIntValue()) {
            prop.value = Integer.toString(defaultValue);
        }
        return prop;
    }

    public Property get(String category, String key, boolean defaultValue) {
        return this.get(category, key, defaultValue, null);
    }

    public Property get(String category, String key, boolean defaultValue, String comment) {
        Property prop = this.get(category, key, Boolean.toString(defaultValue), comment, Property.Type.BOOLEAN);
        if (!prop.isBooleanValue()) {
            prop.value = Boolean.toString(defaultValue);
        }
        return prop;
    }

    public Property get(String category, String key, double defaultValue) {
        return this.get(category, key, defaultValue, null);
    }

    public Property get(String category, String key, double defaultValue, String comment) {
        Property prop = this.get(category, key, Double.toString(defaultValue), comment, Property.Type.DOUBLE);
        if (!prop.isDoubleValue()) {
            prop.value = Double.toString(defaultValue);
        }
        return prop;
    }

    public Property get(String category, String key, String defaultValue) {
        return this.get(category, key, defaultValue, null);
    }

    public Property get(String category, String key, String defaultValue, String comment) {
        return this.get(category, key, defaultValue, comment, Property.Type.STRING);
    }

    public Property get(String category, String key, String[] defaultValue) {
        return this.get(category, key, defaultValue, null);
    }

    public Property get(String category, String key, String[] defaultValue, String comment) {
        return this.get(category, key, defaultValue, comment, Property.Type.STRING);
    }

    public Property get(String category, String key, int[] defaultValue) {
        return this.get(category, key, defaultValue, (String)null);
    }

    public Property get(String category, String key, int[] defaultValue, String comment) {
        String[] values = new String[defaultValue.length];
        for (int i2 = 0; i2 < defaultValue.length; ++i2) {
            values[i2] = Integer.toString(defaultValue[i2]);
        }
        Property prop = this.get(category, key, values, comment, Property.Type.INTEGER);
        if (!prop.isIntList()) {
            prop.valueList = values;
        }
        return prop;
    }

    public Property get(String category, String key, double[] defaultValue) {
        return this.get(category, key, defaultValue, null);
    }

    public Property get(String category, String key, double[] defaultValue, String comment) {
        String[] values = new String[defaultValue.length];
        for (int i2 = 0; i2 < defaultValue.length; ++i2) {
            values[i2] = Double.toString(defaultValue[i2]);
        }
        Property prop = this.get(category, key, values, comment, Property.Type.DOUBLE);
        if (!prop.isDoubleList()) {
            prop.valueList = values;
        }
        return prop;
    }

    public Property get(String category, String key, boolean[] defaultValue) {
        return this.get(category, key, defaultValue, null);
    }

    public Property get(String category, String key, boolean[] defaultValue, String comment) {
        String[] values = new String[defaultValue.length];
        for (int i2 = 0; i2 < defaultValue.length; ++i2) {
            values[i2] = Boolean.toString(defaultValue[i2]);
        }
        Property prop = this.get(category, key, values, comment, Property.Type.BOOLEAN);
        if (!prop.isBooleanList()) {
            prop.valueList = values;
        }
        return prop;
    }

    public Property get(String category, String key, String defaultValue, String comment, Property.Type type) {
        ConfigCategory cat;
        if (!this.caseSensitiveCustomCategories) {
            category = category.toLowerCase(Locale.ENGLISH);
        }
        if ((cat = this.getCategory(category)).containsKey(key)) {
            Property prop = cat.get(key);
            if (prop.getType() == null) {
                prop = new Property(prop.getName(), prop.value, type);
                cat.set(key, prop);
            }
            prop.comment = comment;
            return prop;
        }
        if (defaultValue != null) {
            Property prop = new Property(key, defaultValue, type);
            cat.set(key, prop);
            prop.comment = comment;
            return prop;
        }
        return null;
    }

    public Property get(String category, String key, String[] defaultValue, String comment, Property.Type type) {
        ConfigCategory cat;
        if (!this.caseSensitiveCustomCategories) {
            category = category.toLowerCase(Locale.ENGLISH);
        }
        if ((cat = this.getCategory(category)).containsKey(key)) {
            Property prop = cat.get(key);
            if (prop.getType() == null) {
                prop = new Property(prop.getName(), prop.value, type);
                cat.set(key, prop);
            }
            prop.comment = comment;
            return prop;
        }
        if (defaultValue != null) {
            Property prop = new Property(key, defaultValue, type);
            prop.comment = comment;
            cat.set(key, prop);
            return prop;
        }
        return null;
    }

    public boolean hasCategory(String category) {
        return this.categories.get(category) != null;
    }

    public boolean hasKey(String category, String key) {
        ConfigCategory cat = this.categories.get(category);
        return cat != null && cat.containsKey(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load() {
        block53: {
            if (PARENT != null && PARENT != this) {
                return;
            }
            BufferedReader buffer = null;
            UnicodeInputStreamReader input = null;
            try {
                if (this.file.getParentFile() != null) {
                    this.file.getParentFile().mkdirs();
                }
                if (!this.file.exists() && !this.file.createNewFile()) {
                    return;
                }
                if (!this.file.canRead()) break block53;
                input = new UnicodeInputStreamReader(new FileInputStream(this.file), this.defaultEncoding);
                this.defaultEncoding = input.getEncoding();
                buffer = new BufferedReader(input);
                ConfigCategory currentCat = null;
                Property.Type type = null;
                ArrayList<String> tmpList = null;
                int lineNum = 0;
                String name = null;
                while (true) {
                    ++lineNum;
                    String line = buffer.readLine();
                    if (line == null) {
                        break;
                    }
                    Matcher start = CONFIG_START.matcher(line);
                    Matcher end = CONFIG_END.matcher(line);
                    if (start.matches()) {
                        this.fileName = start.group(1);
                        this.categories = new TreeMap<String, ConfigCategory>();
                        continue;
                    }
                    if (end.matches()) {
                        this.fileName = end.group(1);
                        Configuration child = new Configuration();
                        child.categories = this.categories;
                        this.children.put(this.fileName, child);
                        continue;
                    }
                    int nameStart = -1;
                    int nameEnd = -1;
                    boolean skip = false;
                    boolean quoted = false;
                    block33: for (int i2 = 0; i2 < line.length() && !skip; ++i2) {
                        if (Character.isLetterOrDigit(line.charAt(i2)) || ALLOWED_CHARS.indexOf(line.charAt(i2)) != -1 || quoted && line.charAt(i2) != '\"') {
                            if (nameStart == -1) {
                                nameStart = i2;
                            }
                            nameEnd = i2;
                            continue;
                        }
                        if (Character.isWhitespace(line.charAt(i2))) continue;
                        switch (line.charAt(i2)) {
                            case '#': {
                                skip = true;
                                continue block33;
                            }
                            case '\"': {
                                if (quoted) {
                                    quoted = false;
                                }
                                if (quoted || nameStart != -1) continue block33;
                                quoted = true;
                                continue block33;
                            }
                            case '{': {
                                name = line.substring(nameStart, nameEnd + 1);
                                String qualifiedName = ConfigCategory.getQualifiedName(name, currentCat);
                                ConfigCategory cat = this.categories.get(qualifiedName);
                                if (cat == null) {
                                    currentCat = new ConfigCategory(name, currentCat);
                                    this.categories.put(qualifiedName, currentCat);
                                } else {
                                    currentCat = cat;
                                }
                                name = null;
                                continue block33;
                            }
                            case '}': {
                                if (currentCat == null) {
                                    throw new RuntimeException(String.format("Config file corrupt, attepted to close to many categories '%s:%d'", this.fileName, lineNum));
                                }
                                currentCat = currentCat.parent;
                                continue block33;
                            }
                            case '=': {
                                name = line.substring(nameStart, nameEnd + 1);
                                if (currentCat == null) {
                                    throw new RuntimeException(String.format("'%s' has no scope in '%s:%d'", name, this.fileName, lineNum));
                                }
                                Property prop = new Property(name, line.substring(i2 + 1), type, true);
                                i2 = line.length();
                                currentCat.set(name, prop);
                                continue block33;
                            }
                            case ':': {
                                type = Property.Type.tryParse(line.substring(nameStart, nameEnd + 1).charAt(0));
                                nameEnd = -1;
                                nameStart = -1;
                                continue block33;
                            }
                            case '<': {
                                if (tmpList != null) {
                                    throw new RuntimeException(String.format("Malformed list property \"%s:%d\"", this.fileName, lineNum));
                                }
                                name = line.substring(nameStart, nameEnd + 1);
                                if (currentCat == null) {
                                    throw new RuntimeException(String.format("'%s' has no scope in '%s:%d'", name, this.fileName, lineNum));
                                }
                                tmpList = new ArrayList<String>();
                                skip = true;
                                continue block33;
                            }
                            case '>': {
                                if (tmpList == null) {
                                    throw new RuntimeException(String.format("Malformed list property \"%s:%d\"", this.fileName, lineNum));
                                }
                                currentCat.set(name, new Property(name, tmpList.toArray(new String[tmpList.size()]), type));
                                name = null;
                                tmpList = null;
                                type = null;
                                continue block33;
                            }
                            default: {
                                throw new RuntimeException(String.format("Unknown character '%s' in '%s:%d'", Character.valueOf(line.charAt(i2)), this.fileName, lineNum));
                            }
                        }
                    }
                    if (quoted) {
                        throw new RuntimeException(String.format("Unmatched quote in '%s:%d'", this.fileName, lineNum));
                    }
                    if (tmpList == null || skip) continue;
                    tmpList.add(line.trim());
                }
            }
            catch (IOException e2) {
                e2.printStackTrace();
            }
            finally {
                if (buffer != null) {
                    try {
                        buffer.close();
                    }
                    catch (IOException e3) {}
                }
                if (input != null) {
                    try {
                        input.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    public void save() {
        if (PARENT != null && PARENT != this) {
            PARENT.save();
            return;
        }
        try {
            if (this.file.getParentFile() != null) {
                this.file.getParentFile().mkdirs();
            }
            if (!this.file.exists() && !this.file.createNewFile()) {
                return;
            }
            if (this.file.canWrite()) {
                FileOutputStream fos = new FileOutputStream(this.file);
                BufferedWriter buffer = new BufferedWriter(new OutputStreamWriter((OutputStream)fos, this.defaultEncoding));
                buffer.write("# Configuration file" + NEW_LINE + NEW_LINE);
                if (this.children.isEmpty()) {
                    this.save(buffer);
                } else {
                    for (Map.Entry<String, Configuration> entry : this.children.entrySet()) {
                        buffer.write("START: \"" + entry.getKey() + "\"" + NEW_LINE);
                        entry.getValue().save(buffer);
                        buffer.write("END: \"" + entry.getKey() + "\"" + NEW_LINE + NEW_LINE);
                    }
                }
                buffer.close();
                fos.close();
            }
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
    }

    private void save(BufferedWriter out) throws IOException {
        Object[] categoryArray;
        for (Object o2 : categoryArray = this.categories.values().toArray()) {
            if (!(o2 instanceof TreeMap)) continue;
            TreeMap treeMap = (TreeMap)o2;
            ConfigCategory converted = new ConfigCategory(this.file.getName());
            FMLLog.warning("Forge found a Treemap saved for Configuration file " + this.file.getName() + ", this is deprecated behaviour!", new Object[0]);
            for (Object key : treeMap.keySet()) {
                FMLLog.warning("Converting Treemap to ConfigCategory, key: " + key + ", property value: " + ((Property)treeMap.get(key)).value, new Object[0]);
                converted.set((String)key, (Property)treeMap.get(key));
            }
            this.categories.values().remove(o2);
            this.categories.put(this.file.getName(), converted);
        }
        for (ConfigCategory cat : this.categories.values()) {
            if (cat.isChild()) continue;
            cat.write(out, 0);
            out.newLine();
        }
    }

    public ConfigCategory getCategory(String category) {
        ConfigCategory ret = this.categories.get(category);
        if (ret == null) {
            if (category.contains(CATEGORY_SPLITTER)) {
                String[] hierarchy = category.split("\\.");
                ConfigCategory parent = this.categories.get(hierarchy[0]);
                if (parent == null) {
                    parent = new ConfigCategory(hierarchy[0]);
                    this.categories.put(parent.getQualifiedName(), parent);
                }
                for (int i2 = 1; i2 < hierarchy.length; ++i2) {
                    String name = ConfigCategory.getQualifiedName(hierarchy[i2], parent);
                    ConfigCategory child = this.categories.get(name);
                    if (child == null) {
                        child = new ConfigCategory(hierarchy[i2], parent);
                        this.categories.put(name, child);
                    }
                    ret = child;
                    parent = child;
                }
            } else {
                ret = new ConfigCategory(category);
                this.categories.put(category, ret);
            }
        }
        return ret;
    }

    public void addCustomCategoryComment(String category, String comment) {
        if (!this.caseSensitiveCustomCategories) {
            category = category.toLowerCase(Locale.ENGLISH);
        }
        this.getCategory(category).setComment(comment);
    }

    private void setChild(String name, Configuration child) {
        if (!this.children.containsKey(name)) {
            this.children.put(name, child);
        } else {
            Configuration old = this.children.get(name);
            child.categories = old.categories;
            child.fileName = old.fileName;
        }
    }

    public static void enableGlobalConfig() {
        PARENT = new Configuration(new File(Loader.instance().getConfigDir(), "global.cfg"));
        PARENT.load();
    }

    static {
        CONFIG_START = Pattern.compile("START: \"([^\\\"]+)\"");
        CONFIG_END = Pattern.compile("END: \"([^\\\"]+)\"");
        allowedProperties = CharMatcher.JAVA_LETTER_OR_DIGIT.or(CharMatcher.anyOf((CharSequence)ALLOWED_CHARS));
        PARENT = null;
        Arrays.fill(configMarkers, false);
        NEW_LINE = System.getProperty("line.separator");
    }

    public static class UnicodeInputStreamReader
    extends Reader {
        private final InputStreamReader input;
        private final String defaultEnc;

        public UnicodeInputStreamReader(InputStream source, String encoding) throws IOException {
            this.defaultEnc = encoding;
            String enc = encoding;
            byte[] data = new byte[4];
            PushbackInputStream pbStream = new PushbackInputStream(source, data.length);
            int read = pbStream.read(data, 0, data.length);
            int size = 0;
            int bom16 = (data[0] & 0xFF) << 8 | data[1] & 0xFF;
            int bom24 = bom16 << 8 | data[2] & 0xFF;
            int bom32 = bom24 << 8 | data[3] & 0xFF;
            if (bom24 == 0xEFBBBF) {
                enc = Configuration.DEFAULT_ENCODING;
                size = 3;
            } else if (bom16 == 65279) {
                enc = "UTF-16BE";
                size = 2;
            } else if (bom16 == 65534) {
                enc = "UTF-16LE";
                size = 2;
            } else if (bom32 == 65279) {
                enc = "UTF-32BE";
                size = 4;
            } else if (bom32 == -131072) {
                enc = "UTF-32LE";
                size = 4;
            }
            if (size < read) {
                pbStream.unread(data, size, read - size);
            }
            this.input = new InputStreamReader((InputStream)pbStream, enc);
        }

        public String getEncoding() {
            return this.input.getEncoding();
        }

        @Override
        public int read(char[] cbuf, int off, int len) throws IOException {
            return this.input.read(cbuf, off, len);
        }

        @Override
        public void close() throws IOException {
            this.input.close();
        }
    }
}

