/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import com.google.common.io.Files;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.ArgsWrapper;
import cpw.mods.fml.relauncher.FMLLogFormatter;
import cpw.mods.fml.relauncher.FMLRelauncher;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.awt.GraphicsEnvironment;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.OutputStream;
import java.net.UnknownHostException;
import java.security.KeyPair;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import jline.console.ConsoleReader;
import joptsimple.OptionSet;
import net.minecraft.server.FMLLogJLineBreakProxy;
import net.minecraftforge.common.Configuration;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.WorldEvent;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.command.RemoteConsoleCommandSender;
import org.bukkit.craftbukkit.CraftServer;
import org.bukkit.craftbukkit.Main;
import org.bukkit.craftbukkit.chunkio.ChunkIOExecutor;
import org.bukkit.craftbukkit.util.ExceptionHandler;
import org.bukkit.craftbukkit.util.ServerShutdownThread;
import org.bukkit.craftbukkit.util.Waitable;
import org.bukkit.craftbukkit.util.WatchdogThread;
import org.bukkit.event.Event;
import org.bukkit.event.server.RemoteServerCommandEvent;
import org.bukkit.event.world.WorldInitEvent;
import org.bukkit.event.world.WorldSaveEvent;
import org.bukkit.generator.ChunkGenerator;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginLoadOrder;

public abstract class MinecraftServer
implements aa,
Runnable,
lg {
    public static Logger a = Logger.getLogger("Minecraft");
    private static MinecraftServer l = null;
    public aij m;
    private final le n = new le("server", this);
    public File o;
    private final List p = new ArrayList();
    private final z q;
    public final kh b = new kh();
    private String r;
    private int s = -1;
    public in[] c;
    private gm t;
    private boolean u = true;
    private boolean v = false;
    private int w = 0;
    public String d;
    public int e;
    private boolean x;
    private boolean y;
    private boolean z;
    private boolean A;
    private boolean B;
    private String C;
    private int D;
    private long E;
    private long F;
    private long G;
    private long H;
    public final long[] f = new long[100];
    public final long[] g = new long[100];
    public final long[] h = new long[100];
    public final long[] i = new long[100];
    public final long[] j = new long[100];
    public Hashtable<Integer, long[]> worldTickTimes = new Hashtable();
    private KeyPair I;
    private String J;
    private String K;
    @SideOnly(value=Side.CLIENT)
    private String L;
    private boolean M;
    private boolean N;
    private boolean O;
    private String P = "";
    private boolean Q = false;
    private long R;
    private String S;
    private boolean T;
    public List<in> worlds = new ArrayList<in>();
    public CraftServer server;
    public OptionSet options;
    public ConsoleCommandSender console;
    public RemoteConsoleCommandSender remoteConsole;
    public ConsoleReader reader;
    public static int currentTick;
    public final Thread primaryThread;
    public Queue<Runnable> processQueue = new ConcurrentLinkedQueue<Runnable>();
    public int autosavePeriod;
    private static final int TPS = 20;
    private static final int TICK_TIME = 50000000;
    public static double currentTPS;

    public MinecraftServer(File par1File) {
        l = this;
        this.o = par1File;
        this.q = new hi();
        this.m = new ahs(par1File);
        this.al();
        this.primaryThread = null;
    }

    public MinecraftServer(OptionSet options) {
        l = this;
        this.q = new hi();
        this.al();
        this.options = options;
        try {
            this.reader = new ConsoleReader(System.in, (OutputStream)System.out);
            this.reader.setExpandEvents(false);
        }
        catch (Exception e2) {
            try {
                System.setProperty("jline.terminal", "jline.UnsupportedTerminal");
                System.setProperty("user.language", "en");
                Main.useJline = false;
                this.reader = new ConsoleReader(System.in, (OutputStream)System.out);
                this.reader.setExpandEvents(false);
            }
            catch (IOException ex2) {
                Logger.getLogger(MinecraftServer.class.getName()).log(Level.SEVERE, null, ex2);
            }
        }
        if (Main.useJline) {
            FMLLogJLineBreakProxy.reader = this.reader;
        }
        Runtime.getRuntime().addShutdownHook(new ServerShutdownThread(this));
        this.primaryThread = new fy(this, "Server thread");
    }

    public abstract go getPropertyManager();

    private void al() {
        ajw.a.a(up.l, new fs(this));
        ajw.a.a(up.aP, new gc(this));
        ajw.a.a(up.aD, new gd(this));
        ajw.a.a(up.bD, new ge(this));
        ajw.a.a(up.bs, new gf(this));
        ajw.a.a(up.bC, new gh(this));
        ajw.a.a(up.bU, new gi(this));
        ajw.a.a(up.bE, new gj(this));
        gk behaviordispenseminecart = new gk(this);
        ajw.a.a(up.az, behaviordispenseminecart);
        ajw.a.a(up.aN, behaviordispenseminecart);
        ajw.a.a(up.aO, behaviordispenseminecart);
        ajw.a.a(up.aE, new ft(this));
        fu behaviorbucketfulldispense = new fu(this);
        ajw.a.a(up.ay, behaviorbucketfulldispense);
        ajw.a.a(up.ax, behaviorbucketfulldispense);
        ajw.a.a(up.aw, new fv(this));
    }

    protected abstract boolean c() throws UnknownHostException;

    protected void b(String par1Str) {
        if (this.N().b(par1Str)) {
            a.info("Converting map!");
            this.c("menu.convertingLevel");
            this.N().a(par1Str, new fw(this));
        }
    }

    protected synchronized void c(String par1Str) {
        this.S = par1Str;
    }

    @SideOnly(value=Side.CLIENT)
    public synchronized String d() {
        return this.S;
    }

    protected void a(String par1Str, String par2Str, long par3, yn par5WorldType, String par6Str) {
        hi vanillaCommandManager = (hi)this.E();
        vanillaCommandManager.registerVanillaCommands();
        this.b(par1Str);
        this.c("menu.loadingLevel");
        aih isavehandler = this.m.a(par1Str, true);
        ahx worldinfo = isavehandler.d();
        yk worldsettings = new yk(par3, this.g(), this.f(), this.i(), par5WorldType);
        worldsettings.a(par6Str);
        in overWorld = this.initOverWorld(par1Str, par2Str, worldsettings);
        Integer[] arr$ = DimensionManager.getStaticDimensionIDs();
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            int dimension = arr$[i$];
            String worldType = "";
            String name = "";
            World.Environment env = World.Environment.getEnvironment((int)dimension);
            if (dimension >= -1 && dimension <= 1) {
                if (dimension == 0 || dimension == -1 && !this.s() || dimension == 1 && !this.server.getAllowEnd()) continue;
                worldType = env.toString().toLowerCase();
                name = par1Str + "_" + worldType;
            } else {
                aaq provider = aaq.a(dimension);
                worldType = provider.getClass().getSimpleName();
                env = DimensionManager.registerBukkitEnvironment(provider.h, provider.getClass().getSimpleName());
                if (worldType.contains("WorldProvider")) {
                    worldType = worldType.replace("WorldProvider", "");
                }
                name = "world_" + worldType.toLowerCase();
            }
            ChunkGenerator gen = this.server.getGenerator(name);
            worldsettings = new yk(par3, this.g(), this.f(), this.i(), par5WorldType);
            worldsettings.a(par6Str);
            String dim = "DIM" + dimension;
            File newWorld = new File(new File(name), dim);
            File oldWorld = new File(new File(par1Str), dim);
            if (!newWorld.isDirectory() && oldWorld.isDirectory()) {
                a.info("---- Migration of old " + worldType + " folder required ----");
                a.info("Unfortunately due to the way that Minecraft implemented multiworld support in 1.6, Bukkit requires that you move your " + worldType + " folder to a new location in order to operate correctly.");
                a.info("We will move this folder for you, but it will mean that you need to move it back should you wish to stop using Bukkit in the future.");
                a.info("Attempting to move " + oldWorld + " to " + newWorld + "...");
                if (newWorld.exists()) {
                    a.severe("A file or folder already exists at " + newWorld + "!");
                    a.info("---- Migration of old " + worldType + " folder failed ----");
                } else if (newWorld.getParentFile().mkdirs()) {
                    if (oldWorld.renameTo(newWorld)) {
                        a.info("Success! To restore " + worldType + " in the future, simply move " + newWorld + " to " + oldWorld);
                        try {
                            Files.copy((File)new File(new File(par1Str), "level.dat"), (File)new File(new File(name), "level.dat"));
                        }
                        catch (IOException exception) {
                            a.severe("Unable to migrate world data.");
                        }
                        a.info("---- Migration of old " + worldType + " folder complete ----");
                    } else {
                        a.severe("Could not move folder " + oldWorld + " to " + newWorld + "!");
                        a.info("---- Migration of old " + worldType + " folder failed ----");
                    }
                } else {
                    a.severe("Could not create path for " + newWorld + "!");
                    a.info("---- Migration of old " + worldType + " folder failed ----");
                }
            }
            this.c(name);
            ih world = new ih(this, new ahr(this.server.getWorldContainer(), name, true), name, dimension, worldsettings, overWorld, this.b, env, gen);
            if (gen != null) {
                world.getWorld().getPopulators().addAll(gen.getDefaultPopulators((World)world.getWorld()));
            }
            this.server.getPluginManager().callEvent((Event)new WorldInitEvent((World)world.getWorld()));
            world.a(new ij(this, world));
            if (!this.I()) {
                world.K().a(this.g());
            }
            this.worlds.add(world);
            this.t.a(this.worlds.toArray(new in[this.worlds.size()]));
            MinecraftForge.EVENT_BUS.post(new WorldEvent.Load(world));
        }
        boolean mystLoaded = this.initMystWorld();
        if (mystLoaded) {
            System.out.println("Successfully initialized Mystcraft support.");
        }
        this.c(this.h());
        this.e();
    }

    protected in initOverWorld(String par1Str, String par2Str, yk worldsettings) {
        in overWorld;
        ChunkGenerator gen = this.server.getGenerator(par1Str);
        in in2 = overWorld = this.M() ? new if(this, new ahr(this.server.getWorldContainer(), par2Str, true), par2Str, 0, this.b) : new in(this, new ahr(this.server.getWorldContainer(), par2Str, true), par2Str, 0, worldsettings, this.b, World.Environment.getEnvironment((int)0), gen);
        if (gen != null) {
            overWorld.getWorld().getPopulators().addAll(gen.getDefaultPopulators((World)overWorld.getWorld()));
        }
        this.server.getPluginManager().callEvent((Event)new WorldInitEvent((World)overWorld.getWorld()));
        overWorld.a(new ij(this, overWorld));
        if (!this.I()) {
            overWorld.K().a(this.g());
        }
        this.worlds.add(overWorld);
        this.t.a(this.worlds.toArray(new in[this.worlds.size()]));
        MinecraftForge.EVENT_BUS.post(new WorldEvent.Load(overWorld));
        return overWorld;
    }

    protected boolean initMystWorld() {
        File file;
        String[] directories;
        File mystconfig = new File("./config/mystcraft_config.txt");
        boolean initMyst = false;
        boolean mystLoaded = false;
        int mystProviderType = -999;
        if (mystconfig.exists()) {
            Configuration config = new Configuration(mystconfig);
            config.load();
            mystProviderType = config.get("general", "options.providerId", -999).getInt();
            System.out.println("MinecraftServer mystProvider = " + mystProviderType);
            initMyst = true;
        }
        if (initMyst && (directories = (file = new File("world_myst")).list(new FilenameFilter(){

            @Override
            public boolean accept(File current, String name) {
                return new File(current, name).isDirectory();
            }
        })) != null) {
            for (int i2 = 0; i2 < directories.length; ++i2) {
                String dim = "0";
                if (directories[i2].contains("age")) {
                    dim = directories[i2].replace("age", "");
                }
                if (Integer.parseInt(dim) == 0) continue;
                yk worldsettings = new yk(DimensionManager.getWorld(0).K());
                DimensionManager.registerDimension(Integer.parseInt(dim), mystProviderType);
                in mystWorld = DimensionManager.initMystWorld("world_myst", worldsettings, Integer.parseInt(dim));
                mystLoaded = true;
            }
        }
        return mystLoaded;
    }

    protected void e() {
        int short1 = 196;
        long i2 = System.currentTimeMillis();
        this.c("menu.generatingTerrain");
        boolean b0 = false;
        for (int j2 = 0; j2 < this.worlds.size(); ++j2) {
            in worldserver = this.worlds.get(j2);
            a.info("Preparing start region for level " + j2 + " (Dimension: " + worldserver.u.h + ", Seed: " + worldserver.E() + ")");
            if (!worldserver.getWorld().getKeepSpawnInMemory()) continue;
            s chunkcoordinates = worldserver.H();
            for (int k2 = -short1; k2 <= short1 && this.m(); k2 += 16) {
                for (int l2 = -short1; l2 <= short1 && this.m(); l2 += 16) {
                    long i1 = System.currentTimeMillis();
                    if (i1 < i2) {
                        i2 = i1;
                    }
                    if (i1 > i2 + 1000L) {
                        int j1 = (short1 * 2 + 1) * (short1 * 2 + 1);
                        int k1 = (k2 + short1) * (short1 * 2 + 1) + l2 + 1;
                        this.a_("Preparing spawn area", k1 * 100 / j1);
                        i2 = i1;
                    }
                    worldserver.b.c(chunkcoordinates.a + j2 >> 4, chunkcoordinates.c + k2 >> 4);
                }
            }
        }
        this.j();
    }

    public abstract boolean f();

    public abstract yl g();

    public abstract int h();

    public abstract boolean i();

    protected void a_(String par1Str, int par2) {
        this.d = par1Str;
        this.e = par2;
        a.info(par1Str + ": " + par2 + "%");
    }

    protected void j() {
        this.d = null;
        this.e = 0;
        this.server.enablePlugins(PluginLoadOrder.POSTWORLD);
    }

    protected void a(boolean par1) throws yh {
        if (!this.O) {
            for (int j2 = 0; j2 < this.worlds.size(); ++j2) {
                in worldserver = this.worlds.get(j2);
                if (worldserver == null) continue;
                if (!par1) {
                    a.info("Saving chunks for level '" + worldserver.K().k() + "'/" + worldserver.u.l());
                }
                worldserver.a(true, (kj)null);
                worldserver.m();
                WorldSaveEvent event = new WorldSaveEvent((World)worldserver.getWorld());
                this.server.getPluginManager().callEvent((Event)event);
            }
        }
    }

    public void k() {
        if (!this.O) {
            a.info("Stopping server");
            if (this.server != null) {
                this.server.disablePlugins();
            }
            if (this.ae() != null) {
                this.ae().a();
            }
            if (this.t != null) {
                a.info("Saving players");
                this.t.g();
                this.t.r();
            }
            a.info("Saving worlds");
            try {
                this.a(false);
            }
            catch (yh e2) {
                e2.printStackTrace();
            }
            for (int i2 = 0; i2 < this.worlds.size(); ++i2) {
                in worldserver = this.worlds.get(i2);
                MinecraftForge.EVENT_BUS.post(new WorldEvent.Unload(worldserver));
            }
            List<in> tmp = this.worlds;
            for (in world : tmp) {
                DimensionManager.setWorld(world.dimension, null);
            }
            if (this.n != null && this.n.d()) {
                this.n.e();
            }
        }
    }

    public String l() {
        return this.r;
    }

    public void d(String par1Str) {
        this.r = par1Str;
    }

    public boolean m() {
        return this.u;
    }

    public void n() {
        this.u = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        long lastTick;
        try {
            if (!this.c()) {
                this.a((a)null);
                return;
            }
            FMLCommonHandler.instance().handleServerStarted();
            FMLCommonHandler.instance().onWorldLoadTick(this.worlds.toArray(new in[this.worlds.size()]));
            lastTick = 0L;
        }
        catch (Throwable throwable) {
            if (FMLCommonHandler.instance().shouldServerBeKilledQuietly()) {
                return;
            }
            throwable.printStackTrace();
            a.log(Level.SEVERE, "Encountered an unexpected exception " + throwable.getClass().getSimpleName(), throwable);
            a crashreport = null;
            crashreport = throwable instanceof t ? this.b(((t)throwable).a()) : this.b(new a("Exception in server tick loop", throwable));
            File file1 = new File(new File(this.o(), "crash-reports"), "crash-" + new SimpleDateFormat("yyyy-MM-dd_HH.mm.ss").format(new Date()) + "-server.txt");
            if (crashreport.a(file1)) {
                a.severe("This crash report has been saved to: " + file1.getAbsolutePath());
            } else {
                a.severe("We were unable to save this crash report to disk.");
            }
            this.a(crashreport);
            return;
        }
        finally {
            WatchdogThread.stopping();
            try {
                if (FMLCommonHandler.instance().shouldServerBeKilledQuietly()) {
                    return;
                }
                this.k();
                this.v = true;
            }
            catch (Throwable throwable1) {
                throwable1.printStackTrace();
            }
            finally {
                try {
                    this.reader.getTerminal().restore();
                }
                catch (Exception e2) {}
                this.p();
            }
        }
        while (true) {
            if (!this.u) {
                FMLCommonHandler.instance().handleServerStopping();
                return;
            }
            long curTime = System.nanoTime();
            long wait = 50000000L - (curTime - lastTick);
            if (wait > 0L) {
                Thread.sleep(wait / 1000000L);
            } else {
                currentTPS = currentTPS * 0.95 + 1.0E9 / (double)(curTime - lastTick) * 0.05;
                lastTick = curTime;
                ++currentTick;
                this.q();
            }
            this.Q = true;
        }
    }

    protected File o() {
        return new File(".");
    }

    protected void a(a par1CrashReport) {
    }

    protected void p() {
    }

    protected void q() throws yh {
        FMLCommonHandler.instance().rescheduleTicks(Side.SERVER);
        long i2 = System.nanoTime();
        aoe.a().a();
        FMLCommonHandler.instance().onPreServerTick();
        ++this.w;
        if (this.T) {
            this.T = false;
            this.b.a = true;
            this.b.a();
        }
        this.b.a("root");
        this.r();
        if (this.autosavePeriod > 0 && this.w % this.autosavePeriod == 0) {
            this.b.a("save");
            this.t.g();
            this.a(true);
            this.b.b();
        }
        this.b.a("tallying");
        this.j[this.w % 100] = System.nanoTime() - i2;
        this.f[this.w % 100] = ef.p - this.E;
        this.E = ef.p;
        this.g[this.w % 100] = ef.q - this.F;
        this.F = ef.q;
        this.h[this.w % 100] = ef.n - this.G;
        this.G = ef.n;
        this.i[this.w % 100] = ef.o - this.H;
        this.H = ef.o;
        this.b.b();
        this.b.a("snooper");
        if (!this.n.d() && this.w > 100) {
            this.n.a();
        }
        if (this.w % 6000 == 0) {
            this.n.b();
        }
        this.b.b();
        this.b.b();
        FMLCommonHandler.instance().onPostServerTick();
    }

    public void r() {
        int i2;
        this.b.a("levels");
        this.server.getScheduler().mainThreadHeartbeat(this.w);
        while (!this.processQueue.isEmpty()) {
            this.processQueue.remove().run();
        }
        ChunkIOExecutor.tick();
        if (this.w % 20 == 0) {
            for (i2 = 0; i2 < this.ad().b.size(); ++i2) {
                iq entityplayer = (iq)this.ad().b.get(i2);
                entityplayer.a.b(new fa(entityplayer.p.F(), entityplayer.getPlayerTime()));
            }
        }
        Integer[] ids = DimensionManager.getIDs(this.w % 200 == 0);
        for (int x2 = 0; x2 < ids.length; ++x2) {
            int id2 = ids[x2];
            long j2 = System.nanoTime();
            in worldserver = DimensionManager.getWorld(id2);
            this.b.a(worldserver.K().k());
            this.b.a("pools");
            worldserver.S().a();
            this.b.b();
            this.b.a("tick");
            FMLCommonHandler.instance().onPreWorldTick(worldserver);
            try {
                worldserver.b();
            }
            catch (Throwable throwable) {
                a crashreport = a.a(throwable, "Exception ticking world");
                worldserver.a(crashreport);
                throw new t(crashreport);
            }
            try {
                worldserver.h();
            }
            catch (Throwable throwable1) {
                a crashreport = a.a(throwable1, "Exception ticking world entities");
                worldserver.a(crashreport);
                throw new t(crashreport);
            }
            FMLCommonHandler.instance().onPostWorldTick(worldserver);
            this.b.b();
            this.b.a("tracker");
            worldserver.p().a();
            this.b.b();
            this.b.b();
        }
        this.b.c("dim_unloading");
        this.b.c("connection");
        this.ae().b();
        this.b.c("players");
        this.t.b();
        this.b.c("tickables");
        for (i2 = 0; i2 < this.p.size(); ++i2) {
            ((gp)this.p.get(i2)).a();
        }
        this.b.b();
        WatchdogThread.tick();
    }

    public boolean s() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void t() {
        new fy(this, "Server thread").start();
    }

    public File e(String par1Str) {
        return new File(this.o(), par1Str);
    }

    public void f(String par1Str) {
        a.info(par1Str);
    }

    public void g(String par1Str) {
        a.warning(par1Str);
    }

    public in a(int par1) {
        if (par1 == -1 && !this.s() || par1 == 1 && !this.server.getAllowEnd()) {
            return DimensionManager.getWorld(0);
        }
        in ret = DimensionManager.getWorld(par1);
        if (ret == null) {
            DimensionManager.initDimension(par1);
            ret = DimensionManager.getWorld(par1);
        }
        return ret;
    }

    @SideOnly(value=Side.SERVER)
    public void a(gp par1IUpdatePlayerListBox) {
        this.p.add(par1IUpdatePlayerListBox);
    }

    public String u() {
        return this.r;
    }

    public int v() {
        return this.s;
    }

    public String w() {
        return this.C;
    }

    public String x() {
        return "1.4.7";
    }

    public int y() {
        return this.t.k();
    }

    public int z() {
        return this.t.l();
    }

    public String[] A() {
        return this.t.d();
    }

    public String B() {
        StringBuilder result = new StringBuilder();
        Plugin[] plugins = this.server.getPluginManager().getPlugins();
        result.append(this.server.getName());
        result.append(" on Bukkit ");
        result.append(this.server.getBukkitVersion());
        if (plugins.length > 0 && this.server.getQueryPlugins()) {
            result.append(": ");
            for (int i2 = 0; i2 < plugins.length; ++i2) {
                if (i2 > 0) {
                    result.append("; ");
                }
                result.append(plugins[i2].getDescription().getName());
                result.append(" ");
                result.append(plugins[i2].getDescription().getVersion().replaceAll(";", ","));
            }
        }
        return result.toString();
    }

    public String h(final String par1Str) {
        Waitable<String> waitable = new Waitable<String>(){

            @Override
            protected String evaluate() {
                iz.a.c();
                RemoteServerCommandEvent event = new RemoteServerCommandEvent((CommandSender)MinecraftServer.this.remoteConsole, par1Str);
                MinecraftServer.this.server.getPluginManager().callEvent((Event)event);
                fo servercommand = new fo(event.getCommand(), iz.a);
                MinecraftServer.this.server.dispatchServerCommand((CommandSender)MinecraftServer.this.remoteConsole, servercommand);
                return iz.a.d();
            }
        };
        this.processQueue.add(waitable);
        try {
            return (String)waitable.get();
        }
        catch (ExecutionException e2) {
            throw new RuntimeException("Exception processing rcon command " + par1Str, e2.getCause());
        }
        catch (InterruptedException e3) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Interrupted processing rcon command " + par1Str, e3);
        }
    }

    public boolean C() {
        return this.getPropertyManager().a("debug", false);
    }

    public void i(String par1Str) {
        a.log(Level.SEVERE, par1Str);
    }

    public void j(String par1Str) {
        if (this.C()) {
            a.log(Level.INFO, par1Str);
        }
    }

    public String getServerModName() {
        return "mcpc,craftbukkit,forge,fml";
    }

    public a b(a par1CrashReport) {
        par1CrashReport.g().a("Profiler Position", new fz(this));
        if (this.worlds != null && this.worlds.size() > 0 && this.worlds.get(0) != null) {
            par1CrashReport.g().a("Vec3 Pool Size", new ga(this));
        }
        if (this.t != null) {
            par1CrashReport.g().a("Player Count", new gb(this));
        }
        return par1CrashReport;
    }

    public List a(aa par1ICommandSender, String par2Str) {
        return this.server.tabComplete(par1ICommandSender, par2Str);
    }

    public static MinecraftServer D() {
        return l;
    }

    @Override
    public String c_() {
        return "Server";
    }

    @Override
    public void a(String par1Str) {
        a.info(km.a(par1Str));
    }

    @Override
    public boolean a(int par1, String par2Str) {
        return true;
    }

    @Override
    public String a(String par1Str, Object ... par2ArrayOfObj) {
        return bn.a().a(par1Str, par2ArrayOfObj);
    }

    public z E() {
        return this.q;
    }

    public KeyPair F() {
        return this.I;
    }

    public int G() {
        return this.s;
    }

    public void b(int par1) {
        this.s = par1;
    }

    public String H() {
        return this.J;
    }

    public void k(String par1Str) {
        this.J = par1Str;
    }

    public boolean I() {
        return this.J != null;
    }

    public String J() {
        return this.K;
    }

    public void l(String par1Str) {
        this.K = par1Str;
    }

    @SideOnly(value=Side.CLIENT)
    public void m(String par1Str) {
        this.L = par1Str;
    }

    @SideOnly(value=Side.CLIENT)
    public String K() {
        return this.L;
    }

    public void a(KeyPair par1KeyPair) {
        this.I = par1KeyPair;
    }

    public void c(int par1) {
        for (int j2 = 0; j2 < this.worlds.size(); ++j2) {
            in worldserver = this.worlds.get(j2);
            if (worldserver == null) continue;
            if (worldserver.K().t()) {
                worldserver.s = 3;
                worldserver.a(true, true);
                continue;
            }
            if (this.I()) {
                worldserver.s = par1;
                worldserver.a(worldserver.s > 0, true);
                continue;
            }
            worldserver.s = par1;
            worldserver.a(this.L(), this.y);
        }
    }

    protected boolean L() {
        return true;
    }

    public boolean M() {
        return this.M;
    }

    public void b(boolean par1) {
        this.M = par1;
    }

    public void c(boolean par1) {
        this.N = par1;
    }

    public aij N() {
        return this.m;
    }

    public void P() {
        this.O = true;
        this.N().d();
        for (int i2 = 0; i2 < this.worlds.size(); ++i2) {
            in worldserver = this.worlds.get(i2);
            if (worldserver == null) continue;
            MinecraftForge.EVENT_BUS.post(new WorldEvent.Unload(worldserver));
            worldserver.m();
        }
        this.N().e(this.worlds.get(0).J().g());
        this.n();
    }

    public String Q() {
        return this.P;
    }

    public void n(String par1Str) {
        this.P = par1Str;
    }

    @Override
    public void a(le par1PlayerUsageSnooper) {
        par1PlayerUsageSnooper.a("whitelist_enabled", false);
        par1PlayerUsageSnooper.a("whitelist_count", 0);
        par1PlayerUsageSnooper.a("players_current", this.y());
        par1PlayerUsageSnooper.a("players_max", this.z());
        par1PlayerUsageSnooper.a("players_seen", this.t.m().length);
        par1PlayerUsageSnooper.a("uses_auth", this.x);
        par1PlayerUsageSnooper.a("gui_state", this.ag() ? "enabled" : "disabled");
        par1PlayerUsageSnooper.a("avg_tick_ms", (int)(ke.a(this.j) * 1.0E-6));
        par1PlayerUsageSnooper.a("avg_sent_packet_count", (int)ke.a(this.f));
        par1PlayerUsageSnooper.a("avg_sent_packet_size", (int)ke.a(this.g));
        par1PlayerUsageSnooper.a("avg_rec_packet_count", (int)ke.a(this.h));
        par1PlayerUsageSnooper.a("avg_rec_packet_size", (int)ke.a(this.i));
        int i2 = 0;
        for (int j2 = 0; j2 < this.worlds.size(); ++j2) {
            in worldserver = this.worlds.get(j2);
            ahx worldinfo = worldserver.K();
            par1PlayerUsageSnooper.a("world[" + i2 + "][dimension]", worldserver.u.h);
            par1PlayerUsageSnooper.a("world[" + i2 + "][mode]", (Object)worldinfo.r());
            par1PlayerUsageSnooper.a("world[" + i2 + "][difficulty]", worldserver.s);
            par1PlayerUsageSnooper.a("world[" + i2 + "][hardcore]", worldinfo.t());
            par1PlayerUsageSnooper.a("world[" + i2 + "][generator_name]", worldinfo.u().a());
            par1PlayerUsageSnooper.a("world[" + i2 + "][generator_version]", worldinfo.u().c());
            par1PlayerUsageSnooper.a("world[" + i2 + "][height]", this.D);
            par1PlayerUsageSnooper.a("world[" + i2 + "][chunks_loaded]", worldserver.I().e());
            ++i2;
        }
        par1PlayerUsageSnooper.a("worlds", i2);
    }

    @Override
    public void b(le par1PlayerUsageSnooper) {
        par1PlayerUsageSnooper.a("singleplayer", this.I());
        par1PlayerUsageSnooper.a("server_brand", this.getServerModName());
        par1PlayerUsageSnooper.a("gui_supported", GraphicsEnvironment.isHeadless() ? "headless" : "supported");
        par1PlayerUsageSnooper.a("dedicated", this.T());
    }

    @Override
    public boolean R() {
        return true;
    }

    public int S() {
        return 16;
    }

    public abstract boolean T();

    public boolean U() {
        return this.server.getOnlineMode();
    }

    public void d(boolean par1) {
        this.x = par1;
    }

    public boolean V() {
        return this.y;
    }

    public void e(boolean par1) {
        this.y = par1;
    }

    public boolean W() {
        return this.z;
    }

    public void f(boolean par1) {
        this.z = par1;
    }

    public boolean X() {
        return this.A;
    }

    public void g(boolean par1) {
        this.A = par1;
    }

    public boolean Y() {
        return this.B;
    }

    public void h(boolean par1) {
        this.B = par1;
    }

    public abstract boolean Z();

    public String aa() {
        return this.C;
    }

    public void o(String par1Str) {
        this.C = par1Str;
    }

    public int ab() {
        return this.D;
    }

    public void d(int par1) {
        this.D = par1;
    }

    public boolean ac() {
        return this.v;
    }

    public gm ad() {
        return this.t;
    }

    public void a(gm par1ServerConfigurationManager) {
        this.t = par1ServerConfigurationManager;
    }

    public void a(yl par1EnumGameType) {
        for (int i2 = 0; i2 < this.worlds.size(); ++i2) {
            MinecraftServer.D().worlds.get(i2).K().a(par1EnumGameType);
        }
    }

    public abstract iw ae();

    @SideOnly(value=Side.CLIENT)
    public boolean af() {
        return this.Q;
    }

    public boolean ag() {
        return false;
    }

    public abstract String a(yl var1, boolean var2);

    public int ah() {
        return this.w;
    }

    public void ai() {
        this.T = true;
    }

    @SideOnly(value=Side.CLIENT)
    public le aj() {
        return this.n;
    }

    @Override
    public s b() {
        return new s(0, 0, 0);
    }

    public int ak() {
        return 16;
    }

    public static gm a(MinecraftServer par0MinecraftServer) {
        return par0MinecraftServer.t;
    }

    @SideOnly(value=Side.SERVER)
    public static void main(String[] par0ArrayOfStr) {
        FMLRelauncher.handleServerRelaunch(new ArgsWrapper(par0ArrayOfStr));
    }

    @SideOnly(value=Side.SERVER)
    public static void fmlReentry(ArgsWrapper var1) {
        a.severe(var1.args.getClass().getName());
        OptionSet options = Main.loadOptions(var1.args);
        if (options == null) {
            return;
        }
        FMLLogFormatter.setFormat(options.has("nojline"), options.has("date-format") ? (SimpleDateFormat)options.valueOf("date-format") : null);
        jq.a();
        try {
            int port;
            ho dedicatedserver = new ho(options);
            if (options.has("port") && (port = ((Integer)options.valueOf("port")).intValue()) > 0) {
                dedicatedserver.b(port);
            }
            if (options.has("universe")) {
                dedicatedserver.o = (File)options.valueOf("universe");
            }
            if (options.has("world")) {
                dedicatedserver.l((String)options.valueOf("world"));
            }
            dedicatedserver.primaryThread.setUncaughtExceptionHandler(new ExceptionHandler());
            dedicatedserver.primaryThread.start();
        }
        catch (Exception exception) {
            a.log(Level.SEVERE, "Failed to start the minecraft server", exception);
        }
    }

    static {
        currentTPS = 0.0;
    }
}

