/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.common.registry;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import cpw.mods.fml.common.FMLLog;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Random;

public class VillagerRegistry {
    private static final VillagerRegistry INSTANCE = new VillagerRegistry();
    private Multimap<Integer, IVillageTradeHandler> tradeHandlers = ArrayListMultimap.create();
    private Map<Class<?>, IVillageCreationHandler> villageCreationHandlers = Maps.newHashMap();
    private Map<Integer, String> newVillagers = Maps.newHashMap();
    private List<Integer> newVillagerIds = Lists.newArrayList();

    public static VillagerRegistry instance() {
        return INSTANCE;
    }

    public void registerVillagerType(int villagerId, String villagerSkin) {
        if (this.newVillagers.containsKey(villagerId)) {
            FMLLog.severe("Attempt to register duplicate villager id %d", villagerId);
            throw new RuntimeException();
        }
        this.newVillagers.put(villagerId, villagerSkin);
        this.newVillagerIds.add(villagerId);
    }

    public void registerVillageCreationHandler(IVillageCreationHandler handler) {
        this.villageCreationHandlers.put(handler.getComponentClass(), handler);
    }

    public void registerVillageTradeHandler(int villagerId, IVillageTradeHandler handler) {
        this.tradeHandlers.put((Object)villagerId, (Object)handler);
    }

    public static String getVillagerSkin(int villagerType, String defaultSkin) {
        if (VillagerRegistry.instance().newVillagers.containsKey(villagerType)) {
            return VillagerRegistry.instance().newVillagers.get(villagerType);
        }
        return defaultSkin;
    }

    public static Collection<Integer> getRegisteredVillagers() {
        return Collections.unmodifiableCollection(VillagerRegistry.instance().newVillagerIds);
    }

    public static void manageVillagerTrades(xu recipeList, qu villager, int villagerType, Random random) {
        for (IVillageTradeHandler handler : VillagerRegistry.instance().tradeHandlers.get((Object)villagerType)) {
            handler.manipulateTradesForVillager(villager, recipeList, random);
        }
    }

    public static void addExtraVillageComponents(ArrayList components, Random random, int i2) {
        ArrayList parts = components;
        for (IVillageCreationHandler handler : VillagerRegistry.instance().villageCreationHandlers.values()) {
            parts.add(handler.getVillagePieceWeight(random, i2));
        }
    }

    public static Object getVillageComponent(afj villagePiece, afp startPiece, List pieces, Random random, int p1, int p2, int p3, int p4, int p5) {
        return VillagerRegistry.instance().villageCreationHandlers.get(villagePiece.a).buildComponent(villagePiece, startPiece, pieces, random, p1, p2, p3, p4, p5);
    }

    public static void addEmeraldBuyRecipe(qu villager, xu list, Random random, up item, float chance, int min, int max) {
        if (min > 0 && max > 0) {
            qu.bO.put(item.cj, new kt(min, max));
        }
        qu.a(list, item.m(), random, chance);
    }

    public static void addEmeraldSellRecipe(qu villager, xu list, Random random, up item, float chance, int min, int max) {
        if (min > 0 && max > 0) {
            qu.bP.put(item.cj, new kt(min, max));
        }
        qu.b(list, item.m(), random, chance);
    }

    public static void applyRandomTrade(qu villager, Random rand) {
        int extra = VillagerRegistry.instance().newVillagerIds.size();
        int trade = rand.nextInt(5 + extra);
        villager.s(trade < 5 ? trade : VillagerRegistry.instance().newVillagerIds.get(trade - 5));
    }

    public static interface IVillageTradeHandler {
        public void manipulateTradesForVillager(qu var1, xu var2, Random var3);
    }

    public static interface IVillageCreationHandler {
        public afj getVillagePieceWeight(Random var1, int var2);

        public Class<?> getComponentClass();

        public Object buildComponent(afj var1, afp var2, List var3, Random var4, int var5, int var6, int var7, int var8, int var9);
    }
}

