/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.plugin.java;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import guava10.com.google.common.collect.ImmutableList;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.regex.Pattern;
import net.md_5.specialsource.InheritanceMap;
import net.md_5.specialsource.JarMapping;
import net.md_5.specialsource.JarMappingLoadTransformer;
import net.md_5.specialsource.ShadeRelocationSimulator;
import org.apache.commons.lang.Validate;
import org.bukkit.Bukkit;
import org.bukkit.Server;
import org.bukkit.Warning;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.configuration.serialization.ConfigurationSerializable;
import org.bukkit.configuration.serialization.ConfigurationSerialization;
import org.bukkit.craftbukkit.CraftServer;
import org.bukkit.event.Event;
import org.bukkit.event.EventException;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.server.PluginDisableEvent;
import org.bukkit.event.server.PluginEnableEvent;
import org.bukkit.plugin.AuthorNagException;
import org.bukkit.plugin.EventExecutor;
import org.bukkit.plugin.InvalidDescriptionException;
import org.bukkit.plugin.InvalidPluginException;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginDescriptionFile;
import org.bukkit.plugin.PluginLoader;
import org.bukkit.plugin.RegisteredListener;
import org.bukkit.plugin.TimedRegisteredListener;
import org.bukkit.plugin.UnknownDependencyException;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.plugin.java.PluginClassLoader;
import org.yaml.snakeyaml.error.YAMLException;

public class JavaPluginLoader
implements PluginLoader {
    private final Server server;
    protected final Pattern[] fileFilters = new Pattern[]{Pattern.compile("\\.jar$")};
    protected final Map<String, Class<?>> classes = new HashMap();
    protected final Map<String, PluginClassLoader> loaders = new LinkedHashMap<String, PluginClassLoader>();
    private static boolean warnedLegacy = false;
    private InheritanceMap globalInheritanceMap = null;

    public JavaPluginLoader(Server instance) {
        this.server = instance;
    }

    public Plugin loadPlugin(File file) throws InvalidPluginException {
        PluginDescriptionFile description;
        Validate.notNull((Object)file, (String)"File cannot be null");
        if (!file.exists()) {
            throw new InvalidPluginException((Throwable)new FileNotFoundException(file.getPath() + " does not exist"));
        }
        YamlConfiguration configuration = ((CraftServer)Bukkit.getServer()).configuration;
        String pluginBaseName = file.getName().substring(0, file.getName().indexOf("."));
        if ((configuration.getBoolean("mcpc.plugin-settings.default.remap-plugin-file", false) || configuration.getBoolean("mcpc.plugin-settings." + pluginBaseName + ".remap-plugin-file", false)) && !warnedLegacy) {
            this.server.getLogger().warning("Legacy remap-plugin-file SrgTools file-based remapper no longer included but bukkit.yml remap-plugin-file is true; ignoring. If needed, the old tool can be found at https://github.com/MinecraftPortCentral/MCPC-Plus/tree/5210aa0c613f3a1bdccaadc8af9f1b253e871da3/plugins - but please try the new SpecialSource-based in-memory remapper enabled with custom-class-loader (on by default since MCPC+ build 27+) and report any problems to http://www.mcportcentral.co.za/.");
            warnedLegacy = true;
        }
        try {
            description = this.getPluginDescription(file);
        }
        catch (InvalidDescriptionException ex2) {
            throw new InvalidPluginException((Throwable)ex2);
        }
        File dataFolder = new File(file.getParentFile(), description.getName());
        File oldDataFolder = this.getDataFolder(file);
        if (!dataFolder.equals(oldDataFolder)) {
            if (dataFolder.isDirectory() && oldDataFolder.isDirectory()) {
                this.server.getLogger().log(Level.INFO, String.format("While loading %s (%s) found old-data folder: %s next to the new one: %s", description.getName(), file, oldDataFolder, dataFolder));
            } else if (oldDataFolder.isDirectory() && !dataFolder.exists()) {
                if (!oldDataFolder.renameTo(dataFolder)) {
                    throw new InvalidPluginException("Unable to rename old data folder: '" + oldDataFolder + "' to: '" + dataFolder + "'");
                }
                this.server.getLogger().log(Level.INFO, String.format("While loading %s (%s) renamed data folder: '%s' to '%s'", description.getName(), file, oldDataFolder, dataFolder));
            }
        }
        if (dataFolder.exists() && !dataFolder.isDirectory()) {
            throw new InvalidPluginException(String.format("Projected datafolder: '%s' for %s (%s) exists and is not a directory", dataFolder, description.getName(), file));
        }
        List depend = description.getDepend();
        if (depend == null) {
            depend = ImmutableList.of();
        }
        for (String pluginName : depend) {
            if (this.loaders == null) {
                throw new UnknownDependencyException(pluginName);
            }
            PluginClassLoader current = this.loaders.get(pluginName);
            if (current != null) continue;
            throw new UnknownDependencyException(pluginName);
        }
        PluginClassLoader loader = null;
        JavaPlugin result = null;
        try {
            URL[] urls = new URL[]{file.toURI().toURL()};
            if (description.getClassLoaderOf() != null) {
                loader = this.loaders.get(description.getClassLoaderOf());
                loader.addURL(urls[0]);
            } else {
                loader = new PluginClassLoader(this, urls, this.getClass().getClassLoader(), description);
            }
            Class<?> jarClass = Class.forName(description.getMain(), true, loader);
            Class<JavaPlugin> plugin = jarClass.asSubclass(JavaPlugin.class);
            Constructor<JavaPlugin> constructor = plugin.getConstructor(new Class[0]);
            result = constructor.newInstance(new Object[0]);
            result.initialize((PluginLoader)this, this.server, description, dataFolder, file, (ClassLoader)loader);
        }
        catch (InvocationTargetException ex3) {
            throw new InvalidPluginException(ex3.getCause());
        }
        catch (Throwable ex4) {
            throw new InvalidPluginException(ex4);
        }
        this.loaders.put(description.getName(), loader);
        return result;
    }

    public Plugin loadPlugin(File file, boolean ignoreSoftDependencies) throws InvalidPluginException {
        return this.loadPlugin(file);
    }

    protected File getDataFolder(File file) {
        File dataFolder = null;
        String filename = file.getName();
        int index = file.getName().lastIndexOf(".");
        if (index != -1) {
            String name = filename.substring(0, index);
            dataFolder = new File(file.getParentFile(), name);
        } else {
            dataFolder = new File(file.getParentFile(), filename + "_");
        }
        return dataFolder;
    }

    public PluginDescriptionFile getPluginDescription(File file) throws InvalidDescriptionException {
        Validate.notNull((Object)file, (String)"File cannot be null");
        JarFile jar = null;
        InputStream stream = null;
        try {
            jar = new JarFile(file);
            JarEntry entry = jar.getJarEntry("plugin.yml");
            if (entry == null) {
                throw new InvalidDescriptionException((Throwable)new FileNotFoundException("Jar does not contain plugin.yml"));
            }
            stream = jar.getInputStream(entry);
            PluginDescriptionFile pluginDescriptionFile = new PluginDescriptionFile(stream);
            return pluginDescriptionFile;
        }
        catch (IOException ex2) {
            throw new InvalidDescriptionException((Throwable)ex2);
        }
        catch (YAMLException ex3) {
            throw new InvalidDescriptionException((Throwable)ex3);
        }
        finally {
            if (jar != null) {
                try {
                    jar.close();
                }
                catch (IOException e2) {}
            }
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException e3) {}
            }
        }
    }

    public Pattern[] getPluginFileFilters() {
        return this.fileFilters;
    }

    public Class<?> getClassByName(String name) {
        Class<?> cachedClass = this.classes.get(name);
        if (cachedClass != null) {
            return cachedClass;
        }
        for (String current : this.loaders.keySet()) {
            PluginClassLoader loader = this.loaders.get(current);
            try {
                cachedClass = loader.findClass(name, false);
            }
            catch (ClassNotFoundException cnfe) {
                // empty catch block
            }
            if (cachedClass == null) continue;
            return cachedClass;
        }
        return null;
    }

    public void setClass(String name, Class<?> clazz) {
        if (!this.classes.containsKey(name)) {
            this.classes.put(name, clazz);
            if (ConfigurationSerializable.class.isAssignableFrom(clazz)) {
                Class<ConfigurationSerializable> serializable = clazz.asSubclass(ConfigurationSerializable.class);
                ConfigurationSerialization.registerClass(serializable);
            }
        }
    }

    public void removeClass(String name) {
        Class<?> clazz = this.classes.remove(name);
        try {
            if (clazz != null && ConfigurationSerializable.class.isAssignableFrom(clazz)) {
                Class<ConfigurationSerializable> serializable = clazz.asSubclass(ConfigurationSerializable.class);
                ConfigurationSerialization.unregisterClass(serializable);
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public Map<Class<? extends Event>, Set<RegisteredListener>> createRegisteredListeners(Listener listener, Plugin plugin) {
        HashSet<Method> methods;
        Validate.notNull((Object)plugin, (String)"Plugin can not be null");
        Validate.notNull((Object)listener, (String)"Listener can not be null");
        boolean useTimings = this.server.getPluginManager().useTimings();
        HashMap<Class<? extends Event>, Set<RegisteredListener>> ret = new HashMap<Class<? extends Event>, Set<RegisteredListener>>();
        try {
            Method[] publicMethods = listener.getClass().getMethods();
            methods = new HashSet<Method>(publicMethods.length, Float.MAX_VALUE);
            for (Method method : publicMethods) {
                methods.add(method);
            }
            for (Method method : listener.getClass().getDeclaredMethods()) {
                methods.add(method);
            }
        }
        catch (NoClassDefFoundError e2) {
            plugin.getLogger().severe("Plugin " + plugin.getDescription().getFullName() + " has failed to register events for " + listener.getClass() + " because " + e2.getMessage() + " does not exist.");
            return ret;
        }
        for (final Method method : methods) {
            EventHandler eh2 = method.getAnnotation(EventHandler.class);
            if (eh2 == null) continue;
            Class<?> checkClass = method.getParameterTypes()[0];
            if (!Event.class.isAssignableFrom(checkClass) || method.getParameterTypes().length != 1) {
                plugin.getLogger().severe(plugin.getDescription().getFullName() + " attempted to register an invalid EventHandler method signature \"" + method.toGenericString() + "\" in " + listener.getClass());
                continue;
            }
            final Class<Event> eventClass = checkClass.asSubclass(Event.class);
            method.setAccessible(true);
            HashSet<Object> eventSet = (HashSet<Object>)ret.get(eventClass);
            if (eventSet == null) {
                eventSet = new HashSet<Object>();
                ret.put(eventClass, eventSet);
            }
            Class<Event> clazz = eventClass;
            while (Event.class.isAssignableFrom(clazz)) {
                if (clazz.getAnnotation(Deprecated.class) != null) {
                    Warning warning = clazz.getAnnotation(Warning.class);
                    Warning.WarningState warningState = this.server.getWarningState();
                    if (!warningState.printFor(warning)) break;
                    plugin.getLogger().log(Level.WARNING, String.format("\"%s\" has registered a listener for %s on method \"%s\", but the event is Deprecated. \"%s\"; please notify the authors %s.", plugin.getDescription().getFullName(), clazz.getName(), method.toGenericString(), warning != null && warning.reason().length() != 0 ? warning.reason() : "Server performance will be affected", Arrays.toString(plugin.getDescription().getAuthors().toArray())), (Throwable)(warningState == Warning.WarningState.ON ? new AuthorNagException(null) : null));
                    break;
                }
                clazz = clazz.getSuperclass();
            }
            EventExecutor executor = new EventExecutor(){

                public void execute(Listener listener, Event event) throws EventException {
                    try {
                        if (!eventClass.isAssignableFrom(event.getClass())) {
                            return;
                        }
                        method.invoke((Object)listener, event);
                    }
                    catch (InvocationTargetException ex2) {
                        throw new EventException(ex2.getCause());
                    }
                    catch (Throwable t2) {
                        throw new EventException(t2);
                    }
                }
            };
            if (useTimings) {
                eventSet.add(new TimedRegisteredListener(listener, executor, eh2.priority(), plugin, eh2.ignoreCancelled()));
                continue;
            }
            eventSet.add(new RegisteredListener(listener, executor, eh2.priority(), plugin, eh2.ignoreCancelled()));
        }
        return ret;
    }

    public void enablePlugin(Plugin plugin) {
        if (!(plugin instanceof JavaPlugin)) {
            throw new IllegalArgumentException("Plugin is not associated with this PluginLoader");
        }
        if (!plugin.isEnabled()) {
            String message = String.format("Enabling %s", plugin.getDescription().getFullName());
            plugin.getLogger().info(message);
            JavaPlugin jPlugin = (JavaPlugin)plugin;
            String pluginName = jPlugin.getDescription().getName();
            if (!this.loaders.containsKey(pluginName)) {
                this.loaders.put(pluginName, (PluginClassLoader)jPlugin.getClassLoader());
            }
            try {
                jPlugin.setEnabled(true);
            }
            catch (Throwable ex2) {
                this.server.getLogger().log(Level.SEVERE, "Error occurred while enabling " + plugin.getDescription().getFullName() + " (Is it up to date?)", ex2);
            }
            this.server.getPluginManager().callEvent((Event)new PluginEnableEvent(plugin));
        }
    }

    public void disablePlugin(Plugin plugin) {
        if (!(plugin instanceof JavaPlugin)) {
            throw new IllegalArgumentException("Plugin is not associated with this PluginLoader");
        }
        if (plugin.isEnabled()) {
            String message = String.format("Disabling %s", plugin.getDescription().getFullName());
            plugin.getLogger().info(message);
            this.server.getPluginManager().callEvent((Event)new PluginDisableEvent(plugin));
            JavaPlugin jPlugin = (JavaPlugin)plugin;
            ClassLoader cloader = jPlugin.getClassLoader();
            try {
                jPlugin.setEnabled(false);
            }
            catch (Throwable ex2) {
                this.server.getLogger().log(Level.SEVERE, "Error occurred while disabling " + plugin.getDescription().getFullName() + " (Is it up to date?)", ex2);
            }
            this.loaders.remove(jPlugin.getDescription().getName());
            if (cloader instanceof PluginClassLoader) {
                PluginClassLoader loader = (PluginClassLoader)cloader;
                Set<String> names = loader.getClasses();
                for (String name : names) {
                    this.removeClass(name);
                }
            }
        }
    }

    public InheritanceMap getGlobalInheritanceMap() {
        if (this.globalInheritanceMap == null) {
            HashMap<String, String> relocationsCurrent = new HashMap<String, String>();
            relocationsCurrent.put("net.minecraft.server", "net.minecraft.server.v1_4_R1");
            JarMapping currentMappings = new JarMapping();
            try {
                currentMappings.loadMappings(new BufferedReader(new InputStreamReader(this.getClass().getClassLoader().getResourceAsStream("mappings/1.4.7/cb2obf.csrg"))), (JarMappingLoadTransformer)new ShadeRelocationSimulator(relocationsCurrent), null, false);
            }
            catch (IOException ex2) {
                ex2.printStackTrace();
                throw new RuntimeException(ex2);
            }
            BiMap inverseClassMap = HashBiMap.create((Map)currentMappings.classes).inverse();
            this.globalInheritanceMap = new InheritanceMap();
            BufferedReader reader = new BufferedReader(new InputStreamReader(this.getClass().getClassLoader().getResourceAsStream("mappings/1.4.7/nms.inheritmap")));
            try {
                this.globalInheritanceMap.load(reader, inverseClassMap);
            }
            catch (IOException ex3) {
                ex3.printStackTrace();
                throw new RuntimeException(ex3);
            }
            System.out.println("Loaded inheritance map of " + this.globalInheritanceMap.size() + " classes");
        }
        return this.globalInheritanceMap;
    }
}

