/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.event.server;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.bukkit.entity.Player;
import org.bukkit.event.server.Packet;
import org.bukkit.event.server.PluginDisableEvent;
import org.bukkit.plugin.Plugin;

public abstract class PacketListener {
    public static Map<Integer, Collection<PacketListener>> incomingPacketListeners = new HashMap<Integer, Collection<PacketListener>>();
    public static Map<Integer, Collection<PacketListener>> outgoingPacketListeners = new HashMap<Integer, Collection<PacketListener>>();
    static Map<PacketListener, Plugin> listenerToPlugin = new HashMap<PacketListener, Plugin>();

    public static void addPacketListener(boolean outgoing, int packetID, PacketListener listener, Plugin plugin) {
        Map<Integer, Collection<PacketListener>> packetListeners = outgoing ? outgoingPacketListeners : incomingPacketListeners;
        Collection<PacketListener> listenersForPacket = packetListeners.get(packetID);
        if (listenersForPacket == null) {
            listenersForPacket = new HashSet<PacketListener>();
            packetListeners.put(packetID, listenersForPacket);
        }
        listenersForPacket.add(listener);
        listenerToPlugin.put(listener, plugin);
    }

    public static void removePacketListener(boolean outgoing, int packetID, PacketListener listener) {
        Map<Integer, Collection<PacketListener>> packetListeners = outgoing ? outgoingPacketListeners : incomingPacketListeners;
        Collection<PacketListener> listenersForPacket = packetListeners.get(packetID);
        if (listenersForPacket == null) {
            return;
        }
        listenersForPacket.remove(listenersForPacket);
    }

    public boolean onOutgoingPacket(Player ply, int packetID, Packet packet) {
        System.err.println("onOutgoingPacket not overridden.");
        PacketListener.removePacketListener(true, packetID, this);
        return true;
    }

    public boolean onIncomingPacket(Player ply, int packetID, Packet packet) {
        System.err.println("onIncomingPacket not overridden.");
        PacketListener.removePacketListener(false, packetID, this);
        return true;
    }

    public static final void onPluginDisable(PluginDisableEvent event) {
        Plugin plugin = event.getPlugin();
        Iterator<Map.Entry<PacketListener, Plugin>> it2 = listenerToPlugin.entrySet().iterator();
        while (it2.hasNext()) {
            Map.Entry<PacketListener, Plugin> foo = it2.next();
            PacketListener packetListener = foo.getKey();
            if (foo.getValue() == plugin) {
                for (Map packetListenerMaps : Arrays.asList(outgoingPacketListeners, incomingPacketListeners)) {
                    for (Map.Entry packetListeners : packetListenerMaps.entrySet()) {
                        ((Collection)packetListeners.getValue()).remove(packetListener);
                    }
                }
            }
            it2.remove();
        }
    }
}

