/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.util;

import java.util.ArrayList;
import java.util.List;
import org.bukkit.BlockChangeDelegate;
import org.bukkit.block.BlockState;
import org.bukkit.craftbukkit.CraftWorld;
import org.bukkit.material.MaterialData;

public class StructureGrowDelegate
implements BlockChangeDelegate {
    private final CraftWorld world;
    private final List<BlockState> blocks = new ArrayList<BlockState>();

    public StructureGrowDelegate(yc world) {
        this.world = world.getWorld();
    }

    public boolean setRawTypeId(int x2, int y2, int z2, int type) {
        return this.setRawTypeIdAndData(x2, y2, z2, type, 0);
    }

    public boolean setRawTypeIdAndData(int x2, int y2, int z2, int type, int data) {
        BlockState state = this.world.getBlockAt(x2, y2, z2).getState();
        state.setTypeId(type);
        state.setData(new MaterialData(type, (byte)data));
        this.blocks.add(state);
        return true;
    }

    public boolean setTypeId(int x2, int y2, int z2, int typeId) {
        return this.setRawTypeId(x2, y2, z2, typeId);
    }

    public boolean setTypeIdAndData(int x2, int y2, int z2, int typeId, int data) {
        return this.setRawTypeIdAndData(x2, y2, z2, typeId, data);
    }

    public int getTypeId(int x2, int y2, int z2) {
        return this.world.getBlockTypeIdAt(x2, y2, z2);
    }

    public int getHeight() {
        return this.world.getMaxHeight();
    }

    public List<BlockState> getBlocks() {
        return this.blocks;
    }

    public boolean isEmpty(int x2, int y2, int z2) {
        return this.world.getBlockAt(x2, y2, z2).isEmpty();
    }
}

