/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.updater;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLConnection;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bukkit.craftbukkit.updater.ArtifactDetails;

public class BukkitDLUpdaterService {
    private static final String API_PREFIX_ARTIFACT = "/api/1.0/downloads/projects/craftbukkit/view/";
    private static final String API_PREFIX_CHANNEL = "/api/1.0/downloads/channels/";
    private final String host;

    public BukkitDLUpdaterService(String host) {
        this.host = host;
    }

    public ArtifactDetails getArtifact(String slug, String name) {
        try {
            return this.fetchArtifact(slug);
        }
        catch (UnsupportedEncodingException ex2) {
            Logger.getLogger(BukkitDLUpdaterService.class.getName()).log(Level.WARNING, "Could not get " + name + ": " + ex2.getClass().getSimpleName());
        }
        catch (IOException ex3) {
            Logger.getLogger(BukkitDLUpdaterService.class.getName()).log(Level.WARNING, "Could not get " + name + ": " + ex3.getClass().getSimpleName());
        }
        return null;
    }

    private String getUserAgent() {
        return "CraftBukkit/" + BukkitDLUpdaterService.class.getPackage().getImplementationVersion() + "/" + System.getProperty("java.version");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArtifactDetails fetchArtifact(String slug) throws IOException {
        URL url = new URL("http", this.host, API_PREFIX_ARTIFACT + slug + "/");
        InputStreamReader reader = null;
        try {
            URLConnection connection = url.openConnection();
            connection.setRequestProperty("User-Agent", this.getUserAgent());
            reader = new InputStreamReader(connection.getInputStream());
            ArtifactDetails artifactDetails = null;
            return artifactDetails;
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
    }

    public ArtifactDetails.ChannelDetails getChannel(String slug, String name) {
        try {
            return this.fetchChannel(slug);
        }
        catch (UnsupportedEncodingException ex2) {
            Logger.getLogger(BukkitDLUpdaterService.class.getName()).log(Level.WARNING, "Could not get " + name + ": " + ex2.getClass().getSimpleName());
        }
        catch (IOException ex3) {
            Logger.getLogger(BukkitDLUpdaterService.class.getName()).log(Level.WARNING, "Could not get " + name + ": " + ex3.getClass().getSimpleName());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArtifactDetails.ChannelDetails fetchChannel(String slug) throws IOException {
        URL url = new URL("http", this.host, API_PREFIX_CHANNEL + slug + "/");
        InputStreamReader reader = null;
        try {
            URLConnection connection = url.openConnection();
            connection.setRequestProperty("User-Agent", this.getUserAgent());
            reader = new InputStreamReader(connection.getInputStream());
            ArtifactDetails.ChannelDetails channelDetails = null;
            return channelDetails;
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
    }
}

