/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.scheduler;

import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

class CraftTask
implements BukkitTask,
Runnable {
    private volatile CraftTask next = null;
    private volatile long period;
    private long nextRun;
    private final Runnable task;
    private final Plugin plugin;
    private final int id;

    CraftTask() {
        this(null, null, -1, -1L);
    }

    CraftTask(Runnable task) {
        this(null, task, -1, -1L);
    }

    CraftTask(Plugin plugin, Runnable task, int id2, long period) {
        this.plugin = plugin;
        this.task = task;
        this.id = id2;
        this.period = period;
    }

    public final int getTaskId() {
        return this.id;
    }

    public final Plugin getOwner() {
        return this.plugin;
    }

    public boolean isSync() {
        return true;
    }

    @Override
    public void run() {
        this.task.run();
    }

    long getPeriod() {
        return this.period;
    }

    void setPeriod(long period) {
        this.period = period;
    }

    long getNextRun() {
        return this.nextRun;
    }

    void setNextRun(long nextRun) {
        this.nextRun = nextRun;
    }

    CraftTask getNext() {
        return this.next;
    }

    void setNext(CraftTask next) {
        this.next = next;
    }

    Class<? extends Runnable> getTaskClass() {
        return this.task.getClass();
    }

    public void cancel() {
        Bukkit.getScheduler().cancelTask(this.id);
    }

    boolean cancel0() {
        this.setPeriod(-2L);
        return true;
    }
}

