/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.inventory;

import guava10.com.google.common.base.Strings;
import guava10.com.google.common.collect.ImmutableList;
import guava10.com.google.common.collect.ImmutableMap;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.commons.lang.Validate;
import org.bukkit.Material;
import org.bukkit.configuration.serialization.ConfigurationSerializable;
import org.bukkit.configuration.serialization.DelegateDeserialization;
import org.bukkit.configuration.serialization.SerializableAs;
import org.bukkit.craftbukkit.Overridden;
import org.bukkit.craftbukkit.inventory.CraftItemFactory;
import org.bukkit.craftbukkit.inventory.CraftMetaBook;
import org.bukkit.craftbukkit.inventory.CraftMetaCharge;
import org.bukkit.craftbukkit.inventory.CraftMetaEnchantedBook;
import org.bukkit.craftbukkit.inventory.CraftMetaFirework;
import org.bukkit.craftbukkit.inventory.CraftMetaLeatherArmor;
import org.bukkit.craftbukkit.inventory.CraftMetaMap;
import org.bukkit.craftbukkit.inventory.CraftMetaPotion;
import org.bukkit.craftbukkit.inventory.CraftMetaSkull;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.Repairable;

@DelegateDeserialization(value=SerializableMeta.class)
class CraftMetaItem
implements ItemMeta,
Repairable {
    static final ItemMetaKey NAME = new ItemMetaKey("Name", "display-name");
    static final ItemMetaKey DISPLAY = new ItemMetaKey("display");
    static final ItemMetaKey LORE = new ItemMetaKey("Lore", "lore");
    static final ItemMetaKey ENCHANTMENTS = new ItemMetaKey("ench", "enchants");
    static final ItemMetaKey ENCHANTMENTS_ID = new ItemMetaKey("id");
    static final ItemMetaKey ENCHANTMENTS_LVL = new ItemMetaKey("lvl");
    static final ItemMetaKey REPAIR = new ItemMetaKey("RepairCost", "repair-cost");
    private String displayName;
    private List<String> lore;
    private Map<Enchantment, Integer> enchantments;
    private int repairCost;

    CraftMetaItem(CraftMetaItem meta) {
        if (meta == null) {
            return;
        }
        this.displayName = meta.displayName;
        if (meta.hasLore()) {
            this.lore = new ArrayList<String>(meta.lore);
        }
        if (meta.hasEnchants()) {
            this.enchantments = new HashMap<Enchantment, Integer>(meta.enchantments);
        }
        this.repairCost = meta.repairCost;
    }

    CraftMetaItem(bq tag) {
        if (tag.b(CraftMetaItem.DISPLAY.NBT)) {
            bq display = tag.l(CraftMetaItem.DISPLAY.NBT);
            if (display.b(CraftMetaItem.NAME.NBT)) {
                this.displayName = display.i(CraftMetaItem.NAME.NBT);
            }
            if (display.b(CraftMetaItem.LORE.NBT)) {
                by list = display.m(CraftMetaItem.LORE.NBT);
                this.lore = new ArrayList<String>(list.c());
                for (int index = 0; index < list.c(); ++index) {
                    String line = ((cc)list.b((int)index)).a;
                    this.lore.add(line);
                }
            }
        }
        this.enchantments = CraftMetaItem.buildEnchantments(tag, ENCHANTMENTS);
        if (tag.b(CraftMetaItem.REPAIR.NBT)) {
            this.repairCost = tag.e(CraftMetaItem.REPAIR.NBT);
        }
    }

    static Map<Enchantment, Integer> buildEnchantments(bq tag, ItemMetaKey key) {
        if (!tag.b(key.NBT)) {
            return null;
        }
        by ench = tag.m(key.NBT);
        HashMap<Enchantment, Integer> enchantments = new HashMap<Enchantment, Integer>(ench.c());
        for (int i2 = 0; i2 < ench.c(); ++i2) {
            int id2 = 0xFFFF & ((bq)ench.b(i2)).d(CraftMetaItem.ENCHANTMENTS_ID.NBT);
            int level = 0xFFFF & ((bq)ench.b(i2)).d(CraftMetaItem.ENCHANTMENTS_LVL.NBT);
            enchantments.put(Enchantment.getById((int)id2), level);
        }
        return enchantments;
    }

    CraftMetaItem(Map<String, Object> map) {
        this.setDisplayName(SerializableMeta.getString(map, CraftMetaItem.NAME.BUKKIT, true));
        Iterable lore = SerializableMeta.getObject(Iterable.class, map, CraftMetaItem.LORE.BUKKIT, true);
        if (lore != null) {
            this.lore = new ArrayList<String>();
            CraftMetaItem.safelyAdd(lore, this.lore, Integer.MAX_VALUE);
        }
        this.enchantments = CraftMetaItem.buildEnchantments(map, ENCHANTMENTS);
        Integer repairCost = SerializableMeta.getObject(Integer.class, map, CraftMetaItem.REPAIR.BUKKIT, true);
        if (repairCost != null) {
            this.setRepairCost(repairCost);
        }
    }

    static Map<Enchantment, Integer> buildEnchantments(Map<String, Object> map, ItemMetaKey key) {
        Map ench = SerializableMeta.getObject(Map.class, map, key.BUKKIT, true);
        if (ench == null) {
            return null;
        }
        HashMap<Enchantment, Integer> enchantments = new HashMap<Enchantment, Integer>(ench.size());
        for (Map.Entry entry : ench.entrySet()) {
            Enchantment enchantment = Enchantment.getByName((String)entry.getKey().toString());
            if (enchantment == null || !(entry.getValue() instanceof Integer)) continue;
            enchantments.put(enchantment, (Integer)entry.getValue());
        }
        return enchantments;
    }

    @Overridden
    void applyToItem(bq itemTag) {
        if (this.hasDisplayName()) {
            this.setDisplayTag(itemTag, CraftMetaItem.NAME.NBT, new cc(CraftMetaItem.NAME.NBT, this.displayName));
        }
        if (this.hasLore()) {
            this.setDisplayTag(itemTag, CraftMetaItem.LORE.NBT, CraftMetaItem.createStringList(this.lore, LORE));
        }
        CraftMetaItem.applyEnchantments(this.enchantments, itemTag, ENCHANTMENTS);
        if (this.hasRepairCost()) {
            itemTag.a(CraftMetaItem.REPAIR.NBT, this.repairCost);
        }
    }

    static by createStringList(List<String> list, ItemMetaKey key) {
        if (list == null || list.isEmpty()) {
            return null;
        }
        by tagList = new by(key.NBT);
        for (int i2 = 0; i2 < list.size(); ++i2) {
            tagList.a(new cc("", list.get(i2)));
        }
        return tagList;
    }

    static void applyEnchantments(Map<Enchantment, Integer> enchantments, bq tag, ItemMetaKey key) {
        if (enchantments == null || enchantments.size() == 0) {
            return;
        }
        by list = new by(key.NBT);
        for (Map.Entry<Enchantment, Integer> entry : enchantments.entrySet()) {
            bq subtag = new bq();
            subtag.a(CraftMetaItem.ENCHANTMENTS_ID.NBT, (short)entry.getKey().getId());
            subtag.a(CraftMetaItem.ENCHANTMENTS_LVL.NBT, entry.getValue().shortValue());
            list.a(subtag);
        }
        tag.a(key.NBT, list);
    }

    void setDisplayTag(bq tag, String key, cd value) {
        bq display = tag.l(CraftMetaItem.DISPLAY.NBT);
        if (!tag.b(CraftMetaItem.DISPLAY.NBT)) {
            tag.a(CraftMetaItem.DISPLAY.NBT, display);
        }
        display.a(key, value);
    }

    @Overridden
    boolean applicableTo(Material type) {
        return type != Material.AIR;
    }

    @Overridden
    boolean isEmpty() {
        return !this.hasDisplayName() && !this.hasEnchants() && !this.hasLore();
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public final void setDisplayName(String name) {
        this.displayName = name;
    }

    public boolean hasDisplayName() {
        return !Strings.isNullOrEmpty((String)this.displayName);
    }

    public boolean hasLore() {
        return this.lore != null && !this.lore.isEmpty();
    }

    public boolean hasRepairCost() {
        return this.repairCost > 0;
    }

    public boolean hasEnchant(Enchantment ench) {
        return this.hasEnchants() ? this.enchantments.containsKey(ench) : false;
    }

    public int getEnchantLevel(Enchantment ench) {
        Integer level;
        Integer n2 = level = this.hasEnchants() ? this.enchantments.get(ench) : null;
        if (level == null) {
            return 0;
        }
        return level;
    }

    public Map<Enchantment, Integer> getEnchants() {
        return this.hasEnchants() ? ImmutableMap.copyOf(this.enchantments) : ImmutableMap.of();
    }

    public boolean addEnchant(Enchantment ench, int level, boolean ignoreRestrictions) {
        if (this.enchantments == null) {
            this.enchantments = new HashMap<Enchantment, Integer>(4);
        }
        if (ignoreRestrictions || level >= ench.getStartLevel() && level <= ench.getMaxLevel()) {
            Integer old = this.enchantments.put(ench, level);
            return old == null || old != level;
        }
        return false;
    }

    public boolean removeEnchant(Enchantment ench) {
        return this.hasEnchants() ? this.enchantments.remove(ench) != null : false;
    }

    public boolean hasEnchants() {
        return this.enchantments != null && !this.enchantments.isEmpty();
    }

    public List<String> getLore() {
        return this.lore == null ? null : new ArrayList<String>(this.lore);
    }

    public void setLore(List<String> lore) {
        if (lore == null) {
            this.lore = null;
        } else if (this.lore == null) {
            this.lore = new ArrayList<String>(lore.size());
            CraftMetaItem.safelyAdd(lore, this.lore, Integer.MAX_VALUE);
        } else {
            this.lore.clear();
            CraftMetaItem.safelyAdd(lore, this.lore, Integer.MAX_VALUE);
        }
    }

    public int getRepairCost() {
        return this.repairCost;
    }

    public void setRepairCost(int cost) {
        this.repairCost = cost;
    }

    public final boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (!(object instanceof CraftMetaItem)) {
            return false;
        }
        return CraftItemFactory.instance().equals((ItemMeta)this, (ItemMeta)object);
    }

    @Overridden
    boolean equalsCommon(CraftMetaItem that) {
        return (this.hasDisplayName() ? that.hasDisplayName() && this.displayName.equals(that.displayName) : !that.hasDisplayName()) && (this.hasEnchants() ? that.hasEnchants() && this.enchantments.equals(that.enchantments) : !that.hasEnchants()) && (this.hasLore() ? that.hasLore() && this.lore.equals(that.lore) : !that.hasLore()) && (this.hasRepairCost() ? that.hasRepairCost() && this.repairCost == that.repairCost : !that.hasRepairCost());
    }

    @Overridden
    boolean notUncommon(CraftMetaItem meta) {
        return true;
    }

    public final int hashCode() {
        return this.applyHash();
    }

    @Overridden
    int applyHash() {
        int hash = 3;
        hash = 61 * hash + (this.hasDisplayName() ? this.displayName.hashCode() : 0);
        hash = 61 * hash + (this.hasLore() ? this.lore.hashCode() : 0);
        hash = 61 * hash + (this.hasEnchants() ? this.enchantments.hashCode() : 0);
        hash = 61 * hash + (this.hasRepairCost() ? this.repairCost : 0);
        return hash;
    }

    @Overridden
    public CraftMetaItem clone() {
        try {
            return (CraftMetaItem)super.clone();
        }
        catch (CloneNotSupportedException e2) {
            throw new Error(e2);
        }
    }

    public final Map<String, Object> serialize() {
        ImmutableMap.Builder map = ImmutableMap.builder();
        map.put((Object)"meta-type", SerializableMeta.classMap.get(this.getClass()));
        this.serialize((ImmutableMap.Builder<String, Object>)map);
        return map.build();
    }

    @Overridden
    ImmutableMap.Builder<String, Object> serialize(ImmutableMap.Builder<String, Object> builder) {
        if (this.hasDisplayName()) {
            builder.put((Object)CraftMetaItem.NAME.BUKKIT, (Object)this.displayName);
        }
        if (this.hasLore()) {
            builder.put((Object)CraftMetaItem.LORE.BUKKIT, (Object)ImmutableList.copyOf(this.lore));
        }
        CraftMetaItem.serializeEnchantments(this.enchantments, builder, ENCHANTMENTS);
        if (this.hasRepairCost()) {
            builder.put((Object)CraftMetaItem.REPAIR.BUKKIT, (Object)this.repairCost);
        }
        return builder;
    }

    static void serializeEnchantments(Map<Enchantment, Integer> enchantments, ImmutableMap.Builder<String, Object> builder, ItemMetaKey key) {
        if (enchantments == null || enchantments.isEmpty()) {
            return;
        }
        ImmutableMap.Builder enchants = ImmutableMap.builder();
        for (Map.Entry<Enchantment, Integer> enchant : enchantments.entrySet()) {
            enchants.put((Object)enchant.getKey().getName(), (Object)enchant.getValue());
        }
        builder.put((Object)key.BUKKIT, (Object)enchants.build());
    }

    static void safelyAdd(Iterable<?> addFrom, Collection<String> addTo, int maxItemLength) {
        if (addFrom == null) {
            return;
        }
        for (Object object : addFrom) {
            if (!(object instanceof String)) {
                if (object != null) {
                    throw new IllegalArgumentException(addFrom + " cannot contain non-string " + object.getClass().getName());
                }
                addTo.add("");
                continue;
            }
            String page = object.toString();
            if (page.length() > maxItemLength) {
                page = page.substring(0, maxItemLength);
            }
            addTo.add(page);
        }
    }

    public final String toString() {
        return (String)SerializableMeta.classMap.get(this.getClass()) + "_META:" + this.serialize();
    }

    @SerializableAs(value="ItemMeta")
    public static class SerializableMeta
    implements ConfigurationSerializable {
        static final String TYPE_FIELD = "meta-type";
        static final ImmutableMap<Class<? extends CraftMetaItem>, String> classMap = ImmutableMap.builder().put(CraftMetaBook.class, (Object)"BOOK").put(CraftMetaSkull.class, (Object)"SKULL").put(CraftMetaLeatherArmor.class, (Object)"LEATHER_ARMOR").put(CraftMetaMap.class, (Object)"MAP").put(CraftMetaPotion.class, (Object)"POTION").put(CraftMetaEnchantedBook.class, (Object)"ENCHANTED").put(CraftMetaFirework.class, (Object)"FIREWORK").put(CraftMetaCharge.class, (Object)"FIREWORK_EFFECT").put(CraftMetaItem.class, (Object)"UNSPECIFIC").build();
        static final ImmutableMap<String, Constructor<? extends CraftMetaItem>> constructorMap;

        private SerializableMeta() {
        }

        public static ItemMeta deserialize(Map<String, Object> map) throws Throwable {
            Validate.notNull(map, (String)"Cannot deserialize null map");
            String type = SerializableMeta.getString(map, TYPE_FIELD, false);
            Constructor constructor = (Constructor)constructorMap.get((Object)type);
            if (constructor == null) {
                throw new IllegalArgumentException(type + " is not a valid " + TYPE_FIELD);
            }
            try {
                return (ItemMeta)constructor.newInstance(map);
            }
            catch (InstantiationException e2) {
                throw new AssertionError((Object)e2);
            }
            catch (IllegalAccessException e3) {
                throw new AssertionError((Object)e3);
            }
            catch (InvocationTargetException e4) {
                throw e4.getCause();
            }
        }

        public Map<String, Object> serialize() {
            throw new AssertionError();
        }

        static String getString(Map<?, ?> map, Object field, boolean nullable) {
            return SerializableMeta.getObject(String.class, map, field, nullable);
        }

        static boolean getBoolean(Map<?, ?> map, Object field) {
            Boolean value = SerializableMeta.getObject(Boolean.class, map, field, true);
            return value != null && value != false;
        }

        static <T> T getObject(Class<T> clazz, Map<?, ?> map, Object field, boolean nullable) {
            Object object = map.get(field);
            if (clazz.isInstance(object)) {
                return clazz.cast(object);
            }
            if (object == null) {
                if (!nullable) {
                    throw new NoSuchElementException(map + " does not contain " + field);
                }
                return null;
            }
            throw new IllegalArgumentException(field + "(" + object + ") is not a valid " + clazz);
        }

        static {
            ImmutableMap.Builder classConstructorBuilder = ImmutableMap.builder();
            for (Map.Entry mapping : classMap.entrySet()) {
                try {
                    classConstructorBuilder.put(mapping.getValue(), ((Class)mapping.getKey()).getDeclaredConstructor(Map.class));
                }
                catch (NoSuchMethodException e2) {
                    throw new AssertionError((Object)e2);
                }
            }
            constructorMap = classConstructorBuilder.build();
        }
    }

    static class ItemMetaKey {
        final String BUKKIT;
        final String NBT;

        ItemMetaKey(String both) {
            this(both, both);
        }

        ItemMetaKey(String nbt, String bukkit) {
            this.NBT = nbt;
            this.BUKKIT = bukkit;
        }

        @Retention(value=RetentionPolicy.SOURCE)
        @Target(value={ElementType.FIELD})
        static @interface Specific {
            public To value();

            public static enum To {
                BUKKIT,
                NBT;

            }
        }
    }
}

