/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.inventory;

import guava10.com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.apache.commons.lang.Validate;
import org.bukkit.Material;
import org.bukkit.configuration.serialization.DelegateDeserialization;
import org.bukkit.craftbukkit.inventory.CraftItemFactory;
import org.bukkit.craftbukkit.inventory.CraftMetaBook;
import org.bukkit.craftbukkit.inventory.CraftMetaCharge;
import org.bukkit.craftbukkit.inventory.CraftMetaEnchantedBook;
import org.bukkit.craftbukkit.inventory.CraftMetaFirework;
import org.bukkit.craftbukkit.inventory.CraftMetaItem;
import org.bukkit.craftbukkit.inventory.CraftMetaLeatherArmor;
import org.bukkit.craftbukkit.inventory.CraftMetaMap;
import org.bukkit.craftbukkit.inventory.CraftMetaPotion;
import org.bukkit.craftbukkit.inventory.CraftMetaSkull;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

@DelegateDeserialization(value=ItemStack.class)
public final class CraftItemStack
extends ItemStack {
    ur handle;

    public static ur asNMSCopy(ItemStack original) {
        if (original instanceof CraftItemStack) {
            CraftItemStack stack = (CraftItemStack)original;
            return stack.handle == null ? null : stack.handle.l();
        }
        if (original == null || original.getTypeId() <= 0) {
            return null;
        }
        ur stack = new ur(original.getTypeId(), original.getAmount(), (int)original.getDurability());
        if (original.hasItemMeta()) {
            CraftItemStack.setItemMeta(stack, original.getItemMeta());
        }
        return stack;
    }

    public static ur copyNMSStack(ur original, int amount) {
        ur stack = original.l();
        stack.a = amount;
        return stack;
    }

    public static ItemStack asBukkitCopy(ur original) {
        if (original == null) {
            return new ItemStack(Material.AIR);
        }
        ItemStack stack = new ItemStack(original.c, original.a, (short)original.j());
        if (CraftItemStack.hasItemMeta(original)) {
            stack.setItemMeta(CraftItemStack.getItemMeta(original));
        }
        return stack;
    }

    public static CraftItemStack asCraftMirror(ur original) {
        return new CraftItemStack(original);
    }

    public static CraftItemStack asCraftCopy(ItemStack original) {
        if (original instanceof CraftItemStack) {
            CraftItemStack stack = (CraftItemStack)original;
            return new CraftItemStack(stack.handle == null ? null : stack.handle.l());
        }
        return new CraftItemStack(original);
    }

    public static CraftItemStack asNewCraftStack(up item) {
        return CraftItemStack.asNewCraftStack(item, 1);
    }

    public static CraftItemStack asNewCraftStack(up item, int amount) {
        return new CraftItemStack(item.cj, amount, 0, null);
    }

    private CraftItemStack(ur item) {
        this.handle = item;
    }

    private CraftItemStack(ItemStack item) {
        this(item.getTypeId(), item.getAmount(), item.getDurability(), item.hasItemMeta() ? item.getItemMeta() : null);
    }

    private CraftItemStack(int typeId, int amount, short durability, ItemMeta itemMeta) {
        this.setTypeId(typeId);
        this.setAmount(amount);
        this.setDurability(durability);
        this.setItemMeta(itemMeta);
    }

    public int getTypeId() {
        return this.handle != null ? this.handle.c : 0;
    }

    public void setTypeId(int type) {
        if (this.getTypeId() == type) {
            return;
        }
        if (type == 0) {
            this.handle = null;
        } else if (this.handle == null) {
            this.handle = new ur(type, 1, 0);
        } else {
            this.handle.c = type;
            if (this.hasItemMeta()) {
                CraftItemStack.setItemMeta(this.handle, CraftItemStack.getItemMeta(this.handle));
            }
        }
        this.setData(null);
    }

    public int getAmount() {
        return this.handle != null ? this.handle.a : 0;
    }

    public void setAmount(int amount) {
        if (this.handle == null) {
            return;
        }
        if (amount == 0) {
            this.handle = null;
        } else {
            this.handle.a = amount;
        }
    }

    public void setDurability(short durability) {
        if (this.handle != null) {
            this.handle.b(durability);
        }
    }

    public short getDurability() {
        if (this.handle != null) {
            return (short)this.handle.j();
        }
        return -1;
    }

    public int getMaxStackSize() {
        return this.handle == null ? Material.AIR.getMaxStackSize() : this.handle.b().k();
    }

    public void addUnsafeEnchantment(Enchantment ench, int level) {
        Validate.notNull((Object)ench, (String)"Cannot add null enchantment");
        if (!CraftItemStack.makeTag(this.handle)) {
            return;
        }
        by list = CraftItemStack.getEnchantmentList(this.handle);
        if (list == null) {
            list = new by(CraftMetaItem.ENCHANTMENTS.NBT);
            this.handle.d.a(CraftMetaItem.ENCHANTMENTS.NBT, list);
        }
        int size = list.c();
        for (int i2 = 0; i2 < size; ++i2) {
            bq tag = (bq)list.b(i2);
            short id2 = tag.d(CraftMetaItem.ENCHANTMENTS_ID.NBT);
            if (id2 != ench.getId()) continue;
            tag.a(CraftMetaItem.ENCHANTMENTS_LVL.NBT, (short)level);
            return;
        }
        bq tag = new bq();
        tag.a(CraftMetaItem.ENCHANTMENTS_ID.NBT, (short)ench.getId());
        tag.a(CraftMetaItem.ENCHANTMENTS_LVL.NBT, (short)level);
        list.a(tag);
    }

    static boolean makeTag(ur item) {
        if (item == null) {
            return false;
        }
        if (item.d != null) {
            return true;
        }
        item.d = new bq();
        return true;
    }

    public boolean containsEnchantment(Enchantment ench) {
        return this.getEnchantmentLevel(ench) > 0;
    }

    public int getEnchantmentLevel(Enchantment ench) {
        Validate.notNull((Object)ench, (String)"Cannot find null enchantment");
        if (this.handle == null) {
            return 0;
        }
        return xe.a(ench.getId(), this.handle);
    }

    public int removeEnchantment(Enchantment ench) {
        int i2;
        Validate.notNull((Object)ench, (String)"Cannot remove null enchantment");
        by list = CraftItemStack.getEnchantmentList(this.handle);
        if (list == null) {
            return 0;
        }
        int index = Integer.MIN_VALUE;
        int level = Integer.MIN_VALUE;
        int size = list.c();
        for (i2 = 0; i2 < size; ++i2) {
            bq enchantment = (bq)list.b(i2);
            int id2 = 0xFFFF & enchantment.d(CraftMetaItem.ENCHANTMENTS_ID.NBT);
            if (id2 != ench.getId()) continue;
            index = i2;
            level = 0xFFFF & enchantment.d(CraftMetaItem.ENCHANTMENTS_LVL.NBT);
            break;
        }
        if (index == Integer.MIN_VALUE) {
            return 0;
        }
        if (size == 1) {
            this.handle.d.o(CraftMetaItem.ENCHANTMENTS.NBT);
            if (this.handle.d.d()) {
                this.handle.d = null;
            }
            return level;
        }
        by listCopy = new by(CraftMetaItem.ENCHANTMENTS.NBT);
        for (i2 = 0; i2 < size; ++i2) {
            if (i2 == index) continue;
            listCopy.a(list.b(i2));
        }
        this.handle.d.a(CraftMetaItem.ENCHANTMENTS.NBT, listCopy);
        return level;
    }

    public Map<Enchantment, Integer> getEnchantments() {
        return CraftItemStack.getEnchantments(this.handle);
    }

    static Map<Enchantment, Integer> getEnchantments(ur item) {
        by list;
        ImmutableMap.Builder result = ImmutableMap.builder();
        by by2 = list = item == null ? null : item.q();
        if (list == null) {
            return result.build();
        }
        for (int i2 = 0; i2 < list.c(); ++i2) {
            int id2 = 0xFFFF & ((bq)list.b(i2)).d(CraftMetaItem.ENCHANTMENTS_ID.NBT);
            int level = 0xFFFF & ((bq)list.b(i2)).d(CraftMetaItem.ENCHANTMENTS_LVL.NBT);
            result.put((Object)Enchantment.getById((int)id2), (Object)level);
        }
        return result.build();
    }

    static by getEnchantmentList(ur item) {
        return item == null ? null : item.q();
    }

    public CraftItemStack clone() {
        CraftItemStack itemStack = (CraftItemStack)super.clone();
        if (this.handle != null) {
            itemStack.handle = this.handle.l();
        }
        return itemStack;
    }

    public ItemMeta getItemMeta() {
        return CraftItemStack.getItemMeta(this.handle);
    }

    static ItemMeta getItemMeta(ur item) {
        if (!CraftItemStack.hasItemMeta(item)) {
            return CraftItemFactory.instance().getItemMeta(CraftItemStack.getType(item));
        }
        switch (CraftItemStack.getType(item)) {
            case WRITTEN_BOOK: 
            case BOOK_AND_QUILL: {
                return new CraftMetaBook(item.d);
            }
            case SKULL_ITEM: {
                return new CraftMetaSkull(item.d);
            }
            case LEATHER_HELMET: 
            case LEATHER_CHESTPLATE: 
            case LEATHER_LEGGINGS: 
            case LEATHER_BOOTS: {
                return new CraftMetaLeatherArmor(item.d);
            }
            case POTION: {
                return new CraftMetaPotion(item.d);
            }
            case MAP: {
                return new CraftMetaMap(item.d);
            }
            case FIREWORK: {
                return new CraftMetaFirework(item.d);
            }
            case FIREWORK_CHARGE: {
                return new CraftMetaCharge(item.d);
            }
            case ENCHANTED_BOOK: {
                return new CraftMetaEnchantedBook(item.d);
            }
        }
        return new CraftMetaItem(item.d);
    }

    static Material getType(ur item) {
        Material material = Material.getMaterial(item == null ? 0 : item.c);
        return material == null ? Material.AIR : material;
    }

    public boolean setItemMeta(ItemMeta itemMeta) {
        return CraftItemStack.setItemMeta(this.handle, itemMeta);
    }

    static boolean setItemMeta(ur item, ItemMeta itemMeta) {
        if (item == null) {
            return false;
        }
        if (itemMeta == null) {
            item.d = null;
            return true;
        }
        if (!CraftItemFactory.instance().isApplicable(itemMeta, CraftItemStack.getType(item))) {
            return false;
        }
        bq tag = new bq();
        item.d(tag);
        ((CraftMetaItem)itemMeta).applyToItem(tag);
        return true;
    }

    public boolean isSimilar(ItemStack stack) {
        if (stack == null) {
            return false;
        }
        if (stack == this) {
            return true;
        }
        if (!(stack instanceof CraftItemStack)) {
            return stack.getClass() == ItemStack.class && stack.isSimilar((ItemStack)this);
        }
        CraftItemStack that = (CraftItemStack)stack;
        if (this.handle == that.handle) {
            return true;
        }
        if (this.handle == null || that.handle == null) {
            return false;
        }
        if (that.getTypeId() != this.getTypeId() || this.getDurability() != that.getDurability()) {
            return false;
        }
        return this.hasItemMeta() ? that.hasItemMeta() && this.handle.d.equals(that.handle.d) : !that.hasItemMeta();
    }

    public boolean hasItemMeta() {
        return CraftItemStack.hasItemMeta(this.handle);
    }

    static boolean hasItemMeta(ur item) {
        return item != null && item.d != null && !item.d.d();
    }
}

