/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.inventory;

import org.bukkit.craftbukkit.entity.CraftPlayer;
import org.bukkit.craftbukkit.inventory.CraftInventory;
import org.bukkit.entity.HumanEntity;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryView;

public class CraftContainer
extends rq {
    private final InventoryView view;
    private InventoryType cachedType;
    private String cachedTitle;
    private final int cachedSize;

    public CraftContainer(InventoryView view, int id2) {
        this.view = view;
        this.d = id2;
        la top = ((CraftInventory)view.getTopInventory()).getInventory();
        la bottom = ((CraftInventory)view.getBottomInventory()).getInventory();
        this.cachedType = view.getType();
        this.cachedTitle = view.getTitle();
        this.cachedSize = this.getSize();
        this.setupSlots(top, bottom);
    }

    public CraftContainer(final Inventory inventory, final HumanEntity player, int id2) {
        this(new InventoryView(){

            public Inventory getTopInventory() {
                return inventory;
            }

            public Inventory getBottomInventory() {
                return player.getInventory();
            }

            public HumanEntity getPlayer() {
                return player;
            }

            public InventoryType getType() {
                return inventory.getType();
            }
        }, id2);
    }

    @Override
    public InventoryView getBukkitView() {
        return this.view;
    }

    private int getSize() {
        return this.view.getTopInventory().getSize();
    }

    @Override
    public boolean c(qx entityhuman) {
        if (this.cachedType == this.view.getType() && this.cachedSize == this.getSize() && this.cachedTitle.equals(this.view.getTitle())) {
            return true;
        }
        boolean typeChanged = this.cachedType != this.view.getType();
        this.cachedType = this.view.getType();
        this.cachedTitle = this.view.getTitle();
        if (this.view.getPlayer() instanceof CraftPlayer) {
            CraftPlayer player = (CraftPlayer)this.view.getPlayer();
            int type = CraftContainer.getNotchInventoryType(this.cachedType);
            la top = ((CraftInventory)this.view.getTopInventory()).getInventory();
            la bottom = ((CraftInventory)this.view.getBottomInventory()).getInventory();
            this.b.clear();
            this.c.clear();
            if (typeChanged) {
                this.setupSlots(top, bottom);
            }
            int size = this.getSize();
            player.getHandle().a.b(new de(this.d, type, this.cachedTitle, size));
            player.updateInventory();
        }
        return true;
    }

    public static int getNotchInventoryType(InventoryType type) {
        int typeID;
        switch (type) {
            case WORKBENCH: {
                typeID = 1;
                break;
            }
            case FURNACE: {
                typeID = 2;
                break;
            }
            case DISPENSER: {
                typeID = 3;
                break;
            }
            case ENCHANTING: {
                typeID = 4;
                break;
            }
            case BREWING: {
                typeID = 5;
                break;
            }
            case BEACON: {
                typeID = 7;
                break;
            }
            case ANVIL: {
                typeID = 8;
                break;
            }
            default: {
                typeID = 0;
            }
        }
        return typeID;
    }

    private void setupSlots(la top, la bottom) {
        switch (this.cachedType) {
            case CREATIVE: {
                break;
            }
            case PLAYER: 
            case CHEST: {
                this.setupChest(top, bottom);
                break;
            }
            case DISPENSER: {
                this.setupDispenser(top, bottom);
                break;
            }
            case FURNACE: {
                this.setupFurnace(top, bottom);
                break;
            }
            case WORKBENCH: 
            case CRAFTING: {
                this.setupWorkbench(top, bottom);
                break;
            }
            case ENCHANTING: {
                this.setupEnchanting(top, bottom);
                break;
            }
            case BREWING: {
                this.setupBrewing(top, bottom);
            }
        }
    }

    private void setupChest(la top, la bottom) {
        int col;
        int row;
        int rows = top.k_() / 9;
        int i2 = (rows - 4) * 18;
        for (row = 0; row < rows; ++row) {
            for (col = 0; col < 9; ++col) {
                this.a(new sr(top, col + row * 9, 8 + col * 18, 18 + row * 18));
            }
        }
        for (row = 0; row < 3; ++row) {
            for (col = 0; col < 9; ++col) {
                this.a(new sr(bottom, col + row * 9 + 9, 8 + col * 18, 103 + row * 18 + i2));
            }
        }
        for (col = 0; col < 9; ++col) {
            this.a(new sr(bottom, col, 8 + col * 18, 161 + i2));
        }
    }

    private void setupWorkbench(la top, la bottom) {
        int col;
        int row;
        this.a(new sr(top, 0, 124, 35));
        for (row = 0; row < 3; ++row) {
            for (col = 0; col < 3; ++col) {
                this.a(new sr(top, 1 + col + row * 3, 30 + col * 18, 17 + row * 18));
            }
        }
        for (row = 0; row < 3; ++row) {
            for (col = 0; col < 9; ++col) {
                this.a(new sr(bottom, col + row * 9 + 9, 8 + col * 18, 84 + row * 18));
            }
        }
        for (col = 0; col < 9; ++col) {
            this.a(new sr(bottom, col, 8 + col * 18, 142));
        }
    }

    private void setupFurnace(la top, la bottom) {
        int col;
        this.a(new sr(top, 0, 56, 17));
        this.a(new sr(top, 1, 56, 53));
        this.a(new sr(top, 2, 116, 35));
        for (int row = 0; row < 3; ++row) {
            for (col = 0; col < 9; ++col) {
                this.a(new sr(bottom, col + row * 9 + 9, 8 + col * 18, 84 + row * 18));
            }
        }
        for (col = 0; col < 9; ++col) {
            this.a(new sr(bottom, col, 8 + col * 18, 142));
        }
    }

    private void setupDispenser(la top, la bottom) {
        int col;
        int row;
        for (row = 0; row < 3; ++row) {
            for (col = 0; col < 3; ++col) {
                this.a(new sr(top, col + row * 3, 61 + col * 18, 17 + row * 18));
            }
        }
        for (row = 0; row < 3; ++row) {
            for (col = 0; col < 9; ++col) {
                this.a(new sr(bottom, col + row * 9 + 9, 8 + col * 18, 84 + row * 18));
            }
        }
        for (col = 0; col < 9; ++col) {
            this.a(new sr(bottom, col, 8 + col * 18, 142));
        }
    }

    private void setupEnchanting(la top, la bottom) {
        int row;
        this.a(new sr(top, 0, 25, 47));
        for (row = 0; row < 3; ++row) {
            for (int i1 = 0; i1 < 9; ++i1) {
                this.a(new sr(bottom, i1 + row * 9 + 9, 8 + i1 * 18, 84 + row * 18));
            }
        }
        for (row = 0; row < 9; ++row) {
            this.a(new sr(bottom, row, 8 + row * 18, 142));
        }
    }

    private void setupBrewing(la top, la bottom) {
        int i2;
        this.a(new sr(top, 0, 56, 46));
        this.a(new sr(top, 1, 79, 53));
        this.a(new sr(top, 2, 102, 46));
        this.a(new sr(top, 3, 79, 17));
        for (i2 = 0; i2 < 3; ++i2) {
            for (int j2 = 0; j2 < 9; ++j2) {
                this.a(new sr(bottom, j2 + i2 * 9 + 9, 8 + j2 * 18, 84 + i2 * 18));
            }
        }
        for (i2 = 0; i2 < 9; ++i2) {
            this.a(new sr(bottom, i2, 8 + i2 * 18, 142));
        }
    }

    @Override
    public boolean a(qx entity) {
        return true;
    }
}

