/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.generator;

import java.util.List;
import java.util.Random;
import org.bukkit.World;
import org.bukkit.block.Biome;
import org.bukkit.craftbukkit.block.CraftBlock;
import org.bukkit.craftbukkit.generator.InternalChunkGenerator;
import org.bukkit.generator.BlockPopulator;
import org.bukkit.generator.ChunkGenerator;

public class CustomChunkGenerator
extends InternalChunkGenerator {
    private final ChunkGenerator generator;
    private final in world;
    private final Random random;
    private final ady strongholdGen = new ady();

    public CustomChunkGenerator(yc world, long seed, ChunkGenerator generator) {
        this.world = (in)world;
        this.generator = generator;
        this.random = new Random(seed);
    }

    @Override
    public boolean a(int x2, int z2) {
        return true;
    }

    @Override
    public zz d(int x2, int z2) {
        zz chunk;
        this.random.setSeed((long)x2 * 341873128712L + (long)z2 * 132897987541L);
        CustomBiomeGrid biomegrid = new CustomBiomeGrid();
        biomegrid.biome = new yy[256];
        this.world.t().b(biomegrid.biome, x2 << 4, z2 << 4, 16, 16);
        short[][] xbtypes = this.generator.generateExtBlockSections((World)this.world.getWorld(), this.random, x2, z2, (ChunkGenerator.BiomeGrid)biomegrid);
        if (xbtypes != null) {
            chunk = new zz(this.world, x2, z2);
            aaa[] csect = chunk.i();
            int scnt = Math.min(csect.length, xbtypes.length);
            for (int sec = 0; sec < scnt; ++sec) {
                if (xbtypes[sec] == null) continue;
                byte[] secBlkID = new byte[4096];
                byte[] secExtBlkID = null;
                short[] bdata = xbtypes[sec];
                int i2 = 0;
                int j2 = 0;
                while (i2 < bdata.length) {
                    short b1 = bdata[i2];
                    short b2 = bdata[i2 + 1];
                    byte extb = (byte)(b1 >> 8 | b2 >> 4 & 0xF0);
                    secBlkID[i2] = (byte)b1;
                    secBlkID[i2 + 1] = (byte)b2;
                    if (extb != 0) {
                        if (secExtBlkID == null) {
                            secExtBlkID = new byte[2048];
                        }
                        secExtBlkID[j2] = extb;
                    }
                    i2 += 2;
                    ++j2;
                }
                csect[sec] = new aaa(sec << 4, true, secBlkID, secExtBlkID);
            }
        } else {
            byte[][] btypes = this.generator.generateBlockSections((World)this.world.getWorld(), this.random, x2, z2, (ChunkGenerator.BiomeGrid)biomegrid);
            if (btypes != null) {
                chunk = new zz(this.world, x2, z2);
                aaa[] csect = chunk.i();
                int scnt = Math.min(csect.length, btypes.length);
                for (int sec = 0; sec < scnt; ++sec) {
                    if (btypes[sec] == null) continue;
                    csect[sec] = new aaa(sec << 4, true, btypes[sec], null);
                }
            } else {
                byte[] types = this.generator.generate((World)this.world.getWorld(), this.random, x2, z2);
                int ydim = types.length / 256;
                int scnt = ydim / 16;
                chunk = new zz(this.world, x2, z2);
                aaa[] csect = chunk.i();
                scnt = Math.min(scnt, csect.length);
                for (int sec = 0; sec < scnt; ++sec) {
                    aaa cs2 = null;
                    byte[] csbytes = null;
                    for (int cy2 = 0; cy2 < 16; ++cy2) {
                        int cyoff = cy2 | sec << 4;
                        for (int cx2 = 0; cx2 < 16; ++cx2) {
                            int cxyoff = cx2 * ydim * 16 + cyoff;
                            for (int cz2 = 0; cz2 < 16; ++cz2) {
                                byte blk = types[cxyoff + cz2 * ydim];
                                if (blk == 0) continue;
                                if (cs2 == null) {
                                    cs2 = csect[sec] = new aaa(sec << 4, true);
                                    csbytes = cs2.g();
                                }
                                csbytes[cy2 << 8 | cz2 << 4 | cx2] = blk;
                            }
                        }
                    }
                    if (cs2 == null) continue;
                    cs2.d();
                }
            }
        }
        byte[] biomeIndex = chunk.m();
        for (int i3 = 0; i3 < biomeIndex.length; ++i3) {
            biomeIndex[i3] = (byte)(biomegrid.biome[i3].N & 0xFF);
        }
        chunk.b();
        return chunk;
    }

    @Override
    public void a(zw icp, int i2, int i1) {
    }

    @Override
    public boolean a(boolean bln, kj ipu) {
        return true;
    }

    @Override
    public boolean b() {
        return false;
    }

    @Override
    public boolean c() {
        return true;
    }

    public byte[] generate(World world, Random random, int x2, int z2) {
        return this.generator.generate(world, random, x2, z2);
    }

    public byte[][] generateBlockSections(World world, Random random, int x2, int z2, ChunkGenerator.BiomeGrid biomes) {
        return this.generator.generateBlockSections(world, random, x2, z2, biomes);
    }

    public short[][] generateExtBlockSections(World world, Random random, int x2, int z2, ChunkGenerator.BiomeGrid biomes) {
        return this.generator.generateExtBlockSections(world, random, x2, z2, biomes);
    }

    @Override
    public zz c(int x2, int z2) {
        return this.d(x2, z2);
    }

    public boolean canSpawn(World world, int x2, int z2) {
        return this.generator.canSpawn(world, x2, z2);
    }

    public List<BlockPopulator> getDefaultPopulators(World world) {
        return this.generator.getDefaultPopulators(world);
    }

    public List<?> getMobsFor(me type, int x2, int y2, int z2) {
        yy biomebase = this.world.a(x2, z2);
        return biomebase == null ? null : biomebase.a(type);
    }

    @Override
    public yv a(yc world, String type, int x2, int y2, int z2) {
        return "Stronghold".equals(type) && this.strongholdGen != null ? this.strongholdGen.a(world, x2, y2, z2) : null;
    }

    @Override
    public void e(int i2, int j2) {
    }

    @Override
    public int e() {
        return 0;
    }

    @Override
    public String d() {
        return "CustomChunkGenerator";
    }

    @Override
    public List a(me var1, int var2, int var3, int var4) {
        return null;
    }

    private static class CustomBiomeGrid
    implements ChunkGenerator.BiomeGrid {
        yy[] biome;

        private CustomBiomeGrid() {
        }

        public Biome getBiome(int x2, int z2) {
            return CraftBlock.biomeBaseToBiome(this.biome[z2 << 4 | x2]);
        }

        public void setBiome(int x2, int z2, Biome bio) {
            this.biome[z2 << 4 | x2] = CraftBlock.biomeToBiomeBase(bio);
        }
    }
}

