/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.entity;

import guava10.com.google.common.collect.ImmutableSet;
import guava10.com.google.common.collect.MapMaker;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang.NotImplementedException;
import org.apache.commons.lang.Validate;
import org.bukkit.Achievement;
import org.bukkit.Bukkit;
import org.bukkit.Effect;
import org.bukkit.GameMode;
import org.bukkit.Instrument;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Note;
import org.bukkit.OfflinePlayer;
import org.bukkit.Sound;
import org.bukkit.Statistic;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.serialization.DelegateDeserialization;
import org.bukkit.conversations.Conversation;
import org.bukkit.conversations.ConversationAbandonedEvent;
import org.bukkit.conversations.ConversationCanceller;
import org.bukkit.conversations.ManuallyAbandonedConversationCanceller;
import org.bukkit.craftbukkit.CraftEffect;
import org.bukkit.craftbukkit.CraftOfflinePlayer;
import org.bukkit.craftbukkit.CraftServer;
import org.bukkit.craftbukkit.CraftSound;
import org.bukkit.craftbukkit.CraftWorld;
import org.bukkit.craftbukkit.conversations.ConversationTracker;
import org.bukkit.craftbukkit.entity.CraftHumanEntity;
import org.bukkit.craftbukkit.map.CraftMapView;
import org.bukkit.craftbukkit.map.RenderData;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.player.PlayerGameModeChangeEvent;
import org.bukkit.event.player.PlayerRegisterChannelEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.event.player.PlayerUnregisterChannelEvent;
import org.bukkit.inventory.InventoryView;
import org.bukkit.map.MapView;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.messaging.Messenger;
import org.bukkit.plugin.messaging.StandardMessenger;

@DelegateDeserialization(value=CraftOfflinePlayer.class)
public class CraftPlayer
extends CraftHumanEntity
implements Player {
    private long firstPlayed = 0L;
    private long lastPlayed = 0L;
    private boolean hasPlayedBefore = false;
    private final ConversationTracker conversationTracker = new ConversationTracker();
    private final Set<String> channels = new HashSet<String>();
    private final Map<String, Player> hiddenPlayers = new MapMaker().softValues().makeMap();
    private int hash = 0;

    public CraftPlayer(CraftServer server, iq entity) {
        super(server, entity);
        this.firstPlayed = System.currentTimeMillis();
    }

    @Override
    public boolean isOp() {
        return this.server.getHandle().e(this.getName());
    }

    @Override
    public void setOp(boolean value) {
        if (value == this.isOp()) {
            return;
        }
        if (value) {
            this.server.getHandle().b(this.getName());
        } else {
            this.server.getHandle().c(this.getName());
        }
        this.perm.recalculatePermissions();
    }

    public boolean isOnline() {
        for (Object obj : this.server.getHandle().b) {
            iq player = (iq)obj;
            if (!player.bR.equalsIgnoreCase(this.getName())) continue;
            return true;
        }
        return false;
    }

    public InetSocketAddress getAddress() {
        if (this.getHandle().a == null) {
            return null;
        }
        SocketAddress addr = this.getHandle().a.b.c();
        if (addr instanceof InetSocketAddress) {
            return (InetSocketAddress)addr;
        }
        return null;
    }

    @Override
    public double getEyeHeight() {
        return this.getEyeHeight(false);
    }

    @Override
    public double getEyeHeight(boolean ignoreSneaking) {
        if (ignoreSneaking) {
            return 1.62;
        }
        if (this.isSneaking()) {
            return 1.54;
        }
        return 1.62;
    }

    public void sendRawMessage(String message) {
        if (this.getHandle().a == null) {
            return;
        }
        this.getHandle().a.b(new cu(message));
    }

    public void sendMessage(String message) {
        if (!this.conversationTracker.isConversingModaly()) {
            this.sendRawMessage(message);
        }
    }

    public void sendMessage(String[] messages) {
        for (String message : messages) {
            this.sendMessage(message);
        }
    }

    public String getDisplayName() {
        return this.getHandle().displayName;
    }

    public void setDisplayName(String name) {
        this.getHandle().displayName = name;
    }

    public String getPlayerListName() {
        return this.getHandle().listName;
    }

    public void setPlayerListName(String name) {
        String oldName = this.getHandle().listName;
        if (name == null) {
            name = this.getName();
        }
        if (oldName.equals(name)) {
            return;
        }
        if (name.length() > 16) {
            throw new IllegalArgumentException("Player list names can only be a maximum of 16 characters long");
        }
        for (int i2 = 0; i2 < this.server.getHandle().b.size(); ++i2) {
            if (!((iq)this.server.getHandle().b.get((int)i2)).listName.equals(name)) continue;
            throw new IllegalArgumentException(name + " is already assigned as a player list name for someone");
        }
        this.getHandle().listName = name;
        ek oldpacket = new ek(oldName, false, 9999);
        ek packet = new ek(name, true, this.getHandle().i);
        for (int i3 = 0; i3 < this.server.getHandle().b.size(); ++i3) {
            iq entityplayer = (iq)this.server.getHandle().b.get(i3);
            if (entityplayer.a == null || !entityplayer.getBukkitEntity().canSee(this)) continue;
            entityplayer.a.b(oldpacket);
            entityplayer.a.b(packet);
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof OfflinePlayer)) {
            return false;
        }
        OfflinePlayer other = (OfflinePlayer)obj;
        if (this.getName() == null || other.getName() == null) {
            return false;
        }
        boolean nameEquals = this.getName().equalsIgnoreCase(other.getName());
        boolean idEquals = true;
        if (other instanceof CraftPlayer) {
            idEquals = this.getEntityId() == ((CraftPlayer)other).getEntityId();
        }
        return nameEquals && idEquals;
    }

    public void kickPlayer(String message) {
        this.kickPlayer(message, false);
    }

    public void kickPlayer(String message, boolean async) {
        if (this.getHandle().a == null) {
            return;
        }
        if (!async && !Bukkit.isPrimaryThread()) {
            throw new IllegalStateException("Cannot kick player from asynchronous thread!");
        }
        this.getHandle().a.c(message == null ? "" : message);
    }

    public void setCompassTarget(Location loc) {
        if (this.getHandle().a == null) {
            return;
        }
        this.getHandle().a.b(new ez(loc.getBlockX(), loc.getBlockY(), loc.getBlockZ()));
    }

    public Location getCompassTarget() {
        return this.getHandle().compassTarget;
    }

    public void chat(String msg) {
        if (this.getHandle().a == null) {
            return;
        }
        this.getHandle().a.chat(msg, false);
    }

    public boolean performCommand(String command) {
        return this.server.dispatchCommand((CommandSender)this, command);
    }

    public void playNote(Location loc, byte instrument, byte note) {
        if (this.getHandle().a == null) {
            return;
        }
        int id2 = this.getHandle().p.a(loc.getBlockX(), loc.getBlockY(), loc.getBlockZ());
        this.getHandle().a.b(new fh(loc.getBlockX(), loc.getBlockY(), loc.getBlockZ(), id2, instrument, note));
    }

    public void playNote(Location loc, Instrument instrument, Note note) {
        if (this.getHandle().a == null) {
            return;
        }
        int id2 = this.getHandle().p.a(loc.getBlockX(), loc.getBlockY(), loc.getBlockZ());
        this.getHandle().a.b(new fh(loc.getBlockX(), loc.getBlockY(), loc.getBlockZ(), id2, instrument.getType(), note.getId()));
    }

    public void playSound(Location loc, Sound sound, float volume, float pitch) {
        if (loc == null || sound == null || this.getHandle().a == null) {
            return;
        }
        double x2 = (double)loc.getBlockX() + 0.5;
        double y2 = (double)loc.getBlockY() + 0.5;
        double z2 = (double)loc.getBlockZ() + 0.5;
        dv packet = new dv(CraftSound.getSound(sound), x2, y2, z2, volume, pitch);
        this.getHandle().a.b(packet);
    }

    public void playEffect(Location loc, Effect effect, int data) {
        if (this.getHandle().a == null) {
            return;
        }
        int packetData = effect.getId();
        du packet = new du(packetData, loc.getBlockX(), loc.getBlockY(), loc.getBlockZ(), data, false);
        this.getHandle().a.b(packet);
    }

    public <T> void playEffect(Location loc, Effect effect, T data) {
        if (data != null) {
            Validate.isTrue((boolean)data.getClass().equals(effect.getData()), (String)"Wrong kind of data for this effect!");
        } else {
            Validate.isTrue((effect.getData() == null ? 1 : 0) != 0, (String)"Wrong kind of data for this effect!");
        }
        int datavalue = data == null ? 0 : CraftEffect.getDataValue(effect, data);
        this.playEffect(loc, effect, datavalue);
    }

    public void sendBlockChange(Location loc, Material material, byte data) {
        this.sendBlockChange(loc, material.getId(), data);
    }

    public void sendBlockChange(Location loc, int material, byte data) {
        if (this.getHandle().a == null) {
            return;
        }
        fi packet = new fi(loc.getBlockX(), loc.getBlockY(), loc.getBlockZ(), ((CraftWorld)loc.getWorld()).getHandle());
        packet.d = material;
        packet.e = data;
        this.getHandle().a.b(packet);
    }

    public boolean sendChunkChange(Location loc, int sx2, int sy2, int sz2, byte[] data) {
        if (this.getHandle().a == null) {
            return false;
        }
        throw new NotImplementedException("Chunk changes do not yet work");
    }

    public void sendMap(MapView map) {
        if (this.getHandle().a == null) {
            return;
        }
        RenderData data = ((CraftMapView)map).render(this);
        for (int x2 = 0; x2 < 128; ++x2) {
            byte[] bytes = new byte[131];
            bytes[1] = (byte)x2;
            for (int y2 = 0; y2 < 128; ++y2) {
                bytes[y2 + 3] = data.buffer[y2 * 128 + x2];
            }
            cz packet = new cz((short)Material.MAP.getId(), map.getId(), bytes);
            this.getHandle().a.b(packet);
        }
    }

    @Override
    public boolean teleport(Location location, PlayerTeleportEvent.TeleportCause cause) {
        iq entity = this.getHandle();
        if (this.getHealth() == 0 || entity.L) {
            return false;
        }
        if (entity.a == null || entity.a.c) {
            return false;
        }
        if (entity.o != null || entity.n != null) {
            return false;
        }
        Location from = this.getLocation();
        Location to2 = location;
        PlayerTeleportEvent event = new PlayerTeleportEvent((Player)this, from, to2, cause);
        this.server.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return false;
        }
        from = event.getFrom();
        to2 = event.getTo();
        in fromWorld = ((CraftWorld)from.getWorld()).getHandle();
        in toWorld = ((CraftWorld)to2.getWorld()).getHandle();
        if (this.getHandle().bL != this.getHandle().bK) {
            this.getHandle().i();
        }
        if (fromWorld == toWorld) {
            entity.a.teleport(to2);
        } else {
            if (cause == PlayerTeleportEvent.TeleportCause.PLUGIN) {
                this.server.getHandle().p().ad().bukkitPluginTeleport = true;
            }
            this.server.getHandle().moveToWorld(entity, toWorld.dimension, true, to2, true);
        }
        return true;
    }

    public void setSneaking(boolean sneak) {
        this.getHandle().a(sneak);
    }

    public boolean isSneaking() {
        return this.getHandle().ah();
    }

    public boolean isSprinting() {
        return this.getHandle().ai();
    }

    public void setSprinting(boolean sprinting) {
        this.getHandle().b(sprinting);
    }

    public void loadData() {
        this.server.getHandle().k.b(this.getHandle());
    }

    public void saveData() {
        this.server.getHandle().k.a(this.getHandle());
    }

    public void updateInventory() {
        this.getHandle().a(this.getHandle().bL);
    }

    public void setSleepingIgnored(boolean isSleeping) {
        this.getHandle().fauxSleeping = isSleeping;
        ((CraftWorld)this.getWorld()).getHandle().checkSleepStatus();
    }

    public boolean isSleepingIgnored() {
        return this.getHandle().fauxSleeping;
    }

    public void awardAchievement(Achievement achievement) {
        this.sendStatistic(achievement.getId(), 1);
    }

    public void incrementStatistic(Statistic statistic) {
        this.incrementStatistic(statistic, 1);
    }

    public void incrementStatistic(Statistic statistic, int amount) {
        this.sendStatistic(statistic.getId(), amount);
    }

    public void incrementStatistic(Statistic statistic, Material material) {
        this.incrementStatistic(statistic, material, 1);
    }

    public void incrementStatistic(Statistic statistic, Material material, int amount) {
        if (!statistic.isSubstatistic()) {
            throw new IllegalArgumentException("Given statistic is not a substatistic");
        }
        if (statistic.isBlock() != material.isBlock()) {
            throw new IllegalArgumentException("Given material is not valid for this substatistic");
        }
        int mat = material.getId();
        if (!material.isBlock()) {
            mat -= 255;
        }
        this.sendStatistic(statistic.getId() + mat, amount);
    }

    private void sendStatistic(int id2, int amount) {
        if (this.getHandle().a == null) {
            return;
        }
        while (amount > 127) {
            this.sendStatistic(id2, 127);
            amount -= 127;
        }
        this.getHandle().a.b(new cs(id2, amount));
    }

    public void setPlayerTime(long time, boolean relative) {
        this.getHandle().timeOffset = time;
        this.getHandle().relativeTime = relative;
    }

    public long getPlayerTimeOffset() {
        return this.getHandle().timeOffset;
    }

    public long getPlayerTime() {
        return this.getHandle().getPlayerTime();
    }

    public boolean isPlayerTimeRelative() {
        return this.getHandle().relativeTime;
    }

    public void resetPlayerTime() {
        this.setPlayerTime(0L, true);
    }

    public boolean isBanned() {
        return this.server.getHandle().e().a(this.getName().toLowerCase());
    }

    public void setBanned(boolean value) {
        if (value) {
            fm entry = new fm(this.getName().toLowerCase());
            this.server.getHandle().e().a(entry);
        } else {
            this.server.getHandle().e().b(this.getName().toLowerCase());
        }
        this.server.getHandle().e().f();
    }

    public boolean isWhitelisted() {
        return this.server.getHandle().h().contains(this.getName().toLowerCase());
    }

    public void setWhitelisted(boolean value) {
        if (value) {
            this.server.getHandle().h(this.getName().toLowerCase());
        } else {
            this.server.getHandle().i(this.getName().toLowerCase());
        }
    }

    @Override
    public void setGameMode(GameMode mode) {
        if (this.getHandle().a == null) {
            return;
        }
        if (mode == null) {
            throw new IllegalArgumentException("Mode cannot be null");
        }
        if (mode != this.getGameMode()) {
            PlayerGameModeChangeEvent event = new PlayerGameModeChangeEvent((Player)this, mode);
            this.server.getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                return;
            }
            this.getHandle().c.a(yl.a(mode.getValue()));
            this.getHandle().a.b(new dn(3, mode.getValue()));
        }
    }

    @Override
    public GameMode getGameMode() {
        return GameMode.getByValue((int)this.getHandle().c.b().a());
    }

    public void giveExp(int exp) {
        this.getHandle().w(exp);
    }

    public void giveExpLevels(int levels) {
        this.getHandle().a(levels);
    }

    public float getExp() {
        return this.getHandle().cg;
    }

    public void setExp(float exp) {
        this.getHandle().cg = exp;
        this.getHandle().co = -1;
    }

    public int getLevel() {
        return this.getHandle().ce;
    }

    public void setLevel(int level) {
        this.getHandle().ce = level;
        this.getHandle().co = -1;
    }

    public int getTotalExperience() {
        return this.getHandle().cf;
    }

    public void setTotalExperience(int exp) {
        this.getHandle().cf = exp;
    }

    public float getExhaustion() {
        return this.getHandle().cc().c;
    }

    public void setExhaustion(float value) {
        this.getHandle().cc().c = value;
    }

    public float getSaturation() {
        return this.getHandle().cc().b;
    }

    public void setSaturation(float value) {
        this.getHandle().cc().b = value;
    }

    public int getFoodLevel() {
        return this.getHandle().cc().a;
    }

    public void setFoodLevel(int value) {
        this.getHandle().cc().a = value;
    }

    public Location getBedSpawnLocation() {
        World world = this.getServer().getWorld(this.getHandle().spawnWorld);
        s bed = this.getHandle().bZ();
        if (world != null && bed != null && (bed = qx.a(((CraftWorld)world).getHandle(), bed, this.getHandle().ca())) != null) {
            return new Location(world, (double)bed.a, (double)bed.b, (double)bed.c);
        }
        return null;
    }

    public void setBedSpawnLocation(Location location) {
        this.setBedSpawnLocation(location, false);
    }

    public void setBedSpawnLocation(Location location, boolean override) {
        if (location == null) {
            this.getHandle().a((s)null, override);
        } else {
            this.getHandle().a(new s(location.getBlockX(), location.getBlockY(), location.getBlockZ()), override);
            this.getHandle().spawnWorld = location.getWorld().getName();
        }
    }

    public void hidePlayer(Player player) {
        Validate.notNull((Object)player, (String)"hidden player cannot be null");
        if (this.getHandle().a == null) {
            return;
        }
        if (this.equals(player)) {
            return;
        }
        if (this.hiddenPlayers.containsKey(player.getName())) {
            return;
        }
        this.hiddenPlayers.put(player.getName(), player);
        ii tracker = ((in)this.entity.p).J;
        iq other = ((CraftPlayer)player).getHandle();
        is entry = (is)tracker.c.a(other.k);
        if (entry != null) {
            entry.c(this.getHandle());
        }
        this.getHandle().a.b(new ek(player.getPlayerListName(), false, 9999));
    }

    public void showPlayer(Player player) {
        Validate.notNull((Object)player, (String)"shown player cannot be null");
        if (this.getHandle().a == null) {
            return;
        }
        if (this.equals(player)) {
            return;
        }
        if (!this.hiddenPlayers.containsKey(player.getName())) {
            return;
        }
        this.hiddenPlayers.remove(player.getName());
        ii tracker = ((in)this.entity.p).J;
        iq other = ((CraftPlayer)player).getHandle();
        is entry = (is)tracker.c.a(other.k);
        if (entry != null && !entry.o.contains(this.getHandle())) {
            entry.b(this.getHandle());
        }
        this.getHandle().a.b(new ek(player.getPlayerListName(), true, this.getHandle().i));
    }

    public boolean canSee(Player player) {
        return !this.hiddenPlayers.containsKey(player.getName());
    }

    public Map<String, Object> serialize() {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        result.put("name", this.getName());
        return result;
    }

    public Player getPlayer() {
        return this;
    }

    @Override
    public iq getHandle() {
        return (iq)this.entity;
    }

    public void setHandle(iq entity) {
        super.setHandle(entity);
    }

    @Override
    public String toString() {
        return "CraftPlayer{name=" + this.getName() + '}';
    }

    @Override
    public int hashCode() {
        if (this.hash == 0 || this.hash == 485) {
            this.hash = 485 + (this.getName() != null ? this.getName().toLowerCase().hashCode() : 0);
        }
        return this.hash;
    }

    public long getFirstPlayed() {
        return this.firstPlayed;
    }

    public long getLastPlayed() {
        return this.lastPlayed;
    }

    public boolean hasPlayedBefore() {
        return this.hasPlayedBefore;
    }

    public void setFirstPlayed(long firstPlayed) {
        this.firstPlayed = firstPlayed;
    }

    public void readExtraData(bq nbttagcompound) {
        this.hasPlayedBefore = true;
        if (nbttagcompound.b("bukkit")) {
            bq data = nbttagcompound.l("bukkit");
            if (data.b("firstPlayed")) {
                this.firstPlayed = data.f("firstPlayed");
                this.lastPlayed = data.f("lastPlayed");
            }
            if (data.b("newExp")) {
                iq handle = this.getHandle();
                handle.newExp = data.e("newExp");
                handle.newTotalExp = data.e("newTotalExp");
                handle.newLevel = data.e("newLevel");
                handle.expToDrop = data.e("expToDrop");
                handle.keepLevel = data.n("keepLevel");
            }
        }
    }

    public void setExtraData(bq nbttagcompound) {
        if (!nbttagcompound.b("bukkit")) {
            nbttagcompound.a("bukkit", new bq());
        }
        bq data = nbttagcompound.l("bukkit");
        iq handle = this.getHandle();
        data.a("newExp", handle.newExp);
        data.a("newTotalExp", handle.newTotalExp);
        data.a("newLevel", handle.newLevel);
        data.a("expToDrop", handle.expToDrop);
        data.a("keepLevel", handle.keepLevel);
        data.a("firstPlayed", this.getFirstPlayed());
        data.a("lastPlayed", System.currentTimeMillis());
    }

    public boolean beginConversation(Conversation conversation) {
        return this.conversationTracker.beginConversation(conversation);
    }

    public void abandonConversation(Conversation conversation) {
        this.conversationTracker.abandonConversation(conversation, new ConversationAbandonedEvent(conversation, (ConversationCanceller)new ManuallyAbandonedConversationCanceller()));
    }

    public void abandonConversation(Conversation conversation, ConversationAbandonedEvent details) {
        this.conversationTracker.abandonConversation(conversation, details);
    }

    public void acceptConversationInput(String input) {
        this.conversationTracker.acceptConversationInput(input);
    }

    public boolean isConversing() {
        return this.conversationTracker.isConversing();
    }

    public void sendPluginMessage(Plugin source, String channel, byte[] message) {
        StandardMessenger.validatePluginMessage((Messenger)this.server.getMessenger(), (Plugin)source, (String)channel, (byte[])message);
        if (this.getHandle().a == null) {
            return;
        }
        if (this.channels.contains(channel)) {
            di packet = new di();
            packet.a = channel;
            packet.b = message.length;
            packet.c = message;
            this.getHandle().a.b(packet);
        }
    }

    public void setTexturePack(String url) {
        Validate.notNull((Object)url, (String)"Texture pack URL cannot be null");
        byte[] message = (url + "\u0000" + "16").getBytes();
        Validate.isTrue((message.length <= 32766 ? 1 : 0) != 0, (String)"Texture pack URL is too long");
        this.getHandle().a.b(new di("MC|TPack", message));
    }

    public void addChannel(String channel) {
        if (this.channels.add(channel)) {
            this.server.getPluginManager().callEvent((Event)new PlayerRegisterChannelEvent((Player)this, channel));
        }
    }

    public void removeChannel(String channel) {
        if (this.channels.remove(channel)) {
            this.server.getPluginManager().callEvent((Event)new PlayerUnregisterChannelEvent((Player)this, channel));
        }
    }

    public Set<String> getListeningPluginChannels() {
        return ImmutableSet.copyOf(this.channels);
    }

    public void sendSupportedChannels() {
        if (this.getHandle().a == null) {
            return;
        }
        Set listening = this.server.getMessenger().getIncomingChannels();
        if (!listening.isEmpty()) {
            di packet = new di();
            packet.a = "REGISTER";
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            for (String channel : listening) {
                try {
                    stream.write(channel.getBytes("UTF8"));
                    stream.write(0);
                }
                catch (IOException ex2) {
                    Logger.getLogger(CraftPlayer.class.getName()).log(Level.SEVERE, "Could not send Plugin Channel REGISTER to " + this.getName(), ex2);
                }
            }
            packet.c = stream.toByteArray();
            packet.b = packet.c.length;
            this.getHandle().a.b(packet);
        }
    }

    @Override
    public EntityType getType() {
        return EntityType.PLAYER;
    }

    @Override
    public void setMetadata(String metadataKey, MetadataValue newMetadataValue) {
        this.server.getPlayerMetadata().setMetadata(this, metadataKey, newMetadataValue);
    }

    @Override
    public List<MetadataValue> getMetadata(String metadataKey) {
        return this.server.getPlayerMetadata().getMetadata(this, metadataKey);
    }

    @Override
    public boolean hasMetadata(String metadataKey) {
        return this.server.getPlayerMetadata().hasMetadata(this, metadataKey);
    }

    @Override
    public void removeMetadata(String metadataKey, Plugin owningPlugin) {
        this.server.getPlayerMetadata().removeMetadata(this, metadataKey, owningPlugin);
    }

    @Override
    public boolean setWindowProperty(InventoryView.Property prop, int value) {
        rq container = this.getHandle().bL;
        if (container.getBukkitView().getType() != prop.getType()) {
            return false;
        }
        this.getHandle().a(container, prop.getId(), value);
        return true;
    }

    public void disconnect(String reason) {
        this.conversationTracker.abandonAllConversations();
        this.perm.clearPermissions();
    }

    public boolean isFlying() {
        return this.getHandle().cd.b;
    }

    public void setFlying(boolean value) {
        if (!this.getAllowFlight() && value) {
            throw new IllegalArgumentException("Cannot make player fly if getAllowFlight() is false");
        }
        this.getHandle().cd.b = value;
        this.getHandle().o();
    }

    public boolean getAllowFlight() {
        return this.getHandle().cd.c;
    }

    public void setAllowFlight(boolean value) {
        if (this.isFlying() && !value) {
            this.getHandle().cd.b = false;
        }
        this.getHandle().cd.c = value;
        this.getHandle().o();
    }

    @Override
    public int getNoDamageTicks() {
        if (this.getHandle().cp > 0) {
            return Math.max(this.getHandle().cp, this.getHandle().ae);
        }
        return this.getHandle().ae;
    }

    public void setFlySpeed(float value) {
        this.validateSpeed(value);
        iq player = this.getHandle();
        player.cd.f = value / 2.0f;
        player.o();
    }

    public void setWalkSpeed(float value) {
        this.validateSpeed(value);
        iq player = this.getHandle();
        player.cd.g = value / 2.0f;
        player.o();
    }

    public float getFlySpeed() {
        return this.getHandle().cd.f * 2.0f;
    }

    public float getWalkSpeed() {
        return this.getHandle().cd.g * 2.0f;
    }

    private void validateSpeed(float value) {
        if (value < 0.0f) {
            if (value < -1.0f) {
                throw new IllegalArgumentException(value + " is too low");
            }
        } else if (value > 1.0f) {
            throw new IllegalArgumentException(value + " is too high");
        }
    }

    @Override
    public void setMaxHealth(int amount) {
        super.setMaxHealth(amount);
        this.getHandle().m();
    }

    @Override
    public void resetMaxHealth() {
        super.resetMaxHealth();
        this.getHandle().m();
    }
}

