/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.entity;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang.Validate;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.craftbukkit.CraftServer;
import org.bukkit.craftbukkit.CraftWorld;
import org.bukkit.craftbukkit.entity.CraftEntity;
import org.bukkit.craftbukkit.entity.CraftHumanEntity;
import org.bukkit.craftbukkit.inventory.CraftEntityEquipment;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Egg;
import org.bukkit.entity.EnderPearl;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Fireball;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.SmallFireball;
import org.bukkit.entity.Snowball;
import org.bukkit.entity.WitherSkull;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.util.BlockIterator;
import org.bukkit.util.Vector;

public class CraftLivingEntity
extends CraftEntity
implements LivingEntity {
    private CraftEntityEquipment equipment;

    public CraftLivingEntity(CraftServer server, md entity) {
        super(server, entity);
        if (!(this instanceof HumanEntity)) {
            this.equipment = new CraftEntityEquipment(this);
        }
    }

    public int getHealth() {
        return Math.min(Math.max(0, this.getHandle().aU()), this.getMaxHealth());
    }

    public void setHealth(int health) {
        if (health < 0 || health > this.getMaxHealth()) {
            throw new IllegalArgumentException("Health must be between 0 and " + this.getMaxHealth());
        }
        if (this.entity instanceof iq && health == 0) {
            ((iq)this.entity).a(lh.j);
        }
        this.getHandle().j(health);
    }

    public int getMaxHealth() {
        return this.getHandle().maxHealth;
    }

    public void setMaxHealth(int amount) {
        Validate.isTrue((amount > 0 ? 1 : 0) != 0, (String)"Max health must be greater than 0");
        this.getHandle().maxHealth = amount;
        if (this.getHealth() > amount) {
            this.setHealth(amount);
        }
    }

    public void resetMaxHealth() {
        this.setMaxHealth(this.getHandle().aT());
    }

    @Deprecated
    public Egg throwEgg() {
        return this.launchProjectile(Egg.class);
    }

    @Deprecated
    public Snowball throwSnowball() {
        return this.launchProjectile(Snowball.class);
    }

    public double getEyeHeight() {
        return this.getHandle().e();
    }

    public double getEyeHeight(boolean ignoreSneaking) {
        return this.getEyeHeight();
    }

    private List<Block> getLineOfSight(HashSet<Byte> transparent, int maxDistance, int maxLength) {
        if (maxDistance > 120) {
            maxDistance = 120;
        }
        ArrayList<Block> blocks = new ArrayList<Block>();
        BlockIterator itr = new BlockIterator((LivingEntity)this, maxDistance);
        while (itr.hasNext()) {
            Block block = (Block)itr.next();
            blocks.add(block);
            if (maxLength != 0 && blocks.size() > maxLength) {
                blocks.remove(0);
            }
            int id2 = block.getTypeId();
            if (!(transparent == null ? id2 != 0 : !transparent.contains((byte)id2))) continue;
            break;
        }
        return blocks;
    }

    public List<Block> getLineOfSight(HashSet<Byte> transparent, int maxDistance) {
        return this.getLineOfSight(transparent, maxDistance, 0);
    }

    public Block getTargetBlock(HashSet<Byte> transparent, int maxDistance) {
        List<Block> blocks = this.getLineOfSight(transparent, maxDistance, 1);
        return blocks.get(0);
    }

    public List<Block> getLastTwoTargetBlocks(HashSet<Byte> transparent, int maxDistance) {
        return this.getLineOfSight(transparent, maxDistance, 2);
    }

    @Deprecated
    public Arrow shootArrow() {
        return this.launchProjectile(Arrow.class);
    }

    public int getRemainingAir() {
        return this.getHandle().al();
    }

    public void setRemainingAir(int ticks) {
        this.getHandle().f(ticks);
    }

    public int getMaximumAir() {
        return this.getHandle().maxAirTicks;
    }

    public void setMaximumAir(int ticks) {
        this.getHandle().maxAirTicks = ticks;
    }

    public void damage(int amount) {
        this.damage(amount, null);
    }

    public void damage(int amount, Entity source) {
        lh reason = lh.j;
        if (source instanceof HumanEntity) {
            reason = lh.a(((CraftHumanEntity)source).getHandle());
        } else if (source instanceof LivingEntity) {
            reason = lh.a(((CraftLivingEntity)source).getHandle());
        }
        if (this.entity instanceof pp) {
            ((pp)this.entity).e(reason, amount);
        } else {
            this.entity.a(reason, amount);
        }
    }

    public Location getEyeLocation() {
        Location loc = this.getLocation();
        loc.setY(loc.getY() + this.getEyeHeight());
        return loc;
    }

    public int getMaximumNoDamageTicks() {
        return this.getHandle().au;
    }

    public void setMaximumNoDamageTicks(int ticks) {
        this.getHandle().au = ticks;
    }

    public int getLastDamage() {
        return this.getHandle().bA;
    }

    public void setLastDamage(int damage) {
        this.getHandle().bA = damage;
    }

    public int getNoDamageTicks() {
        return this.getHandle().ae;
    }

    public void setNoDamageTicks(int ticks) {
        this.getHandle().ae = ticks;
    }

    @Override
    public md getHandle() {
        return (md)this.entity;
    }

    public void setHandle(md entity) {
        super.setHandle(entity);
    }

    @Override
    public String toString() {
        return "CraftLivingEntity{id=" + this.getEntityId() + '}';
    }

    public Player getKiller() {
        return this.getHandle().bj == null ? null : (Player)this.getHandle().bj.getBukkitEntity();
    }

    public boolean addPotionEffect(PotionEffect effect) {
        return this.addPotionEffect(effect, false);
    }

    public boolean addPotionEffect(PotionEffect effect, boolean force) {
        if (this.hasPotionEffect(effect.getType())) {
            if (!force) {
                return false;
            }
            this.removePotionEffect(effect.getType());
        }
        this.getHandle().d(new lm(effect.getType().getId(), effect.getDuration(), effect.getAmplifier()));
        return true;
    }

    public boolean addPotionEffects(Collection<PotionEffect> effects) {
        boolean success = true;
        for (PotionEffect effect : effects) {
            success &= this.addPotionEffect(effect);
        }
        return success;
    }

    public boolean hasPotionEffect(PotionEffectType type) {
        return this.getHandle().a(ll.a[type.getId()]);
    }

    public void removePotionEffect(PotionEffectType type) {
        this.getHandle().bm.remove(type.getId());
        this.getHandle().h = true;
        if (this.getHandle() instanceof iq) {
            if (((iq)this.getHandle()).a == null) {
                return;
            }
            ((iq)this.getHandle()).a.b(new en(this.getHandle().k, new lm(type.getId(), 0, 0)));
        }
    }

    public Collection<PotionEffect> getActivePotionEffects() {
        ArrayList<PotionEffect> effects = new ArrayList<PotionEffect>();
        for (Object raw : this.getHandle().bm.values()) {
            if (!(raw instanceof lm)) continue;
            lm handle = (lm)raw;
            effects.add(new PotionEffect(PotionEffectType.getById(handle.a()), handle.b(), handle.c()));
        }
        return effects;
    }

    public <T extends Projectile> T launchProjectile(Class<? extends T> projectile) {
        in world = ((CraftWorld)this.getWorld()).getHandle();
        lq launch = null;
        if (Snowball.class.isAssignableFrom(projectile)) {
            launch = new rh(world, this.getHandle());
        } else if (Egg.class.isAssignableFrom(projectile)) {
            launch = new rj(world, this.getHandle());
        } else if (EnderPearl.class.isAssignableFrom(projectile)) {
            launch = new rk(world, this.getHandle());
        } else if (Arrow.class.isAssignableFrom(projectile)) {
            launch = new qz(world, this.getHandle(), 1.0f);
        } else if (Fireball.class.isAssignableFrom(projectile)) {
            Location location = this.getEyeLocation();
            Vector direction = location.getDirection().multiply(10);
            launch = SmallFireball.class.isAssignableFrom(projectile) ? new rg(world, this.getHandle(), direction.getX(), direction.getY(), direction.getZ()) : (WitherSkull.class.isAssignableFrom(projectile) ? new rn(world, this.getHandle(), direction.getX(), direction.getY(), direction.getZ()) : new re(world, this.getHandle(), direction.getX(), direction.getY(), direction.getZ()));
            launch.b(location.getX(), location.getY(), location.getZ(), location.getYaw(), location.getPitch());
        }
        Validate.notNull((Object)launch, (String)"Projectile not supported");
        world.d(launch);
        return (T)((Projectile)launch.getBukkitEntity());
    }

    public EntityType getType() {
        return EntityType.UNKNOWN;
    }

    public boolean hasLineOfSight(Entity other) {
        return this.getHandle().aA().a(((CraftEntity)other).getHandle());
    }

    public boolean getRemoveWhenFarAway() {
        return !this.getHandle().bU;
    }

    public void setRemoveWhenFarAway(boolean remove) {
        this.getHandle().bU = !remove;
    }

    public EntityEquipment getEquipment() {
        return this.equipment;
    }

    public void setCanPickupItems(boolean pickup) {
        this.getHandle().bs = pickup;
    }

    public boolean getCanPickupItems() {
        return this.getHandle().bs;
    }

    @Override
    public boolean teleport(Location location, PlayerTeleportEvent.TeleportCause cause) {
        if (this.getHealth() == 0) {
            return false;
        }
        return super.teleport(location, cause);
    }
}

