/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.entity;

import java.util.Set;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.craftbukkit.CraftServer;
import org.bukkit.craftbukkit.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.entity.CraftPlayer;
import org.bukkit.craftbukkit.event.CraftEventFactory;
import org.bukkit.craftbukkit.inventory.CraftContainer;
import org.bukkit.craftbukkit.inventory.CraftInventory;
import org.bukkit.craftbukkit.inventory.CraftInventoryPlayer;
import org.bukkit.craftbukkit.inventory.CraftInventoryView;
import org.bukkit.craftbukkit.inventory.CraftItemStack;
import org.bukkit.entity.HumanEntity;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.permissions.PermissibleBase;
import org.bukkit.permissions.Permission;
import org.bukkit.permissions.PermissionAttachment;
import org.bukkit.permissions.PermissionAttachmentInfo;
import org.bukkit.permissions.ServerOperator;
import org.bukkit.plugin.Plugin;

public class CraftHumanEntity
extends CraftLivingEntity
implements HumanEntity {
    private CraftInventoryPlayer inventory;
    private final CraftInventory enderChest;
    protected final PermissibleBase perm = new PermissibleBase((ServerOperator)this);
    private boolean op;
    private GameMode mode;

    public CraftHumanEntity(CraftServer server, qx entity) {
        super(server, entity);
        this.mode = server.getDefaultGameMode();
        this.inventory = new CraftInventoryPlayer(entity.bJ);
        this.enderChest = new CraftInventory(entity.ce());
    }

    public String getName() {
        return this.getHandle().bR;
    }

    public PlayerInventory getInventory() {
        return this.inventory;
    }

    @Override
    public EntityEquipment getEquipment() {
        return this.inventory;
    }

    public Inventory getEnderChest() {
        return this.enderChest;
    }

    public ItemStack getItemInHand() {
        return this.getInventory().getItemInHand();
    }

    public void setItemInHand(ItemStack item) {
        this.getInventory().setItemInHand(item);
    }

    public ItemStack getItemOnCursor() {
        return CraftItemStack.asCraftMirror(this.getHandle().bJ.n());
    }

    public void setItemOnCursor(ItemStack item) {
        ur stack = CraftItemStack.asNMSCopy(item);
        this.getHandle().bJ.b(stack);
        if (this instanceof CraftPlayer) {
            ((iq)this.getHandle()).j();
        }
    }

    public boolean isSleeping() {
        return this.getHandle().bZ;
    }

    public int getSleepTicks() {
        return this.getHandle().b;
    }

    public boolean isOp() {
        return this.op;
    }

    public boolean isPermissionSet(String name) {
        return this.perm.isPermissionSet(name);
    }

    public boolean isPermissionSet(Permission perm) {
        return this.perm.isPermissionSet(perm);
    }

    public boolean hasPermission(String name) {
        return this.perm.hasPermission(name);
    }

    public boolean hasPermission(Permission perm) {
        return this.perm.hasPermission(perm);
    }

    public PermissionAttachment addAttachment(Plugin plugin, String name, boolean value) {
        return this.perm.addAttachment(plugin, name, value);
    }

    public PermissionAttachment addAttachment(Plugin plugin) {
        return this.perm.addAttachment(plugin);
    }

    public PermissionAttachment addAttachment(Plugin plugin, String name, boolean value, int ticks) {
        return this.perm.addAttachment(plugin, name, value, ticks);
    }

    public PermissionAttachment addAttachment(Plugin plugin, int ticks) {
        return this.perm.addAttachment(plugin, ticks);
    }

    public void removeAttachment(PermissionAttachment attachment) {
        this.perm.removeAttachment(attachment);
    }

    public void recalculatePermissions() {
        this.perm.recalculatePermissions();
    }

    public void setOp(boolean value) {
        this.op = value;
        this.perm.recalculatePermissions();
    }

    public Set<PermissionAttachmentInfo> getEffectivePermissions() {
        return this.perm.getEffectivePermissions();
    }

    public GameMode getGameMode() {
        return this.mode;
    }

    public void setGameMode(GameMode mode) {
        if (mode == null) {
            throw new IllegalArgumentException("Mode cannot be null");
        }
        this.mode = mode;
    }

    @Override
    public qx getHandle() {
        return (qx)this.entity;
    }

    public void setHandle(qx entity) {
        super.setHandle(entity);
        this.inventory = new CraftInventoryPlayer(entity.bJ);
    }

    @Override
    public String toString() {
        return "CraftHumanEntity{id=" + this.getEntityId() + "name=" + this.getName() + '}';
    }

    public InventoryView getOpenInventory() {
        return this.getHandle().bL.getBukkitView();
    }

    public InventoryView openInventory(Inventory inventory) {
        if (!(this.getHandle() instanceof iq)) {
            return null;
        }
        iq player = (iq)this.getHandle();
        InventoryType type = inventory.getType();
        rq formerContainer = this.getHandle().bL;
        CraftInventory craftinv = (CraftInventory)inventory;
        switch (type) {
            case PLAYER: 
            case CHEST: 
            case ENDER_CHEST: {
                this.getHandle().a(craftinv.getInventory());
                break;
            }
            case DISPENSER: {
                if (craftinv.getInventory() instanceof ano) {
                    this.getHandle().a((ano)craftinv.getInventory());
                    break;
                }
                this.openCustomInventory(inventory, player, 3);
                break;
            }
            case FURNACE: {
                if (craftinv.getInventory() instanceof anr) {
                    this.getHandle().a((anr)craftinv.getInventory());
                    break;
                }
                this.openCustomInventory(inventory, player, 2);
                break;
            }
            case WORKBENCH: {
                this.openCustomInventory(inventory, player, 1);
                break;
            }
            case BREWING: {
                if (craftinv.getInventory() instanceof anl) {
                    this.getHandle().a((anl)craftinv.getInventory());
                    break;
                }
                this.openCustomInventory(inventory, player, 5);
                break;
            }
            case ENCHANTING: {
                this.openCustomInventory(inventory, player, 4);
                break;
            }
            case CREATIVE: 
            case CRAFTING: {
                throw new IllegalArgumentException("Can't open a " + type + " inventory!");
            }
        }
        if (this.getHandle().bL == formerContainer) {
            return null;
        }
        this.getHandle().bL.checkReachable = false;
        return this.getHandle().bL.getBukkitView();
    }

    private void openCustomInventory(Inventory inventory, iq player, int windowType) {
        if (player.a == null) {
            return;
        }
        rq container = new CraftContainer(inventory, this, player.nextContainerCounter());
        if ((container = CraftEventFactory.callInventoryOpenEvent(player, container)) == null) {
            return;
        }
        String title = container.getBukkitView().getTitle();
        int size = container.getBukkitView().getTopInventory().getSize();
        player.a.b(new de(container.d, windowType, title, size));
        this.getHandle().bL = container;
        this.getHandle().bL.a(player);
    }

    public InventoryView openWorkbench(Location location, boolean force) {
        Block block;
        if (!force && (block = location.getBlock()).getType() != Material.WORKBENCH) {
            return null;
        }
        if (location == null) {
            location = this.getLocation();
        }
        this.getHandle().b(location.getBlockX(), location.getBlockY(), location.getBlockZ());
        if (force) {
            this.getHandle().bL.checkReachable = false;
        }
        return this.getHandle().bL.getBukkitView();
    }

    public InventoryView openEnchanting(Location location, boolean force) {
        Block block;
        if (!force && (block = location.getBlock()).getType() != Material.ENCHANTMENT_TABLE) {
            return null;
        }
        if (location == null) {
            location = this.getLocation();
        }
        this.getHandle().c(location.getBlockX(), location.getBlockY(), location.getBlockZ());
        if (force) {
            this.getHandle().bL.checkReachable = false;
        }
        return this.getHandle().bL.getBukkitView();
    }

    public void openInventory(InventoryView inventory) {
        if (!(this.getHandle() instanceof iq)) {
            return;
        }
        if (((iq)this.getHandle()).a == null) {
            return;
        }
        if (this.getHandle().bL != this.getHandle().bK) {
            ((iq)this.getHandle()).a.a(new dd(this.getHandle().bL.d));
        }
        iq player = (iq)this.getHandle();
        rq container = inventory instanceof CraftInventoryView ? ((CraftInventoryView)inventory).getHandle() : new CraftContainer(inventory, player.nextContainerCounter());
        if ((container = CraftEventFactory.callInventoryOpenEvent(player, container)) == null) {
            return;
        }
        InventoryType type = inventory.getType();
        int windowType = CraftContainer.getNotchInventoryType(type);
        String title = inventory.getTitle();
        int size = inventory.getTopInventory().getSize();
        player.a.b(new de(container.d, windowType, title, size));
        player.bL = container;
        player.bL.a(player);
    }

    public void closeInventory() {
        this.getHandle().i();
    }

    public boolean isBlocking() {
        return this.getHandle().bh();
    }

    public boolean setWindowProperty(InventoryView.Property prop, int value) {
        return false;
    }

    public int getExpToLevel() {
        return this.getHandle().cb();
    }
}

