/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.entity;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.bukkit.EntityEffect;
import org.bukkit.Location;
import org.bukkit.Server;
import org.bukkit.World;
import org.bukkit.craftbukkit.CraftServer;
import org.bukkit.craftbukkit.CraftWorld;
import org.bukkit.craftbukkit.entity.CraftAmbient;
import org.bukkit.craftbukkit.entity.CraftAnimals;
import org.bukkit.craftbukkit.entity.CraftArrow;
import org.bukkit.craftbukkit.entity.CraftBat;
import org.bukkit.craftbukkit.entity.CraftBlaze;
import org.bukkit.craftbukkit.entity.CraftBoat;
import org.bukkit.craftbukkit.entity.CraftCaveSpider;
import org.bukkit.craftbukkit.entity.CraftChicken;
import org.bukkit.craftbukkit.entity.CraftComplexPart;
import org.bukkit.craftbukkit.entity.CraftCow;
import org.bukkit.craftbukkit.entity.CraftCreature;
import org.bukkit.craftbukkit.entity.CraftCreeper;
import org.bukkit.craftbukkit.entity.CraftEgg;
import org.bukkit.craftbukkit.entity.CraftEnderCrystal;
import org.bukkit.craftbukkit.entity.CraftEnderDragon;
import org.bukkit.craftbukkit.entity.CraftEnderDragonPart;
import org.bukkit.craftbukkit.entity.CraftEnderPearl;
import org.bukkit.craftbukkit.entity.CraftEnderSignal;
import org.bukkit.craftbukkit.entity.CraftEnderman;
import org.bukkit.craftbukkit.entity.CraftExperienceOrb;
import org.bukkit.craftbukkit.entity.CraftFakePlayer;
import org.bukkit.craftbukkit.entity.CraftFallingSand;
import org.bukkit.craftbukkit.entity.CraftFireball;
import org.bukkit.craftbukkit.entity.CraftFirework;
import org.bukkit.craftbukkit.entity.CraftFish;
import org.bukkit.craftbukkit.entity.CraftFlying;
import org.bukkit.craftbukkit.entity.CraftGhast;
import org.bukkit.craftbukkit.entity.CraftGiant;
import org.bukkit.craftbukkit.entity.CraftGolem;
import org.bukkit.craftbukkit.entity.CraftHanging;
import org.bukkit.craftbukkit.entity.CraftIronGolem;
import org.bukkit.craftbukkit.entity.CraftItem;
import org.bukkit.craftbukkit.entity.CraftItemFrame;
import org.bukkit.craftbukkit.entity.CraftLargeFireball;
import org.bukkit.craftbukkit.entity.CraftLightningStrike;
import org.bukkit.craftbukkit.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.entity.CraftMagmaCube;
import org.bukkit.craftbukkit.entity.CraftMinecart;
import org.bukkit.craftbukkit.entity.CraftMonster;
import org.bukkit.craftbukkit.entity.CraftMushroomCow;
import org.bukkit.craftbukkit.entity.CraftOcelot;
import org.bukkit.craftbukkit.entity.CraftPainting;
import org.bukkit.craftbukkit.entity.CraftPig;
import org.bukkit.craftbukkit.entity.CraftPigZombie;
import org.bukkit.craftbukkit.entity.CraftPlayer;
import org.bukkit.craftbukkit.entity.CraftPoweredMinecart;
import org.bukkit.craftbukkit.entity.CraftProjectile;
import org.bukkit.craftbukkit.entity.CraftSheep;
import org.bukkit.craftbukkit.entity.CraftSilverfish;
import org.bukkit.craftbukkit.entity.CraftSkeleton;
import org.bukkit.craftbukkit.entity.CraftSlime;
import org.bukkit.craftbukkit.entity.CraftSmallFireball;
import org.bukkit.craftbukkit.entity.CraftSnowball;
import org.bukkit.craftbukkit.entity.CraftSnowman;
import org.bukkit.craftbukkit.entity.CraftSpider;
import org.bukkit.craftbukkit.entity.CraftSquid;
import org.bukkit.craftbukkit.entity.CraftStorageMinecart;
import org.bukkit.craftbukkit.entity.CraftTNTPrimed;
import org.bukkit.craftbukkit.entity.CraftTameableAnimal;
import org.bukkit.craftbukkit.entity.CraftThrownExpBottle;
import org.bukkit.craftbukkit.entity.CraftThrownPotion;
import org.bukkit.craftbukkit.entity.CraftVillager;
import org.bukkit.craftbukkit.entity.CraftWaterMob;
import org.bukkit.craftbukkit.entity.CraftWeather;
import org.bukkit.craftbukkit.entity.CraftWitch;
import org.bukkit.craftbukkit.entity.CraftWither;
import org.bukkit.craftbukkit.entity.CraftWitherSkull;
import org.bukkit.craftbukkit.entity.CraftWolf;
import org.bukkit.craftbukkit.entity.CraftZombie;
import org.bukkit.entity.Entity;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public abstract class CraftEntity
implements Entity {
    protected final CraftServer server;
    protected lq entity;
    private EntityDamageEvent lastDamageEvent;
    private static CraftEntity instance;

    public CraftEntity(CraftServer server, lq entity) {
        this.server = server;
        this.entity = entity;
        instance = this;
    }

    public static CraftEntity getEntity(CraftServer server, lq entity) {
        if (entity instanceof md) {
            if (entity instanceof qx) {
                if (entity instanceof iq) {
                    return new CraftPlayer(server, (iq)entity);
                }
                return new CraftFakePlayer(server, CraftFakePlayer.get(entity.p, (qx)entity));
            }
            if (entity instanceof mi) {
                if (entity instanceof ox) {
                    if (entity instanceof oy) {
                        return new CraftChicken(server, (oy)entity);
                    }
                    if (entity instanceof oz) {
                        if (entity instanceof pb) {
                            return new CraftMushroomCow(server, (pb)entity);
                        }
                        return new CraftCow(server, (oz)entity);
                    }
                    if (entity instanceof pd) {
                        return new CraftPig(server, (pd)entity);
                    }
                    if (entity instanceof ml) {
                        if (entity instanceof pk) {
                            return new CraftWolf(server, (pk)entity);
                        }
                        if (entity instanceof pc) {
                            return new CraftOcelot(server, (pc)entity);
                        }
                        return new CraftTameableAnimal(server, (ml)entity);
                    }
                    if (entity instanceof pe) {
                        return new CraftSheep(server, (pe)entity);
                    }
                    return new CraftAnimals(server, (ox)entity);
                }
                if (entity instanceof qj) {
                    if (entity instanceof qr) {
                        if (entity instanceof qk) {
                            return new CraftPigZombie(server, (qk)entity);
                        }
                        return new CraftZombie(server, (qr)entity);
                    }
                    if (entity instanceof qc) {
                        return new CraftCreeper(server, (qc)entity);
                    }
                    if (entity instanceof qd) {
                        return new CraftEnderman(server, (qd)entity);
                    }
                    if (entity instanceof qm) {
                        return new CraftSilverfish(server, (qm)entity);
                    }
                    if (entity instanceof qh) {
                        return new CraftGiant(server, (qh)entity);
                    }
                    if (entity instanceof qn) {
                        return new CraftSkeleton(server, (qn)entity);
                    }
                    if (entity instanceof qa) {
                        return new CraftBlaze(server, (qa)entity);
                    }
                    if (entity instanceof qq) {
                        return new CraftWitch(server, (qq)entity);
                    }
                    if (entity instanceof pr) {
                        return new CraftWither(server, (pr)entity);
                    }
                    if (entity instanceof qp) {
                        if (entity instanceof qb) {
                            return new CraftCaveSpider(server, (qb)entity);
                        }
                        return new CraftSpider(server, (qp)entity);
                    }
                    return new CraftMonster(server, (qj)entity);
                }
                if (entity instanceof pj) {
                    if (entity instanceof ph) {
                        return new CraftSquid(server, (ph)entity);
                    }
                    return new CraftWaterMob(server, (pj)entity);
                }
                if (entity instanceof pa) {
                    if (entity instanceof pg) {
                        return new CraftSnowman(server, (pg)entity);
                    }
                    if (entity instanceof pi) {
                        return new CraftIronGolem(server, (pi)entity);
                    }
                    return new CraftGolem(server, (pa)entity);
                }
                if (entity instanceof qu) {
                    return new CraftVillager(server, (qu)entity);
                }
                return new CraftCreature(server, (mi)entity);
            }
            if (entity instanceof qo) {
                if (entity instanceof qi) {
                    return new CraftMagmaCube(server, (qi)entity);
                }
                return new CraftSlime(server, (qo)entity);
            }
            if (entity instanceof ma) {
                if (entity instanceof qg) {
                    return new CraftGhast(server, (qg)entity);
                }
                return new CraftFlying(server, (ma)entity);
            }
            if (entity instanceof pp) {
                return new CraftEnderDragon(server, (pp)entity);
            }
            if (entity instanceof ov) {
                if (entity instanceof ow) {
                    return new CraftBat(server, (ow)entity);
                }
                return new CraftAmbient(server, (ov)entity);
            }
            return new CraftLivingEntity(server, (md)entity);
        }
        if (entity instanceof pn) {
            pn part = (pn)entity;
            if (part.a instanceof pp) {
                return new CraftEnderDragonPart(server, (pn)entity);
            }
            return new CraftComplexPart(server, (pn)entity);
        }
        if (entity instanceof lz) {
            return new CraftExperienceOrb(server, (lz)entity);
        }
        if (entity instanceof qz) {
            return new CraftArrow(server, (qz)entity);
        }
        if (entity instanceof pv) {
            return new CraftBoat(server, (pv)entity);
        }
        if (entity instanceof ri) {
            if (entity instanceof rj) {
                return new CraftEgg(server, (rj)entity);
            }
            if (entity instanceof rh) {
                return new CraftSnowball(server, (rh)entity);
            }
            if (entity instanceof rm) {
                return new CraftThrownPotion(server, (rm)entity);
            }
            if (entity instanceof rk) {
                return new CraftEnderPearl(server, (rk)entity);
            }
            if (entity instanceof rl) {
                return new CraftThrownExpBottle(server, (rl)entity);
            }
            return new CraftProjectile(server, (ri)entity);
        }
        if (entity instanceof pw) {
            return new CraftFallingSand(server, (pw)entity);
        }
        if (entity instanceof rb) {
            if (entity instanceof rg) {
                return new CraftSmallFireball(server, (rg)entity);
            }
            if (entity instanceof re) {
                return new CraftLargeFireball(server, (re)entity);
            }
            if (entity instanceof rn) {
                return new CraftWitherSkull(server, (rn)entity);
            }
            return new CraftFireball(server, (rb)entity);
        }
        if (entity instanceof ra) {
            return new CraftEnderSignal(server, (ra)entity);
        }
        if (entity instanceof po) {
            return new CraftEnderCrystal(server, (po)entity);
        }
        if (entity instanceof rd) {
            return new CraftFish(server, (rd)entity);
        }
        if (entity instanceof px) {
            return new CraftItem(server, (px)entity);
        }
        if (entity instanceof pt) {
            if (entity instanceof pu) {
                return new CraftLightningStrike(server, (pu)entity);
            }
            return new CraftWeather(server, (pt)entity);
        }
        if (entity instanceof py) {
            py mc2 = (py)entity;
            if (mc2.a == CraftMinecart.Type.StorageMinecart.getId()) {
                return new CraftStorageMinecart(server, mc2);
            }
            if (mc2.a == CraftMinecart.Type.PoweredMinecart.getId()) {
                return new CraftPoweredMinecart(server, mc2);
            }
            return new CraftMinecart(server, mc2);
        }
        if (entity instanceof mb) {
            if (entity instanceof mg) {
                return new CraftPainting(server, (mg)entity);
            }
            if (entity instanceof mc) {
                return new CraftItemFrame(server, (mc)entity);
            }
            return new CraftHanging(server, (mb)entity);
        }
        if (entity instanceof pz) {
            return new CraftTNTPrimed(server, (pz)entity);
        }
        if (entity instanceof rc) {
            return new CraftFirework(server, (rc)entity);
        }
        if (entity instanceof lq) {
            return instance;
        }
        throw new IllegalArgumentException("Unknown entity " + entity);
    }

    public Location getLocation() {
        return new Location(this.getWorld(), this.entity.t, this.entity.u, this.entity.v, this.entity.z, this.entity.A);
    }

    public Location getLocation(Location loc) {
        if (loc != null) {
            loc.setWorld(this.getWorld());
            loc.setX(this.entity.t);
            loc.setY(this.entity.u);
            loc.setZ(this.entity.v);
            loc.setYaw(this.entity.z);
            loc.setPitch(this.entity.A);
        }
        return loc;
    }

    public Vector getVelocity() {
        return new Vector(this.entity.w, this.entity.x, this.entity.y);
    }

    public void setVelocity(Vector vel) {
        this.entity.w = vel.getX();
        this.entity.x = vel.getY();
        this.entity.y = vel.getZ();
        this.entity.I = true;
    }

    public World getWorld() {
        return ((in)this.entity.p).getWorld();
    }

    public boolean teleport(Location location) {
        return this.teleport(location, PlayerTeleportEvent.TeleportCause.PLUGIN);
    }

    public boolean teleport(Location location, PlayerTeleportEvent.TeleportCause cause) {
        if (this.entity.o != null || this.entity.n != null || this.entity.L) {
            return false;
        }
        this.entity.p = ((CraftWorld)location.getWorld()).getHandle();
        this.entity.a(location.getX(), location.getY(), location.getZ(), location.getYaw(), location.getPitch());
        return true;
    }

    public boolean teleport(Entity destination) {
        return this.teleport(destination.getLocation());
    }

    public boolean teleport(Entity destination, PlayerTeleportEvent.TeleportCause cause) {
        return this.teleport(destination.getLocation(), cause);
    }

    public List<Entity> getNearbyEntities(double x2, double y2, double z2) {
        List notchEntityList = this.entity.p.b(this.entity, this.entity.D.b(x2, y2, z2));
        ArrayList<Entity> bukkitEntityList = new ArrayList<Entity>(notchEntityList.size());
        for (lq e2 : notchEntityList) {
            bukkitEntityList.add(e2.getBukkitEntity());
        }
        return bukkitEntityList;
    }

    public int getEntityId() {
        return this.entity.k;
    }

    public int getFireTicks() {
        return this.entity.d;
    }

    public int getMaxFireTicks() {
        return this.entity.ac;
    }

    public void setFireTicks(int ticks) {
        this.entity.d = ticks;
    }

    public void remove() {
        this.entity.L = true;
    }

    public boolean isDead() {
        return !this.entity.S();
    }

    public boolean isValid() {
        return this.entity.S() && this.entity.valid;
    }

    public Server getServer() {
        return this.server;
    }

    public Vector getMomentum() {
        return this.getVelocity();
    }

    public void setMomentum(Vector value) {
        this.setVelocity(value);
    }

    public Entity getPassenger() {
        return this.isEmpty() ? null : this.getHandle().n.getBukkitEntity();
    }

    public boolean setPassenger(Entity passenger) {
        if (passenger instanceof CraftEntity) {
            ((CraftEntity)passenger).getHandle().setPassengerOf(this.getHandle());
            return true;
        }
        return false;
    }

    public boolean isEmpty() {
        return this.getHandle().n == null;
    }

    public boolean eject() {
        if (this.getHandle().n == null) {
            return false;
        }
        this.getHandle().n.setPassengerOf(null);
        return true;
    }

    public float getFallDistance() {
        return this.getHandle().S;
    }

    public void setFallDistance(float distance) {
        this.getHandle().S = distance;
    }

    public void setLastDamageCause(EntityDamageEvent event) {
        this.lastDamageEvent = event;
    }

    public EntityDamageEvent getLastDamageCause() {
        return this.lastDamageEvent;
    }

    public UUID getUniqueId() {
        return this.getHandle().persistentID;
    }

    public int getTicksLived() {
        return this.getHandle().ab;
    }

    public void setTicksLived(int value) {
        if (value <= 0) {
            throw new IllegalArgumentException("Age must be at least 1 tick");
        }
        this.getHandle().ab = value;
    }

    public lq getHandle() {
        return this.entity;
    }

    public void playEffect(EntityEffect type) {
        this.getHandle().p.a(this.getHandle(), type.getData());
    }

    public void setHandle(lq entity) {
        this.entity = entity;
    }

    public String toString() {
        return "CraftEntity{id=" + this.getEntityId() + '}';
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CraftEntity other = (CraftEntity)obj;
        return this.getEntityId() == other.getEntityId();
    }

    public int hashCode() {
        int hash = 7;
        hash = 29 * hash + this.getEntityId();
        return hash;
    }

    public void setMetadata(String metadataKey, MetadataValue newMetadataValue) {
        this.server.getEntityMetadata().setMetadata(this, metadataKey, newMetadataValue);
    }

    public List<MetadataValue> getMetadata(String metadataKey) {
        return this.server.getEntityMetadata().getMetadata(this, metadataKey);
    }

    public boolean hasMetadata(String metadataKey) {
        return this.server.getEntityMetadata().hasMetadata(this, metadataKey);
    }

    public void removeMetadata(String metadataKey, Plugin owningPlugin) {
        this.server.getEntityMetadata().removeMetadata(this, metadataKey, owningPlugin);
    }

    public boolean isInsideVehicle() {
        return this.getHandle().o != null;
    }

    public boolean leaveVehicle() {
        if (this.getHandle().o == null) {
            return false;
        }
        this.getHandle().setPassengerOf(null);
        return true;
    }

    public Entity getVehicle() {
        if (this.getHandle().o == null) {
            return null;
        }
        return this.getHandle().o.getBukkitEntity();
    }
}

