/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.block;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.FMLLog;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.minecraftforge.common.EnumHelper;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Biome;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.PistonMoveReaction;
import org.bukkit.craftbukkit.CraftChunk;
import org.bukkit.craftbukkit.block.CraftBlockState;
import org.bukkit.craftbukkit.block.CraftBrewingStand;
import org.bukkit.craftbukkit.block.CraftChest;
import org.bukkit.craftbukkit.block.CraftCreatureSpawner;
import org.bukkit.craftbukkit.block.CraftDispenser;
import org.bukkit.craftbukkit.block.CraftFurnace;
import org.bukkit.craftbukkit.block.CraftJukebox;
import org.bukkit.craftbukkit.block.CraftNoteBlock;
import org.bukkit.craftbukkit.block.CraftSign;
import org.bukkit.craftbukkit.block.CraftSkull;
import org.bukkit.craftbukkit.inventory.CraftItemStack;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.BlockVector;

public class CraftBlock
implements Block {
    private final CraftChunk chunk;
    private final int x;
    private final int y;
    private final int z;
    private static final Biome[] BIOME_MAPPING;
    private static final yy[] BIOMEBASE_MAPPING;

    public CraftBlock(CraftChunk chunk, int x2, int y2, int z2) {
        this.x = x2;
        this.y = y2;
        this.z = z2;
        this.chunk = chunk;
    }

    public World getWorld() {
        return this.chunk.getWorld();
    }

    public Location getLocation() {
        return new Location(this.getWorld(), (double)this.x, (double)this.y, (double)this.z);
    }

    public Location getLocation(Location loc) {
        if (loc != null) {
            loc.setWorld(this.getWorld());
            loc.setX((double)this.x);
            loc.setY((double)this.y);
            loc.setZ((double)this.z);
            loc.setYaw(0.0f);
            loc.setPitch(0.0f);
        }
        return loc;
    }

    public BlockVector getVector() {
        return new BlockVector(this.x, this.y, this.z);
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getZ() {
        return this.z;
    }

    public Chunk getChunk() {
        return this.chunk;
    }

    public void setData(byte data) {
        this.chunk.getHandle().e.c(this.x, this.y, this.z, (int)data);
    }

    public void setData(byte data, boolean applyPhysics) {
        if (applyPhysics) {
            this.chunk.getHandle().e.c(this.x, this.y, this.z, (int)data);
        } else {
            this.chunk.getHandle().e.d(this.x, this.y, this.z, data);
        }
    }

    public byte getData() {
        return (byte)this.chunk.getHandle().c(this.x & 0xF, this.y & 0xFF, this.z & 0xF);
    }

    public void setType(Material type) {
        this.setTypeId(type.getId());
    }

    public boolean setTypeId(int type) {
        return this.chunk.getHandle().e.e(this.x, this.y, this.z, type);
    }

    public boolean setTypeId(int type, boolean applyPhysics) {
        if (applyPhysics) {
            return this.setTypeId(type);
        }
        return this.chunk.getHandle().e.b(this.x, this.y, this.z, type);
    }

    public boolean setTypeIdAndData(int type, byte data, boolean applyPhysics) {
        if (applyPhysics) {
            return this.chunk.getHandle().e.d(this.x, this.y, this.z, type, data);
        }
        boolean success = this.chunk.getHandle().e.c(this.x, this.y, this.z, type, data);
        if (success) {
            this.chunk.getHandle().e.i(this.x, this.y, this.z);
        }
        return success;
    }

    public Material getType() {
        return Material.getMaterial(this.getTypeId());
    }

    public int getTypeId() {
        return this.chunk.getHandle().a(this.x & 0xF, this.y & 0xFF, this.z & 0xF);
    }

    public byte getLightLevel() {
        return (byte)this.chunk.getHandle().e.m(this.x, this.y, this.z);
    }

    public byte getLightFromSky() {
        return (byte)this.chunk.getHandle().a(yo.a, this.x & 0xF, this.y & 0xFF, this.z & 0xF);
    }

    public byte getLightFromBlocks() {
        return (byte)this.chunk.getHandle().a(yo.b, this.x & 0xF, this.y & 0xFF, this.z & 0xF);
    }

    public Block getFace(BlockFace face) {
        return this.getRelative(face, 1);
    }

    public Block getFace(BlockFace face, int distance) {
        return this.getRelative(face, distance);
    }

    public Block getRelative(int modX, int modY, int modZ) {
        return this.getWorld().getBlockAt(this.getX() + modX, this.getY() + modY, this.getZ() + modZ);
    }

    public Block getRelative(BlockFace face) {
        return this.getRelative(face, 1);
    }

    public Block getRelative(BlockFace face, int distance) {
        return this.getRelative(face.getModX() * distance, face.getModY() * distance, face.getModZ() * distance);
    }

    public BlockFace getFace(Block block) {
        BlockFace[] values;
        for (BlockFace face : values = BlockFace.values()) {
            if (this.getX() + face.getModX() != block.getX() || this.getY() + face.getModY() != block.getY() || this.getZ() + face.getModZ() != block.getZ()) continue;
            return face;
        }
        return null;
    }

    public String toString() {
        return "CraftBlock{chunk=" + this.chunk + ",x=" + this.x + ",y=" + this.y + ",z=" + this.z + ",type=" + (Object)((Object)this.getType()) + ",data=" + this.getData() + '}';
    }

    public static BlockFace notchToBlockFace(int notch) {
        switch (notch) {
            case 0: {
                return BlockFace.DOWN;
            }
            case 1: {
                return BlockFace.UP;
            }
            case 2: {
                return BlockFace.NORTH;
            }
            case 3: {
                return BlockFace.SOUTH;
            }
            case 4: {
                return BlockFace.WEST;
            }
            case 5: {
                return BlockFace.EAST;
            }
        }
        return BlockFace.SELF;
    }

    public static int blockFaceToNotch(BlockFace face) {
        switch (face) {
            case DOWN: {
                return 0;
            }
            case UP: {
                return 1;
            }
            case NORTH: {
                return 2;
            }
            case SOUTH: {
                return 3;
            }
            case WEST: {
                return 4;
            }
            case EAST: {
                return 5;
            }
        }
        return 7;
    }

    public BlockState getState() {
        Material material = this.getType();
        if (material == null) {
            return new CraftBlockState(this);
        }
        switch (material) {
            case SIGN: 
            case SIGN_POST: 
            case WALL_SIGN: {
                return new CraftSign(this);
            }
            case CHEST: {
                return new CraftChest(this);
            }
            case BURNING_FURNACE: 
            case FURNACE: {
                return new CraftFurnace(this);
            }
            case DISPENSER: {
                return new CraftDispenser(this);
            }
            case MOB_SPAWNER: {
                return new CraftCreatureSpawner(this);
            }
            case NOTE_BLOCK: {
                return new CraftNoteBlock(this);
            }
            case JUKEBOX: {
                return new CraftJukebox(this);
            }
            case BREWING_STAND: {
                return new CraftBrewingStand(this);
            }
            case SKULL: {
                return new CraftSkull(this);
            }
        }
        return new CraftBlockState(this);
    }

    public Biome getBiome() {
        return this.getWorld().getBiome(this.x, this.z);
    }

    public void setBiome(Biome bio) {
        this.getWorld().setBiome(this.x, this.z, bio);
    }

    public static Biome biomeBaseToBiome(yy base) {
        if (base == null) {
            return null;
        }
        return BIOME_MAPPING[base.N];
    }

    public static yy biomeToBiomeBase(Biome bio) {
        if (bio == null) {
            return null;
        }
        return BIOMEBASE_MAPPING[bio.ordinal()];
    }

    public double getTemperature() {
        return this.getWorld().getTemperature(this.x, this.z);
    }

    public double getHumidity() {
        return this.getWorld().getHumidity(this.x, this.z);
    }

    public boolean isBlockPowered() {
        return this.chunk.getHandle().e.A(this.x, this.y, this.z);
    }

    public boolean isBlockIndirectlyPowered() {
        return this.chunk.getHandle().e.B(this.x, this.y, this.z);
    }

    public boolean equals(Object o2) {
        if (o2 == this) {
            return true;
        }
        if (!(o2 instanceof CraftBlock)) {
            return false;
        }
        CraftBlock other = (CraftBlock)o2;
        return this.x == other.x && this.y == other.y && this.z == other.z && this.getWorld().equals(other.getWorld());
    }

    public int hashCode() {
        return this.y << 24 ^ this.x ^ this.z ^ this.getWorld().hashCode();
    }

    public boolean isBlockFacePowered(BlockFace face) {
        return this.chunk.getHandle().e.k(this.x, this.y, this.z, CraftBlock.blockFaceToNotch(face));
    }

    public boolean isBlockFaceIndirectlyPowered(BlockFace face) {
        return this.chunk.getHandle().e.l(this.x, this.y, this.z, CraftBlock.blockFaceToNotch(face));
    }

    public int getBlockPower(BlockFace face) {
        int power = 0;
        alv wire = (alv)amq.ay;
        yc world = this.chunk.getHandle().e;
        if ((face == BlockFace.DOWN || face == BlockFace.SELF) && world.k(this.x, this.y - 1, this.z, 0)) {
            power = wire.d(world, this.x, this.y - 1, this.z, power);
        }
        if ((face == BlockFace.UP || face == BlockFace.SELF) && world.k(this.x, this.y + 1, this.z, 1)) {
            power = wire.d(world, this.x, this.y + 1, this.z, power);
        }
        if ((face == BlockFace.EAST || face == BlockFace.SELF) && world.k(this.x + 1, this.y, this.z, 2)) {
            power = wire.d(world, this.x + 1, this.y, this.z, power);
        }
        if ((face == BlockFace.WEST || face == BlockFace.SELF) && world.k(this.x - 1, this.y, this.z, 3)) {
            power = wire.d(world, this.x - 1, this.y, this.z, power);
        }
        if ((face == BlockFace.NORTH || face == BlockFace.SELF) && world.k(this.x, this.y, this.z - 1, 4)) {
            power = wire.d(world, this.x, this.y, this.z - 1, power);
        }
        if ((face == BlockFace.SOUTH || face == BlockFace.SELF) && world.k(this.x, this.y, this.z + 1, 5)) {
            power = wire.d(world, this.x, this.y, this.z - 1, power);
        }
        return power > 0 ? power : ((face == BlockFace.SELF ? this.isBlockIndirectlyPowered() : this.isBlockFaceIndirectlyPowered(face)) ? 15 : 0);
    }

    public int getBlockPower() {
        return this.getBlockPower(BlockFace.SELF);
    }

    public boolean isEmpty() {
        return this.getType() == Material.AIR;
    }

    public boolean isLiquid() {
        return this.getType() == Material.WATER || this.getType() == Material.STATIONARY_WATER || this.getType() == Material.LAVA || this.getType() == Material.STATIONARY_LAVA;
    }

    public PistonMoveReaction getPistonMoveReaction() {
        return PistonMoveReaction.getById((int)amq.p[this.getTypeId()].cB.m());
    }

    private boolean itemCausesDrops(ItemStack item) {
        amq block = amq.p[this.getTypeId()];
        up itemType = item != null ? up.e[item.getTypeId()] : null;
        return block != null && (block.cB.l() || itemType != null && itemType.a(block));
    }

    public boolean breakNaturally() {
        amq block = amq.p[this.getTypeId()];
        byte data = this.getData();
        boolean result = false;
        if (block != null) {
            block.a(this.chunk.getHandle().e, this.x, this.y, this.z, data, 1.0f, 0);
            result = true;
        }
        this.setTypeId(Material.AIR.getId());
        return result;
    }

    public boolean breakNaturally(ItemStack item) {
        if (this.itemCausesDrops(item)) {
            return this.breakNaturally();
        }
        return this.setTypeId(Material.AIR.getId());
    }

    public Collection<ItemStack> getDrops() {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        amq block = amq.p[this.getTypeId()];
        if (block != null) {
            byte data = this.getData();
            int count = block.a(0, this.chunk.getHandle().e.t);
            for (int i2 = 0; i2 < count; ++i2) {
                int item = block.a((int)data, this.chunk.getHandle().e.t, 0);
                if (item <= 0) continue;
                if (amq.cj.cm == this.getTypeId()) {
                    ur nmsStack = new ur(item, 1, block.h(this.chunk.getHandle().e, this.x, this.y, this.z));
                    anw tileentityskull = (anw)this.chunk.getHandle().e.q(this.x, this.y, this.z);
                    if (tileentityskull.a() == 3 && tileentityskull.c() != null && tileentityskull.c().length() > 0) {
                        nmsStack.d(new bq());
                        nmsStack.p().a("SkullOwner", tileentityskull.c());
                    }
                    drops.add(CraftItemStack.asBukkitCopy(nmsStack));
                    continue;
                }
                drops.add(new ItemStack(item, 1, (short)block.b(data)));
            }
        }
        return drops;
    }

    public Collection<ItemStack> getDrops(ItemStack item) {
        if (this.itemCausesDrops(item)) {
            return this.getDrops();
        }
        return Collections.emptyList();
    }

    public void setMetadata(String metadataKey, MetadataValue newMetadataValue) {
        this.chunk.getCraftWorld().getBlockMetadata().setMetadata(this, metadataKey, newMetadataValue);
    }

    public List<MetadataValue> getMetadata(String metadataKey) {
        return this.chunk.getCraftWorld().getBlockMetadata().getMetadata(this, metadataKey);
    }

    public boolean hasMetadata(String metadataKey) {
        return this.chunk.getCraftWorld().getBlockMetadata().hasMetadata(this, metadataKey);
    }

    public void removeMetadata(String metadataKey, Plugin owningPlugin) {
        this.chunk.getCraftWorld().getBlockMetadata().removeMetadata(this, metadataKey, owningPlugin);
    }

    static {
        int i2;
        BIOME_MAPPING = new Biome[yy.a.length];
        BIOMEBASE_MAPPING = new yy[yy.a.length];
        CraftBlock.BIOME_MAPPING[yy.h.N] = Biome.SWAMPLAND;
        CraftBlock.BIOME_MAPPING[yy.f.N] = Biome.FOREST;
        CraftBlock.BIOME_MAPPING[yy.g.N] = Biome.TAIGA;
        CraftBlock.BIOME_MAPPING[yy.d.N] = Biome.DESERT;
        CraftBlock.BIOME_MAPPING[yy.c.N] = Biome.PLAINS;
        CraftBlock.BIOME_MAPPING[yy.j.N] = Biome.HELL;
        CraftBlock.BIOME_MAPPING[yy.k.N] = Biome.SKY;
        CraftBlock.BIOME_MAPPING[yy.i.N] = Biome.RIVER;
        CraftBlock.BIOME_MAPPING[yy.e.N] = Biome.EXTREME_HILLS;
        CraftBlock.BIOME_MAPPING[yy.b.N] = Biome.OCEAN;
        CraftBlock.BIOME_MAPPING[yy.l.N] = Biome.FROZEN_OCEAN;
        CraftBlock.BIOME_MAPPING[yy.m.N] = Biome.FROZEN_RIVER;
        CraftBlock.BIOME_MAPPING[yy.n.N] = Biome.ICE_PLAINS;
        CraftBlock.BIOME_MAPPING[yy.o.N] = Biome.ICE_MOUNTAINS;
        CraftBlock.BIOME_MAPPING[yy.p.N] = Biome.MUSHROOM_ISLAND;
        CraftBlock.BIOME_MAPPING[yy.q.N] = Biome.MUSHROOM_SHORE;
        CraftBlock.BIOME_MAPPING[yy.r.N] = Biome.BEACH;
        CraftBlock.BIOME_MAPPING[yy.s.N] = Biome.DESERT_HILLS;
        CraftBlock.BIOME_MAPPING[yy.t.N] = Biome.FOREST_HILLS;
        CraftBlock.BIOME_MAPPING[yy.u.N] = Biome.TAIGA_HILLS;
        CraftBlock.BIOME_MAPPING[yy.v.N] = Biome.SMALL_MOUNTAINS;
        CraftBlock.BIOME_MAPPING[yy.w.N] = Biome.JUNGLE;
        CraftBlock.BIOME_MAPPING[yy.x.N] = Biome.JUNGLE_HILLS;
        for (i2 = 0; i2 < BIOME_MAPPING.length; ++i2) {
            if (yy.a[i2] != null && BIOME_MAPPING[i2] == null) {
                String name = yy.a[i2].y;
                int id2 = yy.a[i2].N;
                System.out.println("Adding biome mapping " + yy.a[i2].N + " " + name + " at BiomeBase[" + i2 + "]");
                EnumHelper.addBukkitBiome(name);
                CraftBlock.BIOME_MAPPING[yy.a[i2].N] = Enum.valueOf(Biome.class, name);
            }
            if (BIOME_MAPPING[i2] == null) continue;
            CraftBlock.BIOMEBASE_MAPPING[CraftBlock.BIOME_MAPPING[i2].ordinal()] = yy.a[i2];
        }
        if (FMLCommonHandler.instance().getMinecraftServerInstance().server.getDumpMaterials()) {
            FMLLog.info("MCPC Dump Materials is ENABLED. Starting dump...", new Object[0]);
            for (i2 = 0; i2 < 32000; ++i2) {
                Material material = Material.getMaterial(i2);
                if (material == null) continue;
                FMLLog.info("Found material " + (Object)((Object)material) + " with ID " + i2, new Object[0]);
            }
            FMLLog.info("MCPC Dump Materials complete.", new Object[0]);
            FMLLog.info("To disable these dumps, set mcpc.dump-materials to false in bukkit.yml.", new Object[0]);
        }
    }
}

